-------------------------------------------------------
--  Copyright (c) 2009 Xilinx Inc.
--  All Right Reserved.
-------------------------------------------------------
--
--   ____  ____
--  /   /\/   / 
-- /___/  \  /     Vendor      : Xilinx 
-- \   \   \/      Version : 11.1
--  \   \          Description : Xilinx Functional Simulation Library Component
--  /   /                        PCI Express
-- /___/   /\      Filename    : x_pcie_2_0.vhd
-- \   \  /  \      
--  \__ \/\__ \                   
--                                 
--  Revision: 1.0
--  05/30/08 - CR1014 - Initial version
--  06/06/08 - CR1014 - added component instantiation
--  07/23/08 - CR1014 - CFGLINKCONTROLRCB typo updated in yml
--  10/24/08 - CR493615 - Add timing section
--  11/05/08 - CR495283 - manually updated single clock writer bugs
--  11/11/08 - CR493971 - SIM_VERSION real to string
--  11/17/08 - CR496607 - convert bit_vector to string for VHDL simulation
--  02/18/09 - CR509025 - New pins & timing paths added
--  04/01/09 - CR517362 - Updated constant section for VHDL mixed mode simulation
--  04/13/09 - CR518461 - Connect 4 new pins LNKCLKEN, CFGPMCSR* to RTL
--  07/28/09 - CR528331 - YML update, new period checks
--  08/05/09 - CR529015 - writer update
-------------------------------------------------------

----- CELL X_PCIE_2_0 -----

library IEEE;
use IEEE.STD_LOGIC_arith.all;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.VCOMPONENTS.all; 

library secureip; 
use secureip.all; 
use simprim.VPACKAGE.all;

  entity X_PCIE_2_0 is
    generic (
      TimingChecksOn : boolean := TRUE;
      InstancePath   : string  := "*";
      Xon            : boolean := TRUE;
      MsgOn          : boolean := FALSE;
      LOC            : string  := "UNPLACED";
      AER_BASE_PTR : bit_vector := X"128";
      AER_CAP_ECRC_CHECK_CAPABLE : boolean := FALSE;
      AER_CAP_ECRC_GEN_CAPABLE : boolean := FALSE;
      AER_CAP_ID : bit_vector := X"1111";
      AER_CAP_INT_MSG_NUM_MSI : bit_vector := X"0A";
      AER_CAP_INT_MSG_NUM_MSIX : bit_vector := X"15";
      AER_CAP_NEXTPTR : bit_vector := X"160";
      AER_CAP_ON : boolean := FALSE;
      AER_CAP_PERMIT_ROOTERR_UPDATE : boolean := TRUE;
      AER_CAP_VERSION : bit_vector := X"1";
      ALLOW_X8_GEN2 : boolean := FALSE;
      BAR0 : bit_vector := X"FFFFFF00";
      BAR1 : bit_vector := X"FFFF0000";
      BAR2 : bit_vector := X"FFFF000C";
      BAR3 : bit_vector := X"FFFFFFFF";
      BAR4 : bit_vector := X"00000000";
      BAR5 : bit_vector := X"00000000";
      CAPABILITIES_PTR : bit_vector := X"40";
      CARDBUS_CIS_POINTER : bit_vector := X"00000000";
      CLASS_CODE : bit_vector := X"000000";
      CMD_INTX_IMPLEMENTED : boolean := TRUE;
      CPL_TIMEOUT_DISABLE_SUPPORTED : boolean := FALSE;
      CPL_TIMEOUT_RANGES_SUPPORTED : bit_vector := X"0";
      CRM_MODULE_RSTS : bit_vector := X"00";
      DEVICE_ID : bit_vector := X"0007";
      DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE : boolean := TRUE;
      DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE : boolean := TRUE;
      DEV_CAP_ENDPOINT_L0S_LATENCY : integer := 0;
      DEV_CAP_ENDPOINT_L1_LATENCY : integer := 0;
      DEV_CAP_EXT_TAG_SUPPORTED : boolean := TRUE;
      DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE : boolean := FALSE;
      DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer := 2;
      DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer := 0;
      DEV_CAP_ROLE_BASED_ERROR : boolean := TRUE;
      DEV_CAP_RSVD_14_12 : integer := 0;
      DEV_CAP_RSVD_17_16 : integer := 0;
      DEV_CAP_RSVD_31_29 : integer := 0;
      DEV_CONTROL_AUX_POWER_SUPPORTED : boolean := FALSE;
      DISABLE_ASPM_L1_TIMER : boolean := FALSE;
      DISABLE_BAR_FILTERING : boolean := FALSE;
      DISABLE_ID_CHECK : boolean := FALSE;
      DISABLE_LANE_REVERSAL : boolean := FALSE;
      DISABLE_RX_TC_FILTER : boolean := FALSE;
      DISABLE_SCRAMBLING : boolean := FALSE;
      DNSTREAM_LINK_NUM : bit_vector := X"00";
      DSN_BASE_PTR : bit_vector := X"100";
      DSN_CAP_ID : bit_vector := X"0003";
      DSN_CAP_NEXTPTR : bit_vector := X"000";
      DSN_CAP_ON : boolean := TRUE;
      DSN_CAP_VERSION : bit_vector := X"1";
      ENABLE_MSG_ROUTE : bit_vector := X"000";
      ENABLE_RX_TD_ECRC_TRIM : boolean := FALSE;
      ENTER_RVRY_EI_L0 : boolean := TRUE;
      EXIT_LOOPBACK_ON_EI : boolean := TRUE;
      EXPANSION_ROM : bit_vector := X"FFFFF001";
      EXT_CFG_CAP_PTR : bit_vector := X"3F";
      EXT_CFG_XP_CAP_PTR : bit_vector := X"3FF";
      HEADER_TYPE : bit_vector := X"00";
      INFER_EI : bit_vector := X"00";
      INTERRUPT_PIN : bit_vector := X"01";
      IS_SWITCH : boolean := FALSE;
      LAST_CONFIG_DWORD : bit_vector := X"042";
      LINK_CAP_ASPM_SUPPORT : integer := 1;
      LINK_CAP_CLOCK_POWER_MANAGEMENT : boolean := FALSE;
      LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP : boolean := FALSE;
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
      LINK_CAP_L0S_EXIT_LATENCY_GEN1 : integer := 7;
      LINK_CAP_L0S_EXIT_LATENCY_GEN2 : integer := 7;
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
      LINK_CAP_L1_EXIT_LATENCY_GEN1 : integer := 7;
      LINK_CAP_L1_EXIT_LATENCY_GEN2 : integer := 7;
      LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP : boolean := FALSE;
      LINK_CAP_MAX_LINK_SPEED : bit_vector := X"1";
      LINK_CAP_MAX_LINK_WIDTH : bit_vector := X"08";
      LINK_CAP_RSVD_23_22 : integer := 0;
      LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE : boolean := FALSE;
      LINK_CONTROL_RCB : integer := 0;
      LINK_CTRL2_DEEMPHASIS : boolean := FALSE;
      LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE : boolean := FALSE;
      LINK_CTRL2_TARGET_LINK_SPEED : bit_vector := X"2";
      LINK_STATUS_SLOT_CLOCK_CONFIG : boolean := TRUE;
      LL_ACK_TIMEOUT : bit_vector := X"0000";
      LL_ACK_TIMEOUT_EN : boolean := FALSE;
      LL_ACK_TIMEOUT_FUNC : integer := 0;
      LL_REPLAY_TIMEOUT : bit_vector := X"0000";
      LL_REPLAY_TIMEOUT_EN : boolean := FALSE;
      LL_REPLAY_TIMEOUT_FUNC : integer := 0;
      LTSSM_MAX_LINK_WIDTH : bit_vector := X"01";
      MSIX_BASE_PTR : bit_vector := X"9C";
      MSIX_CAP_ID : bit_vector := X"11";
      MSIX_CAP_NEXTPTR : bit_vector := X"00";
      MSIX_CAP_ON : boolean := FALSE;
      MSIX_CAP_PBA_BIR : integer := 0;
      MSIX_CAP_PBA_OFFSET : bit_vector := X"00000050";
      MSIX_CAP_TABLE_BIR : integer := 0;
      MSIX_CAP_TABLE_OFFSET : bit_vector := X"00000040";
      MSIX_CAP_TABLE_SIZE : bit_vector := X"000";
      MSI_BASE_PTR : bit_vector := X"48";
      MSI_CAP_64_BIT_ADDR_CAPABLE : boolean := TRUE;
      MSI_CAP_ID : bit_vector := X"05";
      MSI_CAP_MULTIMSGCAP : integer := 0;
      MSI_CAP_MULTIMSG_EXTENSION : integer := 0;
      MSI_CAP_NEXTPTR : bit_vector := X"60";
      MSI_CAP_ON : boolean := FALSE;
      MSI_CAP_PER_VECTOR_MASKING_CAPABLE : boolean := TRUE;
      N_FTS_COMCLK_GEN1 : integer := 255;
      N_FTS_COMCLK_GEN2 : integer := 255;
      N_FTS_GEN1 : integer := 255;
      N_FTS_GEN2 : integer := 255;
      PCIE_BASE_PTR : bit_vector := X"60";
      PCIE_CAP_CAPABILITY_ID : bit_vector := X"10";
      PCIE_CAP_CAPABILITY_VERSION : bit_vector := X"2";
      PCIE_CAP_DEVICE_PORT_TYPE : bit_vector := X"0";
      PCIE_CAP_INT_MSG_NUM : bit_vector := X"00";
      PCIE_CAP_NEXTPTR : bit_vector := X"00";
      PCIE_CAP_ON : boolean := TRUE;
      PCIE_CAP_RSVD_15_14 : integer := 0;
      PCIE_CAP_SLOT_IMPLEMENTED : boolean := FALSE;
      PCIE_REVISION : integer := 2;
      PGL0_LANE : integer := 0;
      PGL1_LANE : integer := 1;
      PGL2_LANE : integer := 2;
      PGL3_LANE : integer := 3;
      PGL4_LANE : integer := 4;
      PGL5_LANE : integer := 5;
      PGL6_LANE : integer := 6;
      PGL7_LANE : integer := 7;
      PL_AUTO_CONFIG : integer := 0;
      PL_FAST_TRAIN : boolean := FALSE;
      PM_BASE_PTR : bit_vector := X"40";
      PM_CAP_AUXCURRENT : integer := 0;
      PM_CAP_D1SUPPORT : boolean := TRUE;
      PM_CAP_D2SUPPORT : boolean := TRUE;
      PM_CAP_DSI : boolean := FALSE;
      PM_CAP_ID : bit_vector := X"11";
      PM_CAP_NEXTPTR : bit_vector := X"48";
      PM_CAP_ON : boolean := TRUE;
      PM_CAP_PMESUPPORT : bit_vector := X"0F";
      PM_CAP_PME_CLOCK : boolean := FALSE;
      PM_CAP_RSVD_04 : integer := 0;
      PM_CAP_VERSION : integer := 3;
      PM_CSR_B2B3 : boolean := FALSE;
      PM_CSR_BPCCEN : boolean := FALSE;
      PM_CSR_NOSOFTRST : boolean := TRUE;
      PM_DATA0 : bit_vector := X"01";
      PM_DATA1 : bit_vector := X"01";
      PM_DATA2 : bit_vector := X"01";
      PM_DATA3 : bit_vector := X"01";
      PM_DATA4 : bit_vector := X"01";
      PM_DATA5 : bit_vector := X"01";
      PM_DATA6 : bit_vector := X"01";
      PM_DATA7 : bit_vector := X"01";
      PM_DATA_SCALE0 : bit_vector := X"1";
      PM_DATA_SCALE1 : bit_vector := X"1";
      PM_DATA_SCALE2 : bit_vector := X"1";
      PM_DATA_SCALE3 : bit_vector := X"1";
      PM_DATA_SCALE4 : bit_vector := X"1";
      PM_DATA_SCALE5 : bit_vector := X"1";
      PM_DATA_SCALE6 : bit_vector := X"1";
      PM_DATA_SCALE7 : bit_vector := X"1";
      RECRC_CHK : integer := 0;
      RECRC_CHK_TRIM : boolean := FALSE;
      REVISION_ID : bit_vector := X"00";
      ROOT_CAP_CRS_SW_VISIBILITY : boolean := FALSE;
      SELECT_DLL_IF : boolean := FALSE;
      SIM_VERSION : string := "1.0";
      SLOT_CAP_ATT_BUTTON_PRESENT : boolean := FALSE;
      SLOT_CAP_ATT_INDICATOR_PRESENT : boolean := FALSE;
      SLOT_CAP_ELEC_INTERLOCK_PRESENT : boolean := FALSE;
      SLOT_CAP_HOTPLUG_CAPABLE : boolean := FALSE;
      SLOT_CAP_HOTPLUG_SURPRISE : boolean := FALSE;
      SLOT_CAP_MRL_SENSOR_PRESENT : boolean := FALSE;
      SLOT_CAP_NO_CMD_COMPLETED_SUPPORT : boolean := FALSE;
      SLOT_CAP_PHYSICAL_SLOT_NUM : bit_vector := X"0000";
      SLOT_CAP_POWER_CONTROLLER_PRESENT : boolean := FALSE;
      SLOT_CAP_POWER_INDICATOR_PRESENT : boolean := FALSE;
      SLOT_CAP_SLOT_POWER_LIMIT_SCALE : integer := 0;
      SLOT_CAP_SLOT_POWER_LIMIT_VALUE : bit_vector := X"00";
      SPARE_BIT0 : integer := 0;
      SPARE_BIT1 : integer := 0;
      SPARE_BIT2 : integer := 0;
      SPARE_BIT3 : integer := 0;
      SPARE_BIT4 : integer := 0;
      SPARE_BIT5 : integer := 0;
      SPARE_BIT6 : integer := 0;
      SPARE_BIT7 : integer := 0;
      SPARE_BIT8 : integer := 0;
      SPARE_BYTE0 : bit_vector := X"00";
      SPARE_BYTE1 : bit_vector := X"00";
      SPARE_BYTE2 : bit_vector := X"00";
      SPARE_BYTE3 : bit_vector := X"00";
      SPARE_WORD0 : bit_vector := X"00000000";
      SPARE_WORD1 : bit_vector := X"00000000";
      SPARE_WORD2 : bit_vector := X"00000000";
      SPARE_WORD3 : bit_vector := X"00000000";
      SUBSYSTEM_ID : bit_vector := X"0007";
      SUBSYSTEM_VENDOR_ID : bit_vector := X"10EE";
      TL_RBYPASS : boolean := FALSE;
      TL_RX_RAM_RADDR_LATENCY : integer := 0;
      TL_RX_RAM_RDATA_LATENCY : integer := 2;
      TL_RX_RAM_WRITE_LATENCY : integer := 0;
      TL_TFC_DISABLE : boolean := FALSE;
      TL_TX_CHECKS_DISABLE : boolean := FALSE;
      TL_TX_RAM_RADDR_LATENCY : integer := 0;
      TL_TX_RAM_RDATA_LATENCY : integer := 2;
      TL_TX_RAM_WRITE_LATENCY : integer := 0;
      UPCONFIG_CAPABLE : boolean := TRUE;
      UPSTREAM_FACING : boolean := TRUE;
      UR_INV_REQ : boolean := TRUE;
      USER_CLK_FREQ : integer := 3;
      VC0_CPL_INFINITE : boolean := TRUE;
      VC0_RX_RAM_LIMIT : bit_vector := X"03FF";
      VC0_TOTAL_CREDITS_CD : integer := 127;
      VC0_TOTAL_CREDITS_CH : integer := 31;
      VC0_TOTAL_CREDITS_NPH : integer := 12;
      VC0_TOTAL_CREDITS_PD : integer := 288;
      VC0_TOTAL_CREDITS_PH : integer := 32;
      VC0_TX_LASTPACKET : integer := 31;
      VC_BASE_PTR : bit_vector := X"10C";
      VC_CAP_ID : bit_vector := X"0002";
      VC_CAP_NEXTPTR : bit_vector := X"000";
      VC_CAP_ON : boolean := FALSE;
      VC_CAP_REJECT_SNOOP_TRANSACTIONS : boolean := FALSE;
      VC_CAP_VERSION : bit_vector := X"1";
      VENDOR_ID : bit_vector := X"10EE";
      VSEC_BASE_PTR : bit_vector := X"160";
      VSEC_CAP_HDR_ID : bit_vector := X"1234";
      VSEC_CAP_HDR_LENGTH : bit_vector := X"018";
      VSEC_CAP_HDR_REVISION : bit_vector := X"1";
      VSEC_CAP_ID : bit_vector := X"000B";
      VSEC_CAP_IS_LINK_VISIBLE : boolean := TRUE;
      VSEC_CAP_NEXTPTR : bit_vector := X"000";
      VSEC_CAP_ON : boolean := FALSE;
      VSEC_CAP_VERSION : bit_vector := X"1";
      tipd_CFGBYTEENN : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDI : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDSBUSNUMBER : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDSDEVICENUMBER : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDSFUNCTIONNUMBER : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDSN : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGDWADDR : VitalDelayArrayType01 (9 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGERRACSN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRAERHEADERLOG : VitalDelayArrayType01 (127 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGERRCORN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRCPLABORTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRCPLTIMEOUTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRCPLUNEXPECTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRECRCN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRLOCKEDN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRPOSTEDN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGERRTLPCPLHEADER : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGERRURN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGINTERRUPTASSERTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGINTERRUPTDI : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGINTERRUPTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMDIRECTASPML1N : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMSENDPMACKN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMSENDPMETON : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMSENDPMNAKN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMTURNOFFOKN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPMWAKEN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGPORTNUMBER : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
      tipd_CFGRDENN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGTRNPENDINGN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGWRENN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGWRREADONLYN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CFGWRRW1CASRWN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CMRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_CMSTICKYRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_DBGMODE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_DBGSUBMODE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_DLRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_DRPCLK : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_DRPDADDR : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
      tipd_DRPDEN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_DRPDI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_DRPDWE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_FUNCLVLRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_LL2SENDASREQL1N : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_LL2SENDENTERL1N : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_LL2SENDENTERL23N : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_LL2SUSPENDNOWN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_LL2TLPRCVN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_MIMRXRDATA : VitalDelayArrayType01 (67 downto 0) := (others => (0 ps, 0 ps));
      tipd_MIMTXRDATA : VitalDelayArrayType01 (68 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPECLK : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX0CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX0CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX0DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX0ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX0PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX0STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX0VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX1CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX1CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX1DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX1ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX1PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX1STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX1VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX2CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX2CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX2DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX2ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX2PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX2STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX2VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX3CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX3CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX3DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX3ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX3PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX3STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX3VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX4CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX4CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX4DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX4ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX4PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX4STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX4VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX5CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX5CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX5DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX5ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX5PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX5STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX5VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX6CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX6CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX6DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX6ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX6PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX6STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX6VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX7CHANISALIGNED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX7CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX7DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX7ELECIDLE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX7PHYSTATUS : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PIPERX7STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PIPERX7VALID : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PL2DIRECTEDLSTATE : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
      tipd_PLDBGMODE : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_PLDIRECTEDLINKAUTON : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PLDIRECTEDLINKCHANGE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PLDIRECTEDLINKSPEED : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PLDIRECTEDLINKWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
      tipd_PLDOWNSTREAMDEEMPHSOURCE : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PLRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PLTRANSMITHOTRST : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_PLUPSTREAMPREFERDEEMPH : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_SYSRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TL2ASPMSUSPENDCREDITCHECKN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TL2PPMSUSPENDREQN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TLRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNFCSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
      tipd_TRNRDSTRDYN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNRNPOKN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTCFGGNTN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTD : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
      tipd_TRNTDLLPDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
      tipd_TRNTDLLPSRCRDYN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTECRCGENN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTEOFN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTERRFWDN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTREMN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTSOFN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTSRCDSCN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTSRCRDYN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_TRNTSTRN : VitalDelayType01 :=  (0 ps, 0 ps);
      tipd_USERCLK : VitalDelayType01 :=  (0 ps, 0 ps);
      tpd_DRPCLK_DRPDO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_DRPCLK_DRPDRDY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX0POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX1POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX2POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX3POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX4POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX5POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX6POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPERX7POLARITY : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX0CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX0COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX0DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX0ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX0POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX1CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX1COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX1DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX1ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX1POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX2CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX2COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX2DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX2ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX2POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX3CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX3COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX3DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX3ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX3POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX4CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX4COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX4DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX4ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX4POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX5CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX5COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX5DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX5ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX5POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX6CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX6COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX6DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX6ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX6POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX7CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX7COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX7DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETX7ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETX7POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETXDEEMPH : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETXMARGIN : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PIPETXRATE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETXRCVRDET : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PIPETXRESET : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLDBGVEC : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLINITIALLINKWIDTH : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLLANEREVERSALMODE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLLINKGEN2CAP : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLLINKPARTNERGEN2SUPPORTED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLLINKUPCFGCAP : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLLTSSMSTATE : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLPHYLNKUPN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLRECEIVEDHOTRST : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLRXPMSTATE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLSELLNKRATE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_PIPECLK_PLSELLNKWIDTH : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_PIPECLK_PLTXPMSTATE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGAERECRCCHECKEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGAERECRCGENEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGCOMMANDBUSMASTERENABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGCOMMANDINTERRUPTDISABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGCOMMANDIOENABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGCOMMANDMEMENABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGCOMMANDSERREN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROL2CPLTIMEOUTDIS : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROL2CPLTIMEOUTVAL : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGDEVCONTROLAUXPOWEREN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLCORRERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLENABLERO : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLEXTTAGEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLFATALERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLMAXPAYLOAD : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGDEVCONTROLMAXREADREQ : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGDEVCONTROLNONFATALREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLNOSNOOPEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLPHANTOMEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVCONTROLURERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVSTATUSCORRERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVSTATUSFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVSTATUSNONFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDEVSTATUSURDETECTED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGDO : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGERRAERHEADERLOGSETN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGERRCPLRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGINTERRUPTDO : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGINTERRUPTMMENABLE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGINTERRUPTMSIENABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGINTERRUPTMSIXENABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGINTERRUPTMSIXFM : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGINTERRUPTRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLASPMCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGLINKCONTROLAUTOBANDWIDTHINTEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLBANDWIDTHINTEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLCLOCKPMEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLCOMMONCLOCK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLEXTENDEDSYNC : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLHWAUTOWIDTHDIS : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLLINKDISABLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLRCB : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKCONTROLRETRAINLINK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKSTATUSAUTOBANDWIDTHSTATUS : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKSTATUSBANDWITHSTATUS : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKSTATUSCURRENTSPEED : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGLINKSTATUSDLLACTIVE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKSTATUSLINKTRAINING : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGLINKSTATUSNEGOTIATEDWIDTH : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGMSGDATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGMSGRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDASSERTINTA : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDASSERTINTB : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDASSERTINTC : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDASSERTINTD : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTA : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTB : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTC : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTD : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDERRCOR : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDERRFATAL : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDERRNONFATAL : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDPMASNAK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDPMETO : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDPMETOACK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDPMPME : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDSETSLOTPOWERLIMIT : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGMSGRECEIVEDUNLOCK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPCIELINKSTATE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGPMCSRPMEEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPMCSRPMESTATUS : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPMCSRPOWERSTATE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGPMRCVASREQL1N : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPMRCVENTERL1N : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPMRCVENTERL23N : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGPMRCVREQACKN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGRDWRDONEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGSLOTCONTROLELECTROMECHILCTLPULSE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGTRANSACTION : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGTRANSACTIONADDR : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_CFGTRANSACTIONTYPE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_CFGVCTCVCMAP : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_DBGSCLRA : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRB : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRC : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRD : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRF : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRG : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRH : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRI : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRJ : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGSCLRK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_DBGVECA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_DBGVECB : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_DBGVECC : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_LL2BADDLLPERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2BADTLPERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2PROTOCOLERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2REPLAYROERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2REPLAYTOERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2SUSPENDOKN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2TFCINIT1SEQN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LL2TFCINIT2SEQN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_LNKCLKEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMRXRADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMRXRCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMRXREN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMRXWADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMRXWDATA : VitalDelayArrayType01(67 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMRXWEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMTXRADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMTXRCE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMTXREN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_MIMTXWADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMTXWDATA : VitalDelayArrayType01(68 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_MIMTXWEN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_PL2LINKUPN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_PL2RECEIVERERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_PL2RECOVERYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_PL2RXELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_PL2SUSPENDOK : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_RECEIVEDFUNCLVLRSTN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TL2ASPMSUSPENDCREDITCHECKOKN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TL2ASPMSUSPENDREQN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TL2PPMSUSPENDOKN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNFCCPLD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNFCCPLH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNFCNPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNFCNPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNFCPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNFCPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNLNKUPN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRBARHITN : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNRD : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNRDLLPDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNRDLLPSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRECRCERRN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNREOFN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRERRFWDN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRREMN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRSOFN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNRSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNTBUFAV : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
      tpd_USERCLK_TRNTCFGREQN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNTDLLPDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNTDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_TRNTERRDROPN : VitalDelayType01 := (0 ps, 0 ps);
      tpd_USERCLK_USERRSTN : VitalDelayType01 := (0 ps, 0 ps);
      thold_CFGBYTEENN_USERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
      thold_CFGBYTEENN_USERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
      thold_CFGDI_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      thold_CFGDI_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      thold_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      thold_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      thold_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
      thold_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
      thold_CFGERRACSN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRACSN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
      thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
      thold_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
      thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
      thold_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMACKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMACKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMETON_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMETON_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMNAKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMSENDPMNAKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGPORTNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGPORTNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      thold_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRREADONLYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRREADONLYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRRW1CASRWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CFGWRRW1CASRWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CMRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CMRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_CMSTICKYRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_CMSTICKYRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_DBGMODE_USERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_DBGMODE_USERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_DBGSUBMODE_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_DBGSUBMODE_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_DLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_DLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_DRPDADDR_DRPCLK_negedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
      thold_DRPDADDR_DRPCLK_posedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
      thold_DRPDEN_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_DRPDEN_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_DRPDI_DRPCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_DRPDI_DRPCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_DRPDWE_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_DRPDWE_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_FUNCLVLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_FUNCLVLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDASREQL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDASREQL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDENTERL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDENTERL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDENTERL23N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SENDENTERL23N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SUSPENDNOWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_LL2SUSPENDNOWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_LL2TLPRCVN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_LL2TLPRCVN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
      thold_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
      thold_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
      thold_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
      thold_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX0CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX0DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX0DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX0ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX0STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX0VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX0VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX1CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX1DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX1DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX1ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX1STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX1VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX1VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX2CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX2DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX2DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX2ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX2STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX2VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX2VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX3CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX3DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX3DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX3ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX3STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX3VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX3VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX4CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX4DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX4DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX4ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX4STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX4VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX4VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX5CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX5DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX5DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX5ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX5STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX5VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX5VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX6CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX6DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX6DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX6ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX6STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX6VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX6VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX7CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PIPERX7DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX7DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      thold_PIPERX7ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX7STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PIPERX7VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PIPERX7VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PL2DIRECTEDLSTATE_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      thold_PL2DIRECTEDLSTATE_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      thold_PLDBGMODE_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PLDBGMODE_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_PLDIRECTEDLINKAUTON_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLDIRECTEDLINKAUTON_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PLDIRECTEDLINKCHANGE_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PLDIRECTEDLINKCHANGE_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PLDIRECTEDLINKSPEED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLDIRECTEDLINKSPEED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PLDIRECTEDLINKWIDTH_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PLDIRECTEDLINKWIDTH_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      thold_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PLRSTN_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLRSTN_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PLTRANSMITHOTRST_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLTRANSMITHOTRST_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_PLUPSTREAMPREFERDEEMPH_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TL2PPMSUSPENDREQN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TL2PPMSUSPENDREQN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      thold_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTDLLPDATA_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      thold_TRNTDLLPDATA_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      thold_TRNTDLLPSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTDLLPSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      thold_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      thold_TRNTECRCGENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTECRCGENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTREMN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTREMN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      thold_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGBYTEENN_USERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
      tsetup_CFGBYTEENN_USERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
      tsetup_CFGDI_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tsetup_CFGDI_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tsetup_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tsetup_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tsetup_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
      tsetup_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
      tsetup_CFGERRACSN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRACSN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
      tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
      tsetup_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
      tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
      tsetup_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMACKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMACKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMETON_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMETON_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMNAKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMSENDPMNAKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tsetup_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRREADONLYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRREADONLYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRRW1CASRWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CFGWRRW1CASRWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CMRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CMRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_CMSTICKYRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_CMSTICKYRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_DBGMODE_USERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_DBGMODE_USERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_DBGSUBMODE_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_DBGSUBMODE_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_DLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_DLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_DRPDADDR_DRPCLK_negedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
      tsetup_DRPDADDR_DRPCLK_posedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
      tsetup_DRPDEN_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_DRPDEN_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_DRPDI_DRPCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_DRPDI_DRPCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_DRPDWE_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_DRPDWE_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_FUNCLVLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_FUNCLVLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDASREQL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDASREQL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDENTERL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDENTERL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDENTERL23N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SENDENTERL23N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SUSPENDNOWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2SUSPENDNOWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2TLPRCVN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_LL2TLPRCVN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
      tsetup_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
      tsetup_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
      tsetup_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
      tsetup_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX0CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX0DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX0DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX0ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX0STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX0VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX0VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX1CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX1DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX1DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX1ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX1STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX1VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX1VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX2CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX2DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX2DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX2ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX2STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX2VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX2VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX3CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX3DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX3DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX3ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX3STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX3VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX3VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX4CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX4DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX4DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX4ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX4STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX4VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX4VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX5CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX5DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX5DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX5ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX5STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX5VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX5VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX6CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX6DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX6DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX6ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX6STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX6VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX6VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX7CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PIPERX7DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX7DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tsetup_PIPERX7ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX7STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PIPERX7VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PIPERX7VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PL2DIRECTEDLSTATE_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tsetup_PL2DIRECTEDLSTATE_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tsetup_PLDBGMODE_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PLDBGMODE_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_PLDIRECTEDLINKAUTON_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLDIRECTEDLINKAUTON_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLDIRECTEDLINKCHANGE_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PLDIRECTEDLINKCHANGE_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PLDIRECTEDLINKSPEED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLDIRECTEDLINKSPEED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLDIRECTEDLINKWIDTH_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PLDIRECTEDLINKWIDTH_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tsetup_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLRSTN_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLRSTN_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLTRANSMITHOTRST_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLTRANSMITHOTRST_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLUPSTREAMPREFERDEEMPH_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TL2PPMSUSPENDREQN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TL2PPMSUSPENDREQN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tsetup_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTDLLPDATA_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tsetup_TRNTDLLPDATA_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tsetup_TRNTDLLPSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTDLLPSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tsetup_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tsetup_TRNTECRCGENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTECRCGENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTREMN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTREMN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
      tsetup_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
      tisd_CFGBYTEENN_USERCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
      tisd_CFGDI_USERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tisd_CFGDSBUSNUMBER_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tisd_CFGDSDEVICENUMBER_USERCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tisd_CFGDSFUNCTIONNUMBER_USERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_CFGDSN_USERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tisd_CFGDWADDR_USERCLK : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
      tisd_CFGERRACSN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRAERHEADERLOG_USERCLK : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
      tisd_CFGERRCORN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRCPLABORTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRCPLTIMEOUTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRCPLUNEXPECTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRECRCN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRLOCKEDN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRPOSTEDN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGERRTLPCPLHEADER_USERCLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
      tisd_CFGERRURN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGINTERRUPTASSERTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGINTERRUPTDI_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tisd_CFGINTERRUPTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMDIRECTASPML1N_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMSENDPMACKN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMSENDPMETON_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMSENDPMNAKN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMTURNOFFOKN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPMWAKEN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGPORTNUMBER_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
      tisd_CFGRDENN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGTRNPENDINGN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGWRENN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGWRREADONLYN_USERCLK : VitalDelayType := 0 ps;
      tisd_CFGWRRW1CASRWN_USERCLK : VitalDelayType := 0 ps;
      tisd_CMRSTN_USERCLK : VitalDelayType := 0 ps;
      tisd_CMSTICKYRSTN_USERCLK : VitalDelayType := 0 ps;
      tisd_DBGMODE_USERCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_DBGSUBMODE_USERCLK : VitalDelayType := 0 ps;
      tisd_DLRSTN_USERCLK : VitalDelayType := 0 ps;
      tisd_DRPDADDR_DRPCLK : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
      tisd_DRPDEN_DRPCLK : VitalDelayType := 0 ps;
      tisd_DRPDI_DRPCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_DRPDWE_DRPCLK : VitalDelayType := 0 ps;
      tisd_FUNCLVLRSTN_USERCLK : VitalDelayType := 0 ps;
      tisd_LL2SENDASREQL1N_USERCLK : VitalDelayType := 0 ps;
      tisd_LL2SENDENTERL1N_USERCLK : VitalDelayType := 0 ps;
      tisd_LL2SENDENTERL23N_USERCLK : VitalDelayType := 0 ps;
      tisd_LL2SUSPENDNOWN_USERCLK : VitalDelayType := 0 ps;
      tisd_LL2TLPRCVN_USERCLK : VitalDelayType := 0 ps;
      tisd_MIMRXRDATA_USERCLK : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
      tisd_MIMTXRDATA_USERCLK : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
      tisd_PIPERX0CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX0CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX0DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX0ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX0PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX0STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX0VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX1CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX1CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX1DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX1ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX1PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX1STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX1VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX2CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX2CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX2DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX2ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX2PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX2STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX2VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX3CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX3CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX3DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX3ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX3PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX3STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX3VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX4CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX4CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX4DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX4ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX4PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX4STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX4VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX5CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX5CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX5DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX5ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX5PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX5STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX5VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX6CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX6CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX6DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX6ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX6PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX6STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX6VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX7CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX7CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PIPERX7DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
      tisd_PIPERX7ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX7PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
      tisd_PIPERX7STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PIPERX7VALID_PIPECLK : VitalDelayType := 0 ps;
      tisd_PL2DIRECTEDLSTATE_USERCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
      tisd_PLDBGMODE_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_PLDIRECTEDLINKAUTON_PIPECLK : VitalDelayType := 0 ps;
      tisd_PLDIRECTEDLINKCHANGE_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PLDIRECTEDLINKSPEED_PIPECLK : VitalDelayType := 0 ps;
      tisd_PLDIRECTEDLINKWIDTH_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
      tisd_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK : VitalDelayType := 0 ps;
      tisd_PLRSTN_PIPECLK : VitalDelayType := 0 ps;
      tisd_PLTRANSMITHOTRST_PIPECLK : VitalDelayType := 0 ps;
      tisd_PLUPSTREAMPREFERDEEMPH_PIPECLK : VitalDelayType := 0 ps;
      tisd_TL2ASPMSUSPENDCREDITCHECKN_USERCLK : VitalDelayType := 0 ps;
      tisd_TL2PPMSUSPENDREQN_USERCLK : VitalDelayType := 0 ps;
      tisd_TLRSTN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNFCSEL_USERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
      tisd_TRNRDSTRDYN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNRNPOKN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTCFGGNTN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTDLLPDATA_USERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
      tisd_TRNTDLLPSRCRDYN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTD_USERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
      tisd_TRNTECRCGENN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTEOFN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTERRFWDN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTREMN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTSOFN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTSRCDSCN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTSRCRDYN_USERCLK : VitalDelayType := 0 ps;
      tisd_TRNTSTRN_USERCLK : VitalDelayType := 0 ps;
      ticd_DRPCLK : VitalDelayType := 0 ps;
      ticd_PIPECLK : VitalDelayType := 0 ps;
      ticd_USERCLK : VitalDelayType := 0 ps;
      tperiod_DRPCLK_posedge : VitalDelayType := 0 ps;
      tperiod_PIPECLK_posedge : VitalDelayType := 0 ps;
      tperiod_USERCLK_posedge : VitalDelayType := 0 ps
    );

    port (
      CFGAERECRCCHECKEN    : out std_ulogic;
      CFGAERECRCGENEN      : out std_ulogic;
      CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
      CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
      CFGCOMMANDIOENABLE   : out std_ulogic;
      CFGCOMMANDMEMENABLE  : out std_ulogic;
      CFGCOMMANDSERREN     : out std_ulogic;
      CFGDEVCONTROL2CPLTIMEOUTDIS : out std_ulogic;
      CFGDEVCONTROL2CPLTIMEOUTVAL : out std_logic_vector(3 downto 0);
      CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
      CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
      CFGDEVCONTROLENABLERO : out std_ulogic;
      CFGDEVCONTROLEXTTAGEN : out std_ulogic;
      CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
      CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
      CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
      CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
      CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
      CFGDEVCONTROLPHANTOMEN : out std_ulogic;
      CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
      CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
      CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
      CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
      CFGDEVSTATUSURDETECTED : out std_ulogic;
      CFGDO                : out std_logic_vector(31 downto 0);
      CFGERRAERHEADERLOGSETN : out std_ulogic;
      CFGERRCPLRDYN        : out std_ulogic;
      CFGINTERRUPTDO       : out std_logic_vector(7 downto 0);
      CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
      CFGINTERRUPTMSIENABLE : out std_ulogic;
      CFGINTERRUPTMSIXENABLE : out std_ulogic;
      CFGINTERRUPTMSIXFM   : out std_ulogic;
      CFGINTERRUPTRDYN     : out std_ulogic;
      CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
      CFGLINKCONTROLAUTOBANDWIDTHINTEN : out std_ulogic;
      CFGLINKCONTROLBANDWIDTHINTEN : out std_ulogic;
      CFGLINKCONTROLCLOCKPMEN : out std_ulogic;
      CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
      CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
      CFGLINKCONTROLHWAUTOWIDTHDIS : out std_ulogic;
      CFGLINKCONTROLLINKDISABLE : out std_ulogic;
      CFGLINKCONTROLRCB    : out std_ulogic;
      CFGLINKCONTROLRETRAINLINK : out std_ulogic;
      CFGLINKSTATUSAUTOBANDWIDTHSTATUS : out std_ulogic;
      CFGLINKSTATUSBANDWITHSTATUS : out std_ulogic;
      CFGLINKSTATUSCURRENTSPEED : out std_logic_vector(1 downto 0);
      CFGLINKSTATUSDLLACTIVE : out std_ulogic;
      CFGLINKSTATUSLINKTRAINING : out std_ulogic;
      CFGLINKSTATUSNEGOTIATEDWIDTH : out std_logic_vector(3 downto 0);
      CFGMSGDATA           : out std_logic_vector(15 downto 0);
      CFGMSGRECEIVED       : out std_ulogic;
      CFGMSGRECEIVEDASSERTINTA : out std_ulogic;
      CFGMSGRECEIVEDASSERTINTB : out std_ulogic;
      CFGMSGRECEIVEDASSERTINTC : out std_ulogic;
      CFGMSGRECEIVEDASSERTINTD : out std_ulogic;
      CFGMSGRECEIVEDDEASSERTINTA : out std_ulogic;
      CFGMSGRECEIVEDDEASSERTINTB : out std_ulogic;
      CFGMSGRECEIVEDDEASSERTINTC : out std_ulogic;
      CFGMSGRECEIVEDDEASSERTINTD : out std_ulogic;
      CFGMSGRECEIVEDERRCOR : out std_ulogic;
      CFGMSGRECEIVEDERRFATAL : out std_ulogic;
      CFGMSGRECEIVEDERRNONFATAL : out std_ulogic;
      CFGMSGRECEIVEDPMASNAK : out std_ulogic;
      CFGMSGRECEIVEDPMETO  : out std_ulogic;
      CFGMSGRECEIVEDPMETOACK : out std_ulogic;
      CFGMSGRECEIVEDPMPME  : out std_ulogic;
      CFGMSGRECEIVEDSETSLOTPOWERLIMIT : out std_ulogic;
      CFGMSGRECEIVEDUNLOCK : out std_ulogic;
      CFGPCIELINKSTATE     : out std_logic_vector(2 downto 0);
      CFGPMCSRPMEEN        : out std_ulogic;
      CFGPMCSRPMESTATUS    : out std_ulogic;
      CFGPMCSRPOWERSTATE   : out std_logic_vector(1 downto 0);
      CFGPMRCVASREQL1N     : out std_ulogic;
      CFGPMRCVENTERL1N     : out std_ulogic;
      CFGPMRCVENTERL23N    : out std_ulogic;
      CFGPMRCVREQACKN      : out std_ulogic;
      CFGRDWRDONEN         : out std_ulogic;
      CFGSLOTCONTROLELECTROMECHILCTLPULSE : out std_ulogic;
      CFGTRANSACTION       : out std_ulogic;
      CFGTRANSACTIONADDR   : out std_logic_vector(6 downto 0);
      CFGTRANSACTIONTYPE   : out std_ulogic;
      CFGVCTCVCMAP         : out std_logic_vector(6 downto 0);
      DBGSCLRA             : out std_ulogic;
      DBGSCLRB             : out std_ulogic;
      DBGSCLRC             : out std_ulogic;
      DBGSCLRD             : out std_ulogic;
      DBGSCLRE             : out std_ulogic;
      DBGSCLRF             : out std_ulogic;
      DBGSCLRG             : out std_ulogic;
      DBGSCLRH             : out std_ulogic;
      DBGSCLRI             : out std_ulogic;
      DBGSCLRJ             : out std_ulogic;
      DBGSCLRK             : out std_ulogic;
      DBGVECA              : out std_logic_vector(63 downto 0);
      DBGVECB              : out std_logic_vector(63 downto 0);
      DBGVECC              : out std_logic_vector(11 downto 0);
      DRPDO                : out std_logic_vector(15 downto 0);
      DRPDRDY              : out std_ulogic;
      LL2BADDLLPERRN       : out std_ulogic;
      LL2BADTLPERRN        : out std_ulogic;
      LL2PROTOCOLERRN      : out std_ulogic;
      LL2REPLAYROERRN      : out std_ulogic;
      LL2REPLAYTOERRN      : out std_ulogic;
      LL2SUSPENDOKN        : out std_ulogic;
      LL2TFCINIT1SEQN      : out std_ulogic;
      LL2TFCINIT2SEQN      : out std_ulogic;
      LNKCLKEN             : out std_ulogic;
      MIMRXRADDR           : out std_logic_vector(12 downto 0);
      MIMRXRCE             : out std_ulogic;
      MIMRXREN             : out std_ulogic;
      MIMRXWADDR           : out std_logic_vector(12 downto 0);
      MIMRXWDATA           : out std_logic_vector(67 downto 0);
      MIMRXWEN             : out std_ulogic;
      MIMTXRADDR           : out std_logic_vector(12 downto 0);
      MIMTXRCE             : out std_ulogic;
      MIMTXREN             : out std_ulogic;
      MIMTXWADDR           : out std_logic_vector(12 downto 0);
      MIMTXWDATA           : out std_logic_vector(68 downto 0);
      MIMTXWEN             : out std_ulogic;
      PIPERX0POLARITY      : out std_ulogic;
      PIPERX1POLARITY      : out std_ulogic;
      PIPERX2POLARITY      : out std_ulogic;
      PIPERX3POLARITY      : out std_ulogic;
      PIPERX4POLARITY      : out std_ulogic;
      PIPERX5POLARITY      : out std_ulogic;
      PIPERX6POLARITY      : out std_ulogic;
      PIPERX7POLARITY      : out std_ulogic;
      PIPETX0CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX0COMPLIANCE    : out std_ulogic;
      PIPETX0DATA          : out std_logic_vector(15 downto 0);
      PIPETX0ELECIDLE      : out std_ulogic;
      PIPETX0POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX1CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX1COMPLIANCE    : out std_ulogic;
      PIPETX1DATA          : out std_logic_vector(15 downto 0);
      PIPETX1ELECIDLE      : out std_ulogic;
      PIPETX1POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX2CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX2COMPLIANCE    : out std_ulogic;
      PIPETX2DATA          : out std_logic_vector(15 downto 0);
      PIPETX2ELECIDLE      : out std_ulogic;
      PIPETX2POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX3CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX3COMPLIANCE    : out std_ulogic;
      PIPETX3DATA          : out std_logic_vector(15 downto 0);
      PIPETX3ELECIDLE      : out std_ulogic;
      PIPETX3POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX4CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX4COMPLIANCE    : out std_ulogic;
      PIPETX4DATA          : out std_logic_vector(15 downto 0);
      PIPETX4ELECIDLE      : out std_ulogic;
      PIPETX4POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX5CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX5COMPLIANCE    : out std_ulogic;
      PIPETX5DATA          : out std_logic_vector(15 downto 0);
      PIPETX5ELECIDLE      : out std_ulogic;
      PIPETX5POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX6CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX6COMPLIANCE    : out std_ulogic;
      PIPETX6DATA          : out std_logic_vector(15 downto 0);
      PIPETX6ELECIDLE      : out std_ulogic;
      PIPETX6POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETX7CHARISK       : out std_logic_vector(1 downto 0);
      PIPETX7COMPLIANCE    : out std_ulogic;
      PIPETX7DATA          : out std_logic_vector(15 downto 0);
      PIPETX7ELECIDLE      : out std_ulogic;
      PIPETX7POWERDOWN     : out std_logic_vector(1 downto 0);
      PIPETXDEEMPH         : out std_ulogic;
      PIPETXMARGIN         : out std_logic_vector(2 downto 0);
      PIPETXRATE           : out std_ulogic;
      PIPETXRCVRDET        : out std_ulogic;
      PIPETXRESET          : out std_ulogic;
      PL2LINKUPN           : out std_ulogic;
      PL2RECEIVERERRN      : out std_ulogic;
      PL2RECOVERYN         : out std_ulogic;
      PL2RXELECIDLE        : out std_ulogic;
      PL2SUSPENDOK         : out std_ulogic;
      PLDBGVEC             : out std_logic_vector(11 downto 0);
      PLINITIALLINKWIDTH   : out std_logic_vector(2 downto 0);
      PLLANEREVERSALMODE   : out std_logic_vector(1 downto 0);
      PLLINKGEN2CAP        : out std_ulogic;
      PLLINKPARTNERGEN2SUPPORTED : out std_ulogic;
      PLLINKUPCFGCAP       : out std_ulogic;
      PLLTSSMSTATE         : out std_logic_vector(5 downto 0);
      PLPHYLNKUPN          : out std_ulogic;
      PLRECEIVEDHOTRST     : out std_ulogic;
      PLRXPMSTATE          : out std_logic_vector(1 downto 0);
      PLSELLNKRATE         : out std_ulogic;
      PLSELLNKWIDTH        : out std_logic_vector(1 downto 0);
      PLTXPMSTATE          : out std_logic_vector(2 downto 0);
      RECEIVEDFUNCLVLRSTN  : out std_ulogic;
      TL2ASPMSUSPENDCREDITCHECKOKN : out std_ulogic;
      TL2ASPMSUSPENDREQN   : out std_ulogic;
      TL2PPMSUSPENDOKN     : out std_ulogic;
      TRNFCCPLD            : out std_logic_vector(11 downto 0);
      TRNFCCPLH            : out std_logic_vector(7 downto 0);
      TRNFCNPD             : out std_logic_vector(11 downto 0);
      TRNFCNPH             : out std_logic_vector(7 downto 0);
      TRNFCPD              : out std_logic_vector(11 downto 0);
      TRNFCPH              : out std_logic_vector(7 downto 0);
      TRNLNKUPN            : out std_ulogic;
      TRNRBARHITN          : out std_logic_vector(6 downto 0);
      TRNRD                : out std_logic_vector(63 downto 0);
      TRNRDLLPDATA         : out std_logic_vector(31 downto 0);
      TRNRDLLPSRCRDYN      : out std_ulogic;
      TRNRECRCERRN         : out std_ulogic;
      TRNREOFN             : out std_ulogic;
      TRNRERRFWDN          : out std_ulogic;
      TRNRREMN             : out std_ulogic;
      TRNRSOFN             : out std_ulogic;
      TRNRSRCDSCN          : out std_ulogic;
      TRNRSRCRDYN          : out std_ulogic;
      TRNTBUFAV            : out std_logic_vector(5 downto 0);
      TRNTCFGREQN          : out std_ulogic;
      TRNTDLLPDSTRDYN      : out std_ulogic;
      TRNTDSTRDYN          : out std_ulogic;
      TRNTERRDROPN         : out std_ulogic;
      USERRSTN             : out std_ulogic;
      CFGBYTEENN           : in std_logic_vector(3 downto 0);
      CFGDI                : in std_logic_vector(31 downto 0);
      CFGDSBUSNUMBER       : in std_logic_vector(7 downto 0);
      CFGDSDEVICENUMBER    : in std_logic_vector(4 downto 0);
      CFGDSFUNCTIONNUMBER  : in std_logic_vector(2 downto 0);
      CFGDSN               : in std_logic_vector(63 downto 0);
      CFGDWADDR            : in std_logic_vector(9 downto 0);
      CFGERRACSN           : in std_ulogic;
      CFGERRAERHEADERLOG   : in std_logic_vector(127 downto 0);
      CFGERRCORN           : in std_ulogic;
      CFGERRCPLABORTN      : in std_ulogic;
      CFGERRCPLTIMEOUTN    : in std_ulogic;
      CFGERRCPLUNEXPECTN   : in std_ulogic;
      CFGERRECRCN          : in std_ulogic;
      CFGERRLOCKEDN        : in std_ulogic;
      CFGERRPOSTEDN        : in std_ulogic;
      CFGERRTLPCPLHEADER   : in std_logic_vector(47 downto 0);
      CFGERRURN            : in std_ulogic;
      CFGINTERRUPTASSERTN  : in std_ulogic;
      CFGINTERRUPTDI       : in std_logic_vector(7 downto 0);
      CFGINTERRUPTN        : in std_ulogic;
      CFGPMDIRECTASPML1N   : in std_ulogic;
      CFGPMSENDPMACKN      : in std_ulogic;
      CFGPMSENDPMETON      : in std_ulogic;
      CFGPMSENDPMNAKN      : in std_ulogic;
      CFGPMTURNOFFOKN      : in std_ulogic;
      CFGPMWAKEN           : in std_ulogic;
      CFGPORTNUMBER        : in std_logic_vector(7 downto 0);
      CFGRDENN             : in std_ulogic;
      CFGTRNPENDINGN       : in std_ulogic;
      CFGWRENN             : in std_ulogic;
      CFGWRREADONLYN       : in std_ulogic;
      CFGWRRW1CASRWN       : in std_ulogic;
      CMRSTN               : in std_ulogic;
      CMSTICKYRSTN         : in std_ulogic;
      DBGMODE              : in std_logic_vector(1 downto 0);
      DBGSUBMODE           : in std_ulogic;
      DLRSTN               : in std_ulogic;
      DRPCLK               : in std_ulogic;
      DRPDADDR             : in std_logic_vector(8 downto 0);
      DRPDEN               : in std_ulogic;
      DRPDI                : in std_logic_vector(15 downto 0);
      DRPDWE               : in std_ulogic;
      FUNCLVLRSTN          : in std_ulogic;
      LL2SENDASREQL1N      : in std_ulogic;
      LL2SENDENTERL1N      : in std_ulogic;
      LL2SENDENTERL23N     : in std_ulogic;
      LL2SUSPENDNOWN       : in std_ulogic;
      LL2TLPRCVN           : in std_ulogic;
      MIMRXRDATA           : in std_logic_vector(67 downto 0);
      MIMTXRDATA           : in std_logic_vector(68 downto 0);
      PIPECLK              : in std_ulogic;
      PIPERX0CHANISALIGNED : in std_ulogic;
      PIPERX0CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX0DATA          : in std_logic_vector(15 downto 0);
      PIPERX0ELECIDLE      : in std_ulogic;
      PIPERX0PHYSTATUS     : in std_ulogic;
      PIPERX0STATUS        : in std_logic_vector(2 downto 0);
      PIPERX0VALID         : in std_ulogic;
      PIPERX1CHANISALIGNED : in std_ulogic;
      PIPERX1CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX1DATA          : in std_logic_vector(15 downto 0);
      PIPERX1ELECIDLE      : in std_ulogic;
      PIPERX1PHYSTATUS     : in std_ulogic;
      PIPERX1STATUS        : in std_logic_vector(2 downto 0);
      PIPERX1VALID         : in std_ulogic;
      PIPERX2CHANISALIGNED : in std_ulogic;
      PIPERX2CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX2DATA          : in std_logic_vector(15 downto 0);
      PIPERX2ELECIDLE      : in std_ulogic;
      PIPERX2PHYSTATUS     : in std_ulogic;
      PIPERX2STATUS        : in std_logic_vector(2 downto 0);
      PIPERX2VALID         : in std_ulogic;
      PIPERX3CHANISALIGNED : in std_ulogic;
      PIPERX3CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX3DATA          : in std_logic_vector(15 downto 0);
      PIPERX3ELECIDLE      : in std_ulogic;
      PIPERX3PHYSTATUS     : in std_ulogic;
      PIPERX3STATUS        : in std_logic_vector(2 downto 0);
      PIPERX3VALID         : in std_ulogic;
      PIPERX4CHANISALIGNED : in std_ulogic;
      PIPERX4CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX4DATA          : in std_logic_vector(15 downto 0);
      PIPERX4ELECIDLE      : in std_ulogic;
      PIPERX4PHYSTATUS     : in std_ulogic;
      PIPERX4STATUS        : in std_logic_vector(2 downto 0);
      PIPERX4VALID         : in std_ulogic;
      PIPERX5CHANISALIGNED : in std_ulogic;
      PIPERX5CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX5DATA          : in std_logic_vector(15 downto 0);
      PIPERX5ELECIDLE      : in std_ulogic;
      PIPERX5PHYSTATUS     : in std_ulogic;
      PIPERX5STATUS        : in std_logic_vector(2 downto 0);
      PIPERX5VALID         : in std_ulogic;
      PIPERX6CHANISALIGNED : in std_ulogic;
      PIPERX6CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX6DATA          : in std_logic_vector(15 downto 0);
      PIPERX6ELECIDLE      : in std_ulogic;
      PIPERX6PHYSTATUS     : in std_ulogic;
      PIPERX6STATUS        : in std_logic_vector(2 downto 0);
      PIPERX6VALID         : in std_ulogic;
      PIPERX7CHANISALIGNED : in std_ulogic;
      PIPERX7CHARISK       : in std_logic_vector(1 downto 0);
      PIPERX7DATA          : in std_logic_vector(15 downto 0);
      PIPERX7ELECIDLE      : in std_ulogic;
      PIPERX7PHYSTATUS     : in std_ulogic;
      PIPERX7STATUS        : in std_logic_vector(2 downto 0);
      PIPERX7VALID         : in std_ulogic;
      PL2DIRECTEDLSTATE    : in std_logic_vector(4 downto 0);
      PLDBGMODE            : in std_logic_vector(2 downto 0);
      PLDIRECTEDLINKAUTON  : in std_ulogic;
      PLDIRECTEDLINKCHANGE : in std_logic_vector(1 downto 0);
      PLDIRECTEDLINKSPEED  : in std_ulogic;
      PLDIRECTEDLINKWIDTH  : in std_logic_vector(1 downto 0);
      PLDOWNSTREAMDEEMPHSOURCE : in std_ulogic;
      PLRSTN               : in std_ulogic;
      PLTRANSMITHOTRST     : in std_ulogic;
      PLUPSTREAMPREFERDEEMPH : in std_ulogic;
      SYSRSTN              : in std_ulogic;
      TL2ASPMSUSPENDCREDITCHECKN : in std_ulogic;
      TL2PPMSUSPENDREQN    : in std_ulogic;
      TLRSTN               : in std_ulogic;
      TRNFCSEL             : in std_logic_vector(2 downto 0);
      TRNRDSTRDYN          : in std_ulogic;
      TRNRNPOKN            : in std_ulogic;
      TRNTCFGGNTN          : in std_ulogic;
      TRNTD                : in std_logic_vector(63 downto 0);
      TRNTDLLPDATA         : in std_logic_vector(31 downto 0);
      TRNTDLLPSRCRDYN      : in std_ulogic;
      TRNTECRCGENN         : in std_ulogic;
      TRNTEOFN             : in std_ulogic;
      TRNTERRFWDN          : in std_ulogic;
      TRNTREMN             : in std_ulogic;
      TRNTSOFN             : in std_ulogic;
      TRNTSRCDSCN          : in std_ulogic;
      TRNTSRCRDYN          : in std_ulogic;
      TRNTSTRN             : in std_ulogic;
      USERCLK              : in std_ulogic      
    );
    attribute VITAL_LEVEL0 of X_PCIE_2_0 :     entity is true;
  end X_PCIE_2_0;

  architecture X_PCIE_2_0_V of X_PCIE_2_0 is
    TYPE VitalTimingDataArrayType IS ARRAY (NATURAL RANGE <>) OF VitalTimingDataType;
    component PCIE_2_0_WRAP
      generic (
      AER_BASE_PTR : string;
      AER_CAP_ECRC_CHECK_CAPABLE : string;
      AER_CAP_ECRC_GEN_CAPABLE : string;
      AER_CAP_ID : string;
      AER_CAP_INT_MSG_NUM_MSI : string;
      AER_CAP_INT_MSG_NUM_MSIX : string;
      AER_CAP_NEXTPTR : string;
      AER_CAP_ON : string;
      AER_CAP_PERMIT_ROOTERR_UPDATE : string;
      AER_CAP_VERSION : string;
      ALLOW_X8_GEN2 : string;
      BAR0 : string;
      BAR1 : string;
      BAR2 : string;
      BAR3 : string;
      BAR4 : string;
      BAR5 : string;
      CAPABILITIES_PTR : string;
      CARDBUS_CIS_POINTER : string;
      CLASS_CODE : string;
      CMD_INTX_IMPLEMENTED : string;
      CPL_TIMEOUT_DISABLE_SUPPORTED : string;
      CPL_TIMEOUT_RANGES_SUPPORTED : string;
      CRM_MODULE_RSTS : string;
      DEVICE_ID : string;
      DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE : string;
      DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE : string;
      DEV_CAP_ENDPOINT_L0S_LATENCY : integer;
      DEV_CAP_ENDPOINT_L1_LATENCY : integer;
      DEV_CAP_EXT_TAG_SUPPORTED : string;
      DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE : string;
      DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer;
      DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer;
      DEV_CAP_ROLE_BASED_ERROR : string;
      DEV_CAP_RSVD_14_12 : integer;
      DEV_CAP_RSVD_17_16 : integer;
      DEV_CAP_RSVD_31_29 : integer;
      DEV_CONTROL_AUX_POWER_SUPPORTED : string;
      DISABLE_ASPM_L1_TIMER : string;
      DISABLE_BAR_FILTERING : string;
      DISABLE_ID_CHECK : string;
      DISABLE_LANE_REVERSAL : string;
      DISABLE_RX_TC_FILTER : string;
      DISABLE_SCRAMBLING : string;
      DNSTREAM_LINK_NUM : string;
      DSN_BASE_PTR : string;
      DSN_CAP_ID : string;
      DSN_CAP_NEXTPTR : string;
      DSN_CAP_ON : string;
      DSN_CAP_VERSION : string;
      ENABLE_MSG_ROUTE : string;
      ENABLE_RX_TD_ECRC_TRIM : string;
      ENTER_RVRY_EI_L0 : string;
      EXIT_LOOPBACK_ON_EI : string;
      EXPANSION_ROM : string;
      EXT_CFG_CAP_PTR : string;
      EXT_CFG_XP_CAP_PTR : string;
      HEADER_TYPE : string;
      INFER_EI : string;
      INTERRUPT_PIN : string;
      IS_SWITCH : string;
      LAST_CONFIG_DWORD : string;
      LINK_CAP_ASPM_SUPPORT : integer;
      LINK_CAP_CLOCK_POWER_MANAGEMENT : string;
      LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP : string;
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 : integer;
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 : integer;
      LINK_CAP_L0S_EXIT_LATENCY_GEN1 : integer;
      LINK_CAP_L0S_EXIT_LATENCY_GEN2 : integer;
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 : integer;
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 : integer;
      LINK_CAP_L1_EXIT_LATENCY_GEN1 : integer;
      LINK_CAP_L1_EXIT_LATENCY_GEN2 : integer;
      LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP : string;
      LINK_CAP_MAX_LINK_SPEED : string;
      LINK_CAP_MAX_LINK_WIDTH : string;
      LINK_CAP_RSVD_23_22 : integer;
      LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE : string;
      LINK_CONTROL_RCB : integer;
      LINK_CTRL2_DEEMPHASIS : string;
      LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE : string;
      LINK_CTRL2_TARGET_LINK_SPEED : string;
      LINK_STATUS_SLOT_CLOCK_CONFIG : string;
      LL_ACK_TIMEOUT : string;
      LL_ACK_TIMEOUT_EN : string;
      LL_ACK_TIMEOUT_FUNC : integer;
      LL_REPLAY_TIMEOUT : string;
      LL_REPLAY_TIMEOUT_EN : string;
      LL_REPLAY_TIMEOUT_FUNC : integer;
      LTSSM_MAX_LINK_WIDTH : string;
      MSIX_BASE_PTR : string;
      MSIX_CAP_ID : string;
      MSIX_CAP_NEXTPTR : string;
      MSIX_CAP_ON : string;
      MSIX_CAP_PBA_BIR : integer;
      MSIX_CAP_PBA_OFFSET : string;
      MSIX_CAP_TABLE_BIR : integer;
      MSIX_CAP_TABLE_OFFSET : string;
      MSIX_CAP_TABLE_SIZE : string;
      MSI_BASE_PTR : string;
      MSI_CAP_64_BIT_ADDR_CAPABLE : string;
      MSI_CAP_ID : string;
      MSI_CAP_MULTIMSGCAP : integer;
      MSI_CAP_MULTIMSG_EXTENSION : integer;
      MSI_CAP_NEXTPTR : string;
      MSI_CAP_ON : string;
      MSI_CAP_PER_VECTOR_MASKING_CAPABLE : string;
      N_FTS_COMCLK_GEN1 : integer;
      N_FTS_COMCLK_GEN2 : integer;
      N_FTS_GEN1 : integer;
      N_FTS_GEN2 : integer;
      PCIE_BASE_PTR : string;
      PCIE_CAP_CAPABILITY_ID : string;
      PCIE_CAP_CAPABILITY_VERSION : string;
      PCIE_CAP_DEVICE_PORT_TYPE : string;
      PCIE_CAP_INT_MSG_NUM : string;
      PCIE_CAP_NEXTPTR : string;
      PCIE_CAP_ON : string;
      PCIE_CAP_RSVD_15_14 : integer;
      PCIE_CAP_SLOT_IMPLEMENTED : string;
      PCIE_REVISION : integer;
      PGL0_LANE : integer;
      PGL1_LANE : integer;
      PGL2_LANE : integer;
      PGL3_LANE : integer;
      PGL4_LANE : integer;
      PGL5_LANE : integer;
      PGL6_LANE : integer;
      PGL7_LANE : integer;
      PL_AUTO_CONFIG : integer;
      PL_FAST_TRAIN : string;
      PM_BASE_PTR : string;
      PM_CAP_AUXCURRENT : integer;
      PM_CAP_D1SUPPORT : string;
      PM_CAP_D2SUPPORT : string;
      PM_CAP_DSI : string;
      PM_CAP_ID : string;
      PM_CAP_NEXTPTR : string;
      PM_CAP_ON : string;
      PM_CAP_PMESUPPORT : string;
      PM_CAP_PME_CLOCK : string;
      PM_CAP_RSVD_04 : integer;
      PM_CAP_VERSION : integer;
      PM_CSR_B2B3 : string;
      PM_CSR_BPCCEN : string;
      PM_CSR_NOSOFTRST : string;
      PM_DATA0 : string;
      PM_DATA1 : string;
      PM_DATA2 : string;
      PM_DATA3 : string;
      PM_DATA4 : string;
      PM_DATA5 : string;
      PM_DATA6 : string;
      PM_DATA7 : string;
      PM_DATA_SCALE0 : string;
      PM_DATA_SCALE1 : string;
      PM_DATA_SCALE2 : string;
      PM_DATA_SCALE3 : string;
      PM_DATA_SCALE4 : string;
      PM_DATA_SCALE5 : string;
      PM_DATA_SCALE6 : string;
      PM_DATA_SCALE7 : string;
      RECRC_CHK : integer;
      RECRC_CHK_TRIM : string;
      REVISION_ID : string;
      ROOT_CAP_CRS_SW_VISIBILITY : string;
      SELECT_DLL_IF : string;
      SIM_VERSION : string;
      SLOT_CAP_ATT_BUTTON_PRESENT : string;
      SLOT_CAP_ATT_INDICATOR_PRESENT : string;
      SLOT_CAP_ELEC_INTERLOCK_PRESENT : string;
      SLOT_CAP_HOTPLUG_CAPABLE : string;
      SLOT_CAP_HOTPLUG_SURPRISE : string;
      SLOT_CAP_MRL_SENSOR_PRESENT : string;
      SLOT_CAP_NO_CMD_COMPLETED_SUPPORT : string;
      SLOT_CAP_PHYSICAL_SLOT_NUM : string;
      SLOT_CAP_POWER_CONTROLLER_PRESENT : string;
      SLOT_CAP_POWER_INDICATOR_PRESENT : string;
      SLOT_CAP_SLOT_POWER_LIMIT_SCALE : integer;
      SLOT_CAP_SLOT_POWER_LIMIT_VALUE : string;
      SPARE_BIT0 : integer;
      SPARE_BIT1 : integer;
      SPARE_BIT2 : integer;
      SPARE_BIT3 : integer;
      SPARE_BIT4 : integer;
      SPARE_BIT5 : integer;
      SPARE_BIT6 : integer;
      SPARE_BIT7 : integer;
      SPARE_BIT8 : integer;
      SPARE_BYTE0 : string;
      SPARE_BYTE1 : string;
      SPARE_BYTE2 : string;
      SPARE_BYTE3 : string;
      SPARE_WORD0 : string;
      SPARE_WORD1 : string;
      SPARE_WORD2 : string;
      SPARE_WORD3 : string;
      SUBSYSTEM_ID : string;
      SUBSYSTEM_VENDOR_ID : string;
      TL_RBYPASS : string;
      TL_RX_RAM_RADDR_LATENCY : integer;
      TL_RX_RAM_RDATA_LATENCY : integer;
      TL_RX_RAM_WRITE_LATENCY : integer;
      TL_TFC_DISABLE : string;
      TL_TX_CHECKS_DISABLE : string;
      TL_TX_RAM_RADDR_LATENCY : integer;
      TL_TX_RAM_RDATA_LATENCY : integer;
      TL_TX_RAM_WRITE_LATENCY : integer;
      UPCONFIG_CAPABLE : string;
      UPSTREAM_FACING : string;
      UR_INV_REQ : string;
      USER_CLK_FREQ : integer;
      VC0_CPL_INFINITE : string;
      VC0_RX_RAM_LIMIT : string;
      VC0_TOTAL_CREDITS_CD : integer;
      VC0_TOTAL_CREDITS_CH : integer;
      VC0_TOTAL_CREDITS_NPH : integer;
      VC0_TOTAL_CREDITS_PD : integer;
      VC0_TOTAL_CREDITS_PH : integer;
      VC0_TX_LASTPACKET : integer;
      VC_BASE_PTR : string;
      VC_CAP_ID : string;
      VC_CAP_NEXTPTR : string;
      VC_CAP_ON : string;
      VC_CAP_REJECT_SNOOP_TRANSACTIONS : string;
      VC_CAP_VERSION : string;
      VENDOR_ID : string;
      VSEC_BASE_PTR : string;
      VSEC_CAP_HDR_ID : string;
      VSEC_CAP_HDR_LENGTH : string;
      VSEC_CAP_HDR_REVISION : string;
      VSEC_CAP_ID : string;
      VSEC_CAP_IS_LINK_VISIBLE : string;
      VSEC_CAP_NEXTPTR : string;
      VSEC_CAP_ON : string;
      VSEC_CAP_VERSION : string
       );
      
      port (
        CFGAERECRCCHECKEN    : out std_ulogic;
        CFGAERECRCGENEN      : out std_ulogic;
        CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
        CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
        CFGCOMMANDIOENABLE   : out std_ulogic;
        CFGCOMMANDMEMENABLE  : out std_ulogic;
        CFGCOMMANDSERREN     : out std_ulogic;
        CFGDEVCONTROL2CPLTIMEOUTDIS : out std_ulogic;
        CFGDEVCONTROL2CPLTIMEOUTVAL : out std_logic_vector(3 downto 0);
        CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
        CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
        CFGDEVCONTROLENABLERO : out std_ulogic;
        CFGDEVCONTROLEXTTAGEN : out std_ulogic;
        CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
        CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
        CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
        CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
        CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
        CFGDEVCONTROLPHANTOMEN : out std_ulogic;
        CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
        CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
        CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
        CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
        CFGDEVSTATUSURDETECTED : out std_ulogic;
        CFGDO                : out std_logic_vector(31 downto 0);
        CFGERRAERHEADERLOGSETN : out std_ulogic;
        CFGERRCPLRDYN        : out std_ulogic;
        CFGINTERRUPTDO       : out std_logic_vector(7 downto 0);
        CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
        CFGINTERRUPTMSIENABLE : out std_ulogic;
        CFGINTERRUPTMSIXENABLE : out std_ulogic;
        CFGINTERRUPTMSIXFM   : out std_ulogic;
        CFGINTERRUPTRDYN     : out std_ulogic;
        CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
        CFGLINKCONTROLAUTOBANDWIDTHINTEN : out std_ulogic;
        CFGLINKCONTROLBANDWIDTHINTEN : out std_ulogic;
        CFGLINKCONTROLCLOCKPMEN : out std_ulogic;
        CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
        CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
        CFGLINKCONTROLHWAUTOWIDTHDIS : out std_ulogic;
        CFGLINKCONTROLLINKDISABLE : out std_ulogic;
        CFGLINKCONTROLRCB    : out std_ulogic;
        CFGLINKCONTROLRETRAINLINK : out std_ulogic;
        CFGLINKSTATUSAUTOBANDWIDTHSTATUS : out std_ulogic;
        CFGLINKSTATUSBANDWITHSTATUS : out std_ulogic;
        CFGLINKSTATUSCURRENTSPEED : out std_logic_vector(1 downto 0);
        CFGLINKSTATUSDLLACTIVE : out std_ulogic;
        CFGLINKSTATUSLINKTRAINING : out std_ulogic;
        CFGLINKSTATUSNEGOTIATEDWIDTH : out std_logic_vector(3 downto 0);
        CFGMSGDATA           : out std_logic_vector(15 downto 0);
        CFGMSGRECEIVED       : out std_ulogic;
        CFGMSGRECEIVEDASSERTINTA : out std_ulogic;
        CFGMSGRECEIVEDASSERTINTB : out std_ulogic;
        CFGMSGRECEIVEDASSERTINTC : out std_ulogic;
        CFGMSGRECEIVEDASSERTINTD : out std_ulogic;
        CFGMSGRECEIVEDDEASSERTINTA : out std_ulogic;
        CFGMSGRECEIVEDDEASSERTINTB : out std_ulogic;
        CFGMSGRECEIVEDDEASSERTINTC : out std_ulogic;
        CFGMSGRECEIVEDDEASSERTINTD : out std_ulogic;
        CFGMSGRECEIVEDERRCOR : out std_ulogic;
        CFGMSGRECEIVEDERRFATAL : out std_ulogic;
        CFGMSGRECEIVEDERRNONFATAL : out std_ulogic;
        CFGMSGRECEIVEDPMASNAK : out std_ulogic;
        CFGMSGRECEIVEDPMETO  : out std_ulogic;
        CFGMSGRECEIVEDPMETOACK : out std_ulogic;
        CFGMSGRECEIVEDPMPME  : out std_ulogic;
        CFGMSGRECEIVEDSETSLOTPOWERLIMIT : out std_ulogic;
        CFGMSGRECEIVEDUNLOCK : out std_ulogic;
        CFGPCIELINKSTATE     : out std_logic_vector(2 downto 0);
        CFGPMCSRPMEEN        : out std_ulogic;
        CFGPMCSRPMESTATUS    : out std_ulogic;
        CFGPMCSRPOWERSTATE   : out std_logic_vector(1 downto 0);
        CFGPMRCVASREQL1N     : out std_ulogic;
        CFGPMRCVENTERL1N     : out std_ulogic;
        CFGPMRCVENTERL23N    : out std_ulogic;
        CFGPMRCVREQACKN      : out std_ulogic;
        CFGRDWRDONEN         : out std_ulogic;
        CFGSLOTCONTROLELECTROMECHILCTLPULSE : out std_ulogic;
        CFGTRANSACTION       : out std_ulogic;
        CFGTRANSACTIONADDR   : out std_logic_vector(6 downto 0);
        CFGTRANSACTIONTYPE   : out std_ulogic;
        CFGVCTCVCMAP         : out std_logic_vector(6 downto 0);
        DBGSCLRA             : out std_ulogic;
        DBGSCLRB             : out std_ulogic;
        DBGSCLRC             : out std_ulogic;
        DBGSCLRD             : out std_ulogic;
        DBGSCLRE             : out std_ulogic;
        DBGSCLRF             : out std_ulogic;
        DBGSCLRG             : out std_ulogic;
        DBGSCLRH             : out std_ulogic;
        DBGSCLRI             : out std_ulogic;
        DBGSCLRJ             : out std_ulogic;
        DBGSCLRK             : out std_ulogic;
        DBGVECA              : out std_logic_vector(63 downto 0);
        DBGVECB              : out std_logic_vector(63 downto 0);
        DBGVECC              : out std_logic_vector(11 downto 0);
        DRPDO                : out std_logic_vector(15 downto 0);
        DRPDRDY              : out std_ulogic;
        LL2BADDLLPERRN       : out std_ulogic;
        LL2BADTLPERRN        : out std_ulogic;
        LL2PROTOCOLERRN      : out std_ulogic;
        LL2REPLAYROERRN      : out std_ulogic;
        LL2REPLAYTOERRN      : out std_ulogic;
        LL2SUSPENDOKN        : out std_ulogic;
        LL2TFCINIT1SEQN      : out std_ulogic;
        LL2TFCINIT2SEQN      : out std_ulogic;
        LNKCLKEN             : out std_ulogic;
        MIMRXRADDR           : out std_logic_vector(12 downto 0);
        MIMRXRCE             : out std_ulogic;
        MIMRXREN             : out std_ulogic;
        MIMRXWADDR           : out std_logic_vector(12 downto 0);
        MIMRXWDATA           : out std_logic_vector(67 downto 0);
        MIMRXWEN             : out std_ulogic;
        MIMTXRADDR           : out std_logic_vector(12 downto 0);
        MIMTXRCE             : out std_ulogic;
        MIMTXREN             : out std_ulogic;
        MIMTXWADDR           : out std_logic_vector(12 downto 0);
        MIMTXWDATA           : out std_logic_vector(68 downto 0);
        MIMTXWEN             : out std_ulogic;
        PIPERX0POLARITY      : out std_ulogic;
        PIPERX1POLARITY      : out std_ulogic;
        PIPERX2POLARITY      : out std_ulogic;
        PIPERX3POLARITY      : out std_ulogic;
        PIPERX4POLARITY      : out std_ulogic;
        PIPERX5POLARITY      : out std_ulogic;
        PIPERX6POLARITY      : out std_ulogic;
        PIPERX7POLARITY      : out std_ulogic;
        PIPETX0CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX0COMPLIANCE    : out std_ulogic;
        PIPETX0DATA          : out std_logic_vector(15 downto 0);
        PIPETX0ELECIDLE      : out std_ulogic;
        PIPETX0POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX1CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX1COMPLIANCE    : out std_ulogic;
        PIPETX1DATA          : out std_logic_vector(15 downto 0);
        PIPETX1ELECIDLE      : out std_ulogic;
        PIPETX1POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX2CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX2COMPLIANCE    : out std_ulogic;
        PIPETX2DATA          : out std_logic_vector(15 downto 0);
        PIPETX2ELECIDLE      : out std_ulogic;
        PIPETX2POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX3CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX3COMPLIANCE    : out std_ulogic;
        PIPETX3DATA          : out std_logic_vector(15 downto 0);
        PIPETX3ELECIDLE      : out std_ulogic;
        PIPETX3POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX4CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX4COMPLIANCE    : out std_ulogic;
        PIPETX4DATA          : out std_logic_vector(15 downto 0);
        PIPETX4ELECIDLE      : out std_ulogic;
        PIPETX4POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX5CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX5COMPLIANCE    : out std_ulogic;
        PIPETX5DATA          : out std_logic_vector(15 downto 0);
        PIPETX5ELECIDLE      : out std_ulogic;
        PIPETX5POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX6CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX6COMPLIANCE    : out std_ulogic;
        PIPETX6DATA          : out std_logic_vector(15 downto 0);
        PIPETX6ELECIDLE      : out std_ulogic;
        PIPETX6POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETX7CHARISK       : out std_logic_vector(1 downto 0);
        PIPETX7COMPLIANCE    : out std_ulogic;
        PIPETX7DATA          : out std_logic_vector(15 downto 0);
        PIPETX7ELECIDLE      : out std_ulogic;
        PIPETX7POWERDOWN     : out std_logic_vector(1 downto 0);
        PIPETXDEEMPH         : out std_ulogic;
        PIPETXMARGIN         : out std_logic_vector(2 downto 0);
        PIPETXRATE           : out std_ulogic;
        PIPETXRCVRDET        : out std_ulogic;
        PIPETXRESET          : out std_ulogic;
        PL2LINKUPN           : out std_ulogic;
        PL2RECEIVERERRN      : out std_ulogic;
        PL2RECOVERYN         : out std_ulogic;
        PL2RXELECIDLE        : out std_ulogic;
        PL2SUSPENDOK         : out std_ulogic;
        PLDBGVEC             : out std_logic_vector(11 downto 0);
        PLINITIALLINKWIDTH   : out std_logic_vector(2 downto 0);
        PLLANEREVERSALMODE   : out std_logic_vector(1 downto 0);
        PLLINKGEN2CAP        : out std_ulogic;
        PLLINKPARTNERGEN2SUPPORTED : out std_ulogic;
        PLLINKUPCFGCAP       : out std_ulogic;
        PLLTSSMSTATE         : out std_logic_vector(5 downto 0);
        PLPHYLNKUPN          : out std_ulogic;
        PLRECEIVEDHOTRST     : out std_ulogic;
        PLRXPMSTATE          : out std_logic_vector(1 downto 0);
        PLSELLNKRATE         : out std_ulogic;
        PLSELLNKWIDTH        : out std_logic_vector(1 downto 0);
        PLTXPMSTATE          : out std_logic_vector(2 downto 0);
        RECEIVEDFUNCLVLRSTN  : out std_ulogic;
        TL2ASPMSUSPENDCREDITCHECKOKN : out std_ulogic;
        TL2ASPMSUSPENDREQN   : out std_ulogic;
        TL2PPMSUSPENDOKN     : out std_ulogic;
        TRNFCCPLD            : out std_logic_vector(11 downto 0);
        TRNFCCPLH            : out std_logic_vector(7 downto 0);
        TRNFCNPD             : out std_logic_vector(11 downto 0);
        TRNFCNPH             : out std_logic_vector(7 downto 0);
        TRNFCPD              : out std_logic_vector(11 downto 0);
        TRNFCPH              : out std_logic_vector(7 downto 0);
        TRNLNKUPN            : out std_ulogic;
        TRNRBARHITN          : out std_logic_vector(6 downto 0);
        TRNRD                : out std_logic_vector(63 downto 0);
        TRNRDLLPDATA         : out std_logic_vector(31 downto 0);
        TRNRDLLPSRCRDYN      : out std_ulogic;
        TRNRECRCERRN         : out std_ulogic;
        TRNREOFN             : out std_ulogic;
        TRNRERRFWDN          : out std_ulogic;
        TRNRREMN             : out std_ulogic;
        TRNRSOFN             : out std_ulogic;
        TRNRSRCDSCN          : out std_ulogic;
        TRNRSRCRDYN          : out std_ulogic;
        TRNTBUFAV            : out std_logic_vector(5 downto 0);
        TRNTCFGREQN          : out std_ulogic;
        TRNTDLLPDSTRDYN      : out std_ulogic;
        TRNTDSTRDYN          : out std_ulogic;
        TRNTERRDROPN         : out std_ulogic;
        USERRSTN             : out std_ulogic;
        GSR                  : in std_ulogic;
        CFGBYTEENN           : in std_logic_vector(3 downto 0);
        CFGDI                : in std_logic_vector(31 downto 0);
        CFGDSBUSNUMBER       : in std_logic_vector(7 downto 0);
        CFGDSDEVICENUMBER    : in std_logic_vector(4 downto 0);
        CFGDSFUNCTIONNUMBER  : in std_logic_vector(2 downto 0);
        CFGDSN               : in std_logic_vector(63 downto 0);
        CFGDWADDR            : in std_logic_vector(9 downto 0);
        CFGERRACSN           : in std_ulogic;
        CFGERRAERHEADERLOG   : in std_logic_vector(127 downto 0);
        CFGERRCORN           : in std_ulogic;
        CFGERRCPLABORTN      : in std_ulogic;
        CFGERRCPLTIMEOUTN    : in std_ulogic;
        CFGERRCPLUNEXPECTN   : in std_ulogic;
        CFGERRECRCN          : in std_ulogic;
        CFGERRLOCKEDN        : in std_ulogic;
        CFGERRPOSTEDN        : in std_ulogic;
        CFGERRTLPCPLHEADER   : in std_logic_vector(47 downto 0);
        CFGERRURN            : in std_ulogic;
        CFGINTERRUPTASSERTN  : in std_ulogic;
        CFGINTERRUPTDI       : in std_logic_vector(7 downto 0);
        CFGINTERRUPTN        : in std_ulogic;
        CFGPMDIRECTASPML1N   : in std_ulogic;
        CFGPMSENDPMACKN      : in std_ulogic;
        CFGPMSENDPMETON      : in std_ulogic;
        CFGPMSENDPMNAKN      : in std_ulogic;
        CFGPMTURNOFFOKN      : in std_ulogic;
        CFGPMWAKEN           : in std_ulogic;
        CFGPORTNUMBER        : in std_logic_vector(7 downto 0);
        CFGRDENN             : in std_ulogic;
        CFGTRNPENDINGN       : in std_ulogic;
        CFGWRENN             : in std_ulogic;
        CFGWRREADONLYN       : in std_ulogic;
        CFGWRRW1CASRWN       : in std_ulogic;
        CMRSTN               : in std_ulogic;
        CMSTICKYRSTN         : in std_ulogic;
        DBGMODE              : in std_logic_vector(1 downto 0);
        DBGSUBMODE           : in std_ulogic;
        DLRSTN               : in std_ulogic;
        DRPCLK               : in std_ulogic;
        DRPDADDR             : in std_logic_vector(8 downto 0);
        DRPDEN               : in std_ulogic;
        DRPDI                : in std_logic_vector(15 downto 0);
        DRPDWE               : in std_ulogic;
        FUNCLVLRSTN          : in std_ulogic;
        LL2SENDASREQL1N      : in std_ulogic;
        LL2SENDENTERL1N      : in std_ulogic;
        LL2SENDENTERL23N     : in std_ulogic;
        LL2SUSPENDNOWN       : in std_ulogic;
        LL2TLPRCVN           : in std_ulogic;
        MIMRXRDATA           : in std_logic_vector(67 downto 0);
        MIMTXRDATA           : in std_logic_vector(68 downto 0);
        PIPECLK              : in std_ulogic;
        PIPERX0CHANISALIGNED : in std_ulogic;
        PIPERX0CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX0DATA          : in std_logic_vector(15 downto 0);
        PIPERX0ELECIDLE      : in std_ulogic;
        PIPERX0PHYSTATUS     : in std_ulogic;
        PIPERX0STATUS        : in std_logic_vector(2 downto 0);
        PIPERX0VALID         : in std_ulogic;
        PIPERX1CHANISALIGNED : in std_ulogic;
        PIPERX1CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX1DATA          : in std_logic_vector(15 downto 0);
        PIPERX1ELECIDLE      : in std_ulogic;
        PIPERX1PHYSTATUS     : in std_ulogic;
        PIPERX1STATUS        : in std_logic_vector(2 downto 0);
        PIPERX1VALID         : in std_ulogic;
        PIPERX2CHANISALIGNED : in std_ulogic;
        PIPERX2CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX2DATA          : in std_logic_vector(15 downto 0);
        PIPERX2ELECIDLE      : in std_ulogic;
        PIPERX2PHYSTATUS     : in std_ulogic;
        PIPERX2STATUS        : in std_logic_vector(2 downto 0);
        PIPERX2VALID         : in std_ulogic;
        PIPERX3CHANISALIGNED : in std_ulogic;
        PIPERX3CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX3DATA          : in std_logic_vector(15 downto 0);
        PIPERX3ELECIDLE      : in std_ulogic;
        PIPERX3PHYSTATUS     : in std_ulogic;
        PIPERX3STATUS        : in std_logic_vector(2 downto 0);
        PIPERX3VALID         : in std_ulogic;
        PIPERX4CHANISALIGNED : in std_ulogic;
        PIPERX4CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX4DATA          : in std_logic_vector(15 downto 0);
        PIPERX4ELECIDLE      : in std_ulogic;
        PIPERX4PHYSTATUS     : in std_ulogic;
        PIPERX4STATUS        : in std_logic_vector(2 downto 0);
        PIPERX4VALID         : in std_ulogic;
        PIPERX5CHANISALIGNED : in std_ulogic;
        PIPERX5CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX5DATA          : in std_logic_vector(15 downto 0);
        PIPERX5ELECIDLE      : in std_ulogic;
        PIPERX5PHYSTATUS     : in std_ulogic;
        PIPERX5STATUS        : in std_logic_vector(2 downto 0);
        PIPERX5VALID         : in std_ulogic;
        PIPERX6CHANISALIGNED : in std_ulogic;
        PIPERX6CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX6DATA          : in std_logic_vector(15 downto 0);
        PIPERX6ELECIDLE      : in std_ulogic;
        PIPERX6PHYSTATUS     : in std_ulogic;
        PIPERX6STATUS        : in std_logic_vector(2 downto 0);
        PIPERX6VALID         : in std_ulogic;
        PIPERX7CHANISALIGNED : in std_ulogic;
        PIPERX7CHARISK       : in std_logic_vector(1 downto 0);
        PIPERX7DATA          : in std_logic_vector(15 downto 0);
        PIPERX7ELECIDLE      : in std_ulogic;
        PIPERX7PHYSTATUS     : in std_ulogic;
        PIPERX7STATUS        : in std_logic_vector(2 downto 0);
        PIPERX7VALID         : in std_ulogic;
        PL2DIRECTEDLSTATE    : in std_logic_vector(4 downto 0);
        PLDBGMODE            : in std_logic_vector(2 downto 0);
        PLDIRECTEDLINKAUTON  : in std_ulogic;
        PLDIRECTEDLINKCHANGE : in std_logic_vector(1 downto 0);
        PLDIRECTEDLINKSPEED  : in std_ulogic;
        PLDIRECTEDLINKWIDTH  : in std_logic_vector(1 downto 0);
        PLDOWNSTREAMDEEMPHSOURCE : in std_ulogic;
        PLRSTN               : in std_ulogic;
        PLTRANSMITHOTRST     : in std_ulogic;
        PLUPSTREAMPREFERDEEMPH : in std_ulogic;
        SYSRSTN              : in std_ulogic;
        TL2ASPMSUSPENDCREDITCHECKN : in std_ulogic;
        TL2PPMSUSPENDREQN    : in std_ulogic;
        TLRSTN               : in std_ulogic;
        TRNFCSEL             : in std_logic_vector(2 downto 0);
        TRNRDSTRDYN          : in std_ulogic;
        TRNRNPOKN            : in std_ulogic;
        TRNTCFGGNTN          : in std_ulogic;
        TRNTD                : in std_logic_vector(63 downto 0);
        TRNTDLLPDATA         : in std_logic_vector(31 downto 0);
        TRNTDLLPSRCRDYN      : in std_ulogic;
        TRNTECRCGENN         : in std_ulogic;
        TRNTEOFN             : in std_ulogic;
        TRNTERRFWDN          : in std_ulogic;
        TRNTREMN             : in std_ulogic;
        TRNTSOFN             : in std_ulogic;
        TRNTSRCDSCN          : in std_ulogic;
        TRNTSRCRDYN          : in std_ulogic;
        TRNTSTRN             : in std_ulogic;
        USERCLK              : in std_ulogic        
      );
    end component;
    
    constant IN_DELAY : time := 0 ps;
    constant OUT_DELAY : time := 0 ps;
    constant INCLK_DELAY : time := 0 ps;
    constant OUTCLK_DELAY : time := 0 ps;

    function boolean_to_string(bool: boolean)
    return string is
    begin
      if bool then
        return "TRUE";
      else
        return "FALSE";
      end if;
    end boolean_to_string;

    function getstrlength (
           in_vec : std_logic_vector)
    return integer is
     variable string_length : integer;
    begin
     if ((in_vec'length mod 4) = 0) then
      string_length := in_vec'length/4;
    elsif ((in_vec'length mod 4) > 0) then
      string_length := in_vec'length/4 + 1;
    end if;
    return string_length;
    end getstrlength;
       
     -- Converts bit_vector to std_logic_vector
       constant AER_BASE_PTR_BINARY : std_logic_vector(11 downto 0):= To_StdLogicVector(AER_BASE_PTR)(11 downto 0);
       constant AER_BASE_PTR_STRLEN : integer:= getstrlength(AER_BASE_PTR_BINARY);
       constant AER_CAP_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(AER_CAP_ID)(15 downto 0);
       constant AER_CAP_ID_STRLEN : integer:= getstrlength(AER_CAP_ID_BINARY);
       constant AER_CAP_INT_MSG_NUM_MSIX_BINARY : std_logic_vector(4 downto 0):= To_StdLogicVector(AER_CAP_INT_MSG_NUM_MSIX)(4 downto 0);
       constant AER_CAP_INT_MSG_NUM_MSIX_STRLEN : integer:= getstrlength(AER_CAP_INT_MSG_NUM_MSIX_BINARY);
       constant AER_CAP_INT_MSG_NUM_MSI_BINARY : std_logic_vector(4 downto 0) := To_StdLogicVector(AER_CAP_INT_MSG_NUM_MSI)(4 downto 0) ;
       constant AER_CAP_INT_MSG_NUM_MSI_STRLEN : integer:= getstrlength(AER_CAP_INT_MSG_NUM_MSI_BINARY);
       constant AER_CAP_NEXTPTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(AER_CAP_NEXTPTR)(11 downto 0);
       constant AER_CAP_NEXTPTR_STRLEN : integer:= getstrlength(AER_CAP_NEXTPTR_BINARY);
        constant AER_CAP_VERSION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(AER_CAP_VERSION)(3 downto 0);
       constant AER_CAP_VERSION_STRLEN : integer:= getstrlength(AER_CAP_VERSION_BINARY);
       constant BAR0_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR0)(31 downto 0);
       constant BAR0_STRLEN : integer:= getstrlength(BAR0_BINARY);
    constant BAR1_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR1)(31 downto 0);
       constant BAR1_STRLEN : integer:= getstrlength(BAR1_BINARY);
    constant BAR2_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR2)(31 downto 0);
       constant BAR2_STRLEN : integer:= getstrlength(BAR2_BINARY);
    constant BAR3_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR3)(31 downto 0);
       constant BAR3_STRLEN : integer:= getstrlength(BAR3_BINARY);
    constant BAR4_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR4)(31 downto 0);
       constant BAR4_STRLEN : integer:= getstrlength(BAR4_BINARY);
    constant BAR5_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(BAR5)(31 downto 0);
       constant BAR5_STRLEN : integer:= getstrlength(BAR5_BINARY);
    constant CAPABILITIES_PTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(CAPABILITIES_PTR)(7 downto 0);
       constant CAPABILITIES_PTR_STRLEN : integer:= getstrlength(CAPABILITIES_PTR_BINARY);
    constant CARDBUS_CIS_POINTER_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(CARDBUS_CIS_POINTER)(31 downto 0);
       constant CARDBUS_CIS_POINTER_STRLEN : integer:= getstrlength(CARDBUS_CIS_POINTER_BINARY);
        constant CLASS_CODE_BINARY : std_logic_vector(23 downto 0) := To_StdLogicVector(CLASS_CODE)(23 downto 0) ;
       constant  CLASS_CODE_STRLEN : integer:= getstrlength( CLASS_CODE_BINARY);
       constant CPL_TIMEOUT_RANGES_SUPPORTED_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(CPL_TIMEOUT_RANGES_SUPPORTED)(3 downto 0);
       constant  CPL_TIMEOUT_RANGES_SUPPORTED_STRLEN : integer:= getstrlength( CPL_TIMEOUT_RANGES_SUPPORTED_BINARY);
    constant CRM_MODULE_RSTS_BINARY : std_logic_vector(6 downto 0) := To_StdLogicVector(CRM_MODULE_RSTS)(6 downto 0);
       constant  CRM_MODULE_RSTS_STRLEN : integer:= getstrlength( CRM_MODULE_RSTS_BINARY);
    constant DEVICE_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(DEVICE_ID)(15 downto 0);
       constant  DEVICE_ID_STRLEN : integer:= getstrlength( DEVICE_ID_BINARY);
       constant DNSTREAM_LINK_NUM_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(DNSTREAM_LINK_NUM)(7 downto 0);
       constant  DNSTREAM_LINK_NUM_STRLEN : integer:= getstrlength( DNSTREAM_LINK_NUM_BINARY);
    constant DSN_BASE_PTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(DSN_BASE_PTR)(11 downto 0) ;
       constant  DSN_BASE_PTR_STRLEN : integer:= getstrlength( DSN_BASE_PTR_BINARY);
    constant DSN_CAP_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(DSN_CAP_ID)(15 downto 0);
       constant  DSN_CAP_ID_STRLEN : integer:= getstrlength( DSN_CAP_ID_BINARY);
    constant DSN_CAP_NEXTPTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(DSN_CAP_NEXTPTR)(11 downto 0);
       constant  DSN_CAP_NEXTPTR_STRLEN : integer:= getstrlength( DSN_CAP_NEXTPTR_BINARY);
      constant DSN_CAP_VERSION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(DSN_CAP_VERSION)(3 downto 0) ;
       constant  DSN_CAP_VERSION_STRLEN : integer:= getstrlength( DSN_CAP_VERSION_BINARY);
    constant ENABLE_MSG_ROUTE_BINARY : std_logic_vector(10 downto 0) := To_StdLogicVector(ENABLE_MSG_ROUTE)(10 downto 0);
       constant  ENABLE_MSG_ROUTE_STRLEN : integer:= getstrlength( ENABLE_MSG_ROUTE_BINARY);
       constant EXPANSION_ROM_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(EXPANSION_ROM)(31 downto 0);
       constant  EXPANSION_ROM_STRLEN : integer:= getstrlength( EXPANSION_ROM_BINARY);
       constant EXT_CFG_CAP_PTR_BINARY : std_logic_vector(5 downto 0) := To_StdLogicVector(EXT_CFG_CAP_PTR)(5 downto 0);
       constant  EXT_CFG_CAP_PTR_STRLEN : integer:= getstrlength( EXT_CFG_CAP_PTR_BINARY);
       constant EXT_CFG_XP_CAP_PTR_BINARY : std_logic_vector(9 downto 0) := To_StdLogicVector(EXT_CFG_XP_CAP_PTR)(9 downto 0);
       constant  EXT_CFG_XP_CAP_PTR_STRLEN : integer:= getstrlength( EXT_CFG_XP_CAP_PTR_BINARY);
       constant HEADER_TYPE_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(HEADER_TYPE)(7 downto 0);
       constant  HEADER_TYPE_STRLEN : integer:= getstrlength( HEADER_TYPE_BINARY);
       constant INFER_EI_BINARY : std_logic_vector(4 downto 0) := To_StdLogicVector(INFER_EI)(4 downto 0);
       constant  INFER_EI_STRLEN : integer:= getstrlength( INFER_EI_BINARY);
       constant INTERRUPT_PIN_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(INTERRUPT_PIN)(7 downto 0);
       constant  INTERRUPT_PIN_STRLEN : integer:= getstrlength( INTERRUPT_PIN_BINARY);
 constant LAST_CONFIG_DWORD_BINARY : std_logic_vector(9 downto 0) := To_StdLogicVector(LAST_CONFIG_DWORD)(9 downto 0);
       constant  LAST_CONFIG_DWORD_STRLEN : integer:= getstrlength( LAST_CONFIG_DWORD_BINARY);
        constant LINK_CAP_MAX_LINK_SPEED_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(LINK_CAP_MAX_LINK_SPEED)(3 downto 0);
       constant  LINK_CAP_MAX_LINK_SPEED_STRLEN : integer:= getstrlength( LINK_CAP_MAX_LINK_SPEED_BINARY);
    constant LINK_CAP_MAX_LINK_WIDTH_BINARY : std_logic_vector(5 downto 0) := To_StdLogicVector(LINK_CAP_MAX_LINK_WIDTH)(5 downto 0);
       constant  LINK_CAP_MAX_LINK_WIDTH_STRLEN : integer:= getstrlength( LINK_CAP_MAX_LINK_WIDTH_BINARY);
       constant LINK_CTRL2_TARGET_LINK_SPEED_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(LINK_CTRL2_TARGET_LINK_SPEED)(3 downto 0);
       constant  LINK_CTRL2_TARGET_LINK_SPEED_STRLEN : integer:= getstrlength( LINK_CTRL2_TARGET_LINK_SPEED_BINARY);
       constant LL_ACK_TIMEOUT_BINARY : std_logic_vector(14 downto 0) := To_StdLogicVector(LL_ACK_TIMEOUT)(14 downto 0);
       constant  LL_ACK_TIMEOUT_STRLEN : integer:= getstrlength( LL_ACK_TIMEOUT_BINARY);
       constant LL_REPLAY_TIMEOUT_BINARY : std_logic_vector(14 downto 0) := To_StdLogicVector(LL_REPLAY_TIMEOUT)(14 downto 0);
       constant  LL_REPLAY_TIMEOUT_STRLEN : integer:= getstrlength( LL_REPLAY_TIMEOUT_BINARY);
   constant LTSSM_MAX_LINK_WIDTH_BINARY : std_logic_vector(5 downto 0) := To_StdLogicVector(LTSSM_MAX_LINK_WIDTH)(5 downto 0);
       constant  LTSSM_MAX_LINK_WIDTH_STRLEN : integer:= getstrlength( LTSSM_MAX_LINK_WIDTH_BINARY);
    constant MSIX_BASE_PTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSIX_BASE_PTR)(7 downto 0);
       constant  MSIX_BASE_PTR_STRLEN : integer:= getstrlength( MSIX_BASE_PTR_BINARY);
    constant MSIX_CAP_ID_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSIX_CAP_ID)(7 downto 0);
       constant  MSIX_CAP_ID_STRLEN : integer:= getstrlength( MSIX_CAP_ID_BINARY);
    constant MSIX_CAP_NEXTPTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSIX_CAP_NEXTPTR)(7 downto 0);
       constant  MSIX_CAP_NEXTPTR_STRLEN : integer:= getstrlength( MSIX_CAP_NEXTPTR_BINARY);
 constant MSIX_CAP_PBA_OFFSET_BINARY : std_logic_vector(28 downto 0) := To_StdLogicVector(MSIX_CAP_PBA_OFFSET)(28 downto 0);
       constant  MSIX_CAP_PBA_OFFSET_STRLEN : integer:= getstrlength( MSIX_CAP_PBA_OFFSET_BINARY);
        constant MSIX_CAP_TABLE_OFFSET_BINARY : std_logic_vector(28 downto 0) := To_StdLogicVector(MSIX_CAP_TABLE_OFFSET)(28 downto 0);
       constant  MSIX_CAP_TABLE_OFFSET_STRLEN : integer:= getstrlength( MSIX_CAP_TABLE_OFFSET_BINARY);
constant MSIX_CAP_TABLE_SIZE_BINARY : std_logic_vector(10 downto 0) := To_StdLogicVector(MSIX_CAP_TABLE_SIZE)(10 downto 0);
       constant  MSIX_CAP_TABLE_SIZE_STRLEN : integer:= getstrlength( MSIX_CAP_TABLE_SIZE_BINARY);
    constant MSI_BASE_PTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSI_BASE_PTR)(7 downto 0);
       constant  MSI_BASE_PTR_STRLEN : integer:= getstrlength( MSI_BASE_PTR_BINARY);
       constant MSI_CAP_ID_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSI_CAP_ID)(7 downto 0);
       constant  MSI_CAP_ID_STRLEN : integer:= getstrlength( MSI_CAP_ID_BINARY);
constant MSI_CAP_NEXTPTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(MSI_CAP_NEXTPTR)(7 downto 0);
       constant  MSI_CAP_NEXTPTR_STRLEN : integer:= getstrlength( MSI_CAP_NEXTPTR_BINARY);
       constant PCIE_BASE_PTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PCIE_BASE_PTR)(7 downto 0);
       constant  PCIE_BASE_PTR_STRLEN : integer:= getstrlength( PCIE_BASE_PTR_BINARY);
    constant PCIE_CAP_CAPABILITY_ID_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PCIE_CAP_CAPABILITY_ID)(7 downto 0);
       constant PCIE_CAP_CAPABILITY_ID_STRLEN : integer:= getstrlength( PCIE_CAP_CAPABILITY_ID_BINARY);
    constant PCIE_CAP_CAPABILITY_VERSION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(PCIE_CAP_CAPABILITY_VERSION)(3 downto 0);
       constant PCIE_CAP_CAPABILITY_VERSION_STRLEN : integer:= getstrlength( PCIE_CAP_CAPABILITY_VERSION_BINARY);
    constant PCIE_CAP_DEVICE_PORT_TYPE_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(PCIE_CAP_DEVICE_PORT_TYPE)(3 downto 0);
       constant PCIE_CAP_DEVICE_PORT_TYPE_STRLEN : integer:= getstrlength( PCIE_CAP_DEVICE_PORT_TYPE_BINARY);
    constant PCIE_CAP_INT_MSG_NUM_BINARY : std_logic_vector(4 downto 0) := To_StdLogicVector(PCIE_CAP_INT_MSG_NUM)(4 downto 0);
       constant PCIE_CAP_INT_MSG_NUM_STRLEN : integer:= getstrlength( PCIE_CAP_INT_MSG_NUM_BINARY);
    constant PCIE_CAP_NEXTPTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PCIE_CAP_NEXTPTR)(7 downto 0);
       constant PCIE_CAP_NEXTPTR_STRLEN : integer:= getstrlength( PCIE_CAP_NEXTPTR_BINARY);
 constant PM_BASE_PTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_BASE_PTR)(7 downto 0);
       constant PM_BASE_PTR_STRLEN : integer:= getstrlength( PM_BASE_PTR_BINARY);
 constant PM_CAP_ID_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_CAP_ID)(7 downto 0);
       constant PM_CAP_ID_STRLEN : integer:= getstrlength( PM_CAP_ID_BINARY);
    constant PM_CAP_NEXTPTR_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_CAP_NEXTPTR)(7 downto 0);
       constant PM_CAP_NEXTPTR_STRLEN : integer:= getstrlength( PM_CAP_NEXTPTR_BINARY);
       constant PM_CAP_PMESUPPORT_BINARY : std_logic_vector(4 downto 0) := To_StdLogicVector(PM_CAP_PMESUPPORT)(4 downto 0);
       constant PM_CAP_PMESUPPORT_STRLEN : integer:= getstrlength( PM_CAP_PMESUPPORT_BINARY);
      constant PM_DATA0_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA0)(7 downto 0);
       constant PM_DATA0_STRLEN : integer:= getstrlength( PM_DATA0_BINARY);
    constant PM_DATA1_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA1)(7 downto 0);
       constant PM_DATA1_STRLEN : integer:= getstrlength( PM_DATA1_BINARY);
    constant PM_DATA2_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA2)(7 downto 0);
       constant PM_DATA2_STRLEN : integer:= getstrlength( PM_DATA2_BINARY);
    constant PM_DATA3_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA3)(7 downto 0);
       constant PM_DATA3_STRLEN : integer:= getstrlength( PM_DATA3_BINARY);
    constant PM_DATA4_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA4)(7 downto 0);
       constant PM_DATA4_STRLEN : integer:= getstrlength( PM_DATA4_BINARY);
    constant PM_DATA5_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA5)(7 downto 0);
       constant PM_DATA5_STRLEN : integer:= getstrlength( PM_DATA5_BINARY);
    constant PM_DATA6_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA6)(7 downto 0);
       constant PM_DATA6_STRLEN : integer:= getstrlength( PM_DATA6_BINARY);
    constant PM_DATA7_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(PM_DATA7)(7 downto 0);
       constant PM_DATA7_STRLEN : integer:= getstrlength( PM_DATA7_BINARY);
    constant PM_DATA_SCALE0_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE0)(1 downto 0);
       constant PM_DATA_SCALE0_STRLEN : integer:= getstrlength( PM_DATA_SCALE0_BINARY);
    constant PM_DATA_SCALE1_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE1)(1 downto 0);
       constant PM_DATA_SCALE1_STRLEN : integer:= getstrlength( PM_DATA_SCALE1_BINARY);
    constant PM_DATA_SCALE2_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE2)(1 downto 0);
       constant PM_DATA_SCALE2_STRLEN : integer:= getstrlength( PM_DATA_SCALE2_BINARY);
    constant PM_DATA_SCALE3_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE3)(1 downto 0);
       constant PM_DATA_SCALE3_STRLEN : integer:= getstrlength( PM_DATA_SCALE3_BINARY);
    constant PM_DATA_SCALE4_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE4)(1 downto 0);
       constant PM_DATA_SCALE4_STRLEN : integer:= getstrlength( PM_DATA_SCALE4_BINARY);
    constant PM_DATA_SCALE5_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE5)(1 downto 0);
       constant PM_DATA_SCALE5_STRLEN : integer:= getstrlength( PM_DATA_SCALE5_BINARY);
    constant PM_DATA_SCALE6_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE6)(1 downto 0);
       constant PM_DATA_SCALE6_STRLEN : integer:= getstrlength( PM_DATA_SCALE6_BINARY);
    constant PM_DATA_SCALE7_BINARY : std_logic_vector(1 downto 0) := To_StdLogicVector(PM_DATA_SCALE7)(1 downto 0);
       constant PM_DATA_SCALE7_STRLEN : integer:= getstrlength( PM_DATA_SCALE7_BINARY);
     constant REVISION_ID_BINARY : std_logic_vector(7 downto 0):= To_StdLogicVector(REVISION_ID)(7 downto 0);
       constant REVISION_ID_STRLEN : integer:= getstrlength( REVISION_ID_BINARY);
     constant SLOT_CAP_PHYSICAL_SLOT_NUM_BINARY : std_logic_vector(12 downto 0) := To_StdLogicVector(SLOT_CAP_PHYSICAL_SLOT_NUM)(12 downto 0); 
       constant SLOT_CAP_PHYSICAL_SLOT_NUM_STRLEN : integer:= getstrlength( SLOT_CAP_PHYSICAL_SLOT_NUM_BINARY);
     constant SLOT_CAP_SLOT_POWER_LIMIT_VALUE_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(SLOT_CAP_SLOT_POWER_LIMIT_VALUE)(7 downto 0);
       constant SLOT_CAP_SLOT_POWER_LIMIT_VALUE_STRLEN : integer:= getstrlength( SLOT_CAP_SLOT_POWER_LIMIT_VALUE_BINARY);
    constant SPARE_BYTE0_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(SPARE_BYTE0)(7 downto 0);
       constant SPARE_BYTE0_STRLEN : integer:= getstrlength( SPARE_BYTE0_BINARY);
    constant SPARE_BYTE1_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(SPARE_BYTE1)(7 downto 0);
       constant SPARE_BYTE1_STRLEN : integer:= getstrlength( SPARE_BYTE1_BINARY);
    constant SPARE_BYTE2_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(SPARE_BYTE2)(7 downto 0);
       constant SPARE_BYTE2_STRLEN : integer:= getstrlength( SPARE_BYTE2_BINARY);
    constant SPARE_BYTE3_BINARY : std_logic_vector(7 downto 0) := To_StdLogicVector(SPARE_BYTE3)(7 downto 0);
       constant SPARE_BYTE3_STRLEN : integer:= getstrlength( SPARE_BYTE3_BINARY);
    constant SPARE_WORD0_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(SPARE_WORD0)(31 downto 0);
       constant SPARE_WORD0_STRLEN : integer:= getstrlength( SPARE_WORD0_BINARY);
    constant SPARE_WORD1_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(SPARE_WORD1)(31 downto 0);
       constant SPARE_WORD1_STRLEN : integer:= getstrlength( SPARE_WORD1_BINARY);
    constant SPARE_WORD2_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(SPARE_WORD2)(31 downto 0);
       constant SPARE_WORD2_STRLEN : integer:= getstrlength( SPARE_WORD2_BINARY);
    constant SPARE_WORD3_BINARY : std_logic_vector(31 downto 0) := To_StdLogicVector(SPARE_WORD3)(31 downto 0);
       constant SPARE_WORD3_STRLEN : integer:= getstrlength( SPARE_WORD3_BINARY);
    constant SUBSYSTEM_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(SUBSYSTEM_ID)(15 downto 0);
       constant SUBSYSTEM_ID_STRLEN : integer:= getstrlength( SUBSYSTEM_ID_BINARY);
    constant SUBSYSTEM_VENDOR_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(SUBSYSTEM_VENDOR_ID)(15 downto 0);
       constant SUBSYSTEM_VENDOR_ID_STRLEN : integer:= getstrlength( SUBSYSTEM_VENDOR_ID_BINARY);
constant VC0_RX_RAM_LIMIT_BINARY : std_logic_vector(12 downto 0) := To_StdLogicVector(VC0_RX_RAM_LIMIT)(12 downto 0);
       constant VC0_RX_RAM_LIMIT_STRLEN : integer:= getstrlength( VC0_RX_RAM_LIMIT_BINARY);
constant VC_BASE_PTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(VC_BASE_PTR)(11 downto 0);
       constant VC_BASE_PTR_STRLEN : integer:= getstrlength( VC_BASE_PTR_BINARY);
    constant VC_CAP_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(VC_CAP_ID)(15 downto 0);
       constant VC_CAP_ID_STRLEN : integer:= getstrlength( VC_CAP_ID_BINARY);
       constant VC_CAP_NEXTPTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(VC_CAP_NEXTPTR)(11 downto 0); 
       constant VC_CAP_NEXTPTR_STRLEN : integer:= getstrlength( VC_CAP_NEXTPTR_BINARY);
      constant VC_CAP_VERSION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(VC_CAP_VERSION)(3 downto 0);
       constant VC_CAP_VERSION_STRLEN : integer:= getstrlength( VC_CAP_VERSION_BINARY);
    constant VENDOR_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(VENDOR_ID)(15 downto 0);
       constant VENDOR_ID_STRLEN : integer:= getstrlength( VENDOR_ID_BINARY);
    constant VSEC_BASE_PTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(VSEC_BASE_PTR)(11 downto 0);
       constant VSEC_BASE_PTR_STRLEN : integer:= getstrlength( VSEC_BASE_PTR_BINARY);
    constant VSEC_CAP_HDR_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(VSEC_CAP_HDR_ID)(15 downto 0);
       constant VSEC_CAP_HDR_ID_STRLEN : integer:= getstrlength( VSEC_CAP_HDR_ID_BINARY);
    constant VSEC_CAP_HDR_LENGTH_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(VSEC_CAP_HDR_LENGTH)(11 downto 0);
       constant VSEC_CAP_HDR_LENGTH_STRLEN : integer:= getstrlength( VSEC_CAP_HDR_LENGTH_BINARY);
    constant VSEC_CAP_HDR_REVISION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(VSEC_CAP_HDR_REVISION)(3 downto 0);
       constant VSEC_CAP_HDR_REVISION_STRLEN : integer:= getstrlength( VSEC_CAP_HDR_REVISION_BINARY);
    constant VSEC_CAP_ID_BINARY : std_logic_vector(15 downto 0) := To_StdLogicVector(VSEC_CAP_ID)(15 downto 0);
       constant VSEC_CAP_ID_STRLEN : integer:= getstrlength( VSEC_CAP_ID_BINARY);
       constant VSEC_CAP_NEXTPTR_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(VSEC_CAP_NEXTPTR)(11 downto 0);
       constant VSEC_CAP_NEXTPTR_STRLEN : integer:= getstrlength( VSEC_CAP_NEXTPTR_BINARY);
       constant VSEC_CAP_VERSION_BINARY : std_logic_vector(3 downto 0) := To_StdLogicVector(VSEC_CAP_VERSION)(3 downto 0);
       constant VSEC_CAP_VERSION_STRLEN : integer:= getstrlength( VSEC_CAP_VERSION_BINARY);

     -- Convert std_logic_vector to string
     constant AER_BASE_PTR_STRING : string := SLV_TO_HEX(AER_BASE_PTR_BINARY, AER_BASE_PTR_STRLEN);
     constant AER_CAP_ID_STRING : string := SLV_TO_HEX(AER_CAP_ID_BINARY, AER_CAP_ID_STRLEN);
     constant AER_CAP_INT_MSG_NUM_MSIX_STRING : string := SLV_TO_HEX(AER_CAP_INT_MSG_NUM_MSIX_BINARY, AER_CAP_INT_MSG_NUM_MSIX_STRLEN);
     constant AER_CAP_INT_MSG_NUM_MSI_STRING : string := SLV_TO_HEX(AER_CAP_INT_MSG_NUM_MSI_BINARY, AER_CAP_INT_MSG_NUM_MSI_STRLEN);
     constant AER_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(AER_CAP_NEXTPTR_BINARY, AER_CAP_NEXTPTR_STRLEN);
     constant AER_CAP_VERSION_STRING : string := SLV_TO_HEX(AER_CAP_VERSION_BINARY, AER_CAP_VERSION_STRLEN);
     constant BAR0_STRING : string := SLV_TO_HEX(BAR0_BINARY, BAR0_STRLEN);
     constant BAR1_STRING : string := SLV_TO_HEX(BAR1_BINARY, BAR1_STRLEN);
     constant BAR2_STRING : string := SLV_TO_HEX(BAR2_BINARY, BAR2_STRLEN);
     constant BAR3_STRING : string := SLV_TO_HEX(BAR3_BINARY, BAR3_STRLEN);
     constant BAR4_STRING : string := SLV_TO_HEX(BAR4_BINARY, BAR4_STRLEN);
     constant BAR5_STRING : string := SLV_TO_HEX(BAR5_BINARY, BAR5_STRLEN);
     constant CAPABILITIES_PTR_STRING : string := SLV_TO_HEX(CAPABILITIES_PTR_BINARY, CAPABILITIES_PTR_STRLEN);
     constant CARDBUS_CIS_POINTER_STRING : string := SLV_TO_HEX(CARDBUS_CIS_POINTER_BINARY, CARDBUS_CIS_POINTER_STRLEN);
     constant CLASS_CODE_STRING : string := SLV_TO_HEX(CLASS_CODE_BINARY, CLASS_CODE_STRLEN);
     constant CPL_TIMEOUT_RANGES_SUPPORTED_STRING : string := SLV_TO_HEX(CPL_TIMEOUT_RANGES_SUPPORTED_BINARY, CPL_TIMEOUT_RANGES_SUPPORTED_STRLEN);
     constant CRM_MODULE_RSTS_STRING : string := SLV_TO_HEX(CRM_MODULE_RSTS_BINARY, CRM_MODULE_RSTS_STRLEN);
     constant DEVICE_ID_STRING : string := SLV_TO_HEX(DEVICE_ID_BINARY, DEVICE_ID_STRLEN);
     constant DNSTREAM_LINK_NUM_STRING : string := SLV_TO_HEX(DNSTREAM_LINK_NUM_BINARY, DNSTREAM_LINK_NUM_STRLEN);
     constant DSN_BASE_PTR_STRING : string := SLV_TO_HEX(DSN_BASE_PTR_BINARY, DSN_BASE_PTR_STRLEN);
     constant DSN_CAP_ID_STRING : string := SLV_TO_HEX(DSN_CAP_ID_BINARY, DSN_CAP_ID_STRLEN);
     constant DSN_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(DSN_CAP_NEXTPTR_BINARY, DSN_CAP_NEXTPTR_STRLEN);
     constant DSN_CAP_VERSION_STRING : string := SLV_TO_HEX(DSN_CAP_VERSION_BINARY, DSN_CAP_VERSION_STRLEN);
     constant ENABLE_MSG_ROUTE_STRING : string := SLV_TO_HEX(ENABLE_MSG_ROUTE_BINARY, ENABLE_MSG_ROUTE_STRLEN);
     constant EXPANSION_ROM_STRING : string := SLV_TO_HEX(EXPANSION_ROM_BINARY, EXPANSION_ROM_STRLEN);
     constant EXT_CFG_CAP_PTR_STRING : string := SLV_TO_HEX(EXT_CFG_CAP_PTR_BINARY, EXT_CFG_CAP_PTR_STRLEN);
     constant EXT_CFG_XP_CAP_PTR_STRING : string := SLV_TO_HEX(EXT_CFG_XP_CAP_PTR_BINARY, EXT_CFG_XP_CAP_PTR_STRLEN);
     constant HEADER_TYPE_STRING : string := SLV_TO_HEX(HEADER_TYPE_BINARY, HEADER_TYPE_STRLEN);
     constant INFER_EI_STRING : string := SLV_TO_HEX(INFER_EI_BINARY, INFER_EI_STRLEN);
     constant INTERRUPT_PIN_STRING : string := SLV_TO_HEX(INTERRUPT_PIN_BINARY, INTERRUPT_PIN_STRLEN);
     constant LAST_CONFIG_DWORD_STRING : string := SLV_TO_HEX(LAST_CONFIG_DWORD_BINARY, LAST_CONFIG_DWORD_STRLEN);
     constant LINK_CAP_MAX_LINK_SPEED_STRING : string := SLV_TO_HEX(LINK_CAP_MAX_LINK_SPEED_BINARY, LINK_CAP_MAX_LINK_SPEED_STRLEN);
     constant LINK_CAP_MAX_LINK_WIDTH_STRING : string := SLV_TO_HEX(LINK_CAP_MAX_LINK_WIDTH_BINARY, LINK_CAP_MAX_LINK_WIDTH_STRLEN);
     constant LINK_CTRL2_TARGET_LINK_SPEED_STRING : string := SLV_TO_HEX(LINK_CTRL2_TARGET_LINK_SPEED_BINARY, LINK_CTRL2_TARGET_LINK_SPEED_STRLEN);
     constant LL_ACK_TIMEOUT_STRING : string := SLV_TO_HEX(LL_ACK_TIMEOUT_BINARY, LL_ACK_TIMEOUT_STRLEN);
     constant LL_REPLAY_TIMEOUT_STRING : string := SLV_TO_HEX(LL_REPLAY_TIMEOUT_BINARY, LL_REPLAY_TIMEOUT_STRLEN);
     constant LTSSM_MAX_LINK_WIDTH_STRING : string := SLV_TO_HEX(LTSSM_MAX_LINK_WIDTH_BINARY, LTSSM_MAX_LINK_WIDTH_STRLEN);
     constant MSIX_BASE_PTR_STRING :string := SLV_TO_HEX(MSIX_BASE_PTR_BINARY,MSIX_BASE_PTR_STRLEN);
     constant MSIX_CAP_ID_STRING : string := SLV_TO_HEX(MSIX_CAP_ID_BINARY, MSIX_CAP_ID_STRLEN);
     constant MSIX_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(MSIX_CAP_NEXTPTR_BINARY, MSIX_CAP_NEXTPTR_STRLEN);
     constant MSIX_CAP_PBA_OFFSET_STRING : string := SLV_TO_HEX(MSIX_CAP_PBA_OFFSET_BINARY, MSIX_CAP_PBA_OFFSET_STRLEN);
     constant MSIX_CAP_TABLE_OFFSET_STRING : string := SLV_TO_HEX(MSIX_CAP_TABLE_OFFSET_BINARY, MSIX_CAP_TABLE_OFFSET_STRLEN);
     constant MSIX_CAP_TABLE_SIZE_STRING : string := SLV_TO_HEX(MSIX_CAP_TABLE_SIZE_BINARY, MSIX_CAP_TABLE_SIZE_STRLEN);
     constant MSI_BASE_PTR_STRING : string := SLV_TO_HEX(MSI_BASE_PTR_BINARY, MSI_BASE_PTR_STRLEN);
     constant MSI_CAP_ID_STRING : string := SLV_TO_HEX(MSI_CAP_ID_BINARY, MSI_CAP_ID_STRLEN);
     constant MSI_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(MSI_CAP_NEXTPTR_BINARY, MSI_CAP_NEXTPTR_STRLEN);
     constant PCIE_BASE_PTR_STRING : string := SLV_TO_HEX(PCIE_BASE_PTR_BINARY, PCIE_BASE_PTR_STRLEN);
     constant PCIE_CAP_CAPABILITY_ID_STRING : string := SLV_TO_HEX(PCIE_CAP_CAPABILITY_ID_BINARY, PCIE_CAP_CAPABILITY_ID_STRLEN);
     constant PCIE_CAP_CAPABILITY_VERSION_STRING : string := SLV_TO_HEX(PCIE_CAP_CAPABILITY_VERSION_BINARY, PCIE_CAP_CAPABILITY_VERSION_STRLEN);
     constant PCIE_CAP_DEVICE_PORT_TYPE_STRING : string := SLV_TO_HEX(PCIE_CAP_DEVICE_PORT_TYPE_BINARY, PCIE_CAP_DEVICE_PORT_TYPE_STRLEN);
    constant PCIE_CAP_INT_MSG_NUM_STRING : string := SLV_TO_HEX(PCIE_CAP_INT_MSG_NUM_BINARY, PCIE_CAP_INT_MSG_NUM_STRLEN);
     constant PCIE_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(PCIE_CAP_NEXTPTR_BINARY, PCIE_CAP_NEXTPTR_STRLEN);
     constant PM_BASE_PTR_STRING : string := SLV_TO_HEX(PM_BASE_PTR_BINARY, PM_BASE_PTR_STRLEN);
     constant PM_CAP_ID_STRING : string := SLV_TO_HEX(PM_CAP_ID_BINARY, PM_CAP_ID_STRLEN);
     constant PM_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(PM_CAP_NEXTPTR_BINARY, PM_CAP_NEXTPTR_STRLEN);
     constant PM_CAP_PMESUPPORT_STRING : string := SLV_TO_HEX(PM_CAP_PMESUPPORT_BINARY, PM_CAP_PMESUPPORT_STRLEN);
     constant PM_DATA0_STRING : string := SLV_TO_HEX(PM_DATA0_BINARY, PM_DATA0_STRLEN);
     constant PM_DATA1_STRING : string := SLV_TO_HEX(PM_DATA1_BINARY, PM_DATA1_STRLEN);
     constant PM_DATA2_STRING : string := SLV_TO_HEX(PM_DATA2_BINARY, PM_DATA2_STRLEN);
     constant PM_DATA3_STRING : string := SLV_TO_HEX(PM_DATA3_BINARY, PM_DATA3_STRLEN);
     constant PM_DATA4_STRING : string := SLV_TO_HEX(PM_DATA4_BINARY, PM_DATA4_STRLEN);
     constant PM_DATA5_STRING : string := SLV_TO_HEX(PM_DATA5_BINARY, PM_DATA5_STRLEN);
     constant PM_DATA6_STRING : string := SLV_TO_HEX(PM_DATA6_BINARY, PM_DATA6_STRLEN);
     constant PM_DATA7_STRING : string := SLV_TO_HEX(PM_DATA7_BINARY, PM_DATA7_STRLEN);
     constant PM_DATA_SCALE0_STRING : string := SLV_TO_HEX(PM_DATA_SCALE0_BINARY, PM_DATA_SCALE0_STRLEN);
     constant PM_DATA_SCALE1_STRING : string := SLV_TO_HEX(PM_DATA_SCALE1_BINARY, PM_DATA_SCALE1_STRLEN);
     constant PM_DATA_SCALE2_STRING : string := SLV_TO_HEX(PM_DATA_SCALE2_BINARY, PM_DATA_SCALE2_STRLEN);
     constant PM_DATA_SCALE3_STRING : string := SLV_TO_HEX(PM_DATA_SCALE3_BINARY, PM_DATA_SCALE3_STRLEN);
     constant PM_DATA_SCALE4_STRING : string := SLV_TO_HEX(PM_DATA_SCALE4_BINARY, PM_DATA_SCALE4_STRLEN);
     constant PM_DATA_SCALE5_STRING : string := SLV_TO_HEX(PM_DATA_SCALE5_BINARY, PM_DATA_SCALE5_STRLEN);
     constant PM_DATA_SCALE6_STRING : string := SLV_TO_HEX(PM_DATA_SCALE6_BINARY, PM_DATA_SCALE6_STRLEN);
     constant PM_DATA_SCALE7_STRING : string := SLV_TO_HEX(PM_DATA_SCALE7_BINARY, PM_DATA_SCALE7_STRLEN);
     constant REVISION_ID_STRING : string := SLV_TO_HEX(REVISION_ID_BINARY, REVISION_ID_STRLEN);
     constant SLOT_CAP_PHYSICAL_SLOT_NUM_STRING : string := SLV_TO_HEX(SLOT_CAP_PHYSICAL_SLOT_NUM_BINARY, SLOT_CAP_PHYSICAL_SLOT_NUM_STRLEN); 
     constant SLOT_CAP_SLOT_POWER_LIMIT_VALUE_STRING : string := SLV_TO_HEX(SLOT_CAP_SLOT_POWER_LIMIT_VALUE_BINARY, SLOT_CAP_SLOT_POWER_LIMIT_VALUE_STRLEN);
    constant SPARE_BYTE0_STRING : string := SLV_TO_HEX(SPARE_BYTE0_BINARY, SPARE_BYTE0_STRLEN);
    constant SPARE_BYTE1_STRING : string := SLV_TO_HEX(SPARE_BYTE1_BINARY, SPARE_BYTE1_STRLEN);
    constant SPARE_BYTE2_STRING : string := SLV_TO_HEX(SPARE_BYTE2_BINARY, SPARE_BYTE2_STRLEN);
    constant SPARE_BYTE3_STRING : string := SLV_TO_HEX(SPARE_BYTE3_BINARY, SPARE_BYTE3_STRLEN);
    constant SPARE_WORD0_STRING : string := SLV_TO_HEX(SPARE_WORD0_BINARY, SPARE_WORD0_STRLEN);
    constant SPARE_WORD1_STRING : string := SLV_TO_HEX(SPARE_WORD1_BINARY, SPARE_WORD1_STRLEN);
    constant SPARE_WORD2_STRING : string := SLV_TO_HEX(SPARE_WORD2_BINARY, SPARE_WORD2_STRLEN);
    constant SPARE_WORD3_STRING : string := SLV_TO_HEX(SPARE_WORD3_BINARY, SPARE_WORD3_STRLEN);
    constant SUBSYSTEM_ID_STRING : string := SLV_TO_HEX(SUBSYSTEM_ID_BINARY, SUBSYSTEM_ID_STRLEN);
    constant SUBSYSTEM_VENDOR_ID_STRING : string := SLV_TO_HEX(SUBSYSTEM_VENDOR_ID_BINARY, SUBSYSTEM_VENDOR_ID_STRLEN);
    constant VC0_RX_RAM_LIMIT_STRING : string := SLV_TO_HEX(VC0_RX_RAM_LIMIT_BINARY, VC0_RX_RAM_LIMIT_STRLEN);
    constant VC_BASE_PTR_STRING : string := SLV_TO_HEX(VC_BASE_PTR_BINARY, VC_BASE_PTR_STRLEN);
    constant VC_CAP_ID_STRING : string := SLV_TO_HEX(VC_CAP_ID_BINARY, VC_CAP_ID_STRLEN);
    constant VC_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(VC_CAP_NEXTPTR_BINARY, VC_CAP_NEXTPTR_STRLEN); 
    constant VC_CAP_VERSION_STRING : string := SLV_TO_HEX(VC_CAP_VERSION_BINARY, VC_CAP_VERSION_STRLEN);
    constant VENDOR_ID_STRING : string := SLV_TO_HEX(VENDOR_ID_BINARY, VENDOR_ID_STRLEN);
    constant VSEC_BASE_PTR_STRING : string := SLV_TO_HEX(VSEC_BASE_PTR_BINARY, VSEC_BASE_PTR_STRLEN);
    constant VSEC_CAP_HDR_ID_STRING : string := SLV_TO_HEX(VSEC_CAP_HDR_ID_BINARY, VSEC_CAP_HDR_ID_STRLEN);
    constant VSEC_CAP_HDR_LENGTH_STRING : string := SLV_TO_HEX(VSEC_CAP_HDR_LENGTH_BINARY, VSEC_CAP_HDR_LENGTH_STRLEN);
    constant VSEC_CAP_HDR_REVISION_STRING : string := SLV_TO_HEX(VSEC_CAP_HDR_REVISION_BINARY, VSEC_CAP_HDR_REVISION_STRLEN);
    constant VSEC_CAP_ID_STRING : string := SLV_TO_HEX(VSEC_CAP_ID_BINARY, VSEC_CAP_ID_STRLEN);
    constant VSEC_CAP_NEXTPTR_STRING : string := SLV_TO_HEX(VSEC_CAP_NEXTPTR_BINARY, VSEC_CAP_NEXTPTR_STRLEN);
    constant VSEC_CAP_VERSION_STRING : string := SLV_TO_HEX(VSEC_CAP_VERSION_BINARY, VSEC_CAP_VERSION_STRLEN);

    -- Convert boolean to string
    constant AER_CAP_ECRC_CHECK_CAPABLE_STRING : string := boolean_to_string(AER_CAP_ECRC_CHECK_CAPABLE);
    constant AER_CAP_ECRC_GEN_CAPABLE_STRING : string := boolean_to_string(AER_CAP_ECRC_GEN_CAPABLE);
    constant AER_CAP_ON_STRING : string := boolean_to_string(AER_CAP_ON);
    constant AER_CAP_PERMIT_ROOTERR_UPDATE_STRING : string := boolean_to_string(AER_CAP_PERMIT_ROOTERR_UPDATE);
    constant ALLOW_X8_GEN2_STRING : string := boolean_to_string(ALLOW_X8_GEN2);
    constant CMD_INTX_IMPLEMENTED_STRING : string := boolean_to_string(CMD_INTX_IMPLEMENTED);
    constant CPL_TIMEOUT_DISABLE_SUPPORTED_STRING : string := boolean_to_string(CPL_TIMEOUT_DISABLE_SUPPORTED);
    constant DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_STRING : string := boolean_to_string(DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE);
    constant DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_STRING : string := boolean_to_string(DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE);
    constant DEV_CAP_EXT_TAG_SUPPORTED_STRING : string := boolean_to_string(DEV_CAP_EXT_TAG_SUPPORTED);
    constant DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_STRING : string := boolean_to_string(DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE);
    constant DEV_CAP_ROLE_BASED_ERROR_STRING : string := boolean_to_string(DEV_CAP_ROLE_BASED_ERROR);
    constant DEV_CONTROL_AUX_POWER_SUPPORTED_STRING : string := boolean_to_string(DEV_CONTROL_AUX_POWER_SUPPORTED);
    constant DISABLE_ASPM_L1_TIMER_STRING : string := boolean_to_string(DISABLE_ASPM_L1_TIMER);
    constant DISABLE_BAR_FILTERING_STRING : string := boolean_to_string(DISABLE_BAR_FILTERING);
    constant DISABLE_ID_CHECK_STRING : string := boolean_to_string(DISABLE_ID_CHECK);
    constant DISABLE_LANE_REVERSAL_STRING : string := boolean_to_string(DISABLE_LANE_REVERSAL);
    constant DISABLE_RX_TC_FILTER_STRING : string := boolean_to_string(DISABLE_RX_TC_FILTER);
    constant DISABLE_SCRAMBLING_STRING : string := boolean_to_string(DISABLE_SCRAMBLING);
    constant DSN_CAP_ON_STRING : string := boolean_to_string(DSN_CAP_ON);
    constant ENABLE_RX_TD_ECRC_TRIM_STRING : string := boolean_to_string(ENABLE_RX_TD_ECRC_TRIM);
    constant ENTER_RVRY_EI_L0_STRING : string := boolean_to_string(ENTER_RVRY_EI_L0);
    constant EXIT_LOOPBACK_ON_EI_STRING : string := boolean_to_string(EXIT_LOOPBACK_ON_EI);
    constant IS_SWITCH_STRING : string := boolean_to_string(IS_SWITCH);
    constant LINK_CAP_CLOCK_POWER_MANAGEMENT_STRING : string := boolean_to_string(LINK_CAP_CLOCK_POWER_MANAGEMENT);
    constant LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_STRING : string := boolean_to_string(LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP);
    constant LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_STRING : string := boolean_to_string(LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP);
    constant LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_STRING : string := boolean_to_string(LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE);
    constant LINK_CTRL2_DEEMPHASIS_STRING : string := boolean_to_string(LINK_CTRL2_DEEMPHASIS);
    constant LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_STRING : string := boolean_to_string(LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE);
    constant LINK_STATUS_SLOT_CLOCK_CONFIG_STRING : string := boolean_to_string(LINK_STATUS_SLOT_CLOCK_CONFIG);
    constant LL_ACK_TIMEOUT_EN_STRING : string := boolean_to_string(LL_ACK_TIMEOUT_EN);
    constant LL_REPLAY_TIMEOUT_EN_STRING : string := boolean_to_string(LL_REPLAY_TIMEOUT_EN);
    constant MSIX_CAP_ON_STRING : string := boolean_to_string(MSIX_CAP_ON);
    constant MSI_CAP_64_BIT_ADDR_CAPABLE_STRING : string := boolean_to_string(MSI_CAP_64_BIT_ADDR_CAPABLE);
    constant MSI_CAP_ON_STRING : string := boolean_to_string(MSI_CAP_ON);
    constant MSI_CAP_PER_VECTOR_MASKING_CAPABLE_STRING : string := boolean_to_string(MSI_CAP_PER_VECTOR_MASKING_CAPABLE);
    constant PCIE_CAP_ON_STRING : string := boolean_to_string(PCIE_CAP_ON);
    constant PCIE_CAP_SLOT_IMPLEMENTED_STRING : string := boolean_to_string(PCIE_CAP_SLOT_IMPLEMENTED);
    constant PL_FAST_TRAIN_STRING : string := boolean_to_string(PL_FAST_TRAIN);
    constant PM_CAP_D1SUPPORT_STRING : string := boolean_to_string(PM_CAP_D1SUPPORT);
    constant PM_CAP_D2SUPPORT_STRING : string := boolean_to_string(PM_CAP_D2SUPPORT);
    constant PM_CAP_DSI_STRING : string := boolean_to_string(PM_CAP_DSI);
    constant PM_CAP_ON_STRING : string := boolean_to_string(PM_CAP_ON);
    constant PM_CAP_PME_CLOCK_STRING : string := boolean_to_string(PM_CAP_PME_CLOCK);
    constant PM_CSR_B2B3_STRING : string := boolean_to_string(PM_CSR_B2B3);
    constant PM_CSR_BPCCEN_STRING : string := boolean_to_string(PM_CSR_BPCCEN);
    constant PM_CSR_NOSOFTRST_STRING : string := boolean_to_string(PM_CSR_NOSOFTRST);
    constant RECRC_CHK_TRIM_STRING : string := boolean_to_string(RECRC_CHK_TRIM);
    constant ROOT_CAP_CRS_SW_VISIBILITY_STRING : string := boolean_to_string(ROOT_CAP_CRS_SW_VISIBILITY);
    constant SELECT_DLL_IF_STRING : string := boolean_to_string(SELECT_DLL_IF);
    constant SLOT_CAP_ATT_BUTTON_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_ATT_BUTTON_PRESENT);
    constant SLOT_CAP_ATT_INDICATOR_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_ATT_INDICATOR_PRESENT);
    constant SLOT_CAP_ELEC_INTERLOCK_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_ELEC_INTERLOCK_PRESENT);
    constant SLOT_CAP_HOTPLUG_CAPABLE_STRING : string := boolean_to_string(SLOT_CAP_HOTPLUG_CAPABLE);
    constant SLOT_CAP_HOTPLUG_SURPRISE_STRING : string := boolean_to_string(SLOT_CAP_HOTPLUG_SURPRISE);
    constant SLOT_CAP_MRL_SENSOR_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_MRL_SENSOR_PRESENT);
    constant SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_STRING : string := boolean_to_string(SLOT_CAP_NO_CMD_COMPLETED_SUPPORT);
    constant SLOT_CAP_POWER_CONTROLLER_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_POWER_CONTROLLER_PRESENT);
    constant SLOT_CAP_POWER_INDICATOR_PRESENT_STRING : string := boolean_to_string(SLOT_CAP_POWER_INDICATOR_PRESENT);
    constant TL_RBYPASS_STRING : string := boolean_to_string(TL_RBYPASS);
    constant TL_TFC_DISABLE_STRING : string := boolean_to_string(TL_TFC_DISABLE);
    constant TL_TX_CHECKS_DISABLE_STRING : string := boolean_to_string(TL_TX_CHECKS_DISABLE);
    constant UPCONFIG_CAPABLE_STRING : string := boolean_to_string(UPCONFIG_CAPABLE);
    constant UPSTREAM_FACING_STRING : string := boolean_to_string(UPSTREAM_FACING);
    constant UR_INV_REQ_STRING : string := boolean_to_string(UR_INV_REQ);
    constant VC0_CPL_INFINITE_STRING : string := boolean_to_string(VC0_CPL_INFINITE);
    constant VC_CAP_ON_STRING : string := boolean_to_string(VC_CAP_ON);
    constant VC_CAP_REJECT_SNOOP_TRANSACTIONS_STRING : string := boolean_to_string(VC_CAP_REJECT_SNOOP_TRANSACTIONS);
    constant VSEC_CAP_IS_LINK_VISIBLE_STRING : string := boolean_to_string(VSEC_CAP_IS_LINK_VISIBLE);
    constant VSEC_CAP_ON_STRING : string := boolean_to_string(VSEC_CAP_ON);
    
    signal AER_CAP_ECRC_CHECK_CAPABLE_BINARY : std_ulogic;
    signal AER_CAP_ECRC_GEN_CAPABLE_BINARY : std_ulogic;
    signal AER_CAP_ON_BINARY : std_ulogic;
    signal AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY : std_ulogic;
    signal ALLOW_X8_GEN2_BINARY : std_ulogic;
    signal CMD_INTX_IMPLEMENTED_BINARY : std_ulogic;
    signal CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY : std_ulogic;
    signal DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY : std_ulogic;
    signal DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY : std_ulogic;
    signal DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY : std_logic_vector(2 downto 0);
    signal DEV_CAP_ENDPOINT_L1_LATENCY_BINARY : std_logic_vector(2 downto 0);
    signal DEV_CAP_EXT_TAG_SUPPORTED_BINARY : std_ulogic;
    signal DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY : std_ulogic;
    signal DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY : std_logic_vector(2 downto 0);
    signal DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY : std_logic_vector(1 downto 0);
    signal DEV_CAP_ROLE_BASED_ERROR_BINARY : std_ulogic;
    signal DEV_CAP_RSVD_14_12_BINARY : std_logic_vector(2 downto 0);
    signal DEV_CAP_RSVD_17_16_BINARY : std_logic_vector(1 downto 0);
    signal DEV_CAP_RSVD_31_29_BINARY : std_logic_vector(2 downto 0);
    signal DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY : std_ulogic;
    signal DISABLE_ASPM_L1_TIMER_BINARY : std_ulogic;
    signal DISABLE_BAR_FILTERING_BINARY : std_ulogic;
    signal DISABLE_ID_CHECK_BINARY : std_ulogic;
    signal DISABLE_LANE_REVERSAL_BINARY : std_ulogic;
    signal DISABLE_RX_TC_FILTER_BINARY : std_ulogic;
    signal DISABLE_SCRAMBLING_BINARY : std_ulogic;
    signal DSN_CAP_ON_BINARY : std_ulogic;
    signal ENABLE_RX_TD_ECRC_TRIM_BINARY : std_ulogic;
    signal ENTER_RVRY_EI_L0_BINARY : std_ulogic;
    signal EXIT_LOOPBACK_ON_EI_BINARY : std_ulogic;
    signal IS_SWITCH_BINARY : std_ulogic;
    signal LINK_CAP_ASPM_SUPPORT_BINARY : std_logic_vector(1 downto 0);
    signal LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY : std_ulogic;
    signal LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY : std_ulogic;
    signal LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY : std_logic_vector(2 downto 0);
    signal LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY : std_ulogic;
    signal LINK_CAP_RSVD_23_22_BINARY : std_logic_vector(1 downto 0);
    signal LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY : std_ulogic;
    signal LINK_CONTROL_RCB_BINARY : std_ulogic;
    signal LINK_CTRL2_DEEMPHASIS_BINARY : std_ulogic;
    signal LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY : std_ulogic;
    signal LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY : std_ulogic;
    signal LL_ACK_TIMEOUT_EN_BINARY : std_ulogic;
    signal LL_ACK_TIMEOUT_FUNC_BINARY : std_logic_vector(1 downto 0);
    signal LL_REPLAY_TIMEOUT_EN_BINARY : std_ulogic;
    signal LL_REPLAY_TIMEOUT_FUNC_BINARY : std_logic_vector(1 downto 0);
    signal MSIX_CAP_ON_BINARY : std_ulogic;
    signal MSIX_CAP_PBA_BIR_BINARY : std_logic_vector(2 downto 0);
    signal MSIX_CAP_TABLE_BIR_BINARY : std_logic_vector(2 downto 0);
    signal MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY : std_ulogic;
    signal MSI_CAP_MULTIMSGCAP_BINARY : std_logic_vector(2 downto 0);
    signal MSI_CAP_MULTIMSG_EXTENSION_BINARY : std_ulogic;
    signal MSI_CAP_ON_BINARY : std_ulogic;
    signal MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY : std_ulogic;
    signal N_FTS_COMCLK_GEN1_BINARY : std_logic_vector(7 downto 0);
    signal N_FTS_COMCLK_GEN2_BINARY : std_logic_vector(7 downto 0);
    signal N_FTS_GEN1_BINARY : std_logic_vector(7 downto 0);
    signal N_FTS_GEN2_BINARY : std_logic_vector(7 downto 0);
    signal PCIE_CAP_ON_BINARY : std_ulogic;
    signal PCIE_CAP_RSVD_15_14_BINARY : std_logic_vector(1 downto 0);
    signal PCIE_CAP_SLOT_IMPLEMENTED_BINARY : std_ulogic;
    signal PCIE_REVISION_BINARY : std_logic_vector(3 downto 0);
    signal PGL0_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL1_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL2_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL3_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL4_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL5_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL6_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PGL7_LANE_BINARY : std_logic_vector(2 downto 0);
    signal PL_AUTO_CONFIG_BINARY : std_logic_vector(2 downto 0);
    signal PL_FAST_TRAIN_BINARY : std_ulogic;
    signal PM_CAP_AUXCURRENT_BINARY : std_logic_vector(2 downto 0);
    signal PM_CAP_D1SUPPORT_BINARY : std_ulogic;
    signal PM_CAP_D2SUPPORT_BINARY : std_ulogic;
    signal PM_CAP_DSI_BINARY : std_ulogic;
    signal PM_CAP_ON_BINARY : std_ulogic;
    signal PM_CAP_PME_CLOCK_BINARY : std_ulogic;
    signal PM_CAP_RSVD_04_BINARY : std_ulogic;
    signal PM_CAP_VERSION_BINARY : std_logic_vector(2 downto 0);
    signal PM_CSR_B2B3_BINARY : std_ulogic;
    signal PM_CSR_BPCCEN_BINARY : std_ulogic;
    signal PM_CSR_NOSOFTRST_BINARY : std_ulogic;
    signal RECRC_CHK_BINARY : std_logic_vector(1 downto 0);
    signal RECRC_CHK_TRIM_BINARY : std_ulogic;
    signal ROOT_CAP_CRS_SW_VISIBILITY_BINARY : std_ulogic;
    signal SELECT_DLL_IF_BINARY : std_ulogic;
    signal SIM_VERSION_BINARY : std_ulogic;
    signal SLOT_CAP_ATT_BUTTON_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_HOTPLUG_CAPABLE_BINARY : std_ulogic;
    signal SLOT_CAP_HOTPLUG_SURPRISE_BINARY : std_ulogic;
    signal SLOT_CAP_MRL_SENSOR_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY : std_ulogic;
    signal SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY : std_ulogic;
    signal SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY : std_logic_vector(1 downto 0);
    signal SPARE_BIT0_BINARY : std_ulogic;
    signal SPARE_BIT1_BINARY : std_ulogic;
    signal SPARE_BIT2_BINARY : std_ulogic;
    signal SPARE_BIT3_BINARY : std_ulogic;
    signal SPARE_BIT4_BINARY : std_ulogic;
    signal SPARE_BIT5_BINARY : std_ulogic;
    signal SPARE_BIT6_BINARY : std_ulogic;
    signal SPARE_BIT7_BINARY : std_ulogic;
    signal SPARE_BIT8_BINARY : std_ulogic;
    signal TL_RBYPASS_BINARY : std_ulogic;
    signal TL_RX_RAM_RADDR_LATENCY_BINARY : std_ulogic;
    signal TL_RX_RAM_RDATA_LATENCY_BINARY : std_logic_vector(1 downto 0);
    signal TL_RX_RAM_WRITE_LATENCY_BINARY : std_ulogic;
    signal TL_TFC_DISABLE_BINARY : std_ulogic;
    signal TL_TX_CHECKS_DISABLE_BINARY : std_ulogic;
    signal TL_TX_RAM_RADDR_LATENCY_BINARY : std_ulogic;
    signal TL_TX_RAM_RDATA_LATENCY_BINARY : std_logic_vector(1 downto 0);
    signal TL_TX_RAM_WRITE_LATENCY_BINARY : std_ulogic;
    signal UPCONFIG_CAPABLE_BINARY : std_ulogic;
    signal UPSTREAM_FACING_BINARY : std_ulogic;
    signal UR_INV_REQ_BINARY : std_ulogic;
    signal USER_CLK_FREQ_BINARY : std_logic_vector(2 downto 0);
    signal VC0_CPL_INFINITE_BINARY : std_ulogic;
    signal VC0_TOTAL_CREDITS_CD_BINARY : std_logic_vector(10 downto 0);
    signal VC0_TOTAL_CREDITS_CH_BINARY : std_logic_vector(6 downto 0);
    signal VC0_TOTAL_CREDITS_NPH_BINARY : std_logic_vector(6 downto 0);
    signal VC0_TOTAL_CREDITS_PD_BINARY : std_logic_vector(10 downto 0);
    signal VC0_TOTAL_CREDITS_PH_BINARY : std_logic_vector(6 downto 0);
    signal VC0_TX_LASTPACKET_BINARY : std_logic_vector(4 downto 0);
    signal VC_CAP_ON_BINARY : std_ulogic;
    signal VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY : std_ulogic;
    signal VSEC_CAP_IS_LINK_VISIBLE_BINARY : std_ulogic;
    signal VSEC_CAP_ON_BINARY : std_ulogic;
    
    signal CFGAERECRCCHECKEN_out : std_ulogic;
    signal CFGAERECRCGENEN_out : std_ulogic;
    signal CFGCOMMANDBUSMASTERENABLE_out : std_ulogic;
    signal CFGCOMMANDINTERRUPTDISABLE_out : std_ulogic;
    signal CFGCOMMANDIOENABLE_out : std_ulogic;
    signal CFGCOMMANDMEMENABLE_out : std_ulogic;
    signal CFGCOMMANDSERREN_out : std_ulogic;
    signal CFGDEVCONTROL2CPLTIMEOUTDIS_out : std_ulogic;
    signal CFGDEVCONTROL2CPLTIMEOUTVAL_out : std_logic_vector(3 downto 0);
    signal CFGDEVCONTROLAUXPOWEREN_out : std_ulogic;
    signal CFGDEVCONTROLCORRERRREPORTINGEN_out : std_ulogic;
    signal CFGDEVCONTROLENABLERO_out : std_ulogic;
    signal CFGDEVCONTROLEXTTAGEN_out : std_ulogic;
    signal CFGDEVCONTROLFATALERRREPORTINGEN_out : std_ulogic;
    signal CFGDEVCONTROLMAXPAYLOAD_out : std_logic_vector(2 downto 0);
    signal CFGDEVCONTROLMAXREADREQ_out : std_logic_vector(2 downto 0);
    signal CFGDEVCONTROLNONFATALREPORTINGEN_out : std_ulogic;
    signal CFGDEVCONTROLNOSNOOPEN_out : std_ulogic;
    signal CFGDEVCONTROLPHANTOMEN_out : std_ulogic;
    signal CFGDEVCONTROLURERRREPORTINGEN_out : std_ulogic;
    signal CFGDEVSTATUSCORRERRDETECTED_out : std_ulogic;
    signal CFGDEVSTATUSFATALERRDETECTED_out : std_ulogic;
    signal CFGDEVSTATUSNONFATALERRDETECTED_out : std_ulogic;
    signal CFGDEVSTATUSURDETECTED_out : std_ulogic;
    signal CFGDO_out : std_logic_vector(31 downto 0);
    signal CFGERRAERHEADERLOGSETN_out : std_ulogic;
    signal CFGERRCPLRDYN_out : std_ulogic;
    signal CFGINTERRUPTDO_out : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTMMENABLE_out : std_logic_vector(2 downto 0);
    signal CFGINTERRUPTMSIENABLE_out : std_ulogic;
    signal CFGINTERRUPTMSIXENABLE_out : std_ulogic;
    signal CFGINTERRUPTMSIXFM_out : std_ulogic;
    signal CFGINTERRUPTRDYN_out : std_ulogic;
    signal CFGLINKCONTROLASPMCONTROL_out : std_logic_vector(1 downto 0);
    signal CFGLINKCONTROLAUTOBANDWIDTHINTEN_out : std_ulogic;
    signal CFGLINKCONTROLBANDWIDTHINTEN_out : std_ulogic;
    signal CFGLINKCONTROLCLOCKPMEN_out : std_ulogic;
    signal CFGLINKCONTROLCOMMONCLOCK_out : std_ulogic;
    signal CFGLINKCONTROLEXTENDEDSYNC_out : std_ulogic;
    signal CFGLINKCONTROLHWAUTOWIDTHDIS_out : std_ulogic;
    signal CFGLINKCONTROLLINKDISABLE_out : std_ulogic;
    signal CFGLINKCONTROLRCB_out : std_ulogic;
    signal CFGLINKCONTROLRETRAINLINK_out : std_ulogic;
    signal CFGLINKSTATUSAUTOBANDWIDTHSTATUS_out : std_ulogic;
    signal CFGLINKSTATUSBANDWITHSTATUS_out : std_ulogic;
    signal CFGLINKSTATUSCURRENTSPEED_out : std_logic_vector(1 downto 0);
    signal CFGLINKSTATUSDLLACTIVE_out : std_ulogic;
    signal CFGLINKSTATUSLINKTRAINING_out : std_ulogic;
    signal CFGLINKSTATUSNEGOTIATEDWIDTH_out : std_logic_vector(3 downto 0);
    signal CFGMSGDATA_out : std_logic_vector(15 downto 0);
    signal CFGMSGRECEIVEDASSERTINTA_out : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTB_out : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTC_out : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTD_out : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTA_out : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTB_out : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTC_out : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTD_out : std_ulogic;
    signal CFGMSGRECEIVEDERRCOR_out : std_ulogic;
    signal CFGMSGRECEIVEDERRFATAL_out : std_ulogic;
    signal CFGMSGRECEIVEDERRNONFATAL_out : std_ulogic;
    signal CFGMSGRECEIVEDPMASNAK_out : std_ulogic;
    signal CFGMSGRECEIVEDPMETOACK_out : std_ulogic;
    signal CFGMSGRECEIVEDPMETO_out : std_ulogic;
    signal CFGMSGRECEIVEDPMPME_out : std_ulogic;
    signal CFGMSGRECEIVEDSETSLOTPOWERLIMIT_out : std_ulogic;
    signal CFGMSGRECEIVEDUNLOCK_out : std_ulogic;
    signal CFGMSGRECEIVED_out : std_ulogic;
    signal CFGPCIELINKSTATE_out : std_logic_vector(2 downto 0);
    signal CFGPMCSRPMEEN_out : std_ulogic;
    signal CFGPMCSRPMESTATUS_out : std_ulogic;
    signal CFGPMCSRPOWERSTATE_out : std_logic_vector(1 downto 0);
    signal CFGPMRCVASREQL1N_out : std_ulogic;
    signal CFGPMRCVENTERL1N_out : std_ulogic;
    signal CFGPMRCVENTERL23N_out : std_ulogic;
    signal CFGPMRCVREQACKN_out : std_ulogic;
    signal CFGRDWRDONEN_out : std_ulogic;
    signal CFGSLOTCONTROLELECTROMECHILCTLPULSE_out : std_ulogic;
    signal CFGTRANSACTIONADDR_out : std_logic_vector(6 downto 0);
    signal CFGTRANSACTIONTYPE_out : std_ulogic;
    signal CFGTRANSACTION_out : std_ulogic;
    signal CFGVCTCVCMAP_out : std_logic_vector(6 downto 0);
    signal DBGSCLRA_out : std_ulogic;
    signal DBGSCLRB_out : std_ulogic;
    signal DBGSCLRC_out : std_ulogic;
    signal DBGSCLRD_out : std_ulogic;
    signal DBGSCLRE_out : std_ulogic;
    signal DBGSCLRF_out : std_ulogic;
    signal DBGSCLRG_out : std_ulogic;
    signal DBGSCLRH_out : std_ulogic;
    signal DBGSCLRI_out : std_ulogic;
    signal DBGSCLRJ_out : std_ulogic;
    signal DBGSCLRK_out : std_ulogic;
    signal DBGVECA_out : std_logic_vector(63 downto 0);
    signal DBGVECB_out : std_logic_vector(63 downto 0);
    signal DBGVECC_out : std_logic_vector(11 downto 0);
    signal DRPDO_out : std_logic_vector(15 downto 0);
    signal DRPDRDY_out : std_ulogic;
    signal LL2BADDLLPERRN_out : std_ulogic;
    signal LL2BADTLPERRN_out : std_ulogic;
    signal LL2PROTOCOLERRN_out : std_ulogic;
    signal LL2REPLAYROERRN_out : std_ulogic;
    signal LL2REPLAYTOERRN_out : std_ulogic;
    signal LL2SUSPENDOKN_out : std_ulogic;
    signal LL2TFCINIT1SEQN_out : std_ulogic;
    signal LL2TFCINIT2SEQN_out : std_ulogic;
    signal LNKCLKEN_out : std_ulogic;
    signal MIMRXRADDR_out : std_logic_vector(12 downto 0);
    signal MIMRXRCE_out : std_ulogic;
    signal MIMRXREN_out : std_ulogic;
    signal MIMRXWADDR_out : std_logic_vector(12 downto 0);
    signal MIMRXWDATA_out : std_logic_vector(67 downto 0);
    signal MIMRXWEN_out : std_ulogic;
    signal MIMTXRADDR_out : std_logic_vector(12 downto 0);
    signal MIMTXRCE_out : std_ulogic;
    signal MIMTXREN_out : std_ulogic;
    signal MIMTXWADDR_out : std_logic_vector(12 downto 0);
    signal MIMTXWDATA_out : std_logic_vector(68 downto 0);
    signal MIMTXWEN_out : std_ulogic;
    signal PIPERX0POLARITY_out : std_ulogic;
    signal PIPERX1POLARITY_out : std_ulogic;
    signal PIPERX2POLARITY_out : std_ulogic;
    signal PIPERX3POLARITY_out : std_ulogic;
    signal PIPERX4POLARITY_out : std_ulogic;
    signal PIPERX5POLARITY_out : std_ulogic;
    signal PIPERX6POLARITY_out : std_ulogic;
    signal PIPERX7POLARITY_out : std_ulogic;
    signal PIPETX0CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX0COMPLIANCE_out : std_ulogic;
    signal PIPETX0DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX0ELECIDLE_out : std_ulogic;
    signal PIPETX0POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX1CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX1COMPLIANCE_out : std_ulogic;
    signal PIPETX1DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX1ELECIDLE_out : std_ulogic;
    signal PIPETX1POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX2CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX2COMPLIANCE_out : std_ulogic;
    signal PIPETX2DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX2ELECIDLE_out : std_ulogic;
    signal PIPETX2POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX3CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX3COMPLIANCE_out : std_ulogic;
    signal PIPETX3DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX3ELECIDLE_out : std_ulogic;
    signal PIPETX3POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX4CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX4COMPLIANCE_out : std_ulogic;
    signal PIPETX4DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX4ELECIDLE_out : std_ulogic;
    signal PIPETX4POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX5CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX5COMPLIANCE_out : std_ulogic;
    signal PIPETX5DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX5ELECIDLE_out : std_ulogic;
    signal PIPETX5POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX6CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX6COMPLIANCE_out : std_ulogic;
    signal PIPETX6DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX6ELECIDLE_out : std_ulogic;
    signal PIPETX6POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETX7CHARISK_out : std_logic_vector(1 downto 0);
    signal PIPETX7COMPLIANCE_out : std_ulogic;
    signal PIPETX7DATA_out : std_logic_vector(15 downto 0);
    signal PIPETX7ELECIDLE_out : std_ulogic;
    signal PIPETX7POWERDOWN_out : std_logic_vector(1 downto 0);
    signal PIPETXDEEMPH_out : std_ulogic;
    signal PIPETXMARGIN_out : std_logic_vector(2 downto 0);
    signal PIPETXRATE_out : std_ulogic;
    signal PIPETXRCVRDET_out : std_ulogic;
    signal PIPETXRESET_out : std_ulogic;
    signal PL2LINKUPN_out : std_ulogic;
    signal PL2RECEIVERERRN_out : std_ulogic;
    signal PL2RECOVERYN_out : std_ulogic;
    signal PL2RXELECIDLE_out : std_ulogic;
    signal PL2SUSPENDOK_out : std_ulogic;
    signal PLDBGVEC_out : std_logic_vector(11 downto 0);
    signal PLINITIALLINKWIDTH_out : std_logic_vector(2 downto 0);
    signal PLLANEREVERSALMODE_out : std_logic_vector(1 downto 0);
    signal PLLINKGEN2CAP_out : std_ulogic;
    signal PLLINKPARTNERGEN2SUPPORTED_out : std_ulogic;
    signal PLLINKUPCFGCAP_out : std_ulogic;
    signal PLLTSSMSTATE_out : std_logic_vector(5 downto 0);
    signal PLPHYLNKUPN_out : std_ulogic;
    signal PLRECEIVEDHOTRST_out : std_ulogic;
    signal PLRXPMSTATE_out : std_logic_vector(1 downto 0);
    signal PLSELLNKRATE_out : std_ulogic;
    signal PLSELLNKWIDTH_out : std_logic_vector(1 downto 0);
    signal PLTXPMSTATE_out : std_logic_vector(2 downto 0);
    signal RECEIVEDFUNCLVLRSTN_out : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKOKN_out : std_ulogic;
    signal TL2ASPMSUSPENDREQN_out : std_ulogic;
    signal TL2PPMSUSPENDOKN_out : std_ulogic;
    signal TRNFCCPLD_out : std_logic_vector(11 downto 0);
    signal TRNFCCPLH_out : std_logic_vector(7 downto 0);
    signal TRNFCNPD_out : std_logic_vector(11 downto 0);
    signal TRNFCNPH_out : std_logic_vector(7 downto 0);
    signal TRNFCPD_out : std_logic_vector(11 downto 0);
    signal TRNFCPH_out : std_logic_vector(7 downto 0);
    signal TRNLNKUPN_out : std_ulogic;
    signal TRNRBARHITN_out : std_logic_vector(6 downto 0);
    signal TRNRDLLPDATA_out : std_logic_vector(31 downto 0);
    signal TRNRDLLPSRCRDYN_out : std_ulogic;
    signal TRNRD_out : std_logic_vector(63 downto 0);
    signal TRNRECRCERRN_out : std_ulogic;
    signal TRNREOFN_out : std_ulogic;
    signal TRNRERRFWDN_out : std_ulogic;
    signal TRNRREMN_out : std_ulogic;
    signal TRNRSOFN_out : std_ulogic;
    signal TRNRSRCDSCN_out : std_ulogic;
    signal TRNRSRCRDYN_out : std_ulogic;
    signal TRNTBUFAV_out : std_logic_vector(5 downto 0);
    signal TRNTCFGREQN_out : std_ulogic;
    signal TRNTDLLPDSTRDYN_out : std_ulogic;
    signal TRNTDSTRDYN_out : std_ulogic;
    signal TRNTERRDROPN_out : std_ulogic;
    signal USERRSTN_out : std_ulogic;
    
    signal CFGAERECRCCHECKEN_outdelay : std_ulogic;
    signal CFGAERECRCGENEN_outdelay : std_ulogic;
    signal CFGCOMMANDBUSMASTERENABLE_outdelay : std_ulogic;
    signal CFGCOMMANDINTERRUPTDISABLE_outdelay : std_ulogic;
    signal CFGCOMMANDIOENABLE_outdelay : std_ulogic;
    signal CFGCOMMANDMEMENABLE_outdelay : std_ulogic;
    signal CFGCOMMANDSERREN_outdelay : std_ulogic;
    signal CFGDEVCONTROL2CPLTIMEOUTDIS_outdelay : std_ulogic;
    signal CFGDEVCONTROL2CPLTIMEOUTVAL_outdelay : std_logic_vector(3 downto 0);
    signal CFGDEVCONTROLAUXPOWEREN_outdelay : std_ulogic;
    signal CFGDEVCONTROLCORRERRREPORTINGEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLENABLERO_outdelay : std_ulogic;
    signal CFGDEVCONTROLEXTTAGEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLFATALERRREPORTINGEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLMAXPAYLOAD_outdelay : std_logic_vector(2 downto 0);
    signal CFGDEVCONTROLMAXREADREQ_outdelay : std_logic_vector(2 downto 0);
    signal CFGDEVCONTROLNONFATALREPORTINGEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLNOSNOOPEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLPHANTOMEN_outdelay : std_ulogic;
    signal CFGDEVCONTROLURERRREPORTINGEN_outdelay : std_ulogic;
    signal CFGDEVSTATUSCORRERRDETECTED_outdelay : std_ulogic;
    signal CFGDEVSTATUSFATALERRDETECTED_outdelay : std_ulogic;
    signal CFGDEVSTATUSNONFATALERRDETECTED_outdelay : std_ulogic;
    signal CFGDEVSTATUSURDETECTED_outdelay : std_ulogic;
    signal CFGDO_outdelay : std_logic_vector(31 downto 0);
    signal CFGERRAERHEADERLOGSETN_outdelay : std_ulogic;
    signal CFGERRCPLRDYN_outdelay : std_ulogic;
    signal CFGINTERRUPTDO_outdelay : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTMMENABLE_outdelay : std_logic_vector(2 downto 0);
    signal CFGINTERRUPTMSIENABLE_outdelay : std_ulogic;
    signal CFGINTERRUPTMSIXENABLE_outdelay : std_ulogic;
    signal CFGINTERRUPTMSIXFM_outdelay : std_ulogic;
    signal CFGINTERRUPTRDYN_outdelay : std_ulogic;
    signal CFGLINKCONTROLASPMCONTROL_outdelay : std_logic_vector(1 downto 0);
    signal CFGLINKCONTROLAUTOBANDWIDTHINTEN_outdelay : std_ulogic;
    signal CFGLINKCONTROLBANDWIDTHINTEN_outdelay : std_ulogic;
    signal CFGLINKCONTROLCLOCKPMEN_outdelay : std_ulogic;
    signal CFGLINKCONTROLCOMMONCLOCK_outdelay : std_ulogic;
    signal CFGLINKCONTROLEXTENDEDSYNC_outdelay : std_ulogic;
    signal CFGLINKCONTROLHWAUTOWIDTHDIS_outdelay : std_ulogic;
    signal CFGLINKCONTROLLINKDISABLE_outdelay : std_ulogic;
    signal CFGLINKCONTROLRCB_outdelay : std_ulogic;
    signal CFGLINKCONTROLRETRAINLINK_outdelay : std_ulogic;
    signal CFGLINKSTATUSAUTOBANDWIDTHSTATUS_outdelay : std_ulogic;
    signal CFGLINKSTATUSBANDWITHSTATUS_outdelay : std_ulogic;
    signal CFGLINKSTATUSCURRENTSPEED_outdelay : std_logic_vector(1 downto 0);
    signal CFGLINKSTATUSDLLACTIVE_outdelay : std_ulogic;
    signal CFGLINKSTATUSLINKTRAINING_outdelay : std_ulogic;
    signal CFGLINKSTATUSNEGOTIATEDWIDTH_outdelay : std_logic_vector(3 downto 0);
    signal CFGMSGDATA_outdelay : std_logic_vector(15 downto 0);
    signal CFGMSGRECEIVEDASSERTINTA_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTB_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTC_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDASSERTINTD_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTA_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTB_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTC_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDDEASSERTINTD_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDERRCOR_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDERRFATAL_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDERRNONFATAL_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDPMASNAK_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDPMETOACK_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDPMETO_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDPMPME_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDSETSLOTPOWERLIMIT_outdelay : std_ulogic;
    signal CFGMSGRECEIVEDUNLOCK_outdelay : std_ulogic;
    signal CFGMSGRECEIVED_outdelay : std_ulogic;
    signal CFGPCIELINKSTATE_outdelay : std_logic_vector(2 downto 0);
    signal CFGPMCSRPMEEN_outdelay : std_ulogic;
    signal CFGPMCSRPMESTATUS_outdelay : std_ulogic;
    signal CFGPMCSRPOWERSTATE_outdelay : std_logic_vector(1 downto 0);
    signal CFGPMRCVASREQL1N_outdelay : std_ulogic;
    signal CFGPMRCVENTERL1N_outdelay : std_ulogic;
    signal CFGPMRCVENTERL23N_outdelay : std_ulogic;
    signal CFGPMRCVREQACKN_outdelay : std_ulogic;
    signal CFGRDWRDONEN_outdelay : std_ulogic;
    signal CFGSLOTCONTROLELECTROMECHILCTLPULSE_outdelay : std_ulogic;
    signal CFGTRANSACTIONADDR_outdelay : std_logic_vector(6 downto 0);
    signal CFGTRANSACTIONTYPE_outdelay : std_ulogic;
    signal CFGTRANSACTION_outdelay : std_ulogic;
    signal CFGVCTCVCMAP_outdelay : std_logic_vector(6 downto 0);
    signal DBGSCLRA_outdelay : std_ulogic;
    signal DBGSCLRB_outdelay : std_ulogic;
    signal DBGSCLRC_outdelay : std_ulogic;
    signal DBGSCLRD_outdelay : std_ulogic;
    signal DBGSCLRE_outdelay : std_ulogic;
    signal DBGSCLRF_outdelay : std_ulogic;
    signal DBGSCLRG_outdelay : std_ulogic;
    signal DBGSCLRH_outdelay : std_ulogic;
    signal DBGSCLRI_outdelay : std_ulogic;
    signal DBGSCLRJ_outdelay : std_ulogic;
    signal DBGSCLRK_outdelay : std_ulogic;
    signal DBGVECA_outdelay : std_logic_vector(63 downto 0);
    signal DBGVECB_outdelay : std_logic_vector(63 downto 0);
    signal DBGVECC_outdelay : std_logic_vector(11 downto 0);
    signal DRPDO_outdelay : std_logic_vector(15 downto 0);
    signal DRPDRDY_outdelay : std_ulogic;
    signal LL2BADDLLPERRN_outdelay : std_ulogic;
    signal LL2BADTLPERRN_outdelay : std_ulogic;
    signal LL2PROTOCOLERRN_outdelay : std_ulogic;
    signal LL2REPLAYROERRN_outdelay : std_ulogic;
    signal LL2REPLAYTOERRN_outdelay : std_ulogic;
    signal LL2SUSPENDOKN_outdelay : std_ulogic;
    signal LL2TFCINIT1SEQN_outdelay : std_ulogic;
    signal LL2TFCINIT2SEQN_outdelay : std_ulogic;
    signal LNKCLKEN_outdelay : std_ulogic;
    signal MIMRXRADDR_outdelay : std_logic_vector(12 downto 0);
    signal MIMRXRCE_outdelay : std_ulogic;
    signal MIMRXREN_outdelay : std_ulogic;
    signal MIMRXWADDR_outdelay : std_logic_vector(12 downto 0);
    signal MIMRXWDATA_outdelay : std_logic_vector(67 downto 0);
    signal MIMRXWEN_outdelay : std_ulogic;
    signal MIMTXRADDR_outdelay : std_logic_vector(12 downto 0);
    signal MIMTXRCE_outdelay : std_ulogic;
    signal MIMTXREN_outdelay : std_ulogic;
    signal MIMTXWADDR_outdelay : std_logic_vector(12 downto 0);
    signal MIMTXWDATA_outdelay : std_logic_vector(68 downto 0);
    signal MIMTXWEN_outdelay : std_ulogic;
    signal PIPERX0POLARITY_outdelay : std_ulogic;
    signal PIPERX1POLARITY_outdelay : std_ulogic;
    signal PIPERX2POLARITY_outdelay : std_ulogic;
    signal PIPERX3POLARITY_outdelay : std_ulogic;
    signal PIPERX4POLARITY_outdelay : std_ulogic;
    signal PIPERX5POLARITY_outdelay : std_ulogic;
    signal PIPERX6POLARITY_outdelay : std_ulogic;
    signal PIPERX7POLARITY_outdelay : std_ulogic;
    signal PIPETX0CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX0COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX0DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX0ELECIDLE_outdelay : std_ulogic;
    signal PIPETX0POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX1CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX1COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX1DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX1ELECIDLE_outdelay : std_ulogic;
    signal PIPETX1POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX2CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX2COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX2DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX2ELECIDLE_outdelay : std_ulogic;
    signal PIPETX2POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX3CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX3COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX3DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX3ELECIDLE_outdelay : std_ulogic;
    signal PIPETX3POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX4CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX4COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX4DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX4ELECIDLE_outdelay : std_ulogic;
    signal PIPETX4POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX5CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX5COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX5DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX5ELECIDLE_outdelay : std_ulogic;
    signal PIPETX5POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX6CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX6COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX6DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX6ELECIDLE_outdelay : std_ulogic;
    signal PIPETX6POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX7CHARISK_outdelay : std_logic_vector(1 downto 0);
    signal PIPETX7COMPLIANCE_outdelay : std_ulogic;
    signal PIPETX7DATA_outdelay : std_logic_vector(15 downto 0);
    signal PIPETX7ELECIDLE_outdelay : std_ulogic;
    signal PIPETX7POWERDOWN_outdelay : std_logic_vector(1 downto 0);
    signal PIPETXDEEMPH_outdelay : std_ulogic;
    signal PIPETXMARGIN_outdelay : std_logic_vector(2 downto 0);
    signal PIPETXRATE_outdelay : std_ulogic;
    signal PIPETXRCVRDET_outdelay : std_ulogic;
    signal PIPETXRESET_outdelay : std_ulogic;
    signal PL2LINKUPN_outdelay : std_ulogic;
    signal PL2RECEIVERERRN_outdelay : std_ulogic;
    signal PL2RECOVERYN_outdelay : std_ulogic;
    signal PL2RXELECIDLE_outdelay : std_ulogic;
    signal PL2SUSPENDOK_outdelay : std_ulogic;
    signal PLDBGVEC_outdelay : std_logic_vector(11 downto 0);
    signal PLINITIALLINKWIDTH_outdelay : std_logic_vector(2 downto 0);
    signal PLLANEREVERSALMODE_outdelay : std_logic_vector(1 downto 0);
    signal PLLINKGEN2CAP_outdelay : std_ulogic;
    signal PLLINKPARTNERGEN2SUPPORTED_outdelay : std_ulogic;
    signal PLLINKUPCFGCAP_outdelay : std_ulogic;
    signal PLLTSSMSTATE_outdelay : std_logic_vector(5 downto 0);
    signal PLPHYLNKUPN_outdelay : std_ulogic;
    signal PLRECEIVEDHOTRST_outdelay : std_ulogic;
    signal PLRXPMSTATE_outdelay : std_logic_vector(1 downto 0);
    signal PLSELLNKRATE_outdelay : std_ulogic;
    signal PLSELLNKWIDTH_outdelay : std_logic_vector(1 downto 0);
    signal PLTXPMSTATE_outdelay : std_logic_vector(2 downto 0);
    signal RECEIVEDFUNCLVLRSTN_outdelay : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKOKN_outdelay : std_ulogic;
    signal TL2ASPMSUSPENDREQN_outdelay : std_ulogic;
    signal TL2PPMSUSPENDOKN_outdelay : std_ulogic;
    signal TRNFCCPLD_outdelay : std_logic_vector(11 downto 0);
    signal TRNFCCPLH_outdelay : std_logic_vector(7 downto 0);
    signal TRNFCNPD_outdelay : std_logic_vector(11 downto 0);
    signal TRNFCNPH_outdelay : std_logic_vector(7 downto 0);
    signal TRNFCPD_outdelay : std_logic_vector(11 downto 0);
    signal TRNFCPH_outdelay : std_logic_vector(7 downto 0);
    signal TRNLNKUPN_outdelay : std_ulogic;
    signal TRNRBARHITN_outdelay : std_logic_vector(6 downto 0);
    signal TRNRDLLPDATA_outdelay : std_logic_vector(31 downto 0);
    signal TRNRDLLPSRCRDYN_outdelay : std_ulogic;
    signal TRNRD_outdelay : std_logic_vector(63 downto 0);
    signal TRNRECRCERRN_outdelay : std_ulogic;
    signal TRNREOFN_outdelay : std_ulogic;
    signal TRNRERRFWDN_outdelay : std_ulogic;
    signal TRNRREMN_outdelay : std_ulogic;
    signal TRNRSOFN_outdelay : std_ulogic;
    signal TRNRSRCDSCN_outdelay : std_ulogic;
    signal TRNRSRCRDYN_outdelay : std_ulogic;
    signal TRNTBUFAV_outdelay : std_logic_vector(5 downto 0);
    signal TRNTCFGREQN_outdelay : std_ulogic;
    signal TRNTDLLPDSTRDYN_outdelay : std_ulogic;
    signal TRNTDSTRDYN_outdelay : std_ulogic;
    signal TRNTERRDROPN_outdelay : std_ulogic;
    signal USERRSTN_outdelay : std_ulogic;
    
    signal CFGBYTEENN_ipd : std_logic_vector(3 downto 0);
    signal CFGDI_ipd : std_logic_vector(31 downto 0);
    signal CFGDSBUSNUMBER_ipd : std_logic_vector(7 downto 0);
    signal CFGDSDEVICENUMBER_ipd : std_logic_vector(4 downto 0);
    signal CFGDSFUNCTIONNUMBER_ipd : std_logic_vector(2 downto 0);
    signal CFGDSN_ipd : std_logic_vector(63 downto 0);
    signal CFGDWADDR_ipd : std_logic_vector(9 downto 0);
    signal CFGERRACSN_ipd : std_ulogic;
    signal CFGERRAERHEADERLOG_ipd : std_logic_vector(127 downto 0);
    signal CFGERRCORN_ipd : std_ulogic;
    signal CFGERRCPLABORTN_ipd : std_ulogic;
    signal CFGERRCPLTIMEOUTN_ipd : std_ulogic;
    signal CFGERRCPLUNEXPECTN_ipd : std_ulogic;
    signal CFGERRECRCN_ipd : std_ulogic;
    signal CFGERRLOCKEDN_ipd : std_ulogic;
    signal CFGERRPOSTEDN_ipd : std_ulogic;
    signal CFGERRTLPCPLHEADER_ipd : std_logic_vector(47 downto 0);
    signal CFGERRURN_ipd : std_ulogic;
    signal CFGINTERRUPTASSERTN_ipd : std_ulogic;
    signal CFGINTERRUPTDI_ipd : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTN_ipd : std_ulogic;
    signal CFGPMDIRECTASPML1N_ipd : std_ulogic;
    signal CFGPMSENDPMACKN_ipd : std_ulogic;
    signal CFGPMSENDPMETON_ipd : std_ulogic;
    signal CFGPMSENDPMNAKN_ipd : std_ulogic;
    signal CFGPMTURNOFFOKN_ipd : std_ulogic;
    signal CFGPMWAKEN_ipd : std_ulogic;
    signal CFGPORTNUMBER_ipd : std_logic_vector(7 downto 0);
    signal CFGRDENN_ipd : std_ulogic;
    signal CFGTRNPENDINGN_ipd : std_ulogic;
    signal CFGWRENN_ipd : std_ulogic;
    signal CFGWRREADONLYN_ipd : std_ulogic;
    signal CFGWRRW1CASRWN_ipd : std_ulogic;
    signal CMRSTN_ipd : std_ulogic;
    signal CMSTICKYRSTN_ipd : std_ulogic;
    signal DBGMODE_ipd : std_logic_vector(1 downto 0);
    signal DBGSUBMODE_ipd : std_ulogic;
    signal DLRSTN_ipd : std_ulogic;
    signal DRPCLK_ipd : std_ulogic;
    signal DRPDADDR_ipd : std_logic_vector(8 downto 0);
    signal DRPDEN_ipd : std_ulogic;
    signal DRPDI_ipd : std_logic_vector(15 downto 0);
    signal DRPDWE_ipd : std_ulogic;
    signal FUNCLVLRSTN_ipd : std_ulogic;
    signal LL2SENDASREQL1N_ipd : std_ulogic;
    signal LL2SENDENTERL1N_ipd : std_ulogic;
    signal LL2SENDENTERL23N_ipd : std_ulogic;
    signal LL2SUSPENDNOWN_ipd : std_ulogic;
    signal LL2TLPRCVN_ipd : std_ulogic;
    signal MIMRXRDATA_ipd : std_logic_vector(67 downto 0);
    signal MIMTXRDATA_ipd : std_logic_vector(68 downto 0);
    signal PIPECLK_ipd : std_ulogic;
    signal PIPERX0CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX0CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX0DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX0ELECIDLE_ipd : std_ulogic;
    signal PIPERX0PHYSTATUS_ipd : std_ulogic;
    signal PIPERX0STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX0VALID_ipd : std_ulogic;
    signal PIPERX1CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX1CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX1DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX1ELECIDLE_ipd : std_ulogic;
    signal PIPERX1PHYSTATUS_ipd : std_ulogic;
    signal PIPERX1STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX1VALID_ipd : std_ulogic;
    signal PIPERX2CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX2CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX2DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX2ELECIDLE_ipd : std_ulogic;
    signal PIPERX2PHYSTATUS_ipd : std_ulogic;
    signal PIPERX2STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX2VALID_ipd : std_ulogic;
    signal PIPERX3CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX3CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX3DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX3ELECIDLE_ipd : std_ulogic;
    signal PIPERX3PHYSTATUS_ipd : std_ulogic;
    signal PIPERX3STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX3VALID_ipd : std_ulogic;
    signal PIPERX4CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX4CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX4DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX4ELECIDLE_ipd : std_ulogic;
    signal PIPERX4PHYSTATUS_ipd : std_ulogic;
    signal PIPERX4STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX4VALID_ipd : std_ulogic;
    signal PIPERX5CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX5CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX5DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX5ELECIDLE_ipd : std_ulogic;
    signal PIPERX5PHYSTATUS_ipd : std_ulogic;
    signal PIPERX5STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX5VALID_ipd : std_ulogic;
    signal PIPERX6CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX6CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX6DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX6ELECIDLE_ipd : std_ulogic;
    signal PIPERX6PHYSTATUS_ipd : std_ulogic;
    signal PIPERX6STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX6VALID_ipd : std_ulogic;
    signal PIPERX7CHANISALIGNED_ipd : std_ulogic;
    signal PIPERX7CHARISK_ipd : std_logic_vector(1 downto 0);
    signal PIPERX7DATA_ipd : std_logic_vector(15 downto 0);
    signal PIPERX7ELECIDLE_ipd : std_ulogic;
    signal PIPERX7PHYSTATUS_ipd : std_ulogic;
    signal PIPERX7STATUS_ipd : std_logic_vector(2 downto 0);
    signal PIPERX7VALID_ipd : std_ulogic;
    signal PL2DIRECTEDLSTATE_ipd : std_logic_vector(4 downto 0);
    signal PLDBGMODE_ipd : std_logic_vector(2 downto 0);
    signal PLDIRECTEDLINKAUTON_ipd : std_ulogic;
    signal PLDIRECTEDLINKCHANGE_ipd : std_logic_vector(1 downto 0);
    signal PLDIRECTEDLINKSPEED_ipd : std_ulogic;
    signal PLDIRECTEDLINKWIDTH_ipd : std_logic_vector(1 downto 0);
    signal PLDOWNSTREAMDEEMPHSOURCE_ipd : std_ulogic;
    signal PLRSTN_ipd : std_ulogic;
    signal PLTRANSMITHOTRST_ipd : std_ulogic;
    signal PLUPSTREAMPREFERDEEMPH_ipd : std_ulogic;
    signal SYSRSTN_ipd : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKN_ipd : std_ulogic;
    signal TL2PPMSUSPENDREQN_ipd : std_ulogic;
    signal TLRSTN_ipd : std_ulogic;
    signal TRNFCSEL_ipd : std_logic_vector(2 downto 0);
    signal TRNRDSTRDYN_ipd : std_ulogic;
    signal TRNRNPOKN_ipd : std_ulogic;
    signal TRNTCFGGNTN_ipd : std_ulogic;
    signal TRNTDLLPDATA_ipd : std_logic_vector(31 downto 0);
    signal TRNTDLLPSRCRDYN_ipd : std_ulogic;
    signal TRNTD_ipd : std_logic_vector(63 downto 0);
    signal TRNTECRCGENN_ipd : std_ulogic;
    signal TRNTEOFN_ipd : std_ulogic;
    signal TRNTERRFWDN_ipd : std_ulogic;
    signal TRNTREMN_ipd : std_ulogic;
    signal TRNTSOFN_ipd : std_ulogic;
    signal TRNTSRCDSCN_ipd : std_ulogic;
    signal TRNTSRCRDYN_ipd : std_ulogic;
    signal TRNTSTRN_ipd : std_ulogic;
    signal USERCLK_ipd : std_ulogic;
    
    signal CFGBYTEENN_USERCLK_dly : std_logic_vector(3 downto 0);
    signal CFGDI_USERCLK_dly : std_logic_vector(31 downto 0);
    signal CFGDSBUSNUMBER_USERCLK_dly : std_logic_vector(7 downto 0);
    signal CFGDSDEVICENUMBER_USERCLK_dly : std_logic_vector(4 downto 0);
    signal CFGDSFUNCTIONNUMBER_USERCLK_dly : std_logic_vector(2 downto 0);
    signal CFGDSN_USERCLK_dly : std_logic_vector(63 downto 0);
    signal CFGDWADDR_USERCLK_dly : std_logic_vector(9 downto 0);
    signal CFGERRACSN_USERCLK_dly : std_ulogic;
    signal CFGERRAERHEADERLOG_USERCLK_dly : std_logic_vector(127 downto 0);
    signal CFGERRCORN_USERCLK_dly : std_ulogic;
    signal CFGERRCPLABORTN_USERCLK_dly : std_ulogic;
    signal CFGERRCPLTIMEOUTN_USERCLK_dly : std_ulogic;
    signal CFGERRCPLUNEXPECTN_USERCLK_dly : std_ulogic;
    signal CFGERRECRCN_USERCLK_dly : std_ulogic;
    signal CFGERRLOCKEDN_USERCLK_dly : std_ulogic;
    signal CFGERRPOSTEDN_USERCLK_dly : std_ulogic;
    signal CFGERRTLPCPLHEADER_USERCLK_dly : std_logic_vector(47 downto 0);
    signal CFGERRURN_USERCLK_dly : std_ulogic;
    signal CFGINTERRUPTASSERTN_USERCLK_dly : std_ulogic;
    signal CFGINTERRUPTDI_USERCLK_dly : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTN_USERCLK_dly : std_ulogic;
    signal CFGPMDIRECTASPML1N_USERCLK_dly : std_ulogic;
    signal CFGPMSENDPMACKN_USERCLK_dly : std_ulogic;
    signal CFGPMSENDPMETON_USERCLK_dly : std_ulogic;
    signal CFGPMSENDPMNAKN_USERCLK_dly : std_ulogic;
    signal CFGPMTURNOFFOKN_USERCLK_dly : std_ulogic;
    signal CFGPMWAKEN_USERCLK_dly : std_ulogic;
    signal CFGPORTNUMBER_USERCLK_dly : std_logic_vector(7 downto 0);
    signal CFGRDENN_USERCLK_dly : std_ulogic;
    signal CFGTRNPENDINGN_USERCLK_dly : std_ulogic;
    signal CFGWRENN_USERCLK_dly : std_ulogic;
    signal CFGWRREADONLYN_USERCLK_dly : std_ulogic;
    signal CFGWRRW1CASRWN_USERCLK_dly : std_ulogic;
    signal CMRSTN_USERCLK_dly : std_ulogic;
    signal CMSTICKYRSTN_USERCLK_dly : std_ulogic;
    signal DBGMODE_USERCLK_dly : std_logic_vector(1 downto 0);
    signal DBGSUBMODE_USERCLK_dly : std_ulogic;
    signal DLRSTN_USERCLK_dly : std_ulogic;
    signal DRPCLK_dly : std_ulogic;
    signal DRPDADDR_DRPCLK_dly : std_logic_vector(8 downto 0);
    signal DRPDEN_DRPCLK_dly : std_ulogic;
    signal DRPDI_DRPCLK_dly : std_logic_vector(15 downto 0);
    signal DRPDWE_DRPCLK_dly : std_ulogic;
    signal FUNCLVLRSTN_USERCLK_dly : std_ulogic;
    signal LL2SENDASREQL1N_USERCLK_dly : std_ulogic;
    signal LL2SENDENTERL1N_USERCLK_dly : std_ulogic;
    signal LL2SENDENTERL23N_USERCLK_dly : std_ulogic;
    signal LL2SUSPENDNOWN_USERCLK_dly : std_ulogic;
    signal LL2TLPRCVN_USERCLK_dly : std_ulogic;
    signal MIMRXRDATA_USERCLK_dly : std_logic_vector(67 downto 0);
    signal MIMTXRDATA_USERCLK_dly : std_logic_vector(68 downto 0);
    signal PIPECLK_dly : std_ulogic;
    signal PIPERX0CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX0CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX0DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX0ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX0PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX0STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX0VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX1CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX1CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX1DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX1ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX1PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX1STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX1VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX2CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX2CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX2DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX2ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX2PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX2STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX2VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX3CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX3CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX3DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX3ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX3PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX3STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX3VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX4CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX4CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX4DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX4ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX4PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX4STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX4VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX5CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX5CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX5DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX5ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX5PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX5STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX5VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX6CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX6CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX6DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX6ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX6PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX6STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX6VALID_PIPECLK_dly : std_ulogic;
    signal PIPERX7CHANISALIGNED_PIPECLK_dly : std_ulogic;
    signal PIPERX7CHARISK_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PIPERX7DATA_PIPECLK_dly : std_logic_vector(15 downto 0);
    signal PIPERX7ELECIDLE_PIPECLK_dly : std_ulogic;
    signal PIPERX7PHYSTATUS_PIPECLK_dly : std_ulogic;
    signal PIPERX7STATUS_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PIPERX7VALID_PIPECLK_dly : std_ulogic;
    signal PL2DIRECTEDLSTATE_USERCLK_dly : std_logic_vector(4 downto 0);
    signal PLDBGMODE_PIPECLK_dly : std_logic_vector(2 downto 0);
    signal PLDIRECTEDLINKAUTON_PIPECLK_dly : std_ulogic;
    signal PLDIRECTEDLINKCHANGE_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PLDIRECTEDLINKSPEED_PIPECLK_dly : std_ulogic;
    signal PLDIRECTEDLINKWIDTH_PIPECLK_dly : std_logic_vector(1 downto 0);
    signal PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_dly : std_ulogic;
    signal PLRSTN_PIPECLK_dly : std_ulogic;
    signal PLTRANSMITHOTRST_PIPECLK_dly : std_ulogic;
    signal PLUPSTREAMPREFERDEEMPH_PIPECLK_dly : std_ulogic;
    signal SYSRSTN_dly : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKN_USERCLK_dly : std_ulogic;
    signal TL2PPMSUSPENDREQN_USERCLK_dly : std_ulogic;
    signal TLRSTN_USERCLK_dly : std_ulogic;
    signal TRNFCSEL_USERCLK_dly : std_logic_vector(2 downto 0);
    signal TRNRDSTRDYN_USERCLK_dly : std_ulogic;
    signal TRNRNPOKN_USERCLK_dly : std_ulogic;
    signal TRNTCFGGNTN_USERCLK_dly : std_ulogic;
    signal TRNTDLLPDATA_USERCLK_dly : std_logic_vector(31 downto 0);
    signal TRNTDLLPSRCRDYN_USERCLK_dly : std_ulogic;
    signal TRNTD_USERCLK_dly : std_logic_vector(63 downto 0);
    signal TRNTECRCGENN_USERCLK_dly : std_ulogic;
    signal TRNTEOFN_USERCLK_dly : std_ulogic;
    signal TRNTERRFWDN_USERCLK_dly : std_ulogic;
    signal TRNTREMN_USERCLK_dly : std_ulogic;
    signal TRNTSOFN_USERCLK_dly : std_ulogic;
    signal TRNTSRCDSCN_USERCLK_dly : std_ulogic;
    signal TRNTSRCRDYN_USERCLK_dly : std_ulogic;
    signal TRNTSTRN_USERCLK_dly : std_ulogic;
    signal USERCLK_dly : std_ulogic;
    
    signal CFGBYTEENN_indelay : std_logic_vector(3 downto 0);
    signal CFGDI_indelay : std_logic_vector(31 downto 0);
    signal CFGDSBUSNUMBER_indelay : std_logic_vector(7 downto 0);
    signal CFGDSDEVICENUMBER_indelay : std_logic_vector(4 downto 0);
    signal CFGDSFUNCTIONNUMBER_indelay : std_logic_vector(2 downto 0);
    signal CFGDSN_indelay : std_logic_vector(63 downto 0);
    signal CFGDWADDR_indelay : std_logic_vector(9 downto 0);
    signal CFGERRACSN_indelay : std_ulogic;
    signal CFGERRAERHEADERLOG_indelay : std_logic_vector(127 downto 0);
    signal CFGERRCORN_indelay : std_ulogic;
    signal CFGERRCPLABORTN_indelay : std_ulogic;
    signal CFGERRCPLTIMEOUTN_indelay : std_ulogic;
    signal CFGERRCPLUNEXPECTN_indelay : std_ulogic;
    signal CFGERRECRCN_indelay : std_ulogic;
    signal CFGERRLOCKEDN_indelay : std_ulogic;
    signal CFGERRPOSTEDN_indelay : std_ulogic;
    signal CFGERRTLPCPLHEADER_indelay : std_logic_vector(47 downto 0);
    signal CFGERRURN_indelay : std_ulogic;
    signal CFGINTERRUPTASSERTN_indelay : std_ulogic;
    signal CFGINTERRUPTDI_indelay : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTN_indelay : std_ulogic;
    signal CFGPMDIRECTASPML1N_indelay : std_ulogic;
    signal CFGPMSENDPMACKN_indelay : std_ulogic;
    signal CFGPMSENDPMETON_indelay : std_ulogic;
    signal CFGPMSENDPMNAKN_indelay : std_ulogic;
    signal CFGPMTURNOFFOKN_indelay : std_ulogic;
    signal CFGPMWAKEN_indelay : std_ulogic;
    signal CFGPORTNUMBER_indelay : std_logic_vector(7 downto 0);
    signal CFGRDENN_indelay : std_ulogic;
    signal CFGTRNPENDINGN_indelay : std_ulogic;
    signal CFGWRENN_indelay : std_ulogic;
    signal CFGWRREADONLYN_indelay : std_ulogic;
    signal CFGWRRW1CASRWN_indelay : std_ulogic;
    signal CMRSTN_indelay : std_ulogic;
    signal CMSTICKYRSTN_indelay : std_ulogic;
    signal DBGMODE_indelay : std_logic_vector(1 downto 0);
    signal DBGSUBMODE_indelay : std_ulogic;
    signal DLRSTN_indelay : std_ulogic;
    signal DRPCLK_indelay : std_ulogic;
    signal DRPDADDR_indelay : std_logic_vector(8 downto 0);
    signal DRPDEN_indelay : std_ulogic;
    signal DRPDI_indelay : std_logic_vector(15 downto 0);
    signal DRPDWE_indelay : std_ulogic;
    signal FUNCLVLRSTN_indelay : std_ulogic;
    signal LL2SENDASREQL1N_indelay : std_ulogic;
    signal LL2SENDENTERL1N_indelay : std_ulogic;
    signal LL2SENDENTERL23N_indelay : std_ulogic;
    signal LL2SUSPENDNOWN_indelay : std_ulogic;
    signal LL2TLPRCVN_indelay : std_ulogic;
    signal MIMRXRDATA_indelay : std_logic_vector(67 downto 0);
    signal MIMTXRDATA_indelay : std_logic_vector(68 downto 0);
    signal PIPECLK_indelay : std_ulogic;
    signal PIPERX0CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX0CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX0DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX0ELECIDLE_indelay : std_ulogic;
    signal PIPERX0PHYSTATUS_indelay : std_ulogic;
    signal PIPERX0STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX0VALID_indelay : std_ulogic;
    signal PIPERX1CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX1CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX1DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX1ELECIDLE_indelay : std_ulogic;
    signal PIPERX1PHYSTATUS_indelay : std_ulogic;
    signal PIPERX1STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX1VALID_indelay : std_ulogic;
    signal PIPERX2CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX2CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX2DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX2ELECIDLE_indelay : std_ulogic;
    signal PIPERX2PHYSTATUS_indelay : std_ulogic;
    signal PIPERX2STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX2VALID_indelay : std_ulogic;
    signal PIPERX3CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX3CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX3DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX3ELECIDLE_indelay : std_ulogic;
    signal PIPERX3PHYSTATUS_indelay : std_ulogic;
    signal PIPERX3STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX3VALID_indelay : std_ulogic;
    signal PIPERX4CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX4CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX4DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX4ELECIDLE_indelay : std_ulogic;
    signal PIPERX4PHYSTATUS_indelay : std_ulogic;
    signal PIPERX4STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX4VALID_indelay : std_ulogic;
    signal PIPERX5CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX5CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX5DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX5ELECIDLE_indelay : std_ulogic;
    signal PIPERX5PHYSTATUS_indelay : std_ulogic;
    signal PIPERX5STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX5VALID_indelay : std_ulogic;
    signal PIPERX6CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX6CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX6DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX6ELECIDLE_indelay : std_ulogic;
    signal PIPERX6PHYSTATUS_indelay : std_ulogic;
    signal PIPERX6STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX6VALID_indelay : std_ulogic;
    signal PIPERX7CHANISALIGNED_indelay : std_ulogic;
    signal PIPERX7CHARISK_indelay : std_logic_vector(1 downto 0);
    signal PIPERX7DATA_indelay : std_logic_vector(15 downto 0);
    signal PIPERX7ELECIDLE_indelay : std_ulogic;
    signal PIPERX7PHYSTATUS_indelay : std_ulogic;
    signal PIPERX7STATUS_indelay : std_logic_vector(2 downto 0);
    signal PIPERX7VALID_indelay : std_ulogic;
    signal PL2DIRECTEDLSTATE_indelay : std_logic_vector(4 downto 0);
    signal PLDBGMODE_indelay : std_logic_vector(2 downto 0);
    signal PLDIRECTEDLINKAUTON_indelay : std_ulogic;
    signal PLDIRECTEDLINKCHANGE_indelay : std_logic_vector(1 downto 0);
    signal PLDIRECTEDLINKSPEED_indelay : std_ulogic;
    signal PLDIRECTEDLINKWIDTH_indelay : std_logic_vector(1 downto 0);
    signal PLDOWNSTREAMDEEMPHSOURCE_indelay : std_ulogic;
    signal PLRSTN_indelay : std_ulogic;
    signal PLTRANSMITHOTRST_indelay : std_ulogic;
    signal PLUPSTREAMPREFERDEEMPH_indelay : std_ulogic;
    signal SYSRSTN_indelay : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKN_indelay : std_ulogic;
    signal TL2PPMSUSPENDREQN_indelay : std_ulogic;
    signal TLRSTN_indelay : std_ulogic;
    signal TRNFCSEL_indelay : std_logic_vector(2 downto 0);
    signal TRNRDSTRDYN_indelay : std_ulogic;
    signal TRNRNPOKN_indelay : std_ulogic;
    signal TRNTCFGGNTN_indelay : std_ulogic;
    signal TRNTDLLPDATA_indelay : std_logic_vector(31 downto 0);
    signal TRNTDLLPSRCRDYN_indelay : std_ulogic;
    signal TRNTD_indelay : std_logic_vector(63 downto 0);
    signal TRNTECRCGENN_indelay : std_ulogic;
    signal TRNTEOFN_indelay : std_ulogic;
    signal TRNTERRFWDN_indelay : std_ulogic;
    signal TRNTREMN_indelay : std_ulogic;
    signal TRNTSOFN_indelay : std_ulogic;
    signal TRNTSRCDSCN_indelay : std_ulogic;
    signal TRNTSRCRDYN_indelay : std_ulogic;
    signal TRNTSTRN_indelay : std_ulogic;
    signal USERCLK_indelay : std_ulogic;

        signal CFGBYTEENN_indly : std_logic_vector(3 downto 0);
    signal CFGDI_indly : std_logic_vector(31 downto 0);
    signal CFGDSBUSNUMBER_indly : std_logic_vector(7 downto 0);
    signal CFGDSDEVICENUMBER_indly : std_logic_vector(4 downto 0);
    signal CFGDSFUNCTIONNUMBER_indly : std_logic_vector(2 downto 0);
    signal CFGDSN_indly : std_logic_vector(63 downto 0);
    signal CFGDWADDR_indly : std_logic_vector(9 downto 0);
    signal CFGERRACSN_indly : std_ulogic;
    signal CFGERRAERHEADERLOG_indly : std_logic_vector(127 downto 0);
    signal CFGERRCORN_indly : std_ulogic;
    signal CFGERRCPLABORTN_indly : std_ulogic;
    signal CFGERRCPLTIMEOUTN_indly : std_ulogic;
    signal CFGERRCPLUNEXPECTN_indly : std_ulogic;
    signal CFGERRECRCN_indly : std_ulogic;
    signal CFGERRLOCKEDN_indly : std_ulogic;
    signal CFGERRPOSTEDN_indly : std_ulogic;
    signal CFGERRTLPCPLHEADER_indly : std_logic_vector(47 downto 0);
    signal CFGERRURN_indly : std_ulogic;
    signal CFGINTERRUPTASSERTN_indly : std_ulogic;
    signal CFGINTERRUPTDI_indly : std_logic_vector(7 downto 0);
    signal CFGINTERRUPTN_indly : std_ulogic;
    signal CFGPMDIRECTASPML1N_indly : std_ulogic;
    signal CFGPMSENDPMACKN_indly : std_ulogic;
    signal CFGPMSENDPMETON_indly : std_ulogic;
    signal CFGPMSENDPMNAKN_indly : std_ulogic;
    signal CFGPMTURNOFFOKN_indly : std_ulogic;
    signal CFGPMWAKEN_indly : std_ulogic;
    signal CFGPORTNUMBER_indly : std_logic_vector(7 downto 0);
    signal CFGRDENN_indly : std_ulogic;
    signal CFGTRNPENDINGN_indly : std_ulogic;
    signal CFGWRENN_indly : std_ulogic;
    signal CFGWRREADONLYN_indly : std_ulogic;
    signal CFGWRRW1CASRWN_indly : std_ulogic;
    signal CMRSTN_indly : std_ulogic;
    signal CMSTICKYRSTN_indly : std_ulogic;
    signal DBGMODE_indly : std_logic_vector(1 downto 0);
    signal DBGSUBMODE_indly : std_ulogic;
    signal DLRSTN_indly : std_ulogic;
    signal DRPCLK_indly : std_ulogic;
    signal DRPDADDR_indly : std_logic_vector(8 downto 0);
    signal DRPDEN_indly : std_ulogic;
    signal DRPDI_indly : std_logic_vector(15 downto 0);
    signal DRPDWE_indly : std_ulogic;
    signal FUNCLVLRSTN_indly : std_ulogic;
    signal LL2SENDASREQL1N_indly : std_ulogic;
    signal LL2SENDENTERL1N_indly : std_ulogic;
    signal LL2SENDENTERL23N_indly : std_ulogic;
    signal LL2SUSPENDNOWN_indly : std_ulogic;
    signal LL2TLPRCVN_indly : std_ulogic;
    signal MIMRXRDATA_indly : std_logic_vector(67 downto 0);
    signal MIMTXRDATA_indly : std_logic_vector(68 downto 0);
    signal PIPECLK_indly : std_ulogic;
    signal PIPERX0CHANISALIGNED_indly : std_ulogic;
    signal PIPERX0CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX0DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX0ELECIDLE_indly : std_ulogic;
    signal PIPERX0PHYSTATUS_indly : std_ulogic;
    signal PIPERX0STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX0VALID_indly : std_ulogic;
    signal PIPERX1CHANISALIGNED_indly : std_ulogic;
    signal PIPERX1CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX1DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX1ELECIDLE_indly : std_ulogic;
    signal PIPERX1PHYSTATUS_indly : std_ulogic;
    signal PIPERX1STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX1VALID_indly : std_ulogic;
    signal PIPERX2CHANISALIGNED_indly : std_ulogic;
    signal PIPERX2CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX2DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX2ELECIDLE_indly : std_ulogic;
    signal PIPERX2PHYSTATUS_indly : std_ulogic;
    signal PIPERX2STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX2VALID_indly : std_ulogic;
    signal PIPERX3CHANISALIGNED_indly : std_ulogic;
    signal PIPERX3CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX3DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX3ELECIDLE_indly : std_ulogic;
    signal PIPERX3PHYSTATUS_indly : std_ulogic;
    signal PIPERX3STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX3VALID_indly : std_ulogic;
    signal PIPERX4CHANISALIGNED_indly : std_ulogic;
    signal PIPERX4CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX4DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX4ELECIDLE_indly : std_ulogic;
    signal PIPERX4PHYSTATUS_indly : std_ulogic;
    signal PIPERX4STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX4VALID_indly : std_ulogic;
    signal PIPERX5CHANISALIGNED_indly : std_ulogic;
    signal PIPERX5CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX5DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX5ELECIDLE_indly : std_ulogic;
    signal PIPERX5PHYSTATUS_indly : std_ulogic;
    signal PIPERX5STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX5VALID_indly : std_ulogic;
    signal PIPERX6CHANISALIGNED_indly : std_ulogic;
    signal PIPERX6CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX6DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX6ELECIDLE_indly : std_ulogic;
    signal PIPERX6PHYSTATUS_indly : std_ulogic;
    signal PIPERX6STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX6VALID_indly : std_ulogic;
    signal PIPERX7CHANISALIGNED_indly : std_ulogic;
    signal PIPERX7CHARISK_indly : std_logic_vector(1 downto 0);
    signal PIPERX7DATA_indly : std_logic_vector(15 downto 0);
    signal PIPERX7ELECIDLE_indly : std_ulogic;
    signal PIPERX7PHYSTATUS_indly : std_ulogic;
    signal PIPERX7STATUS_indly : std_logic_vector(2 downto 0);
    signal PIPERX7VALID_indly : std_ulogic;
    signal PL2DIRECTEDLSTATE_indly : std_logic_vector(4 downto 0);
    signal PLDBGMODE_indly : std_logic_vector(2 downto 0);
    signal PLDIRECTEDLINKAUTON_indly : std_ulogic;
    signal PLDIRECTEDLINKCHANGE_indly : std_logic_vector(1 downto 0);
    signal PLDIRECTEDLINKSPEED_indly : std_ulogic;
    signal PLDIRECTEDLINKWIDTH_indly : std_logic_vector(1 downto 0);
    signal PLDOWNSTREAMDEEMPHSOURCE_indly : std_ulogic;
    signal PLRSTN_indly : std_ulogic;
    signal PLTRANSMITHOTRST_indly : std_ulogic;
    signal PLUPSTREAMPREFERDEEMPH_indly : std_ulogic;
    signal SYSRSTN_indly : std_ulogic;
    signal TL2ASPMSUSPENDCREDITCHECKN_indly : std_ulogic;
    signal TL2PPMSUSPENDREQN_indly : std_ulogic;
    signal TLRSTN_indly : std_ulogic;
    signal TRNFCSEL_indly : std_logic_vector(2 downto 0);
    signal TRNRDSTRDYN_indly : std_ulogic;
    signal TRNRNPOKN_indly : std_ulogic;
    signal TRNTCFGGNTN_indly : std_ulogic;
    signal TRNTDLLPDATA_indly : std_logic_vector(31 downto 0);
    signal TRNTDLLPSRCRDYN_indly : std_ulogic;
    signal TRNTD_indly : std_logic_vector(63 downto 0);
    signal TRNTECRCGENN_indly : std_ulogic;
    signal TRNTEOFN_indly : std_ulogic;
    signal TRNTERRFWDN_indly : std_ulogic;
    signal TRNTREMN_indly : std_ulogic;
    signal TRNTSOFN_indly : std_ulogic;
    signal TRNTSRCDSCN_indly : std_ulogic;
    signal TRNTSRCRDYN_indly : std_ulogic;
    signal TRNTSTRN_indly : std_ulogic;
    signal USERCLK_indly : std_ulogic;  
    
-- <!--Aldec correction start
	signal GSR_local : std_ulogic;
-- Aldec correction end --> 

    begin
    
    WireDelay : block
    begin
      CFGBYTEENN_DELAY : for i in 0 to 3 generate
        VitalWireDelay (CFGBYTEENN_ipd(i),CFGBYTEENN(i),tipd_CFGBYTEENN(i));
      end generate CFGBYTEENN_DELAY;
      CFGDI_DELAY : for i in 0 to 31 generate
        VitalWireDelay (CFGDI_ipd(i),CFGDI(i),tipd_CFGDI(i));
      end generate CFGDI_DELAY;
      CFGDSBUSNUMBER_DELAY : for i in 0 to 7 generate
        VitalWireDelay (CFGDSBUSNUMBER_ipd(i),CFGDSBUSNUMBER(i),tipd_CFGDSBUSNUMBER(i));
      end generate CFGDSBUSNUMBER_DELAY;
      CFGDSDEVICENUMBER_DELAY : for i in 0 to 4 generate
        VitalWireDelay (CFGDSDEVICENUMBER_ipd(i),CFGDSDEVICENUMBER(i),tipd_CFGDSDEVICENUMBER(i));
      end generate CFGDSDEVICENUMBER_DELAY;
      CFGDSFUNCTIONNUMBER_DELAY : for i in 0 to 2 generate
        VitalWireDelay (CFGDSFUNCTIONNUMBER_ipd(i),CFGDSFUNCTIONNUMBER(i),tipd_CFGDSFUNCTIONNUMBER(i));
      end generate CFGDSFUNCTIONNUMBER_DELAY;
      CFGDSN_DELAY : for i in 0 to 63 generate
        VitalWireDelay (CFGDSN_ipd(i),CFGDSN(i),tipd_CFGDSN(i));
      end generate CFGDSN_DELAY;
      CFGDWADDR_DELAY : for i in 0 to 9 generate
        VitalWireDelay (CFGDWADDR_ipd(i),CFGDWADDR(i),tipd_CFGDWADDR(i));
      end generate CFGDWADDR_DELAY;
      CFGERRAERHEADERLOG_DELAY : for i in 0 to 127 generate
        VitalWireDelay (CFGERRAERHEADERLOG_ipd(i),CFGERRAERHEADERLOG(i),tipd_CFGERRAERHEADERLOG(i));
      end generate CFGERRAERHEADERLOG_DELAY;
      CFGERRTLPCPLHEADER_DELAY : for i in 0 to 47 generate
        VitalWireDelay (CFGERRTLPCPLHEADER_ipd(i),CFGERRTLPCPLHEADER(i),tipd_CFGERRTLPCPLHEADER(i));
      end generate CFGERRTLPCPLHEADER_DELAY;
      CFGINTERRUPTDI_DELAY : for i in 0 to 7 generate
        VitalWireDelay (CFGINTERRUPTDI_ipd(i),CFGINTERRUPTDI(i),tipd_CFGINTERRUPTDI(i));
      end generate CFGINTERRUPTDI_DELAY;
      CFGPORTNUMBER_DELAY : for i in 0 to 7 generate
        VitalWireDelay (CFGPORTNUMBER_ipd(i),CFGPORTNUMBER(i),tipd_CFGPORTNUMBER(i));
      end generate CFGPORTNUMBER_DELAY;
      DBGMODE_DELAY : for i in 0 to 1 generate
        VitalWireDelay (DBGMODE_ipd(i),DBGMODE(i),tipd_DBGMODE(i));
      end generate DBGMODE_DELAY;
      DRPDADDR_DELAY : for i in 0 to 8 generate
        VitalWireDelay (DRPDADDR_ipd(i),DRPDADDR(i),tipd_DRPDADDR(i));
      end generate DRPDADDR_DELAY;
      DRPDI_DELAY : for i in 0 to 15 generate
        VitalWireDelay (DRPDI_ipd(i),DRPDI(i),tipd_DRPDI(i));
      end generate DRPDI_DELAY;
      MIMRXRDATA_DELAY : for i in 0 to 67 generate
        VitalWireDelay (MIMRXRDATA_ipd(i),MIMRXRDATA(i),tipd_MIMRXRDATA(i));
      end generate MIMRXRDATA_DELAY;
      MIMTXRDATA_DELAY : for i in 0 to 68 generate
        VitalWireDelay (MIMTXRDATA_ipd(i),MIMTXRDATA(i),tipd_MIMTXRDATA(i));
      end generate MIMTXRDATA_DELAY;
      PIPERX0CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX0CHARISK_ipd(i),PIPERX0CHARISK(i),tipd_PIPERX0CHARISK(i));
      end generate PIPERX0CHARISK_DELAY;
      PIPERX0DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX0DATA_ipd(i),PIPERX0DATA(i),tipd_PIPERX0DATA(i));
      end generate PIPERX0DATA_DELAY;
      PIPERX0STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX0STATUS_ipd(i),PIPERX0STATUS(i),tipd_PIPERX0STATUS(i));
      end generate PIPERX0STATUS_DELAY;
      PIPERX1CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX1CHARISK_ipd(i),PIPERX1CHARISK(i),tipd_PIPERX1CHARISK(i));
      end generate PIPERX1CHARISK_DELAY;
      PIPERX1DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX1DATA_ipd(i),PIPERX1DATA(i),tipd_PIPERX1DATA(i));
      end generate PIPERX1DATA_DELAY;
      PIPERX1STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX1STATUS_ipd(i),PIPERX1STATUS(i),tipd_PIPERX1STATUS(i));
      end generate PIPERX1STATUS_DELAY;
      PIPERX2CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX2CHARISK_ipd(i),PIPERX2CHARISK(i),tipd_PIPERX2CHARISK(i));
      end generate PIPERX2CHARISK_DELAY;
      PIPERX2DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX2DATA_ipd(i),PIPERX2DATA(i),tipd_PIPERX2DATA(i));
      end generate PIPERX2DATA_DELAY;
      PIPERX2STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX2STATUS_ipd(i),PIPERX2STATUS(i),tipd_PIPERX2STATUS(i));
      end generate PIPERX2STATUS_DELAY;
      PIPERX3CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX3CHARISK_ipd(i),PIPERX3CHARISK(i),tipd_PIPERX3CHARISK(i));
      end generate PIPERX3CHARISK_DELAY;
      PIPERX3DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX3DATA_ipd(i),PIPERX3DATA(i),tipd_PIPERX3DATA(i));
      end generate PIPERX3DATA_DELAY;
      PIPERX3STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX3STATUS_ipd(i),PIPERX3STATUS(i),tipd_PIPERX3STATUS(i));
      end generate PIPERX3STATUS_DELAY;
      PIPERX4CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX4CHARISK_ipd(i),PIPERX4CHARISK(i),tipd_PIPERX4CHARISK(i));
      end generate PIPERX4CHARISK_DELAY;
      PIPERX4DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX4DATA_ipd(i),PIPERX4DATA(i),tipd_PIPERX4DATA(i));
      end generate PIPERX4DATA_DELAY;
      PIPERX4STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX4STATUS_ipd(i),PIPERX4STATUS(i),tipd_PIPERX4STATUS(i));
      end generate PIPERX4STATUS_DELAY;
      PIPERX5CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX5CHARISK_ipd(i),PIPERX5CHARISK(i),tipd_PIPERX5CHARISK(i));
      end generate PIPERX5CHARISK_DELAY;
      PIPERX5DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX5DATA_ipd(i),PIPERX5DATA(i),tipd_PIPERX5DATA(i));
      end generate PIPERX5DATA_DELAY;
      PIPERX5STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX5STATUS_ipd(i),PIPERX5STATUS(i),tipd_PIPERX5STATUS(i));
      end generate PIPERX5STATUS_DELAY;
      PIPERX6CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX6CHARISK_ipd(i),PIPERX6CHARISK(i),tipd_PIPERX6CHARISK(i));
      end generate PIPERX6CHARISK_DELAY;
      PIPERX6DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX6DATA_ipd(i),PIPERX6DATA(i),tipd_PIPERX6DATA(i));
      end generate PIPERX6DATA_DELAY;
      PIPERX6STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX6STATUS_ipd(i),PIPERX6STATUS(i),tipd_PIPERX6STATUS(i));
      end generate PIPERX6STATUS_DELAY;
      PIPERX7CHARISK_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PIPERX7CHARISK_ipd(i),PIPERX7CHARISK(i),tipd_PIPERX7CHARISK(i));
      end generate PIPERX7CHARISK_DELAY;
      PIPERX7DATA_DELAY : for i in 0 to 15 generate
        VitalWireDelay (PIPERX7DATA_ipd(i),PIPERX7DATA(i),tipd_PIPERX7DATA(i));
      end generate PIPERX7DATA_DELAY;
      PIPERX7STATUS_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PIPERX7STATUS_ipd(i),PIPERX7STATUS(i),tipd_PIPERX7STATUS(i));
      end generate PIPERX7STATUS_DELAY;
      PL2DIRECTEDLSTATE_DELAY : for i in 0 to 4 generate
        VitalWireDelay (PL2DIRECTEDLSTATE_ipd(i),PL2DIRECTEDLSTATE(i),tipd_PL2DIRECTEDLSTATE(i));
      end generate PL2DIRECTEDLSTATE_DELAY;
      PLDBGMODE_DELAY : for i in 0 to 2 generate
        VitalWireDelay (PLDBGMODE_ipd(i),PLDBGMODE(i),tipd_PLDBGMODE(i));
      end generate PLDBGMODE_DELAY;
      PLDIRECTEDLINKCHANGE_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PLDIRECTEDLINKCHANGE_ipd(i),PLDIRECTEDLINKCHANGE(i),tipd_PLDIRECTEDLINKCHANGE(i));
      end generate PLDIRECTEDLINKCHANGE_DELAY;
      PLDIRECTEDLINKWIDTH_DELAY : for i in 0 to 1 generate
        VitalWireDelay (PLDIRECTEDLINKWIDTH_ipd(i),PLDIRECTEDLINKWIDTH(i),tipd_PLDIRECTEDLINKWIDTH(i));
      end generate PLDIRECTEDLINKWIDTH_DELAY;
      TRNFCSEL_DELAY : for i in 0 to 2 generate
        VitalWireDelay (TRNFCSEL_ipd(i),TRNFCSEL(i),tipd_TRNFCSEL(i));
      end generate TRNFCSEL_DELAY;
      TRNTDLLPDATA_DELAY : for i in 0 to 31 generate
        VitalWireDelay (TRNTDLLPDATA_ipd(i),TRNTDLLPDATA(i),tipd_TRNTDLLPDATA(i));
      end generate TRNTDLLPDATA_DELAY;
      TRNTD_DELAY : for i in 0 to 63 generate
        VitalWireDelay (TRNTD_ipd(i),TRNTD(i),tipd_TRNTD(i));
      end generate TRNTD_DELAY;
      VitalWireDelay (CFGERRACSN_ipd,CFGERRACSN,tipd_CFGERRACSN);
      VitalWireDelay (CFGERRCORN_ipd,CFGERRCORN,tipd_CFGERRCORN);
      VitalWireDelay (CFGERRCPLABORTN_ipd,CFGERRCPLABORTN,tipd_CFGERRCPLABORTN);
      VitalWireDelay (CFGERRCPLTIMEOUTN_ipd,CFGERRCPLTIMEOUTN,tipd_CFGERRCPLTIMEOUTN);
      VitalWireDelay (CFGERRCPLUNEXPECTN_ipd,CFGERRCPLUNEXPECTN,tipd_CFGERRCPLUNEXPECTN);
      VitalWireDelay (CFGERRECRCN_ipd,CFGERRECRCN,tipd_CFGERRECRCN);
      VitalWireDelay (CFGERRLOCKEDN_ipd,CFGERRLOCKEDN,tipd_CFGERRLOCKEDN);
      VitalWireDelay (CFGERRPOSTEDN_ipd,CFGERRPOSTEDN,tipd_CFGERRPOSTEDN);
      VitalWireDelay (CFGERRURN_ipd,CFGERRURN,tipd_CFGERRURN);
      VitalWireDelay (CFGINTERRUPTASSERTN_ipd,CFGINTERRUPTASSERTN,tipd_CFGINTERRUPTASSERTN);
      VitalWireDelay (CFGINTERRUPTN_ipd,CFGINTERRUPTN,tipd_CFGINTERRUPTN);
      VitalWireDelay (CFGPMDIRECTASPML1N_ipd,CFGPMDIRECTASPML1N,tipd_CFGPMDIRECTASPML1N);
      VitalWireDelay (CFGPMSENDPMACKN_ipd,CFGPMSENDPMACKN,tipd_CFGPMSENDPMACKN);
      VitalWireDelay (CFGPMSENDPMETON_ipd,CFGPMSENDPMETON,tipd_CFGPMSENDPMETON);
      VitalWireDelay (CFGPMSENDPMNAKN_ipd,CFGPMSENDPMNAKN,tipd_CFGPMSENDPMNAKN);
      VitalWireDelay (CFGPMTURNOFFOKN_ipd,CFGPMTURNOFFOKN,tipd_CFGPMTURNOFFOKN);
      VitalWireDelay (CFGPMWAKEN_ipd,CFGPMWAKEN,tipd_CFGPMWAKEN);
      VitalWireDelay (CFGRDENN_ipd,CFGRDENN,tipd_CFGRDENN);
      VitalWireDelay (CFGTRNPENDINGN_ipd,CFGTRNPENDINGN,tipd_CFGTRNPENDINGN);
      VitalWireDelay (CFGWRENN_ipd,CFGWRENN,tipd_CFGWRENN);
      VitalWireDelay (CFGWRREADONLYN_ipd,CFGWRREADONLYN,tipd_CFGWRREADONLYN);
      VitalWireDelay (CFGWRRW1CASRWN_ipd,CFGWRRW1CASRWN,tipd_CFGWRRW1CASRWN);
      VitalWireDelay (CMRSTN_ipd,CMRSTN,tipd_CMRSTN);
      VitalWireDelay (CMSTICKYRSTN_ipd,CMSTICKYRSTN,tipd_CMSTICKYRSTN);
      VitalWireDelay (DBGSUBMODE_ipd,DBGSUBMODE,tipd_DBGSUBMODE);
      VitalWireDelay (DLRSTN_ipd,DLRSTN,tipd_DLRSTN);
      VitalWireDelay (DRPCLK_ipd,DRPCLK,tipd_DRPCLK);
      VitalWireDelay (DRPDEN_ipd,DRPDEN,tipd_DRPDEN);
      VitalWireDelay (DRPDWE_ipd,DRPDWE,tipd_DRPDWE);
      VitalWireDelay (FUNCLVLRSTN_ipd,FUNCLVLRSTN,tipd_FUNCLVLRSTN);
      VitalWireDelay (LL2SENDASREQL1N_ipd,LL2SENDASREQL1N,tipd_LL2SENDASREQL1N);
      VitalWireDelay (LL2SENDENTERL1N_ipd,LL2SENDENTERL1N,tipd_LL2SENDENTERL1N);
      VitalWireDelay (LL2SENDENTERL23N_ipd,LL2SENDENTERL23N,tipd_LL2SENDENTERL23N);
      VitalWireDelay (LL2SUSPENDNOWN_ipd,LL2SUSPENDNOWN,tipd_LL2SUSPENDNOWN);
      VitalWireDelay (LL2TLPRCVN_ipd,LL2TLPRCVN,tipd_LL2TLPRCVN);
      VitalWireDelay (PIPECLK_ipd,PIPECLK,tipd_PIPECLK);
      VitalWireDelay (PIPERX0CHANISALIGNED_ipd,PIPERX0CHANISALIGNED,tipd_PIPERX0CHANISALIGNED);
      VitalWireDelay (PIPERX0ELECIDLE_ipd,PIPERX0ELECIDLE,tipd_PIPERX0ELECIDLE);
      VitalWireDelay (PIPERX0PHYSTATUS_ipd,PIPERX0PHYSTATUS,tipd_PIPERX0PHYSTATUS);
      VitalWireDelay (PIPERX0VALID_ipd,PIPERX0VALID,tipd_PIPERX0VALID);
      VitalWireDelay (PIPERX1CHANISALIGNED_ipd,PIPERX1CHANISALIGNED,tipd_PIPERX1CHANISALIGNED);
      VitalWireDelay (PIPERX1ELECIDLE_ipd,PIPERX1ELECIDLE,tipd_PIPERX1ELECIDLE);
      VitalWireDelay (PIPERX1PHYSTATUS_ipd,PIPERX1PHYSTATUS,tipd_PIPERX1PHYSTATUS);
      VitalWireDelay (PIPERX1VALID_ipd,PIPERX1VALID,tipd_PIPERX1VALID);
      VitalWireDelay (PIPERX2CHANISALIGNED_ipd,PIPERX2CHANISALIGNED,tipd_PIPERX2CHANISALIGNED);
      VitalWireDelay (PIPERX2ELECIDLE_ipd,PIPERX2ELECIDLE,tipd_PIPERX2ELECIDLE);
      VitalWireDelay (PIPERX2PHYSTATUS_ipd,PIPERX2PHYSTATUS,tipd_PIPERX2PHYSTATUS);
      VitalWireDelay (PIPERX2VALID_ipd,PIPERX2VALID,tipd_PIPERX2VALID);
      VitalWireDelay (PIPERX3CHANISALIGNED_ipd,PIPERX3CHANISALIGNED,tipd_PIPERX3CHANISALIGNED);
      VitalWireDelay (PIPERX3ELECIDLE_ipd,PIPERX3ELECIDLE,tipd_PIPERX3ELECIDLE);
      VitalWireDelay (PIPERX3PHYSTATUS_ipd,PIPERX3PHYSTATUS,tipd_PIPERX3PHYSTATUS);
      VitalWireDelay (PIPERX3VALID_ipd,PIPERX3VALID,tipd_PIPERX3VALID);
      VitalWireDelay (PIPERX4CHANISALIGNED_ipd,PIPERX4CHANISALIGNED,tipd_PIPERX4CHANISALIGNED);
      VitalWireDelay (PIPERX4ELECIDLE_ipd,PIPERX4ELECIDLE,tipd_PIPERX4ELECIDLE);
      VitalWireDelay (PIPERX4PHYSTATUS_ipd,PIPERX4PHYSTATUS,tipd_PIPERX4PHYSTATUS);
      VitalWireDelay (PIPERX4VALID_ipd,PIPERX4VALID,tipd_PIPERX4VALID);
      VitalWireDelay (PIPERX5CHANISALIGNED_ipd,PIPERX5CHANISALIGNED,tipd_PIPERX5CHANISALIGNED);
      VitalWireDelay (PIPERX5ELECIDLE_ipd,PIPERX5ELECIDLE,tipd_PIPERX5ELECIDLE);
      VitalWireDelay (PIPERX5PHYSTATUS_ipd,PIPERX5PHYSTATUS,tipd_PIPERX5PHYSTATUS);
      VitalWireDelay (PIPERX5VALID_ipd,PIPERX5VALID,tipd_PIPERX5VALID);
      VitalWireDelay (PIPERX6CHANISALIGNED_ipd,PIPERX6CHANISALIGNED,tipd_PIPERX6CHANISALIGNED);
      VitalWireDelay (PIPERX6ELECIDLE_ipd,PIPERX6ELECIDLE,tipd_PIPERX6ELECIDLE);
      VitalWireDelay (PIPERX6PHYSTATUS_ipd,PIPERX6PHYSTATUS,tipd_PIPERX6PHYSTATUS);
      VitalWireDelay (PIPERX6VALID_ipd,PIPERX6VALID,tipd_PIPERX6VALID);
      VitalWireDelay (PIPERX7CHANISALIGNED_ipd,PIPERX7CHANISALIGNED,tipd_PIPERX7CHANISALIGNED);
      VitalWireDelay (PIPERX7ELECIDLE_ipd,PIPERX7ELECIDLE,tipd_PIPERX7ELECIDLE);
      VitalWireDelay (PIPERX7PHYSTATUS_ipd,PIPERX7PHYSTATUS,tipd_PIPERX7PHYSTATUS);
      VitalWireDelay (PIPERX7VALID_ipd,PIPERX7VALID,tipd_PIPERX7VALID);
      VitalWireDelay (PLDIRECTEDLINKAUTON_ipd,PLDIRECTEDLINKAUTON,tipd_PLDIRECTEDLINKAUTON);
      VitalWireDelay (PLDIRECTEDLINKSPEED_ipd,PLDIRECTEDLINKSPEED,tipd_PLDIRECTEDLINKSPEED);
      VitalWireDelay (PLDOWNSTREAMDEEMPHSOURCE_ipd,PLDOWNSTREAMDEEMPHSOURCE,tipd_PLDOWNSTREAMDEEMPHSOURCE);
      VitalWireDelay (PLRSTN_ipd,PLRSTN,tipd_PLRSTN);
      VitalWireDelay (PLTRANSMITHOTRST_ipd,PLTRANSMITHOTRST,tipd_PLTRANSMITHOTRST);
      VitalWireDelay (PLUPSTREAMPREFERDEEMPH_ipd,PLUPSTREAMPREFERDEEMPH,tipd_PLUPSTREAMPREFERDEEMPH);
      VitalWireDelay (SYSRSTN_ipd,SYSRSTN,tipd_SYSRSTN);
      VitalWireDelay (TL2ASPMSUSPENDCREDITCHECKN_ipd,TL2ASPMSUSPENDCREDITCHECKN,tipd_TL2ASPMSUSPENDCREDITCHECKN);
      VitalWireDelay (TL2PPMSUSPENDREQN_ipd,TL2PPMSUSPENDREQN,tipd_TL2PPMSUSPENDREQN);
      VitalWireDelay (TLRSTN_ipd,TLRSTN,tipd_TLRSTN);
      VitalWireDelay (TRNRDSTRDYN_ipd,TRNRDSTRDYN,tipd_TRNRDSTRDYN);
      VitalWireDelay (TRNRNPOKN_ipd,TRNRNPOKN,tipd_TRNRNPOKN);
      VitalWireDelay (TRNTCFGGNTN_ipd,TRNTCFGGNTN,tipd_TRNTCFGGNTN);
      VitalWireDelay (TRNTDLLPSRCRDYN_ipd,TRNTDLLPSRCRDYN,tipd_TRNTDLLPSRCRDYN);
      VitalWireDelay (TRNTECRCGENN_ipd,TRNTECRCGENN,tipd_TRNTECRCGENN);
      VitalWireDelay (TRNTEOFN_ipd,TRNTEOFN,tipd_TRNTEOFN);
      VitalWireDelay (TRNTERRFWDN_ipd,TRNTERRFWDN,tipd_TRNTERRFWDN);
      VitalWireDelay (TRNTREMN_ipd,TRNTREMN,tipd_TRNTREMN);
      VitalWireDelay (TRNTSOFN_ipd,TRNTSOFN,tipd_TRNTSOFN);
      VitalWireDelay (TRNTSRCDSCN_ipd,TRNTSRCDSCN,tipd_TRNTSRCDSCN);
      VitalWireDelay (TRNTSRCRDYN_ipd,TRNTSRCRDYN,tipd_TRNTSRCRDYN);
      VitalWireDelay (TRNTSTRN_ipd,TRNTSTRN,tipd_TRNTSTRN);
      VitalWireDelay (USERCLK_ipd,USERCLK,tipd_USERCLK);
    end block;
    
    SignalDelay : block
    begin
      CFGBYTEENN_USERCLK_DELAY : for i in 3 downto 0 generate
        VitalSignalDelay (CFGBYTEENN_USERCLK_dly(i),CFGBYTEENN_ipd(i),tisd_CFGBYTEENN_USERCLK(i));
      end generate CFGBYTEENN_USERCLK_DELAY;
      CFGDI_USERCLK_DELAY : for i in 31 downto 0 generate
        VitalSignalDelay (CFGDI_USERCLK_dly(i),CFGDI_ipd(i),tisd_CFGDI_USERCLK(i));
      end generate CFGDI_USERCLK_DELAY;
      CFGDSBUSNUMBER_USERCLK_DELAY : for i in 7 downto 0 generate
        VitalSignalDelay (CFGDSBUSNUMBER_USERCLK_dly(i),CFGDSBUSNUMBER_ipd(i),tisd_CFGDSBUSNUMBER_USERCLK(i));
      end generate CFGDSBUSNUMBER_USERCLK_DELAY;
      CFGDSDEVICENUMBER_USERCLK_DELAY : for i in 4 downto 0 generate
        VitalSignalDelay (CFGDSDEVICENUMBER_USERCLK_dly(i),CFGDSDEVICENUMBER_ipd(i),tisd_CFGDSDEVICENUMBER_USERCLK(i));
      end generate CFGDSDEVICENUMBER_USERCLK_DELAY;
      CFGDSFUNCTIONNUMBER_USERCLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (CFGDSFUNCTIONNUMBER_USERCLK_dly(i),CFGDSFUNCTIONNUMBER_ipd(i),tisd_CFGDSFUNCTIONNUMBER_USERCLK(i));
      end generate CFGDSFUNCTIONNUMBER_USERCLK_DELAY;
      CFGDSN_USERCLK_DELAY : for i in 63 downto 0 generate
        VitalSignalDelay (CFGDSN_USERCLK_dly(i),CFGDSN_ipd(i),tisd_CFGDSN_USERCLK(i));
      end generate CFGDSN_USERCLK_DELAY;
      CFGDWADDR_USERCLK_DELAY : for i in 9 downto 0 generate
        VitalSignalDelay (CFGDWADDR_USERCLK_dly(i),CFGDWADDR_ipd(i),tisd_CFGDWADDR_USERCLK(i));
      end generate CFGDWADDR_USERCLK_DELAY;
      CFGERRAERHEADERLOG_USERCLK_DELAY : for i in 127 downto 0 generate
        VitalSignalDelay (CFGERRAERHEADERLOG_USERCLK_dly(i),CFGERRAERHEADERLOG_ipd(i),tisd_CFGERRAERHEADERLOG_USERCLK(i));
      end generate CFGERRAERHEADERLOG_USERCLK_DELAY;
      CFGERRTLPCPLHEADER_USERCLK_DELAY : for i in 47 downto 0 generate
        VitalSignalDelay (CFGERRTLPCPLHEADER_USERCLK_dly(i),CFGERRTLPCPLHEADER_ipd(i),tisd_CFGERRTLPCPLHEADER_USERCLK(i));
      end generate CFGERRTLPCPLHEADER_USERCLK_DELAY;
      CFGINTERRUPTDI_USERCLK_DELAY : for i in 7 downto 0 generate
        VitalSignalDelay (CFGINTERRUPTDI_USERCLK_dly(i),CFGINTERRUPTDI_ipd(i),tisd_CFGINTERRUPTDI_USERCLK(i));
      end generate CFGINTERRUPTDI_USERCLK_DELAY;
      CFGPORTNUMBER_USERCLK_DELAY : for i in 7 downto 0 generate
        VitalSignalDelay (CFGPORTNUMBER_USERCLK_dly(i),CFGPORTNUMBER_ipd(i),tisd_CFGPORTNUMBER_USERCLK(i));
      end generate CFGPORTNUMBER_USERCLK_DELAY;
      DBGMODE_USERCLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (DBGMODE_USERCLK_dly(i),DBGMODE_ipd(i),tisd_DBGMODE_USERCLK(i));
      end generate DBGMODE_USERCLK_DELAY;
      DRPDADDR_DRPCLK_DELAY : for i in 8 downto 0 generate
        VitalSignalDelay (DRPDADDR_DRPCLK_dly(i),DRPDADDR_ipd(i),tisd_DRPDADDR_DRPCLK(i));
      end generate DRPDADDR_DRPCLK_DELAY;
      DRPDI_DRPCLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (DRPDI_DRPCLK_dly(i),DRPDI_ipd(i),tisd_DRPDI_DRPCLK(i));
      end generate DRPDI_DRPCLK_DELAY;
      MIMRXRDATA_USERCLK_DELAY : for i in 67 downto 0 generate
        VitalSignalDelay (MIMRXRDATA_USERCLK_dly(i),MIMRXRDATA_ipd(i),tisd_MIMRXRDATA_USERCLK(i));
      end generate MIMRXRDATA_USERCLK_DELAY;
      MIMTXRDATA_USERCLK_DELAY : for i in 68 downto 0 generate
        VitalSignalDelay (MIMTXRDATA_USERCLK_dly(i),MIMTXRDATA_ipd(i),tisd_MIMTXRDATA_USERCLK(i));
      end generate MIMTXRDATA_USERCLK_DELAY;
      PIPERX0CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX0CHARISK_PIPECLK_dly(i),PIPERX0CHARISK_ipd(i),tisd_PIPERX0CHARISK_PIPECLK(i));
      end generate PIPERX0CHARISK_PIPECLK_DELAY;
      PIPERX0DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX0DATA_PIPECLK_dly(i),PIPERX0DATA_ipd(i),tisd_PIPERX0DATA_PIPECLK(i));
      end generate PIPERX0DATA_PIPECLK_DELAY;
      PIPERX0STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX0STATUS_PIPECLK_dly(i),PIPERX0STATUS_ipd(i),tisd_PIPERX0STATUS_PIPECLK(i));
      end generate PIPERX0STATUS_PIPECLK_DELAY;
      PIPERX1CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX1CHARISK_PIPECLK_dly(i),PIPERX1CHARISK_ipd(i),tisd_PIPERX1CHARISK_PIPECLK(i));
      end generate PIPERX1CHARISK_PIPECLK_DELAY;
      PIPERX1DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX1DATA_PIPECLK_dly(i),PIPERX1DATA_ipd(i),tisd_PIPERX1DATA_PIPECLK(i));
      end generate PIPERX1DATA_PIPECLK_DELAY;
      PIPERX1STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX1STATUS_PIPECLK_dly(i),PIPERX1STATUS_ipd(i),tisd_PIPERX1STATUS_PIPECLK(i));
      end generate PIPERX1STATUS_PIPECLK_DELAY;
      PIPERX2CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX2CHARISK_PIPECLK_dly(i),PIPERX2CHARISK_ipd(i),tisd_PIPERX2CHARISK_PIPECLK(i));
      end generate PIPERX2CHARISK_PIPECLK_DELAY;
      PIPERX2DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX2DATA_PIPECLK_dly(i),PIPERX2DATA_ipd(i),tisd_PIPERX2DATA_PIPECLK(i));
      end generate PIPERX2DATA_PIPECLK_DELAY;
      PIPERX2STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX2STATUS_PIPECLK_dly(i),PIPERX2STATUS_ipd(i),tisd_PIPERX2STATUS_PIPECLK(i));
      end generate PIPERX2STATUS_PIPECLK_DELAY;
      PIPERX3CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX3CHARISK_PIPECLK_dly(i),PIPERX3CHARISK_ipd(i),tisd_PIPERX3CHARISK_PIPECLK(i));
      end generate PIPERX3CHARISK_PIPECLK_DELAY;
      PIPERX3DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX3DATA_PIPECLK_dly(i),PIPERX3DATA_ipd(i),tisd_PIPERX3DATA_PIPECLK(i));
      end generate PIPERX3DATA_PIPECLK_DELAY;
      PIPERX3STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX3STATUS_PIPECLK_dly(i),PIPERX3STATUS_ipd(i),tisd_PIPERX3STATUS_PIPECLK(i));
      end generate PIPERX3STATUS_PIPECLK_DELAY;
      PIPERX4CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX4CHARISK_PIPECLK_dly(i),PIPERX4CHARISK_ipd(i),tisd_PIPERX4CHARISK_PIPECLK(i));
      end generate PIPERX4CHARISK_PIPECLK_DELAY;
      PIPERX4DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX4DATA_PIPECLK_dly(i),PIPERX4DATA_ipd(i),tisd_PIPERX4DATA_PIPECLK(i));
      end generate PIPERX4DATA_PIPECLK_DELAY;
      PIPERX4STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX4STATUS_PIPECLK_dly(i),PIPERX4STATUS_ipd(i),tisd_PIPERX4STATUS_PIPECLK(i));
      end generate PIPERX4STATUS_PIPECLK_DELAY;
      PIPERX5CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX5CHARISK_PIPECLK_dly(i),PIPERX5CHARISK_ipd(i),tisd_PIPERX5CHARISK_PIPECLK(i));
      end generate PIPERX5CHARISK_PIPECLK_DELAY;
      PIPERX5DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX5DATA_PIPECLK_dly(i),PIPERX5DATA_ipd(i),tisd_PIPERX5DATA_PIPECLK(i));
      end generate PIPERX5DATA_PIPECLK_DELAY;
      PIPERX5STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX5STATUS_PIPECLK_dly(i),PIPERX5STATUS_ipd(i),tisd_PIPERX5STATUS_PIPECLK(i));
      end generate PIPERX5STATUS_PIPECLK_DELAY;
      PIPERX6CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX6CHARISK_PIPECLK_dly(i),PIPERX6CHARISK_ipd(i),tisd_PIPERX6CHARISK_PIPECLK(i));
      end generate PIPERX6CHARISK_PIPECLK_DELAY;
      PIPERX6DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX6DATA_PIPECLK_dly(i),PIPERX6DATA_ipd(i),tisd_PIPERX6DATA_PIPECLK(i));
      end generate PIPERX6DATA_PIPECLK_DELAY;
      PIPERX6STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX6STATUS_PIPECLK_dly(i),PIPERX6STATUS_ipd(i),tisd_PIPERX6STATUS_PIPECLK(i));
      end generate PIPERX6STATUS_PIPECLK_DELAY;
      PIPERX7CHARISK_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PIPERX7CHARISK_PIPECLK_dly(i),PIPERX7CHARISK_ipd(i),tisd_PIPERX7CHARISK_PIPECLK(i));
      end generate PIPERX7CHARISK_PIPECLK_DELAY;
      PIPERX7DATA_PIPECLK_DELAY : for i in 15 downto 0 generate
        VitalSignalDelay (PIPERX7DATA_PIPECLK_dly(i),PIPERX7DATA_ipd(i),tisd_PIPERX7DATA_PIPECLK(i));
      end generate PIPERX7DATA_PIPECLK_DELAY;
      PIPERX7STATUS_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PIPERX7STATUS_PIPECLK_dly(i),PIPERX7STATUS_ipd(i),tisd_PIPERX7STATUS_PIPECLK(i));
      end generate PIPERX7STATUS_PIPECLK_DELAY;
      PL2DIRECTEDLSTATE_USERCLK_DELAY : for i in 4 downto 0 generate
        VitalSignalDelay (PL2DIRECTEDLSTATE_USERCLK_dly(i),PL2DIRECTEDLSTATE_ipd(i),tisd_PL2DIRECTEDLSTATE_USERCLK(i));
      end generate PL2DIRECTEDLSTATE_USERCLK_DELAY;
      PLDBGMODE_PIPECLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (PLDBGMODE_PIPECLK_dly(i),PLDBGMODE_ipd(i),tisd_PLDBGMODE_PIPECLK(i));
      end generate PLDBGMODE_PIPECLK_DELAY;
      PLDIRECTEDLINKCHANGE_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PLDIRECTEDLINKCHANGE_PIPECLK_dly(i),PLDIRECTEDLINKCHANGE_ipd(i),tisd_PLDIRECTEDLINKCHANGE_PIPECLK(i));
      end generate PLDIRECTEDLINKCHANGE_PIPECLK_DELAY;
      PLDIRECTEDLINKWIDTH_PIPECLK_DELAY : for i in 1 downto 0 generate
        VitalSignalDelay (PLDIRECTEDLINKWIDTH_PIPECLK_dly(i),PLDIRECTEDLINKWIDTH_ipd(i),tisd_PLDIRECTEDLINKWIDTH_PIPECLK(i));
      end generate PLDIRECTEDLINKWIDTH_PIPECLK_DELAY;
      TRNFCSEL_USERCLK_DELAY : for i in 2 downto 0 generate
        VitalSignalDelay (TRNFCSEL_USERCLK_dly(i),TRNFCSEL_ipd(i),tisd_TRNFCSEL_USERCLK(i));
      end generate TRNFCSEL_USERCLK_DELAY;
      TRNTDLLPDATA_USERCLK_DELAY : for i in 31 downto 0 generate
        VitalSignalDelay (TRNTDLLPDATA_USERCLK_dly(i),TRNTDLLPDATA_ipd(i),tisd_TRNTDLLPDATA_USERCLK(i));
      end generate TRNTDLLPDATA_USERCLK_DELAY;
      TRNTD_USERCLK_DELAY : for i in 63 downto 0 generate
        VitalSignalDelay (TRNTD_USERCLK_dly(i),TRNTD_ipd(i),tisd_TRNTD_USERCLK(i));
      end generate TRNTD_USERCLK_DELAY;
      VitalSignalDelay (CFGERRACSN_USERCLK_dly,CFGERRACSN_ipd,tisd_CFGERRACSN_USERCLK);
      VitalSignalDelay (CFGERRCORN_USERCLK_dly,CFGERRCORN_ipd,tisd_CFGERRCORN_USERCLK);
      VitalSignalDelay (CFGERRCPLABORTN_USERCLK_dly,CFGERRCPLABORTN_ipd,tisd_CFGERRCPLABORTN_USERCLK);
      VitalSignalDelay (CFGERRCPLTIMEOUTN_USERCLK_dly,CFGERRCPLTIMEOUTN_ipd,tisd_CFGERRCPLTIMEOUTN_USERCLK);
      VitalSignalDelay (CFGERRCPLUNEXPECTN_USERCLK_dly,CFGERRCPLUNEXPECTN_ipd,tisd_CFGERRCPLUNEXPECTN_USERCLK);
      VitalSignalDelay (CFGERRECRCN_USERCLK_dly,CFGERRECRCN_ipd,tisd_CFGERRECRCN_USERCLK);
      VitalSignalDelay (CFGERRLOCKEDN_USERCLK_dly,CFGERRLOCKEDN_ipd,tisd_CFGERRLOCKEDN_USERCLK);
      VitalSignalDelay (CFGERRPOSTEDN_USERCLK_dly,CFGERRPOSTEDN_ipd,tisd_CFGERRPOSTEDN_USERCLK);
      VitalSignalDelay (CFGERRURN_USERCLK_dly,CFGERRURN_ipd,tisd_CFGERRURN_USERCLK);
      VitalSignalDelay (CFGINTERRUPTASSERTN_USERCLK_dly,CFGINTERRUPTASSERTN_ipd,tisd_CFGINTERRUPTASSERTN_USERCLK);
      VitalSignalDelay (CFGINTERRUPTN_USERCLK_dly,CFGINTERRUPTN_ipd,tisd_CFGINTERRUPTN_USERCLK);
      VitalSignalDelay (CFGPMDIRECTASPML1N_USERCLK_dly,CFGPMDIRECTASPML1N_ipd,tisd_CFGPMDIRECTASPML1N_USERCLK);
      VitalSignalDelay (CFGPMSENDPMACKN_USERCLK_dly,CFGPMSENDPMACKN_ipd,tisd_CFGPMSENDPMACKN_USERCLK);
      VitalSignalDelay (CFGPMSENDPMETON_USERCLK_dly,CFGPMSENDPMETON_ipd,tisd_CFGPMSENDPMETON_USERCLK);
      VitalSignalDelay (CFGPMSENDPMNAKN_USERCLK_dly,CFGPMSENDPMNAKN_ipd,tisd_CFGPMSENDPMNAKN_USERCLK);
      VitalSignalDelay (CFGPMTURNOFFOKN_USERCLK_dly,CFGPMTURNOFFOKN_ipd,tisd_CFGPMTURNOFFOKN_USERCLK);
      VitalSignalDelay (CFGPMWAKEN_USERCLK_dly,CFGPMWAKEN_ipd,tisd_CFGPMWAKEN_USERCLK);
      VitalSignalDelay (CFGRDENN_USERCLK_dly,CFGRDENN_ipd,tisd_CFGRDENN_USERCLK);
      VitalSignalDelay (CFGTRNPENDINGN_USERCLK_dly,CFGTRNPENDINGN_ipd,tisd_CFGTRNPENDINGN_USERCLK);
      VitalSignalDelay (CFGWRENN_USERCLK_dly,CFGWRENN_ipd,tisd_CFGWRENN_USERCLK);
      VitalSignalDelay (CFGWRREADONLYN_USERCLK_dly,CFGWRREADONLYN_ipd,tisd_CFGWRREADONLYN_USERCLK);
      VitalSignalDelay (CFGWRRW1CASRWN_USERCLK_dly,CFGWRRW1CASRWN_ipd,tisd_CFGWRRW1CASRWN_USERCLK);
      VitalSignalDelay (CMRSTN_USERCLK_dly,CMRSTN_ipd,tisd_CMRSTN_USERCLK);
      VitalSignalDelay (CMSTICKYRSTN_USERCLK_dly,CMSTICKYRSTN_ipd,tisd_CMSTICKYRSTN_USERCLK);
      VitalSignalDelay (DBGSUBMODE_USERCLK_dly,DBGSUBMODE_ipd,tisd_DBGSUBMODE_USERCLK);
      VitalSignalDelay (DLRSTN_USERCLK_dly,DLRSTN_ipd,tisd_DLRSTN_USERCLK);
      VitalSignalDelay (DRPDEN_DRPCLK_dly,DRPDEN_ipd,tisd_DRPDEN_DRPCLK);
      VitalSignalDelay (DRPDWE_DRPCLK_dly,DRPDWE_ipd,tisd_DRPDWE_DRPCLK);
      VitalSignalDelay (FUNCLVLRSTN_USERCLK_dly,FUNCLVLRSTN_ipd,tisd_FUNCLVLRSTN_USERCLK);
      VitalSignalDelay (LL2SENDASREQL1N_USERCLK_dly,LL2SENDASREQL1N_ipd,tisd_LL2SENDASREQL1N_USERCLK);
      VitalSignalDelay (LL2SENDENTERL1N_USERCLK_dly,LL2SENDENTERL1N_ipd,tisd_LL2SENDENTERL1N_USERCLK);
      VitalSignalDelay (LL2SENDENTERL23N_USERCLK_dly,LL2SENDENTERL23N_ipd,tisd_LL2SENDENTERL23N_USERCLK);
      VitalSignalDelay (LL2SUSPENDNOWN_USERCLK_dly,LL2SUSPENDNOWN_ipd,tisd_LL2SUSPENDNOWN_USERCLK);
      VitalSignalDelay (LL2TLPRCVN_USERCLK_dly,LL2TLPRCVN_ipd,tisd_LL2TLPRCVN_USERCLK);
      VitalSignalDelay (PIPERX0CHANISALIGNED_PIPECLK_dly,PIPERX0CHANISALIGNED_ipd,tisd_PIPERX0CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX0ELECIDLE_PIPECLK_dly,PIPERX0ELECIDLE_ipd,tisd_PIPERX0ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX0PHYSTATUS_PIPECLK_dly,PIPERX0PHYSTATUS_ipd,tisd_PIPERX0PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX0VALID_PIPECLK_dly,PIPERX0VALID_ipd,tisd_PIPERX0VALID_PIPECLK);
      VitalSignalDelay (PIPERX1CHANISALIGNED_PIPECLK_dly,PIPERX1CHANISALIGNED_ipd,tisd_PIPERX1CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX1ELECIDLE_PIPECLK_dly,PIPERX1ELECIDLE_ipd,tisd_PIPERX1ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX1PHYSTATUS_PIPECLK_dly,PIPERX1PHYSTATUS_ipd,tisd_PIPERX1PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX1VALID_PIPECLK_dly,PIPERX1VALID_ipd,tisd_PIPERX1VALID_PIPECLK);
      VitalSignalDelay (PIPERX2CHANISALIGNED_PIPECLK_dly,PIPERX2CHANISALIGNED_ipd,tisd_PIPERX2CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX2ELECIDLE_PIPECLK_dly,PIPERX2ELECIDLE_ipd,tisd_PIPERX2ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX2PHYSTATUS_PIPECLK_dly,PIPERX2PHYSTATUS_ipd,tisd_PIPERX2PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX2VALID_PIPECLK_dly,PIPERX2VALID_ipd,tisd_PIPERX2VALID_PIPECLK);
      VitalSignalDelay (PIPERX3CHANISALIGNED_PIPECLK_dly,PIPERX3CHANISALIGNED_ipd,tisd_PIPERX3CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX3ELECIDLE_PIPECLK_dly,PIPERX3ELECIDLE_ipd,tisd_PIPERX3ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX3PHYSTATUS_PIPECLK_dly,PIPERX3PHYSTATUS_ipd,tisd_PIPERX3PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX3VALID_PIPECLK_dly,PIPERX3VALID_ipd,tisd_PIPERX3VALID_PIPECLK);
      VitalSignalDelay (PIPERX4CHANISALIGNED_PIPECLK_dly,PIPERX4CHANISALIGNED_ipd,tisd_PIPERX4CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX4ELECIDLE_PIPECLK_dly,PIPERX4ELECIDLE_ipd,tisd_PIPERX4ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX4PHYSTATUS_PIPECLK_dly,PIPERX4PHYSTATUS_ipd,tisd_PIPERX4PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX4VALID_PIPECLK_dly,PIPERX4VALID_ipd,tisd_PIPERX4VALID_PIPECLK);
      VitalSignalDelay (PIPERX5CHANISALIGNED_PIPECLK_dly,PIPERX5CHANISALIGNED_ipd,tisd_PIPERX5CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX5ELECIDLE_PIPECLK_dly,PIPERX5ELECIDLE_ipd,tisd_PIPERX5ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX5PHYSTATUS_PIPECLK_dly,PIPERX5PHYSTATUS_ipd,tisd_PIPERX5PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX5VALID_PIPECLK_dly,PIPERX5VALID_ipd,tisd_PIPERX5VALID_PIPECLK);
      VitalSignalDelay (PIPERX6CHANISALIGNED_PIPECLK_dly,PIPERX6CHANISALIGNED_ipd,tisd_PIPERX6CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX6ELECIDLE_PIPECLK_dly,PIPERX6ELECIDLE_ipd,tisd_PIPERX6ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX6PHYSTATUS_PIPECLK_dly,PIPERX6PHYSTATUS_ipd,tisd_PIPERX6PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX6VALID_PIPECLK_dly,PIPERX6VALID_ipd,tisd_PIPERX6VALID_PIPECLK);
      VitalSignalDelay (PIPERX7CHANISALIGNED_PIPECLK_dly,PIPERX7CHANISALIGNED_ipd,tisd_PIPERX7CHANISALIGNED_PIPECLK);
      VitalSignalDelay (PIPERX7ELECIDLE_PIPECLK_dly,PIPERX7ELECIDLE_ipd,tisd_PIPERX7ELECIDLE_PIPECLK);
      VitalSignalDelay (PIPERX7PHYSTATUS_PIPECLK_dly,PIPERX7PHYSTATUS_ipd,tisd_PIPERX7PHYSTATUS_PIPECLK);
      VitalSignalDelay (PIPERX7VALID_PIPECLK_dly,PIPERX7VALID_ipd,tisd_PIPERX7VALID_PIPECLK);
      VitalSignalDelay (PLDIRECTEDLINKAUTON_PIPECLK_dly,PLDIRECTEDLINKAUTON_ipd,tisd_PLDIRECTEDLINKAUTON_PIPECLK);
      VitalSignalDelay (PLDIRECTEDLINKSPEED_PIPECLK_dly,PLDIRECTEDLINKSPEED_ipd,tisd_PLDIRECTEDLINKSPEED_PIPECLK);
      VitalSignalDelay (PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_dly,PLDOWNSTREAMDEEMPHSOURCE_ipd,tisd_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK);
      VitalSignalDelay (PLRSTN_PIPECLK_dly,PLRSTN_ipd,tisd_PLRSTN_PIPECLK);
      VitalSignalDelay (PLTRANSMITHOTRST_PIPECLK_dly,PLTRANSMITHOTRST_ipd,tisd_PLTRANSMITHOTRST_PIPECLK);
      VitalSignalDelay (PLUPSTREAMPREFERDEEMPH_PIPECLK_dly,PLUPSTREAMPREFERDEEMPH_ipd,tisd_PLUPSTREAMPREFERDEEMPH_PIPECLK);
      VitalSignalDelay (TL2ASPMSUSPENDCREDITCHECKN_USERCLK_dly,TL2ASPMSUSPENDCREDITCHECKN_ipd,tisd_TL2ASPMSUSPENDCREDITCHECKN_USERCLK);
      VitalSignalDelay (TL2PPMSUSPENDREQN_USERCLK_dly,TL2PPMSUSPENDREQN_ipd,tisd_TL2PPMSUSPENDREQN_USERCLK);
      VitalSignalDelay (TLRSTN_USERCLK_dly,TLRSTN_ipd,tisd_TLRSTN_USERCLK);
      VitalSignalDelay (TRNRDSTRDYN_USERCLK_dly,TRNRDSTRDYN_ipd,tisd_TRNRDSTRDYN_USERCLK);
      VitalSignalDelay (TRNRNPOKN_USERCLK_dly,TRNRNPOKN_ipd,tisd_TRNRNPOKN_USERCLK);
      VitalSignalDelay (TRNTCFGGNTN_USERCLK_dly,TRNTCFGGNTN_ipd,tisd_TRNTCFGGNTN_USERCLK);
      VitalSignalDelay (TRNTDLLPSRCRDYN_USERCLK_dly,TRNTDLLPSRCRDYN_ipd,tisd_TRNTDLLPSRCRDYN_USERCLK);
      VitalSignalDelay (TRNTECRCGENN_USERCLK_dly,TRNTECRCGENN_ipd,tisd_TRNTECRCGENN_USERCLK);
      VitalSignalDelay (TRNTEOFN_USERCLK_dly,TRNTEOFN_ipd,tisd_TRNTEOFN_USERCLK);
      VitalSignalDelay (TRNTERRFWDN_USERCLK_dly,TRNTERRFWDN_ipd,tisd_TRNTERRFWDN_USERCLK);
      VitalSignalDelay (TRNTREMN_USERCLK_dly,TRNTREMN_ipd,tisd_TRNTREMN_USERCLK);
      VitalSignalDelay (TRNTSOFN_USERCLK_dly,TRNTSOFN_ipd,tisd_TRNTSOFN_USERCLK);
      VitalSignalDelay (TRNTSRCDSCN_USERCLK_dly,TRNTSRCDSCN_ipd,tisd_TRNTSRCDSCN_USERCLK);
      VitalSignalDelay (TRNTSRCRDYN_USERCLK_dly,TRNTSRCRDYN_ipd,tisd_TRNTSRCRDYN_USERCLK);
      VitalSignalDelay (TRNTSTRN_USERCLK_dly,TRNTSTRN_ipd,tisd_TRNTSTRN_USERCLK);

      VitalSignalDelay (DRPCLK_dly,DRPCLK_ipd,ticd_DRPCLK);
      VitalSignalDelay (PIPECLK_dly,PIPECLK_ipd,ticd_PIPECLK);
      VitalSignalDelay (USERCLK_dly,USERCLK_ipd,ticd_USERCLK);
    end block;
      
    --Input ports sensitive to single clock
    CFGBYTEENN_indelay <= CFGBYTEENN_USERCLK_dly;
    CFGDI_indelay <= CFGDI_USERCLK_dly;
    CFGDSBUSNUMBER_indelay <= CFGDSBUSNUMBER_USERCLK_dly;
    CFGDSDEVICENUMBER_indelay <= CFGDSDEVICENUMBER_USERCLK_dly;
    CFGDSFUNCTIONNUMBER_indelay <= CFGDSFUNCTIONNUMBER_USERCLK_dly;
    CFGDSN_indelay <= CFGDSN_USERCLK_dly;
    CFGDWADDR_indelay <= CFGDWADDR_USERCLK_dly;
    CFGERRACSN_indelay <= CFGERRACSN_USERCLK_dly;
    CFGERRAERHEADERLOG_indelay <= CFGERRAERHEADERLOG_USERCLK_dly;
    CFGERRCORN_indelay <= CFGERRCORN_USERCLK_dly;
    CFGERRCPLABORTN_indelay <= CFGERRCPLABORTN_USERCLK_dly;
    CFGERRCPLTIMEOUTN_indelay <= CFGERRCPLTIMEOUTN_USERCLK_dly;
    CFGERRCPLUNEXPECTN_indelay <= CFGERRCPLUNEXPECTN_USERCLK_dly;
    CFGERRECRCN_indelay <= CFGERRECRCN_USERCLK_dly;
    CFGERRLOCKEDN_indelay <= CFGERRLOCKEDN_USERCLK_dly;
    CFGERRPOSTEDN_indelay <= CFGERRPOSTEDN_USERCLK_dly;
    CFGERRTLPCPLHEADER_indelay <= CFGERRTLPCPLHEADER_USERCLK_dly;
    CFGERRURN_indelay <= CFGERRURN_USERCLK_dly;
    CFGINTERRUPTASSERTN_indelay <= CFGINTERRUPTASSERTN_USERCLK_dly;
    CFGINTERRUPTDI_indelay <= CFGINTERRUPTDI_USERCLK_dly;
    CFGINTERRUPTN_indelay <= CFGINTERRUPTN_USERCLK_dly;
    CFGPMDIRECTASPML1N_indelay <= CFGPMDIRECTASPML1N_USERCLK_dly;
    CFGPMSENDPMACKN_indelay <= CFGPMSENDPMACKN_USERCLK_dly;
    CFGPMSENDPMETON_indelay <= CFGPMSENDPMETON_USERCLK_dly;
    CFGPMSENDPMNAKN_indelay <= CFGPMSENDPMNAKN_USERCLK_dly;
    CFGPMTURNOFFOKN_indelay <= CFGPMTURNOFFOKN_USERCLK_dly;
    CFGPMWAKEN_indelay <= CFGPMWAKEN_USERCLK_dly;
    CFGPORTNUMBER_indelay <= CFGPORTNUMBER_USERCLK_dly;
    CFGRDENN_indelay <= CFGRDENN_USERCLK_dly;
    CFGTRNPENDINGN_indelay <= CFGTRNPENDINGN_USERCLK_dly;
    CFGWRENN_indelay <= CFGWRENN_USERCLK_dly;
    CFGWRREADONLYN_indelay <= CFGWRREADONLYN_USERCLK_dly;
    CFGWRRW1CASRWN_indelay <= CFGWRRW1CASRWN_USERCLK_dly;
    CMRSTN_indelay <= CMRSTN_USERCLK_dly;
    CMSTICKYRSTN_indelay <= CMSTICKYRSTN_USERCLK_dly;
    DBGMODE_indelay <= DBGMODE_USERCLK_dly;
    DBGSUBMODE_indelay <= DBGSUBMODE_USERCLK_dly;
    DLRSTN_indelay <= DLRSTN_USERCLK_dly;
    DRPDADDR_indelay <= DRPDADDR_DRPCLK_dly;
    DRPDEN_indelay <= DRPDEN_DRPCLK_dly;
    DRPDI_indelay <= DRPDI_DRPCLK_dly;
    DRPDWE_indelay <= DRPDWE_DRPCLK_dly;
    FUNCLVLRSTN_indelay <= FUNCLVLRSTN_USERCLK_dly;
    LL2SENDASREQL1N_indelay <= LL2SENDASREQL1N_USERCLK_dly;
    LL2SENDENTERL1N_indelay <= LL2SENDENTERL1N_USERCLK_dly;
    LL2SENDENTERL23N_indelay <= LL2SENDENTERL23N_USERCLK_dly;
    LL2SUSPENDNOWN_indelay <= LL2SUSPENDNOWN_USERCLK_dly;
    LL2TLPRCVN_indelay <= LL2TLPRCVN_USERCLK_dly;
    MIMRXRDATA_indelay <= MIMRXRDATA_USERCLK_dly;
    MIMTXRDATA_indelay <= MIMTXRDATA_USERCLK_dly;
    PIPERX0CHANISALIGNED_indelay <= PIPERX0CHANISALIGNED_PIPECLK_dly;
    PIPERX0CHARISK_indelay <= PIPERX0CHARISK_PIPECLK_dly;
    PIPERX0DATA_indelay <= PIPERX0DATA_PIPECLK_dly;
    PIPERX0ELECIDLE_indelay <= PIPERX0ELECIDLE_PIPECLK_dly;
    PIPERX0PHYSTATUS_indelay <= PIPERX0PHYSTATUS_PIPECLK_dly;
    PIPERX0STATUS_indelay <= PIPERX0STATUS_PIPECLK_dly;
    PIPERX0VALID_indelay <= PIPERX0VALID_PIPECLK_dly;
    PIPERX1CHANISALIGNED_indelay <= PIPERX1CHANISALIGNED_PIPECLK_dly;
    PIPERX1CHARISK_indelay <= PIPERX1CHARISK_PIPECLK_dly;
    PIPERX1DATA_indelay <= PIPERX1DATA_PIPECLK_dly;
    PIPERX1ELECIDLE_indelay <= PIPERX1ELECIDLE_PIPECLK_dly;
    PIPERX1PHYSTATUS_indelay <= PIPERX1PHYSTATUS_PIPECLK_dly;
    PIPERX1STATUS_indelay <= PIPERX1STATUS_PIPECLK_dly;
    PIPERX1VALID_indelay <= PIPERX1VALID_PIPECLK_dly;
    PIPERX2CHANISALIGNED_indelay <= PIPERX2CHANISALIGNED_PIPECLK_dly;
    PIPERX2CHARISK_indelay <= PIPERX2CHARISK_PIPECLK_dly;
    PIPERX2DATA_indelay <= PIPERX2DATA_PIPECLK_dly;
    PIPERX2ELECIDLE_indelay <= PIPERX2ELECIDLE_PIPECLK_dly;
    PIPERX2PHYSTATUS_indelay <= PIPERX2PHYSTATUS_PIPECLK_dly;
    PIPERX2STATUS_indelay <= PIPERX2STATUS_PIPECLK_dly;
    PIPERX2VALID_indelay <= PIPERX2VALID_PIPECLK_dly;
    PIPERX3CHANISALIGNED_indelay <= PIPERX3CHANISALIGNED_PIPECLK_dly;
    PIPERX3CHARISK_indelay <= PIPERX3CHARISK_PIPECLK_dly;
    PIPERX3DATA_indelay <= PIPERX3DATA_PIPECLK_dly;
    PIPERX3ELECIDLE_indelay <= PIPERX3ELECIDLE_PIPECLK_dly;
    PIPERX3PHYSTATUS_indelay <= PIPERX3PHYSTATUS_PIPECLK_dly;
    PIPERX3STATUS_indelay <= PIPERX3STATUS_PIPECLK_dly;
    PIPERX3VALID_indelay <= PIPERX3VALID_PIPECLK_dly;
    PIPERX4CHANISALIGNED_indelay <= PIPERX4CHANISALIGNED_PIPECLK_dly;
    PIPERX4CHARISK_indelay <= PIPERX4CHARISK_PIPECLK_dly;
    PIPERX4DATA_indelay <= PIPERX4DATA_PIPECLK_dly;
    PIPERX4ELECIDLE_indelay <= PIPERX4ELECIDLE_PIPECLK_dly;
    PIPERX4PHYSTATUS_indelay <= PIPERX4PHYSTATUS_PIPECLK_dly;
    PIPERX4STATUS_indelay <= PIPERX4STATUS_PIPECLK_dly;
    PIPERX4VALID_indelay <= PIPERX4VALID_PIPECLK_dly;
    PIPERX5CHANISALIGNED_indelay <= PIPERX5CHANISALIGNED_PIPECLK_dly;
    PIPERX5CHARISK_indelay <= PIPERX5CHARISK_PIPECLK_dly;
    PIPERX5DATA_indelay <= PIPERX5DATA_PIPECLK_dly;
    PIPERX5ELECIDLE_indelay <= PIPERX5ELECIDLE_PIPECLK_dly;
    PIPERX5PHYSTATUS_indelay <= PIPERX5PHYSTATUS_PIPECLK_dly;
    PIPERX5STATUS_indelay <= PIPERX5STATUS_PIPECLK_dly;
    PIPERX5VALID_indelay <= PIPERX5VALID_PIPECLK_dly;
    PIPERX6CHANISALIGNED_indelay <= PIPERX6CHANISALIGNED_PIPECLK_dly;
    PIPERX6CHARISK_indelay <= PIPERX6CHARISK_PIPECLK_dly;
    PIPERX6DATA_indelay <= PIPERX6DATA_PIPECLK_dly;
    PIPERX6ELECIDLE_indelay <= PIPERX6ELECIDLE_PIPECLK_dly;
    PIPERX6PHYSTATUS_indelay <= PIPERX6PHYSTATUS_PIPECLK_dly;
    PIPERX6STATUS_indelay <= PIPERX6STATUS_PIPECLK_dly;
    PIPERX6VALID_indelay <= PIPERX6VALID_PIPECLK_dly;
    PIPERX7CHANISALIGNED_indelay <= PIPERX7CHANISALIGNED_PIPECLK_dly;
    PIPERX7CHARISK_indelay <= PIPERX7CHARISK_PIPECLK_dly;
    PIPERX7DATA_indelay <= PIPERX7DATA_PIPECLK_dly;
    PIPERX7ELECIDLE_indelay <= PIPERX7ELECIDLE_PIPECLK_dly;
    PIPERX7PHYSTATUS_indelay <= PIPERX7PHYSTATUS_PIPECLK_dly;
    PIPERX7STATUS_indelay <= PIPERX7STATUS_PIPECLK_dly;
    PIPERX7VALID_indelay <= PIPERX7VALID_PIPECLK_dly;
    PL2DIRECTEDLSTATE_indelay <= PL2DIRECTEDLSTATE_USERCLK_dly;
    PLDBGMODE_indelay <= PLDBGMODE_PIPECLK_dly;
    PLDIRECTEDLINKAUTON_indelay <= PLDIRECTEDLINKAUTON_PIPECLK_dly;
    PLDIRECTEDLINKCHANGE_indelay <= PLDIRECTEDLINKCHANGE_PIPECLK_dly;
    PLDIRECTEDLINKSPEED_indelay <= PLDIRECTEDLINKSPEED_PIPECLK_dly;
    PLDIRECTEDLINKWIDTH_indelay <= PLDIRECTEDLINKWIDTH_PIPECLK_dly;
    PLDOWNSTREAMDEEMPHSOURCE_indelay <= PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_dly;
    PLRSTN_indelay <= PLRSTN_PIPECLK_dly;
    PLTRANSMITHOTRST_indelay <= PLTRANSMITHOTRST_PIPECLK_dly;
    PLUPSTREAMPREFERDEEMPH_indelay <= PLUPSTREAMPREFERDEEMPH_PIPECLK_dly;
    TL2ASPMSUSPENDCREDITCHECKN_indelay <= TL2ASPMSUSPENDCREDITCHECKN_USERCLK_dly;
    TL2PPMSUSPENDREQN_indelay <= TL2PPMSUSPENDREQN_USERCLK_dly;
    TLRSTN_indelay <= TLRSTN_USERCLK_dly;
    TRNFCSEL_indelay <= TRNFCSEL_USERCLK_dly;
    TRNRDSTRDYN_indelay <= TRNRDSTRDYN_USERCLK_dly;
    TRNRNPOKN_indelay <= TRNRNPOKN_USERCLK_dly;
    TRNTCFGGNTN_indelay <= TRNTCFGGNTN_USERCLK_dly;
    TRNTDLLPDATA_indelay <= TRNTDLLPDATA_USERCLK_dly;
    TRNTDLLPSRCRDYN_indelay <= TRNTDLLPSRCRDYN_USERCLK_dly;
    TRNTD_indelay <= TRNTD_USERCLK_dly;
    TRNTECRCGENN_indelay <= TRNTECRCGENN_USERCLK_dly;
    TRNTEOFN_indelay <= TRNTEOFN_USERCLK_dly;
    TRNTERRFWDN_indelay <= TRNTERRFWDN_USERCLK_dly;
    TRNTREMN_indelay <= TRNTREMN_USERCLK_dly;
    TRNTSOFN_indelay <= TRNTSOFN_USERCLK_dly;
    TRNTSRCDSCN_indelay <= TRNTSRCDSCN_USERCLK_dly;
    TRNTSRCRDYN_indelay <= TRNTSRCRDYN_USERCLK_dly;
    TRNTSTRN_indelay <= TRNTSTRN_USERCLK_dly;
    
    --Input ports sensitive to more than two clocks
    SYSRSTN_indelay <= SYSRSTN_ipd;
    
    DRPCLK_indelay <= DRPCLK_dly;
    PIPECLK_indelay <= PIPECLK_dly;
    USERCLK_indelay <= USERCLK_dly;
    
    CFGAERECRCCHECKEN_out <= CFGAERECRCCHECKEN_outdelay after OUT_DELAY;
    CFGAERECRCGENEN_out <= CFGAERECRCGENEN_outdelay after OUT_DELAY;
    CFGCOMMANDBUSMASTERENABLE_out <= CFGCOMMANDBUSMASTERENABLE_outdelay after OUT_DELAY;
    CFGCOMMANDINTERRUPTDISABLE_out <= CFGCOMMANDINTERRUPTDISABLE_outdelay after OUT_DELAY;
    CFGCOMMANDIOENABLE_out <= CFGCOMMANDIOENABLE_outdelay after OUT_DELAY;
    CFGCOMMANDMEMENABLE_out <= CFGCOMMANDMEMENABLE_outdelay after OUT_DELAY;
    CFGCOMMANDSERREN_out <= CFGCOMMANDSERREN_outdelay after OUT_DELAY;
    CFGDEVCONTROL2CPLTIMEOUTDIS_out <= CFGDEVCONTROL2CPLTIMEOUTDIS_outdelay after OUT_DELAY;
    CFGDEVCONTROL2CPLTIMEOUTVAL_out <= CFGDEVCONTROL2CPLTIMEOUTVAL_outdelay after OUT_DELAY;
    CFGDEVCONTROLAUXPOWEREN_out <= CFGDEVCONTROLAUXPOWEREN_outdelay after OUT_DELAY;
    CFGDEVCONTROLCORRERRREPORTINGEN_out <= CFGDEVCONTROLCORRERRREPORTINGEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLENABLERO_out <= CFGDEVCONTROLENABLERO_outdelay after OUT_DELAY;
    CFGDEVCONTROLEXTTAGEN_out <= CFGDEVCONTROLEXTTAGEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLFATALERRREPORTINGEN_out <= CFGDEVCONTROLFATALERRREPORTINGEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLMAXPAYLOAD_out <= CFGDEVCONTROLMAXPAYLOAD_outdelay after OUT_DELAY;
    CFGDEVCONTROLMAXREADREQ_out <= CFGDEVCONTROLMAXREADREQ_outdelay after OUT_DELAY;
    CFGDEVCONTROLNONFATALREPORTINGEN_out <= CFGDEVCONTROLNONFATALREPORTINGEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLNOSNOOPEN_out <= CFGDEVCONTROLNOSNOOPEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLPHANTOMEN_out <= CFGDEVCONTROLPHANTOMEN_outdelay after OUT_DELAY;
    CFGDEVCONTROLURERRREPORTINGEN_out <= CFGDEVCONTROLURERRREPORTINGEN_outdelay after OUT_DELAY;
    CFGDEVSTATUSCORRERRDETECTED_out <= CFGDEVSTATUSCORRERRDETECTED_outdelay after OUT_DELAY;
    CFGDEVSTATUSFATALERRDETECTED_out <= CFGDEVSTATUSFATALERRDETECTED_outdelay after OUT_DELAY;
    CFGDEVSTATUSNONFATALERRDETECTED_out <= CFGDEVSTATUSNONFATALERRDETECTED_outdelay after OUT_DELAY;
    CFGDEVSTATUSURDETECTED_out <= CFGDEVSTATUSURDETECTED_outdelay after OUT_DELAY;
    CFGDO_out <= CFGDO_outdelay after OUT_DELAY;
    CFGERRAERHEADERLOGSETN_out <= CFGERRAERHEADERLOGSETN_outdelay after OUT_DELAY;
    CFGERRCPLRDYN_out <= CFGERRCPLRDYN_outdelay after OUT_DELAY;
    CFGINTERRUPTDO_out <= CFGINTERRUPTDO_outdelay after OUT_DELAY;
    CFGINTERRUPTMMENABLE_out <= CFGINTERRUPTMMENABLE_outdelay after OUT_DELAY;
    CFGINTERRUPTMSIENABLE_out <= CFGINTERRUPTMSIENABLE_outdelay after OUT_DELAY;
    CFGINTERRUPTMSIXENABLE_out <= CFGINTERRUPTMSIXENABLE_outdelay after OUT_DELAY;
    CFGINTERRUPTMSIXFM_out <= CFGINTERRUPTMSIXFM_outdelay after OUT_DELAY;
    CFGINTERRUPTRDYN_out <= CFGINTERRUPTRDYN_outdelay after OUT_DELAY;
    CFGLINKCONTROLASPMCONTROL_out <= CFGLINKCONTROLASPMCONTROL_outdelay after OUT_DELAY;
    CFGLINKCONTROLAUTOBANDWIDTHINTEN_out <= CFGLINKCONTROLAUTOBANDWIDTHINTEN_outdelay after OUT_DELAY;
    CFGLINKCONTROLBANDWIDTHINTEN_out <= CFGLINKCONTROLBANDWIDTHINTEN_outdelay after OUT_DELAY;
    CFGLINKCONTROLCLOCKPMEN_out <= CFGLINKCONTROLCLOCKPMEN_outdelay after OUT_DELAY;
    CFGLINKCONTROLCOMMONCLOCK_out <= CFGLINKCONTROLCOMMONCLOCK_outdelay after OUT_DELAY;
    CFGLINKCONTROLEXTENDEDSYNC_out <= CFGLINKCONTROLEXTENDEDSYNC_outdelay after OUT_DELAY;
    CFGLINKCONTROLHWAUTOWIDTHDIS_out <= CFGLINKCONTROLHWAUTOWIDTHDIS_outdelay after OUT_DELAY;
    CFGLINKCONTROLLINKDISABLE_out <= CFGLINKCONTROLLINKDISABLE_outdelay after OUT_DELAY;
    CFGLINKCONTROLRCB_out <= CFGLINKCONTROLRCB_outdelay after OUT_DELAY;
    CFGLINKCONTROLRETRAINLINK_out <= CFGLINKCONTROLRETRAINLINK_outdelay after OUT_DELAY;
    CFGLINKSTATUSAUTOBANDWIDTHSTATUS_out <= CFGLINKSTATUSAUTOBANDWIDTHSTATUS_outdelay after OUT_DELAY;
    CFGLINKSTATUSBANDWITHSTATUS_out <= CFGLINKSTATUSBANDWITHSTATUS_outdelay after OUT_DELAY;
    CFGLINKSTATUSCURRENTSPEED_out <= CFGLINKSTATUSCURRENTSPEED_outdelay after OUT_DELAY;
    CFGLINKSTATUSDLLACTIVE_out <= CFGLINKSTATUSDLLACTIVE_outdelay after OUT_DELAY;
    CFGLINKSTATUSLINKTRAINING_out <= CFGLINKSTATUSLINKTRAINING_outdelay after OUT_DELAY;
    CFGLINKSTATUSNEGOTIATEDWIDTH_out <= CFGLINKSTATUSNEGOTIATEDWIDTH_outdelay after OUT_DELAY;
    CFGMSGDATA_out <= CFGMSGDATA_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDASSERTINTA_out <= CFGMSGRECEIVEDASSERTINTA_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDASSERTINTB_out <= CFGMSGRECEIVEDASSERTINTB_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDASSERTINTC_out <= CFGMSGRECEIVEDASSERTINTC_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDASSERTINTD_out <= CFGMSGRECEIVEDASSERTINTD_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDDEASSERTINTA_out <= CFGMSGRECEIVEDDEASSERTINTA_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDDEASSERTINTB_out <= CFGMSGRECEIVEDDEASSERTINTB_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDDEASSERTINTC_out <= CFGMSGRECEIVEDDEASSERTINTC_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDDEASSERTINTD_out <= CFGMSGRECEIVEDDEASSERTINTD_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDERRCOR_out <= CFGMSGRECEIVEDERRCOR_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDERRFATAL_out <= CFGMSGRECEIVEDERRFATAL_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDERRNONFATAL_out <= CFGMSGRECEIVEDERRNONFATAL_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDPMASNAK_out <= CFGMSGRECEIVEDPMASNAK_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDPMETOACK_out <= CFGMSGRECEIVEDPMETOACK_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDPMETO_out <= CFGMSGRECEIVEDPMETO_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDPMPME_out <= CFGMSGRECEIVEDPMPME_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDSETSLOTPOWERLIMIT_out <= CFGMSGRECEIVEDSETSLOTPOWERLIMIT_outdelay after OUT_DELAY;
    CFGMSGRECEIVEDUNLOCK_out <= CFGMSGRECEIVEDUNLOCK_outdelay after OUT_DELAY;
    CFGMSGRECEIVED_out <= CFGMSGRECEIVED_outdelay after OUT_DELAY;
    CFGPCIELINKSTATE_out <= CFGPCIELINKSTATE_outdelay after OUT_DELAY;
    CFGPMCSRPMEEN_out <= CFGPMCSRPMEEN_outdelay after OUT_DELAY;
    CFGPMCSRPMESTATUS_out <= CFGPMCSRPMESTATUS_outdelay after OUT_DELAY;
    CFGPMCSRPOWERSTATE_out <= CFGPMCSRPOWERSTATE_outdelay after OUT_DELAY;
    CFGPMRCVASREQL1N_out <= CFGPMRCVASREQL1N_outdelay after OUT_DELAY;
    CFGPMRCVENTERL1N_out <= CFGPMRCVENTERL1N_outdelay after OUT_DELAY;
    CFGPMRCVENTERL23N_out <= CFGPMRCVENTERL23N_outdelay after OUT_DELAY;
    CFGPMRCVREQACKN_out <= CFGPMRCVREQACKN_outdelay after OUT_DELAY;
    CFGRDWRDONEN_out <= CFGRDWRDONEN_outdelay after OUT_DELAY;
    CFGSLOTCONTROLELECTROMECHILCTLPULSE_out <= CFGSLOTCONTROLELECTROMECHILCTLPULSE_outdelay after OUT_DELAY;
    CFGTRANSACTIONADDR_out <= CFGTRANSACTIONADDR_outdelay after OUT_DELAY;
    CFGTRANSACTIONTYPE_out <= CFGTRANSACTIONTYPE_outdelay after OUT_DELAY;
    CFGTRANSACTION_out <= CFGTRANSACTION_outdelay after OUT_DELAY;
    CFGVCTCVCMAP_out <= CFGVCTCVCMAP_outdelay after OUT_DELAY;
    DBGSCLRA_out <= DBGSCLRA_outdelay after OUT_DELAY;
    DBGSCLRB_out <= DBGSCLRB_outdelay after OUT_DELAY;
    DBGSCLRC_out <= DBGSCLRC_outdelay after OUT_DELAY;
    DBGSCLRD_out <= DBGSCLRD_outdelay after OUT_DELAY;
    DBGSCLRE_out <= DBGSCLRE_outdelay after OUT_DELAY;
    DBGSCLRF_out <= DBGSCLRF_outdelay after OUT_DELAY;
    DBGSCLRG_out <= DBGSCLRG_outdelay after OUT_DELAY;
    DBGSCLRH_out <= DBGSCLRH_outdelay after OUT_DELAY;
    DBGSCLRI_out <= DBGSCLRI_outdelay after OUT_DELAY;
    DBGSCLRJ_out <= DBGSCLRJ_outdelay after OUT_DELAY;
    DBGSCLRK_out <= DBGSCLRK_outdelay after OUT_DELAY;
    DBGVECA_out <= DBGVECA_outdelay after OUT_DELAY;
    DBGVECB_out <= DBGVECB_outdelay after OUT_DELAY;
    DBGVECC_out <= DBGVECC_outdelay after OUT_DELAY;
    DRPDO_out <= DRPDO_outdelay after OUT_DELAY;
    DRPDRDY_out <= DRPDRDY_outdelay after OUT_DELAY;
    LL2BADDLLPERRN_out <= LL2BADDLLPERRN_outdelay after OUT_DELAY;
    LL2BADTLPERRN_out <= LL2BADTLPERRN_outdelay after OUT_DELAY;
    LL2PROTOCOLERRN_out <= LL2PROTOCOLERRN_outdelay after OUT_DELAY;
    LL2REPLAYROERRN_out <= LL2REPLAYROERRN_outdelay after OUT_DELAY;
    LL2REPLAYTOERRN_out <= LL2REPLAYTOERRN_outdelay after OUT_DELAY;
    LL2SUSPENDOKN_out <= LL2SUSPENDOKN_outdelay after OUT_DELAY;
    LL2TFCINIT1SEQN_out <= LL2TFCINIT1SEQN_outdelay after OUT_DELAY;
    LL2TFCINIT2SEQN_out <= LL2TFCINIT2SEQN_outdelay after OUT_DELAY;
    LNKCLKEN_out <= LNKCLKEN_outdelay after OUT_DELAY;
    MIMRXRADDR_out <= MIMRXRADDR_outdelay after OUT_DELAY;
    MIMRXRCE_out <= MIMRXRCE_outdelay after OUT_DELAY;
    MIMRXREN_out <= MIMRXREN_outdelay after OUT_DELAY;
    MIMRXWADDR_out <= MIMRXWADDR_outdelay after OUT_DELAY;
    MIMRXWDATA_out <= MIMRXWDATA_outdelay after OUT_DELAY;
    MIMRXWEN_out <= MIMRXWEN_outdelay after OUT_DELAY;
    MIMTXRADDR_out <= MIMTXRADDR_outdelay after OUT_DELAY;
    MIMTXRCE_out <= MIMTXRCE_outdelay after OUT_DELAY;
    MIMTXREN_out <= MIMTXREN_outdelay after OUT_DELAY;
    MIMTXWADDR_out <= MIMTXWADDR_outdelay after OUT_DELAY;
    MIMTXWDATA_out <= MIMTXWDATA_outdelay after OUT_DELAY;
    MIMTXWEN_out <= MIMTXWEN_outdelay after OUT_DELAY;
    PIPERX0POLARITY_out <= PIPERX0POLARITY_outdelay after OUT_DELAY;
    PIPERX1POLARITY_out <= PIPERX1POLARITY_outdelay after OUT_DELAY;
    PIPERX2POLARITY_out <= PIPERX2POLARITY_outdelay after OUT_DELAY;
    PIPERX3POLARITY_out <= PIPERX3POLARITY_outdelay after OUT_DELAY;
    PIPERX4POLARITY_out <= PIPERX4POLARITY_outdelay after OUT_DELAY;
    PIPERX5POLARITY_out <= PIPERX5POLARITY_outdelay after OUT_DELAY;
    PIPERX6POLARITY_out <= PIPERX6POLARITY_outdelay after OUT_DELAY;
    PIPERX7POLARITY_out <= PIPERX7POLARITY_outdelay after OUT_DELAY;
    PIPETX0CHARISK_out <= PIPETX0CHARISK_outdelay after OUT_DELAY;
    PIPETX0COMPLIANCE_out <= PIPETX0COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX0DATA_out <= PIPETX0DATA_outdelay after OUT_DELAY;
    PIPETX0ELECIDLE_out <= PIPETX0ELECIDLE_outdelay after OUT_DELAY;
    PIPETX0POWERDOWN_out <= PIPETX0POWERDOWN_outdelay after OUT_DELAY;
    PIPETX1CHARISK_out <= PIPETX1CHARISK_outdelay after OUT_DELAY;
    PIPETX1COMPLIANCE_out <= PIPETX1COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX1DATA_out <= PIPETX1DATA_outdelay after OUT_DELAY;
    PIPETX1ELECIDLE_out <= PIPETX1ELECIDLE_outdelay after OUT_DELAY;
    PIPETX1POWERDOWN_out <= PIPETX1POWERDOWN_outdelay after OUT_DELAY;
    PIPETX2CHARISK_out <= PIPETX2CHARISK_outdelay after OUT_DELAY;
    PIPETX2COMPLIANCE_out <= PIPETX2COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX2DATA_out <= PIPETX2DATA_outdelay after OUT_DELAY;
    PIPETX2ELECIDLE_out <= PIPETX2ELECIDLE_outdelay after OUT_DELAY;
    PIPETX2POWERDOWN_out <= PIPETX2POWERDOWN_outdelay after OUT_DELAY;
    PIPETX3CHARISK_out <= PIPETX3CHARISK_outdelay after OUT_DELAY;
    PIPETX3COMPLIANCE_out <= PIPETX3COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX3DATA_out <= PIPETX3DATA_outdelay after OUT_DELAY;
    PIPETX3ELECIDLE_out <= PIPETX3ELECIDLE_outdelay after OUT_DELAY;
    PIPETX3POWERDOWN_out <= PIPETX3POWERDOWN_outdelay after OUT_DELAY;
    PIPETX4CHARISK_out <= PIPETX4CHARISK_outdelay after OUT_DELAY;
    PIPETX4COMPLIANCE_out <= PIPETX4COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX4DATA_out <= PIPETX4DATA_outdelay after OUT_DELAY;
    PIPETX4ELECIDLE_out <= PIPETX4ELECIDLE_outdelay after OUT_DELAY;
    PIPETX4POWERDOWN_out <= PIPETX4POWERDOWN_outdelay after OUT_DELAY;
    PIPETX5CHARISK_out <= PIPETX5CHARISK_outdelay after OUT_DELAY;
    PIPETX5COMPLIANCE_out <= PIPETX5COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX5DATA_out <= PIPETX5DATA_outdelay after OUT_DELAY;
    PIPETX5ELECIDLE_out <= PIPETX5ELECIDLE_outdelay after OUT_DELAY;
    PIPETX5POWERDOWN_out <= PIPETX5POWERDOWN_outdelay after OUT_DELAY;
    PIPETX6CHARISK_out <= PIPETX6CHARISK_outdelay after OUT_DELAY;
    PIPETX6COMPLIANCE_out <= PIPETX6COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX6DATA_out <= PIPETX6DATA_outdelay after OUT_DELAY;
    PIPETX6ELECIDLE_out <= PIPETX6ELECIDLE_outdelay after OUT_DELAY;
    PIPETX6POWERDOWN_out <= PIPETX6POWERDOWN_outdelay after OUT_DELAY;
    PIPETX7CHARISK_out <= PIPETX7CHARISK_outdelay after OUT_DELAY;
    PIPETX7COMPLIANCE_out <= PIPETX7COMPLIANCE_outdelay after OUT_DELAY;
    PIPETX7DATA_out <= PIPETX7DATA_outdelay after OUT_DELAY;
    PIPETX7ELECIDLE_out <= PIPETX7ELECIDLE_outdelay after OUT_DELAY;
    PIPETX7POWERDOWN_out <= PIPETX7POWERDOWN_outdelay after OUT_DELAY;
    PIPETXDEEMPH_out <= PIPETXDEEMPH_outdelay after OUT_DELAY;
    PIPETXMARGIN_out <= PIPETXMARGIN_outdelay after OUT_DELAY;
    PIPETXRATE_out <= PIPETXRATE_outdelay after OUT_DELAY;
    PIPETXRCVRDET_out <= PIPETXRCVRDET_outdelay after OUT_DELAY;
    PIPETXRESET_out <= PIPETXRESET_outdelay after OUT_DELAY;
    PL2LINKUPN_out <= PL2LINKUPN_outdelay after OUT_DELAY;
    PL2RECEIVERERRN_out <= PL2RECEIVERERRN_outdelay after OUT_DELAY;
    PL2RECOVERYN_out <= PL2RECOVERYN_outdelay after OUT_DELAY;
    PL2RXELECIDLE_out <= PL2RXELECIDLE_outdelay after OUT_DELAY;
    PL2SUSPENDOK_out <= PL2SUSPENDOK_outdelay after OUT_DELAY;
    PLDBGVEC_out <= PLDBGVEC_outdelay after OUT_DELAY;
    PLINITIALLINKWIDTH_out <= PLINITIALLINKWIDTH_outdelay after OUT_DELAY;
    PLLANEREVERSALMODE_out <= PLLANEREVERSALMODE_outdelay after OUT_DELAY;
    PLLINKGEN2CAP_out <= PLLINKGEN2CAP_outdelay after OUT_DELAY;
    PLLINKPARTNERGEN2SUPPORTED_out <= PLLINKPARTNERGEN2SUPPORTED_outdelay after OUT_DELAY;
    PLLINKUPCFGCAP_out <= PLLINKUPCFGCAP_outdelay after OUT_DELAY;
    PLLTSSMSTATE_out <= PLLTSSMSTATE_outdelay after OUT_DELAY;
    PLPHYLNKUPN_out <= PLPHYLNKUPN_outdelay after OUT_DELAY;
    PLRECEIVEDHOTRST_out <= PLRECEIVEDHOTRST_outdelay after OUT_DELAY;
    PLRXPMSTATE_out <= PLRXPMSTATE_outdelay after OUT_DELAY;
    PLSELLNKRATE_out <= PLSELLNKRATE_outdelay after OUT_DELAY;
    PLSELLNKWIDTH_out <= PLSELLNKWIDTH_outdelay after OUT_DELAY;
    PLTXPMSTATE_out <= PLTXPMSTATE_outdelay after OUT_DELAY;
    RECEIVEDFUNCLVLRSTN_out <= RECEIVEDFUNCLVLRSTN_outdelay after OUT_DELAY;
    TL2ASPMSUSPENDCREDITCHECKOKN_out <= TL2ASPMSUSPENDCREDITCHECKOKN_outdelay after OUT_DELAY;
    TL2ASPMSUSPENDREQN_out <= TL2ASPMSUSPENDREQN_outdelay after OUT_DELAY;
    TL2PPMSUSPENDOKN_out <= TL2PPMSUSPENDOKN_outdelay after OUT_DELAY;
    TRNFCCPLD_out <= TRNFCCPLD_outdelay after OUT_DELAY;
    TRNFCCPLH_out <= TRNFCCPLH_outdelay after OUT_DELAY;
    TRNFCNPD_out <= TRNFCNPD_outdelay after OUT_DELAY;
    TRNFCNPH_out <= TRNFCNPH_outdelay after OUT_DELAY;
    TRNFCPD_out <= TRNFCPD_outdelay after OUT_DELAY;
    TRNFCPH_out <= TRNFCPH_outdelay after OUT_DELAY;
    TRNLNKUPN_out <= TRNLNKUPN_outdelay after OUT_DELAY;
    TRNRBARHITN_out <= TRNRBARHITN_outdelay after OUT_DELAY;
    TRNRDLLPDATA_out <= TRNRDLLPDATA_outdelay after OUT_DELAY;
    TRNRDLLPSRCRDYN_out <= TRNRDLLPSRCRDYN_outdelay after OUT_DELAY;
    TRNRD_out <= TRNRD_outdelay after OUT_DELAY;
    TRNRECRCERRN_out <= TRNRECRCERRN_outdelay after OUT_DELAY;
    TRNREOFN_out <= TRNREOFN_outdelay after OUT_DELAY;
    TRNRERRFWDN_out <= TRNRERRFWDN_outdelay after OUT_DELAY;
    TRNRREMN_out <= TRNRREMN_outdelay after OUT_DELAY;
    TRNRSOFN_out <= TRNRSOFN_outdelay after OUT_DELAY;
    TRNRSRCDSCN_out <= TRNRSRCDSCN_outdelay after OUT_DELAY;
    TRNRSRCRDYN_out <= TRNRSRCRDYN_outdelay after OUT_DELAY;
    TRNTBUFAV_out <= TRNTBUFAV_outdelay after OUT_DELAY;
    TRNTCFGREQN_out <= TRNTCFGREQN_outdelay after OUT_DELAY;
    TRNTDLLPDSTRDYN_out <= TRNTDLLPDSTRDYN_outdelay after OUT_DELAY;
    TRNTDSTRDYN_out <= TRNTDSTRDYN_outdelay after OUT_DELAY;
    TRNTERRDROPN_out <= TRNTERRDROPN_outdelay after OUT_DELAY;
    USERRSTN_out <= USERRSTN_outdelay after OUT_DELAY;
    
    DRPCLK_indly <= DRPCLK_indelay after INCLK_DELAY;
    PIPECLK_indly <= PIPECLK_indelay after INCLK_DELAY;
    USERCLK_indly <= USERCLK_indelay after INCLK_DELAY;
    
    CFGBYTEENN_indly <= CFGBYTEENN_indelay after IN_DELAY;
    CFGDI_indly <= CFGDI_indelay after IN_DELAY;
    CFGDSBUSNUMBER_indly <= CFGDSBUSNUMBER_indelay after IN_DELAY;
    CFGDSDEVICENUMBER_indly <= CFGDSDEVICENUMBER_indelay after IN_DELAY;
    CFGDSFUNCTIONNUMBER_indly <= CFGDSFUNCTIONNUMBER_indelay after IN_DELAY;
    CFGDSN_indly <= CFGDSN_indelay after IN_DELAY;
    CFGDWADDR_indly <= CFGDWADDR_indelay after IN_DELAY;
    CFGERRACSN_indly <= CFGERRACSN_indelay after IN_DELAY;
    CFGERRAERHEADERLOG_indly <= CFGERRAERHEADERLOG_indelay after IN_DELAY;
    CFGERRCORN_indly <= CFGERRCORN_indelay after IN_DELAY;
    CFGERRCPLABORTN_indly <= CFGERRCPLABORTN_indelay after IN_DELAY;
    CFGERRCPLTIMEOUTN_indly <= CFGERRCPLTIMEOUTN_indelay after IN_DELAY;
    CFGERRCPLUNEXPECTN_indly <= CFGERRCPLUNEXPECTN_indelay after IN_DELAY;
    CFGERRECRCN_indly <= CFGERRECRCN_indelay after IN_DELAY;
    CFGERRLOCKEDN_indly <= CFGERRLOCKEDN_indelay after IN_DELAY;
    CFGERRPOSTEDN_indly <= CFGERRPOSTEDN_indelay after IN_DELAY;
    CFGERRTLPCPLHEADER_indly <= CFGERRTLPCPLHEADER_indelay after IN_DELAY;
    CFGERRURN_indly <= CFGERRURN_indelay after IN_DELAY;
    CFGINTERRUPTASSERTN_indly <= CFGINTERRUPTASSERTN_indelay after IN_DELAY;
    CFGINTERRUPTDI_indly <= CFGINTERRUPTDI_indelay after IN_DELAY;
    CFGINTERRUPTN_indly <= CFGINTERRUPTN_indelay after IN_DELAY;
    CFGPMDIRECTASPML1N_indly <= CFGPMDIRECTASPML1N_indelay after IN_DELAY;
    CFGPMSENDPMACKN_indly <= CFGPMSENDPMACKN_indelay after IN_DELAY;
    CFGPMSENDPMETON_indly <= CFGPMSENDPMETON_indelay after IN_DELAY;
    CFGPMSENDPMNAKN_indly <= CFGPMSENDPMNAKN_indelay after IN_DELAY;
    CFGPMTURNOFFOKN_indly <= CFGPMTURNOFFOKN_indelay after IN_DELAY;
    CFGPMWAKEN_indly <= CFGPMWAKEN_indelay after IN_DELAY;
    CFGPORTNUMBER_indly <= CFGPORTNUMBER_indelay after IN_DELAY;
    CFGRDENN_indly <= CFGRDENN_indelay after IN_DELAY;
    CFGTRNPENDINGN_indly <= CFGTRNPENDINGN_indelay after IN_DELAY;
    CFGWRENN_indly <= CFGWRENN_indelay after IN_DELAY;
    CFGWRREADONLYN_indly <= CFGWRREADONLYN_indelay after IN_DELAY;
    CFGWRRW1CASRWN_indly <= CFGWRRW1CASRWN_indelay after IN_DELAY;
    CMRSTN_indly <= CMRSTN_indelay after IN_DELAY;
    CMSTICKYRSTN_indly <= CMSTICKYRSTN_indelay after IN_DELAY;
    DBGMODE_indly <= DBGMODE_indelay after IN_DELAY;
    DBGSUBMODE_indly <= DBGSUBMODE_indelay after IN_DELAY;
    DLRSTN_indly <= DLRSTN_indelay after IN_DELAY;
    DRPDADDR_indly <= DRPDADDR_indelay after IN_DELAY;
    DRPDEN_indly <= DRPDEN_indelay after IN_DELAY;
    DRPDI_indly <= DRPDI_indelay after IN_DELAY;
    DRPDWE_indly <= DRPDWE_indelay after IN_DELAY;
    FUNCLVLRSTN_indly <= FUNCLVLRSTN_indelay after IN_DELAY;
    LL2SENDASREQL1N_indly <= LL2SENDASREQL1N_indelay after IN_DELAY;
    LL2SENDENTERL1N_indly <= LL2SENDENTERL1N_indelay after IN_DELAY;
    LL2SENDENTERL23N_indly <= LL2SENDENTERL23N_indelay after IN_DELAY;
    LL2SUSPENDNOWN_indly <= LL2SUSPENDNOWN_indelay after IN_DELAY;
    LL2TLPRCVN_indly <= LL2TLPRCVN_indelay after IN_DELAY;
    MIMRXRDATA_indly <= MIMRXRDATA_indelay after IN_DELAY;
    MIMTXRDATA_indly <= MIMTXRDATA_indelay after IN_DELAY;
    PIPERX0CHANISALIGNED_indly <= PIPERX0CHANISALIGNED_indelay after IN_DELAY;
    PIPERX0CHARISK_indly <= PIPERX0CHARISK_indelay after IN_DELAY;
    PIPERX0DATA_indly <= PIPERX0DATA_indelay after IN_DELAY;
    PIPERX0ELECIDLE_indly <= PIPERX0ELECIDLE_indelay after IN_DELAY;
    PIPERX0PHYSTATUS_indly <= PIPERX0PHYSTATUS_indelay after IN_DELAY;
    PIPERX0STATUS_indly <= PIPERX0STATUS_indelay after IN_DELAY;
    PIPERX0VALID_indly <= PIPERX0VALID_indelay after IN_DELAY;
    PIPERX1CHANISALIGNED_indly <= PIPERX1CHANISALIGNED_indelay after IN_DELAY;
    PIPERX1CHARISK_indly <= PIPERX1CHARISK_indelay after IN_DELAY;
    PIPERX1DATA_indly <= PIPERX1DATA_indelay after IN_DELAY;
    PIPERX1ELECIDLE_indly <= PIPERX1ELECIDLE_indelay after IN_DELAY;
    PIPERX1PHYSTATUS_indly <= PIPERX1PHYSTATUS_indelay after IN_DELAY;
    PIPERX1STATUS_indly <= PIPERX1STATUS_indelay after IN_DELAY;
    PIPERX1VALID_indly <= PIPERX1VALID_indelay after IN_DELAY;
    PIPERX2CHANISALIGNED_indly <= PIPERX2CHANISALIGNED_indelay after IN_DELAY;
    PIPERX2CHARISK_indly <= PIPERX2CHARISK_indelay after IN_DELAY;
    PIPERX2DATA_indly <= PIPERX2DATA_indelay after IN_DELAY;
    PIPERX2ELECIDLE_indly <= PIPERX2ELECIDLE_indelay after IN_DELAY;
    PIPERX2PHYSTATUS_indly <= PIPERX2PHYSTATUS_indelay after IN_DELAY;
    PIPERX2STATUS_indly <= PIPERX2STATUS_indelay after IN_DELAY;
    PIPERX2VALID_indly <= PIPERX2VALID_indelay after IN_DELAY;
    PIPERX3CHANISALIGNED_indly <= PIPERX3CHANISALIGNED_indelay after IN_DELAY;
    PIPERX3CHARISK_indly <= PIPERX3CHARISK_indelay after IN_DELAY;
    PIPERX3DATA_indly <= PIPERX3DATA_indelay after IN_DELAY;
    PIPERX3ELECIDLE_indly <= PIPERX3ELECIDLE_indelay after IN_DELAY;
    PIPERX3PHYSTATUS_indly <= PIPERX3PHYSTATUS_indelay after IN_DELAY;
    PIPERX3STATUS_indly <= PIPERX3STATUS_indelay after IN_DELAY;
    PIPERX3VALID_indly <= PIPERX3VALID_indelay after IN_DELAY;
    PIPERX4CHANISALIGNED_indly <= PIPERX4CHANISALIGNED_indelay after IN_DELAY;
    PIPERX4CHARISK_indly <= PIPERX4CHARISK_indelay after IN_DELAY;
    PIPERX4DATA_indly <= PIPERX4DATA_indelay after IN_DELAY;
    PIPERX4ELECIDLE_indly <= PIPERX4ELECIDLE_indelay after IN_DELAY;
    PIPERX4PHYSTATUS_indly <= PIPERX4PHYSTATUS_indelay after IN_DELAY;
    PIPERX4STATUS_indly <= PIPERX4STATUS_indelay after IN_DELAY;
    PIPERX4VALID_indly <= PIPERX4VALID_indelay after IN_DELAY;
    PIPERX5CHANISALIGNED_indly <= PIPERX5CHANISALIGNED_indelay after IN_DELAY;
    PIPERX5CHARISK_indly <= PIPERX5CHARISK_indelay after IN_DELAY;
    PIPERX5DATA_indly <= PIPERX5DATA_indelay after IN_DELAY;
    PIPERX5ELECIDLE_indly <= PIPERX5ELECIDLE_indelay after IN_DELAY;
    PIPERX5PHYSTATUS_indly <= PIPERX5PHYSTATUS_indelay after IN_DELAY;
    PIPERX5STATUS_indly <= PIPERX5STATUS_indelay after IN_DELAY;
    PIPERX5VALID_indly <= PIPERX5VALID_indelay after IN_DELAY;
    PIPERX6CHANISALIGNED_indly <= PIPERX6CHANISALIGNED_indelay after IN_DELAY;
    PIPERX6CHARISK_indly <= PIPERX6CHARISK_indelay after IN_DELAY;
    PIPERX6DATA_indly <= PIPERX6DATA_indelay after IN_DELAY;
    PIPERX6ELECIDLE_indly <= PIPERX6ELECIDLE_indelay after IN_DELAY;
    PIPERX6PHYSTATUS_indly <= PIPERX6PHYSTATUS_indelay after IN_DELAY;
    PIPERX6STATUS_indly <= PIPERX6STATUS_indelay after IN_DELAY;
    PIPERX6VALID_indly <= PIPERX6VALID_indelay after IN_DELAY;
    PIPERX7CHANISALIGNED_indly <= PIPERX7CHANISALIGNED_indelay after IN_DELAY;
    PIPERX7CHARISK_indly <= PIPERX7CHARISK_indelay after IN_DELAY;
    PIPERX7DATA_indly <= PIPERX7DATA_indelay after IN_DELAY;
    PIPERX7ELECIDLE_indly <= PIPERX7ELECIDLE_indelay after IN_DELAY;
    PIPERX7PHYSTATUS_indly <= PIPERX7PHYSTATUS_indelay after IN_DELAY;
    PIPERX7STATUS_indly <= PIPERX7STATUS_indelay after IN_DELAY;
    PIPERX7VALID_indly <= PIPERX7VALID_indelay after IN_DELAY;
    PL2DIRECTEDLSTATE_indly <= PL2DIRECTEDLSTATE_indelay after IN_DELAY;
    PLDBGMODE_indly <= PLDBGMODE_indelay after IN_DELAY;
    PLDIRECTEDLINKAUTON_indly <= PLDIRECTEDLINKAUTON_indelay after IN_DELAY;
    PLDIRECTEDLINKCHANGE_indly <= PLDIRECTEDLINKCHANGE_indelay after IN_DELAY;
    PLDIRECTEDLINKSPEED_indly <= PLDIRECTEDLINKSPEED_indelay after IN_DELAY;
    PLDIRECTEDLINKWIDTH_indly <= PLDIRECTEDLINKWIDTH_indelay after IN_DELAY;
    PLDOWNSTREAMDEEMPHSOURCE_indly <= PLDOWNSTREAMDEEMPHSOURCE_indelay after IN_DELAY;
    PLRSTN_indly <= PLRSTN_indelay after IN_DELAY;
    PLTRANSMITHOTRST_indly <= PLTRANSMITHOTRST_indelay after IN_DELAY;
    PLUPSTREAMPREFERDEEMPH_indly <= PLUPSTREAMPREFERDEEMPH_indelay after IN_DELAY;
    SYSRSTN_indly <= SYSRSTN_indelay after IN_DELAY;
    TL2ASPMSUSPENDCREDITCHECKN_indly <= TL2ASPMSUSPENDCREDITCHECKN_indelay after IN_DELAY;
    TL2PPMSUSPENDREQN_indly <= TL2PPMSUSPENDREQN_indelay after IN_DELAY;
    TLRSTN_indly <= TLRSTN_indelay after IN_DELAY;
    TRNFCSEL_indly <= TRNFCSEL_indelay after IN_DELAY;
    TRNRDSTRDYN_indly <= TRNRDSTRDYN_indelay after IN_DELAY;
    TRNRNPOKN_indly <= TRNRNPOKN_indelay after IN_DELAY;
    TRNTCFGGNTN_indly <= TRNTCFGGNTN_indelay after IN_DELAY;
    TRNTDLLPDATA_indly <= TRNTDLLPDATA_indelay after IN_DELAY;
    TRNTDLLPSRCRDYN_indly <= TRNTDLLPSRCRDYN_indelay after IN_DELAY;
    TRNTD_indly <= TRNTD_indelay after IN_DELAY;
    TRNTECRCGENN_indly <= TRNTECRCGENN_indelay after IN_DELAY;
    TRNTEOFN_indly <= TRNTEOFN_indelay after IN_DELAY;
    TRNTERRFWDN_indly <= TRNTERRFWDN_indelay after IN_DELAY;
    TRNTREMN_indly <= TRNTREMN_indelay after IN_DELAY;
    TRNTSOFN_indly <= TRNTSOFN_indelay after IN_DELAY;
    TRNTSRCDSCN_indly <= TRNTSRCDSCN_indelay after IN_DELAY;
    TRNTSRCRDYN_indly <= TRNTSRCRDYN_indelay after IN_DELAY;
    TRNTSTRN_indly <= TRNTSTRN_indelay after IN_DELAY;
    
-- <!--Aldec correction start
	GSR_local <= GSR;
-- Aldec correction end -->

    PCIE_2_0_INST : PCIE_2_0_WRAP
      generic map (
        AER_BASE_PTR         => AER_BASE_PTR_STRING,
        AER_CAP_ECRC_CHECK_CAPABLE => AER_CAP_ECRC_CHECK_CAPABLE_STRING,
        AER_CAP_ECRC_GEN_CAPABLE => AER_CAP_ECRC_GEN_CAPABLE_STRING,
        AER_CAP_ID           => AER_CAP_ID_STRING,
        AER_CAP_INT_MSG_NUM_MSI => AER_CAP_INT_MSG_NUM_MSI_STRING,
        AER_CAP_INT_MSG_NUM_MSIX => AER_CAP_INT_MSG_NUM_MSIX_STRING,
        AER_CAP_NEXTPTR      => AER_CAP_NEXTPTR_STRING,
        AER_CAP_ON           => AER_CAP_ON_STRING,
        AER_CAP_PERMIT_ROOTERR_UPDATE => AER_CAP_PERMIT_ROOTERR_UPDATE_STRING,
        AER_CAP_VERSION      => AER_CAP_VERSION_STRING,
        ALLOW_X8_GEN2        => ALLOW_X8_GEN2_STRING,
        BAR0                 => BAR0_STRING,
        BAR1                 => BAR1_STRING,
        BAR2                 => BAR2_STRING,
        BAR3                 => BAR3_STRING,
        BAR4                 => BAR4_STRING,
        BAR5                 => BAR5_STRING,
        CAPABILITIES_PTR     => CAPABILITIES_PTR_STRING,
        CARDBUS_CIS_POINTER  => CARDBUS_CIS_POINTER_STRING,
        CLASS_CODE           => CLASS_CODE_STRING,
        CMD_INTX_IMPLEMENTED => CMD_INTX_IMPLEMENTED_STRING,
        CPL_TIMEOUT_DISABLE_SUPPORTED => CPL_TIMEOUT_DISABLE_SUPPORTED_STRING,
        CPL_TIMEOUT_RANGES_SUPPORTED => CPL_TIMEOUT_RANGES_SUPPORTED_STRING,
        CRM_MODULE_RSTS      => CRM_MODULE_RSTS_STRING,
        DEVICE_ID            => DEVICE_ID_STRING,
        DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE => DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_STRING,
        DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE => DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_STRING,
        DEV_CAP_ENDPOINT_L0S_LATENCY => DEV_CAP_ENDPOINT_L0S_LATENCY,
        DEV_CAP_ENDPOINT_L1_LATENCY => DEV_CAP_ENDPOINT_L1_LATENCY,
        DEV_CAP_EXT_TAG_SUPPORTED => DEV_CAP_EXT_TAG_SUPPORTED_STRING,
        DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE => DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_STRING,
        DEV_CAP_MAX_PAYLOAD_SUPPORTED => DEV_CAP_MAX_PAYLOAD_SUPPORTED,
        DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT => DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT,
        DEV_CAP_ROLE_BASED_ERROR => DEV_CAP_ROLE_BASED_ERROR_STRING,
        DEV_CAP_RSVD_14_12   => DEV_CAP_RSVD_14_12,
        DEV_CAP_RSVD_17_16   => DEV_CAP_RSVD_17_16,
        DEV_CAP_RSVD_31_29   => DEV_CAP_RSVD_31_29,
        DEV_CONTROL_AUX_POWER_SUPPORTED => DEV_CONTROL_AUX_POWER_SUPPORTED_STRING,
        DISABLE_ASPM_L1_TIMER => DISABLE_ASPM_L1_TIMER_STRING,
        DISABLE_BAR_FILTERING => DISABLE_BAR_FILTERING_STRING,
        DISABLE_ID_CHECK     => DISABLE_ID_CHECK_STRING,
        DISABLE_LANE_REVERSAL => DISABLE_LANE_REVERSAL_STRING,
        DISABLE_RX_TC_FILTER => DISABLE_RX_TC_FILTER_STRING,
        DISABLE_SCRAMBLING   => DISABLE_SCRAMBLING_STRING,
        DNSTREAM_LINK_NUM    => DNSTREAM_LINK_NUM_STRING,
        DSN_BASE_PTR         => DSN_BASE_PTR_STRING,
        DSN_CAP_ID           => DSN_CAP_ID_STRING,
        DSN_CAP_NEXTPTR      => DSN_CAP_NEXTPTR_STRING,
        DSN_CAP_ON           => DSN_CAP_ON_STRING,
        DSN_CAP_VERSION      => DSN_CAP_VERSION_STRING,
        ENABLE_MSG_ROUTE     => ENABLE_MSG_ROUTE_STRING,
        ENABLE_RX_TD_ECRC_TRIM => ENABLE_RX_TD_ECRC_TRIM_STRING,
        ENTER_RVRY_EI_L0     => ENTER_RVRY_EI_L0_STRING,
        EXIT_LOOPBACK_ON_EI  => EXIT_LOOPBACK_ON_EI_STRING,
        EXPANSION_ROM        => EXPANSION_ROM_STRING,
        EXT_CFG_CAP_PTR      => EXT_CFG_CAP_PTR_STRING,
        EXT_CFG_XP_CAP_PTR   => EXT_CFG_XP_CAP_PTR_STRING,
        HEADER_TYPE          => HEADER_TYPE_STRING,
        INFER_EI             => INFER_EI_STRING,
        INTERRUPT_PIN        => INTERRUPT_PIN_STRING,
        IS_SWITCH            => IS_SWITCH_STRING,
        LAST_CONFIG_DWORD    => LAST_CONFIG_DWORD_STRING,
        LINK_CAP_ASPM_SUPPORT => LINK_CAP_ASPM_SUPPORT,
        LINK_CAP_CLOCK_POWER_MANAGEMENT => LINK_CAP_CLOCK_POWER_MANAGEMENT_STRING,
        LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP => LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_STRING,
        LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 => LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1,
        LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 => LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2,
        LINK_CAP_L0S_EXIT_LATENCY_GEN1 => LINK_CAP_L0S_EXIT_LATENCY_GEN1,
        LINK_CAP_L0S_EXIT_LATENCY_GEN2 => LINK_CAP_L0S_EXIT_LATENCY_GEN2,
        LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 => LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1,
        LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 => LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2,
        LINK_CAP_L1_EXIT_LATENCY_GEN1 => LINK_CAP_L1_EXIT_LATENCY_GEN1,
        LINK_CAP_L1_EXIT_LATENCY_GEN2 => LINK_CAP_L1_EXIT_LATENCY_GEN2,
        LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP => LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_STRING,
        LINK_CAP_MAX_LINK_SPEED => LINK_CAP_MAX_LINK_SPEED_STRING,
        LINK_CAP_MAX_LINK_WIDTH => LINK_CAP_MAX_LINK_WIDTH_STRING,
        LINK_CAP_RSVD_23_22  => LINK_CAP_RSVD_23_22,
        LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE => LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_STRING,
        LINK_CONTROL_RCB     => LINK_CONTROL_RCB,
        LINK_CTRL2_DEEMPHASIS => LINK_CTRL2_DEEMPHASIS_STRING,
        LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE => LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_STRING,
        LINK_CTRL2_TARGET_LINK_SPEED => LINK_CTRL2_TARGET_LINK_SPEED_STRING,
        LINK_STATUS_SLOT_CLOCK_CONFIG => LINK_STATUS_SLOT_CLOCK_CONFIG_STRING,
        LL_ACK_TIMEOUT       => LL_ACK_TIMEOUT_STRING,
        LL_ACK_TIMEOUT_EN    => LL_ACK_TIMEOUT_EN_STRING,
        LL_ACK_TIMEOUT_FUNC  => LL_ACK_TIMEOUT_FUNC,
        LL_REPLAY_TIMEOUT    => LL_REPLAY_TIMEOUT_STRING,
        LL_REPLAY_TIMEOUT_EN => LL_REPLAY_TIMEOUT_EN_STRING,
        LL_REPLAY_TIMEOUT_FUNC => LL_REPLAY_TIMEOUT_FUNC,
        LTSSM_MAX_LINK_WIDTH => LTSSM_MAX_LINK_WIDTH_STRING,
        MSIX_BASE_PTR        => MSIX_BASE_PTR_STRING,
        MSIX_CAP_ID          => MSIX_CAP_ID_STRING,
        MSIX_CAP_NEXTPTR     => MSIX_CAP_NEXTPTR_STRING,
        MSIX_CAP_ON          => MSIX_CAP_ON_STRING,
        MSIX_CAP_PBA_BIR     => MSIX_CAP_PBA_BIR,
        MSIX_CAP_PBA_OFFSET  => MSIX_CAP_PBA_OFFSET_STRING,
        MSIX_CAP_TABLE_BIR   => MSIX_CAP_TABLE_BIR,
        MSIX_CAP_TABLE_OFFSET => MSIX_CAP_TABLE_OFFSET_STRING,
        MSIX_CAP_TABLE_SIZE  => MSIX_CAP_TABLE_SIZE_STRING,
        MSI_BASE_PTR         => MSI_BASE_PTR_STRING,
        MSI_CAP_64_BIT_ADDR_CAPABLE => MSI_CAP_64_BIT_ADDR_CAPABLE_STRING,
        MSI_CAP_ID           => MSI_CAP_ID_STRING,
        MSI_CAP_MULTIMSGCAP  => MSI_CAP_MULTIMSGCAP,
        MSI_CAP_MULTIMSG_EXTENSION => MSI_CAP_MULTIMSG_EXTENSION,
        MSI_CAP_NEXTPTR      => MSI_CAP_NEXTPTR_STRING,
        MSI_CAP_ON           => MSI_CAP_ON_STRING,
        MSI_CAP_PER_VECTOR_MASKING_CAPABLE => MSI_CAP_PER_VECTOR_MASKING_CAPABLE_STRING,
        N_FTS_COMCLK_GEN1    => N_FTS_COMCLK_GEN1,
        N_FTS_COMCLK_GEN2    => N_FTS_COMCLK_GEN2,
        N_FTS_GEN1           => N_FTS_GEN1,
        N_FTS_GEN2           => N_FTS_GEN2,
        PCIE_BASE_PTR        => PCIE_BASE_PTR_STRING,
        PCIE_CAP_CAPABILITY_ID => PCIE_CAP_CAPABILITY_ID_STRING,
        PCIE_CAP_CAPABILITY_VERSION => PCIE_CAP_CAPABILITY_VERSION_STRING,
        PCIE_CAP_DEVICE_PORT_TYPE => PCIE_CAP_DEVICE_PORT_TYPE_STRING,
        PCIE_CAP_INT_MSG_NUM => PCIE_CAP_INT_MSG_NUM_STRING,
        PCIE_CAP_NEXTPTR     => PCIE_CAP_NEXTPTR_STRING,
        PCIE_CAP_ON          => PCIE_CAP_ON_STRING,
        PCIE_CAP_RSVD_15_14  => PCIE_CAP_RSVD_15_14,
        PCIE_CAP_SLOT_IMPLEMENTED => PCIE_CAP_SLOT_IMPLEMENTED_STRING,
        PCIE_REVISION        => PCIE_REVISION,
        PGL0_LANE            => PGL0_LANE,
        PGL1_LANE            => PGL1_LANE,
        PGL2_LANE            => PGL2_LANE,
        PGL3_LANE            => PGL3_LANE,
        PGL4_LANE            => PGL4_LANE,
        PGL5_LANE            => PGL5_LANE,
        PGL6_LANE            => PGL6_LANE,
        PGL7_LANE            => PGL7_LANE,
        PL_AUTO_CONFIG       => PL_AUTO_CONFIG,
        PL_FAST_TRAIN        => PL_FAST_TRAIN_STRING,
        PM_BASE_PTR          => PM_BASE_PTR_STRING,
        PM_CAP_AUXCURRENT    => PM_CAP_AUXCURRENT,
        PM_CAP_D1SUPPORT     => PM_CAP_D1SUPPORT_STRING,
        PM_CAP_D2SUPPORT     => PM_CAP_D2SUPPORT_STRING,
        PM_CAP_DSI           => PM_CAP_DSI_STRING,
        PM_CAP_ID            => PM_CAP_ID_STRING,
        PM_CAP_NEXTPTR       => PM_CAP_NEXTPTR_STRING,
        PM_CAP_ON            => PM_CAP_ON_STRING,
        PM_CAP_PMESUPPORT    => PM_CAP_PMESUPPORT_STRING,
        PM_CAP_PME_CLOCK     => PM_CAP_PME_CLOCK_STRING,
        PM_CAP_RSVD_04       => PM_CAP_RSVD_04,
        PM_CAP_VERSION       => PM_CAP_VERSION,
        PM_CSR_B2B3          => PM_CSR_B2B3_STRING,
        PM_CSR_BPCCEN        => PM_CSR_BPCCEN_STRING,
        PM_CSR_NOSOFTRST     => PM_CSR_NOSOFTRST_STRING,
        PM_DATA0             => PM_DATA0_STRING,
        PM_DATA1             => PM_DATA1_STRING,
        PM_DATA2             => PM_DATA2_STRING,
        PM_DATA3             => PM_DATA3_STRING,
        PM_DATA4             => PM_DATA4_STRING,
        PM_DATA5             => PM_DATA5_STRING,
        PM_DATA6             => PM_DATA6_STRING,
        PM_DATA7             => PM_DATA7_STRING,
        PM_DATA_SCALE0       => PM_DATA_SCALE0_STRING,
        PM_DATA_SCALE1       => PM_DATA_SCALE1_STRING,
        PM_DATA_SCALE2       => PM_DATA_SCALE2_STRING,
        PM_DATA_SCALE3       => PM_DATA_SCALE3_STRING,
        PM_DATA_SCALE4       => PM_DATA_SCALE4_STRING,
        PM_DATA_SCALE5       => PM_DATA_SCALE5_STRING,
        PM_DATA_SCALE6       => PM_DATA_SCALE6_STRING,
        PM_DATA_SCALE7       => PM_DATA_SCALE7_STRING,
        RECRC_CHK            => RECRC_CHK,
        RECRC_CHK_TRIM       => RECRC_CHK_TRIM_STRING,
        REVISION_ID          => REVISION_ID_STRING,
        ROOT_CAP_CRS_SW_VISIBILITY => ROOT_CAP_CRS_SW_VISIBILITY_STRING,
        SELECT_DLL_IF        => SELECT_DLL_IF_STRING,
        SIM_VERSION          => SIM_VERSION,
        SLOT_CAP_ATT_BUTTON_PRESENT => SLOT_CAP_ATT_BUTTON_PRESENT_STRING,
        SLOT_CAP_ATT_INDICATOR_PRESENT => SLOT_CAP_ATT_INDICATOR_PRESENT_STRING,
        SLOT_CAP_ELEC_INTERLOCK_PRESENT => SLOT_CAP_ELEC_INTERLOCK_PRESENT_STRING,
        SLOT_CAP_HOTPLUG_CAPABLE => SLOT_CAP_HOTPLUG_CAPABLE_STRING,
        SLOT_CAP_HOTPLUG_SURPRISE => SLOT_CAP_HOTPLUG_SURPRISE_STRING,
        SLOT_CAP_MRL_SENSOR_PRESENT => SLOT_CAP_MRL_SENSOR_PRESENT_STRING,
        SLOT_CAP_NO_CMD_COMPLETED_SUPPORT => SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_STRING,
        SLOT_CAP_PHYSICAL_SLOT_NUM => SLOT_CAP_PHYSICAL_SLOT_NUM_STRING,
        SLOT_CAP_POWER_CONTROLLER_PRESENT => SLOT_CAP_POWER_CONTROLLER_PRESENT_STRING,
        SLOT_CAP_POWER_INDICATOR_PRESENT => SLOT_CAP_POWER_INDICATOR_PRESENT_STRING,
        SLOT_CAP_SLOT_POWER_LIMIT_SCALE => SLOT_CAP_SLOT_POWER_LIMIT_SCALE,
        SLOT_CAP_SLOT_POWER_LIMIT_VALUE => SLOT_CAP_SLOT_POWER_LIMIT_VALUE_STRING,
        SPARE_BIT0           => SPARE_BIT0,
        SPARE_BIT1           => SPARE_BIT1,
        SPARE_BIT2           => SPARE_BIT2,
        SPARE_BIT3           => SPARE_BIT3,
        SPARE_BIT4           => SPARE_BIT4,
        SPARE_BIT5           => SPARE_BIT5,
        SPARE_BIT6           => SPARE_BIT6,
        SPARE_BIT7           => SPARE_BIT7,
        SPARE_BIT8           => SPARE_BIT8,
        SPARE_BYTE0          => SPARE_BYTE0_STRING,
        SPARE_BYTE1          => SPARE_BYTE1_STRING,
        SPARE_BYTE2          => SPARE_BYTE2_STRING,
        SPARE_BYTE3          => SPARE_BYTE3_STRING,
        SPARE_WORD0          => SPARE_WORD0_STRING,
        SPARE_WORD1          => SPARE_WORD1_STRING,
        SPARE_WORD2          => SPARE_WORD2_STRING,
        SPARE_WORD3          => SPARE_WORD3_STRING,
        SUBSYSTEM_ID         => SUBSYSTEM_ID_STRING,
        SUBSYSTEM_VENDOR_ID  => SUBSYSTEM_VENDOR_ID_STRING,
        TL_RBYPASS           => TL_RBYPASS_STRING,
        TL_RX_RAM_RADDR_LATENCY => TL_RX_RAM_RADDR_LATENCY,
        TL_RX_RAM_RDATA_LATENCY => TL_RX_RAM_RDATA_LATENCY,
        TL_RX_RAM_WRITE_LATENCY => TL_RX_RAM_WRITE_LATENCY,
        TL_TFC_DISABLE       => TL_TFC_DISABLE_STRING,
        TL_TX_CHECKS_DISABLE => TL_TX_CHECKS_DISABLE_STRING,
        TL_TX_RAM_RADDR_LATENCY => TL_TX_RAM_RADDR_LATENCY,
        TL_TX_RAM_RDATA_LATENCY => TL_TX_RAM_RDATA_LATENCY,
        TL_TX_RAM_WRITE_LATENCY => TL_TX_RAM_WRITE_LATENCY,
        UPCONFIG_CAPABLE     => UPCONFIG_CAPABLE_STRING,
        UPSTREAM_FACING      => UPSTREAM_FACING_STRING,
        UR_INV_REQ           => UR_INV_REQ_STRING,
        USER_CLK_FREQ        => USER_CLK_FREQ,
        VC0_CPL_INFINITE     => VC0_CPL_INFINITE_STRING,
        VC0_RX_RAM_LIMIT     => VC0_RX_RAM_LIMIT_STRING,
        VC0_TOTAL_CREDITS_CD => VC0_TOTAL_CREDITS_CD,
        VC0_TOTAL_CREDITS_CH => VC0_TOTAL_CREDITS_CH,
        VC0_TOTAL_CREDITS_NPH => VC0_TOTAL_CREDITS_NPH,
        VC0_TOTAL_CREDITS_PD => VC0_TOTAL_CREDITS_PD,
        VC0_TOTAL_CREDITS_PH => VC0_TOTAL_CREDITS_PH,
        VC0_TX_LASTPACKET    => VC0_TX_LASTPACKET,
        VC_BASE_PTR          => VC_BASE_PTR_STRING,
        VC_CAP_ID            => VC_CAP_ID_STRING,
        VC_CAP_NEXTPTR       => VC_CAP_NEXTPTR_STRING,
        VC_CAP_ON            => VC_CAP_ON_STRING,
        VC_CAP_REJECT_SNOOP_TRANSACTIONS => VC_CAP_REJECT_SNOOP_TRANSACTIONS_STRING,
        VC_CAP_VERSION       => VC_CAP_VERSION_STRING,
        VENDOR_ID            => VENDOR_ID_STRING,
        VSEC_BASE_PTR        => VSEC_BASE_PTR_STRING,
        VSEC_CAP_HDR_ID      => VSEC_CAP_HDR_ID_STRING,
        VSEC_CAP_HDR_LENGTH  => VSEC_CAP_HDR_LENGTH_STRING,
        VSEC_CAP_HDR_REVISION => VSEC_CAP_HDR_REVISION_STRING,
        VSEC_CAP_ID          => VSEC_CAP_ID_STRING,
        VSEC_CAP_IS_LINK_VISIBLE => VSEC_CAP_IS_LINK_VISIBLE_STRING,
        VSEC_CAP_NEXTPTR     => VSEC_CAP_NEXTPTR_STRING,
        VSEC_CAP_ON          => VSEC_CAP_ON_STRING,
        VSEC_CAP_VERSION     => VSEC_CAP_VERSION_STRING
        )
      port map (
-- <!--Aldec correction start        
        GSR => GSR_local,
-- Aldec correction end --> 
        CFGAERECRCCHECKEN    => CFGAERECRCCHECKEN_outdelay,
        CFGAERECRCGENEN      => CFGAERECRCGENEN_outdelay,
        CFGCOMMANDBUSMASTERENABLE => CFGCOMMANDBUSMASTERENABLE_outdelay,
        CFGCOMMANDINTERRUPTDISABLE => CFGCOMMANDINTERRUPTDISABLE_outdelay,
        CFGCOMMANDIOENABLE   => CFGCOMMANDIOENABLE_outdelay,
        CFGCOMMANDMEMENABLE  => CFGCOMMANDMEMENABLE_outdelay,
        CFGCOMMANDSERREN     => CFGCOMMANDSERREN_outdelay,
        CFGDEVCONTROL2CPLTIMEOUTDIS => CFGDEVCONTROL2CPLTIMEOUTDIS_outdelay,
        CFGDEVCONTROL2CPLTIMEOUTVAL => CFGDEVCONTROL2CPLTIMEOUTVAL_outdelay,
        CFGDEVCONTROLAUXPOWEREN => CFGDEVCONTROLAUXPOWEREN_outdelay,
        CFGDEVCONTROLCORRERRREPORTINGEN => CFGDEVCONTROLCORRERRREPORTINGEN_outdelay,
        CFGDEVCONTROLENABLERO => CFGDEVCONTROLENABLERO_outdelay,
        CFGDEVCONTROLEXTTAGEN => CFGDEVCONTROLEXTTAGEN_outdelay,
        CFGDEVCONTROLFATALERRREPORTINGEN => CFGDEVCONTROLFATALERRREPORTINGEN_outdelay,
        CFGDEVCONTROLMAXPAYLOAD => CFGDEVCONTROLMAXPAYLOAD_outdelay,
        CFGDEVCONTROLMAXREADREQ => CFGDEVCONTROLMAXREADREQ_outdelay,
        CFGDEVCONTROLNONFATALREPORTINGEN => CFGDEVCONTROLNONFATALREPORTINGEN_outdelay,
        CFGDEVCONTROLNOSNOOPEN => CFGDEVCONTROLNOSNOOPEN_outdelay,
        CFGDEVCONTROLPHANTOMEN => CFGDEVCONTROLPHANTOMEN_outdelay,
        CFGDEVCONTROLURERRREPORTINGEN => CFGDEVCONTROLURERRREPORTINGEN_outdelay,
        CFGDEVSTATUSCORRERRDETECTED => CFGDEVSTATUSCORRERRDETECTED_outdelay,
        CFGDEVSTATUSFATALERRDETECTED => CFGDEVSTATUSFATALERRDETECTED_outdelay,
        CFGDEVSTATUSNONFATALERRDETECTED => CFGDEVSTATUSNONFATALERRDETECTED_outdelay,
        CFGDEVSTATUSURDETECTED => CFGDEVSTATUSURDETECTED_outdelay,
        CFGDO                => CFGDO_outdelay,
        CFGERRAERHEADERLOGSETN => CFGERRAERHEADERLOGSETN_outdelay,
        CFGERRCPLRDYN        => CFGERRCPLRDYN_outdelay,
        CFGINTERRUPTDO       => CFGINTERRUPTDO_outdelay,
        CFGINTERRUPTMMENABLE => CFGINTERRUPTMMENABLE_outdelay,
        CFGINTERRUPTMSIENABLE => CFGINTERRUPTMSIENABLE_outdelay,
        CFGINTERRUPTMSIXENABLE => CFGINTERRUPTMSIXENABLE_outdelay,
        CFGINTERRUPTMSIXFM   => CFGINTERRUPTMSIXFM_outdelay,
        CFGINTERRUPTRDYN     => CFGINTERRUPTRDYN_outdelay,
        CFGLINKCONTROLASPMCONTROL => CFGLINKCONTROLASPMCONTROL_outdelay,
        CFGLINKCONTROLAUTOBANDWIDTHINTEN => CFGLINKCONTROLAUTOBANDWIDTHINTEN_outdelay,
        CFGLINKCONTROLBANDWIDTHINTEN => CFGLINKCONTROLBANDWIDTHINTEN_outdelay,
        CFGLINKCONTROLCLOCKPMEN => CFGLINKCONTROLCLOCKPMEN_outdelay,
        CFGLINKCONTROLCOMMONCLOCK => CFGLINKCONTROLCOMMONCLOCK_outdelay,
        CFGLINKCONTROLEXTENDEDSYNC => CFGLINKCONTROLEXTENDEDSYNC_outdelay,
        CFGLINKCONTROLHWAUTOWIDTHDIS => CFGLINKCONTROLHWAUTOWIDTHDIS_outdelay,
        CFGLINKCONTROLLINKDISABLE => CFGLINKCONTROLLINKDISABLE_outdelay,
        CFGLINKCONTROLRCB    => CFGLINKCONTROLRCB_outdelay,
        CFGLINKCONTROLRETRAINLINK => CFGLINKCONTROLRETRAINLINK_outdelay,
        CFGLINKSTATUSAUTOBANDWIDTHSTATUS => CFGLINKSTATUSAUTOBANDWIDTHSTATUS_outdelay,
        CFGLINKSTATUSBANDWITHSTATUS => CFGLINKSTATUSBANDWITHSTATUS_outdelay,
        CFGLINKSTATUSCURRENTSPEED => CFGLINKSTATUSCURRENTSPEED_outdelay,
        CFGLINKSTATUSDLLACTIVE => CFGLINKSTATUSDLLACTIVE_outdelay,
        CFGLINKSTATUSLINKTRAINING => CFGLINKSTATUSLINKTRAINING_outdelay,
        CFGLINKSTATUSNEGOTIATEDWIDTH => CFGLINKSTATUSNEGOTIATEDWIDTH_outdelay,
        CFGMSGDATA           => CFGMSGDATA_outdelay,
        CFGMSGRECEIVED       => CFGMSGRECEIVED_outdelay,
        CFGMSGRECEIVEDASSERTINTA => CFGMSGRECEIVEDASSERTINTA_outdelay,
        CFGMSGRECEIVEDASSERTINTB => CFGMSGRECEIVEDASSERTINTB_outdelay,
        CFGMSGRECEIVEDASSERTINTC => CFGMSGRECEIVEDASSERTINTC_outdelay,
        CFGMSGRECEIVEDASSERTINTD => CFGMSGRECEIVEDASSERTINTD_outdelay,
        CFGMSGRECEIVEDDEASSERTINTA => CFGMSGRECEIVEDDEASSERTINTA_outdelay,
        CFGMSGRECEIVEDDEASSERTINTB => CFGMSGRECEIVEDDEASSERTINTB_outdelay,
        CFGMSGRECEIVEDDEASSERTINTC => CFGMSGRECEIVEDDEASSERTINTC_outdelay,
        CFGMSGRECEIVEDDEASSERTINTD => CFGMSGRECEIVEDDEASSERTINTD_outdelay,
        CFGMSGRECEIVEDERRCOR => CFGMSGRECEIVEDERRCOR_outdelay,
        CFGMSGRECEIVEDERRFATAL => CFGMSGRECEIVEDERRFATAL_outdelay,
        CFGMSGRECEIVEDERRNONFATAL => CFGMSGRECEIVEDERRNONFATAL_outdelay,
        CFGMSGRECEIVEDPMASNAK => CFGMSGRECEIVEDPMASNAK_outdelay,
        CFGMSGRECEIVEDPMETO  => CFGMSGRECEIVEDPMETO_outdelay,
        CFGMSGRECEIVEDPMETOACK => CFGMSGRECEIVEDPMETOACK_outdelay,
        CFGMSGRECEIVEDPMPME  => CFGMSGRECEIVEDPMPME_outdelay,
        CFGMSGRECEIVEDSETSLOTPOWERLIMIT => CFGMSGRECEIVEDSETSLOTPOWERLIMIT_outdelay,
        CFGMSGRECEIVEDUNLOCK => CFGMSGRECEIVEDUNLOCK_outdelay,
        CFGPCIELINKSTATE     => CFGPCIELINKSTATE_outdelay,
        CFGPMCSRPMEEN        => CFGPMCSRPMEEN_outdelay, 
        CFGPMCSRPMESTATUS    => CFGPMCSRPMESTATUS_outdelay,
        CFGPMCSRPOWERSTATE   => CFGPMCSRPOWERSTATE_outdelay,
        CFGPMRCVASREQL1N     => CFGPMRCVASREQL1N_outdelay,
        CFGPMRCVENTERL1N     => CFGPMRCVENTERL1N_outdelay,
        CFGPMRCVENTERL23N    => CFGPMRCVENTERL23N_outdelay,
        CFGPMRCVREQACKN      => CFGPMRCVREQACKN_outdelay,
        CFGRDWRDONEN         => CFGRDWRDONEN_outdelay,
        CFGSLOTCONTROLELECTROMECHILCTLPULSE => CFGSLOTCONTROLELECTROMECHILCTLPULSE_outdelay,
        CFGTRANSACTION       => CFGTRANSACTION_outdelay,
        CFGTRANSACTIONADDR   => CFGTRANSACTIONADDR_outdelay,
        CFGTRANSACTIONTYPE   => CFGTRANSACTIONTYPE_outdelay,
        CFGVCTCVCMAP         => CFGVCTCVCMAP_outdelay,
        DBGSCLRA             => DBGSCLRA_outdelay,
        DBGSCLRB             => DBGSCLRB_outdelay,
        DBGSCLRC             => DBGSCLRC_outdelay,
        DBGSCLRD             => DBGSCLRD_outdelay,
        DBGSCLRE             => DBGSCLRE_outdelay,
        DBGSCLRF             => DBGSCLRF_outdelay,
        DBGSCLRG             => DBGSCLRG_outdelay,
        DBGSCLRH             => DBGSCLRH_outdelay,
        DBGSCLRI             => DBGSCLRI_outdelay,
        DBGSCLRJ             => DBGSCLRJ_outdelay,
        DBGSCLRK             => DBGSCLRK_outdelay,
        DBGVECA              => DBGVECA_outdelay,
        DBGVECB              => DBGVECB_outdelay,
        DBGVECC              => DBGVECC_outdelay,
        DRPDO                => DRPDO_outdelay,
        DRPDRDY              => DRPDRDY_outdelay,
        LL2BADDLLPERRN       => LL2BADDLLPERRN_outdelay,
        LL2BADTLPERRN        => LL2BADTLPERRN_outdelay,
        LL2PROTOCOLERRN      => LL2PROTOCOLERRN_outdelay,
        LL2REPLAYROERRN      => LL2REPLAYROERRN_outdelay,
        LL2REPLAYTOERRN      => LL2REPLAYTOERRN_outdelay,
        LL2SUSPENDOKN        => LL2SUSPENDOKN_outdelay,
        LL2TFCINIT1SEQN      => LL2TFCINIT1SEQN_outdelay,
        LL2TFCINIT2SEQN      => LL2TFCINIT2SEQN_outdelay,
        LNKCLKEN             => LNKCLKEN_outdelay,
        MIMRXRADDR           => MIMRXRADDR_outdelay,
        MIMRXRCE             => MIMRXRCE_outdelay,
        MIMRXREN             => MIMRXREN_outdelay,
        MIMRXWADDR           => MIMRXWADDR_outdelay,
        MIMRXWDATA           => MIMRXWDATA_outdelay,
        MIMRXWEN             => MIMRXWEN_outdelay,
        MIMTXRADDR           => MIMTXRADDR_outdelay,
        MIMTXRCE             => MIMTXRCE_outdelay,
        MIMTXREN             => MIMTXREN_outdelay,
        MIMTXWADDR           => MIMTXWADDR_outdelay,
        MIMTXWDATA           => MIMTXWDATA_outdelay,
        MIMTXWEN             => MIMTXWEN_outdelay,
        PIPERX0POLARITY      => PIPERX0POLARITY_outdelay,
        PIPERX1POLARITY      => PIPERX1POLARITY_outdelay,
        PIPERX2POLARITY      => PIPERX2POLARITY_outdelay,
        PIPERX3POLARITY      => PIPERX3POLARITY_outdelay,
        PIPERX4POLARITY      => PIPERX4POLARITY_outdelay,
        PIPERX5POLARITY      => PIPERX5POLARITY_outdelay,
        PIPERX6POLARITY      => PIPERX6POLARITY_outdelay,
        PIPERX7POLARITY      => PIPERX7POLARITY_outdelay,
        PIPETX0CHARISK       => PIPETX0CHARISK_outdelay,
        PIPETX0COMPLIANCE    => PIPETX0COMPLIANCE_outdelay,
        PIPETX0DATA          => PIPETX0DATA_outdelay,
        PIPETX0ELECIDLE      => PIPETX0ELECIDLE_outdelay,
        PIPETX0POWERDOWN     => PIPETX0POWERDOWN_outdelay,
        PIPETX1CHARISK       => PIPETX1CHARISK_outdelay,
        PIPETX1COMPLIANCE    => PIPETX1COMPLIANCE_outdelay,
        PIPETX1DATA          => PIPETX1DATA_outdelay,
        PIPETX1ELECIDLE      => PIPETX1ELECIDLE_outdelay,
        PIPETX1POWERDOWN     => PIPETX1POWERDOWN_outdelay,
        PIPETX2CHARISK       => PIPETX2CHARISK_outdelay,
        PIPETX2COMPLIANCE    => PIPETX2COMPLIANCE_outdelay,
        PIPETX2DATA          => PIPETX2DATA_outdelay,
        PIPETX2ELECIDLE      => PIPETX2ELECIDLE_outdelay,
        PIPETX2POWERDOWN     => PIPETX2POWERDOWN_outdelay,
        PIPETX3CHARISK       => PIPETX3CHARISK_outdelay,
        PIPETX3COMPLIANCE    => PIPETX3COMPLIANCE_outdelay,
        PIPETX3DATA          => PIPETX3DATA_outdelay,
        PIPETX3ELECIDLE      => PIPETX3ELECIDLE_outdelay,
        PIPETX3POWERDOWN     => PIPETX3POWERDOWN_outdelay,
        PIPETX4CHARISK       => PIPETX4CHARISK_outdelay,
        PIPETX4COMPLIANCE    => PIPETX4COMPLIANCE_outdelay,
        PIPETX4DATA          => PIPETX4DATA_outdelay,
        PIPETX4ELECIDLE      => PIPETX4ELECIDLE_outdelay,
        PIPETX4POWERDOWN     => PIPETX4POWERDOWN_outdelay,
        PIPETX5CHARISK       => PIPETX5CHARISK_outdelay,
        PIPETX5COMPLIANCE    => PIPETX5COMPLIANCE_outdelay,
        PIPETX5DATA          => PIPETX5DATA_outdelay,
        PIPETX5ELECIDLE      => PIPETX5ELECIDLE_outdelay,
        PIPETX5POWERDOWN     => PIPETX5POWERDOWN_outdelay,
        PIPETX6CHARISK       => PIPETX6CHARISK_outdelay,
        PIPETX6COMPLIANCE    => PIPETX6COMPLIANCE_outdelay,
        PIPETX6DATA          => PIPETX6DATA_outdelay,
        PIPETX6ELECIDLE      => PIPETX6ELECIDLE_outdelay,
        PIPETX6POWERDOWN     => PIPETX6POWERDOWN_outdelay,
        PIPETX7CHARISK       => PIPETX7CHARISK_outdelay,
        PIPETX7COMPLIANCE    => PIPETX7COMPLIANCE_outdelay,
        PIPETX7DATA          => PIPETX7DATA_outdelay,
        PIPETX7ELECIDLE      => PIPETX7ELECIDLE_outdelay,
        PIPETX7POWERDOWN     => PIPETX7POWERDOWN_outdelay,
        PIPETXDEEMPH         => PIPETXDEEMPH_outdelay,
        PIPETXMARGIN         => PIPETXMARGIN_outdelay,
        PIPETXRATE           => PIPETXRATE_outdelay,
        PIPETXRCVRDET        => PIPETXRCVRDET_outdelay,
        PIPETXRESET          => PIPETXRESET_outdelay,
        PL2LINKUPN           => PL2LINKUPN_outdelay,
        PL2RECEIVERERRN      => PL2RECEIVERERRN_outdelay,
        PL2RECOVERYN         => PL2RECOVERYN_outdelay,
        PL2RXELECIDLE        => PL2RXELECIDLE_outdelay,
        PL2SUSPENDOK         => PL2SUSPENDOK_outdelay,
        PLDBGVEC             => PLDBGVEC_outdelay,
        PLINITIALLINKWIDTH   => PLINITIALLINKWIDTH_outdelay,
        PLLANEREVERSALMODE   => PLLANEREVERSALMODE_outdelay,
        PLLINKGEN2CAP        => PLLINKGEN2CAP_outdelay,
        PLLINKPARTNERGEN2SUPPORTED => PLLINKPARTNERGEN2SUPPORTED_outdelay,
        PLLINKUPCFGCAP       => PLLINKUPCFGCAP_outdelay,
        PLLTSSMSTATE         => PLLTSSMSTATE_outdelay,
        PLPHYLNKUPN          => PLPHYLNKUPN_outdelay,
        PLRECEIVEDHOTRST     => PLRECEIVEDHOTRST_outdelay,
        PLRXPMSTATE          => PLRXPMSTATE_outdelay,
        PLSELLNKRATE         => PLSELLNKRATE_outdelay,
        PLSELLNKWIDTH        => PLSELLNKWIDTH_outdelay,
        PLTXPMSTATE          => PLTXPMSTATE_outdelay,
        RECEIVEDFUNCLVLRSTN  => RECEIVEDFUNCLVLRSTN_outdelay,
        TL2ASPMSUSPENDCREDITCHECKOKN => TL2ASPMSUSPENDCREDITCHECKOKN_outdelay,
        TL2ASPMSUSPENDREQN   => TL2ASPMSUSPENDREQN_outdelay,
        TL2PPMSUSPENDOKN     => TL2PPMSUSPENDOKN_outdelay,
        TRNFCCPLD            => TRNFCCPLD_outdelay,
        TRNFCCPLH            => TRNFCCPLH_outdelay,
        TRNFCNPD             => TRNFCNPD_outdelay,
        TRNFCNPH             => TRNFCNPH_outdelay,
        TRNFCPD              => TRNFCPD_outdelay,
        TRNFCPH              => TRNFCPH_outdelay,
        TRNLNKUPN            => TRNLNKUPN_outdelay,
        TRNRBARHITN          => TRNRBARHITN_outdelay,
        TRNRD                => TRNRD_outdelay,
        TRNRDLLPDATA         => TRNRDLLPDATA_outdelay,
        TRNRDLLPSRCRDYN      => TRNRDLLPSRCRDYN_outdelay,
        TRNRECRCERRN         => TRNRECRCERRN_outdelay,
        TRNREOFN             => TRNREOFN_outdelay,
        TRNRERRFWDN          => TRNRERRFWDN_outdelay,
        TRNRREMN             => TRNRREMN_outdelay,
        TRNRSOFN             => TRNRSOFN_outdelay,
        TRNRSRCDSCN          => TRNRSRCDSCN_outdelay,
        TRNRSRCRDYN          => TRNRSRCRDYN_outdelay,
        TRNTBUFAV            => TRNTBUFAV_outdelay,
        TRNTCFGREQN          => TRNTCFGREQN_outdelay,
        TRNTDLLPDSTRDYN      => TRNTDLLPDSTRDYN_outdelay,
        TRNTDSTRDYN          => TRNTDSTRDYN_outdelay,
        TRNTERRDROPN         => TRNTERRDROPN_outdelay,
        USERRSTN             => USERRSTN_outdelay,
        CFGBYTEENN           => CFGBYTEENN_indly,
        CFGDI                => CFGDI_indly,
        CFGDSBUSNUMBER       => CFGDSBUSNUMBER_indly,
        CFGDSDEVICENUMBER    => CFGDSDEVICENUMBER_indly,
        CFGDSFUNCTIONNUMBER  => CFGDSFUNCTIONNUMBER_indly,
        CFGDSN               => CFGDSN_indly,
        CFGDWADDR            => CFGDWADDR_indly,
        CFGERRACSN           => CFGERRACSN_indly,
        CFGERRAERHEADERLOG   => CFGERRAERHEADERLOG_indly,
        CFGERRCORN           => CFGERRCORN_indly,
        CFGERRCPLABORTN      => CFGERRCPLABORTN_indly,
        CFGERRCPLTIMEOUTN    => CFGERRCPLTIMEOUTN_indly,
        CFGERRCPLUNEXPECTN   => CFGERRCPLUNEXPECTN_indly,
        CFGERRECRCN          => CFGERRECRCN_indly,
        CFGERRLOCKEDN        => CFGERRLOCKEDN_indly,
        CFGERRPOSTEDN        => CFGERRPOSTEDN_indly,
        CFGERRTLPCPLHEADER   => CFGERRTLPCPLHEADER_indly,
        CFGERRURN            => CFGERRURN_indly,
        CFGINTERRUPTASSERTN  => CFGINTERRUPTASSERTN_indly,
        CFGINTERRUPTDI       => CFGINTERRUPTDI_indly,
        CFGINTERRUPTN        => CFGINTERRUPTN_indly,
        CFGPMDIRECTASPML1N   => CFGPMDIRECTASPML1N_indly,
        CFGPMSENDPMACKN      => CFGPMSENDPMACKN_indly,
        CFGPMSENDPMETON      => CFGPMSENDPMETON_indly,
        CFGPMSENDPMNAKN      => CFGPMSENDPMNAKN_indly,
        CFGPMTURNOFFOKN      => CFGPMTURNOFFOKN_indly,
        CFGPMWAKEN           => CFGPMWAKEN_indly,
        CFGPORTNUMBER        => CFGPORTNUMBER_indly,
        CFGRDENN             => CFGRDENN_indly,
        CFGTRNPENDINGN       => CFGTRNPENDINGN_indly,
        CFGWRENN             => CFGWRENN_indly,
        CFGWRREADONLYN       => CFGWRREADONLYN_indly,
        CFGWRRW1CASRWN       => CFGWRRW1CASRWN_indly,
        CMRSTN               => CMRSTN_indly,
        CMSTICKYRSTN         => CMSTICKYRSTN_indly,
        DBGMODE              => DBGMODE_indly,
        DBGSUBMODE           => DBGSUBMODE_indly,
        DLRSTN               => DLRSTN_indly,
        DRPCLK               => DRPCLK_indly,
        DRPDADDR             => DRPDADDR_indly,
        DRPDEN               => DRPDEN_indly,
        DRPDI                => DRPDI_indly,
        DRPDWE               => DRPDWE_indly,
        FUNCLVLRSTN          => FUNCLVLRSTN_indly,
        LL2SENDASREQL1N      => LL2SENDASREQL1N_indly,
        LL2SENDENTERL1N      => LL2SENDENTERL1N_indly,
        LL2SENDENTERL23N     => LL2SENDENTERL23N_indly,
        LL2SUSPENDNOWN       => LL2SUSPENDNOWN_indly,
        LL2TLPRCVN           => LL2TLPRCVN_indly,
        MIMRXRDATA           => MIMRXRDATA_indly,
        MIMTXRDATA           => MIMTXRDATA_indly,
        PIPECLK              => PIPECLK_indly,
        PIPERX0CHANISALIGNED => PIPERX0CHANISALIGNED_indly,
        PIPERX0CHARISK       => PIPERX0CHARISK_indly,
        PIPERX0DATA          => PIPERX0DATA_indly,
        PIPERX0ELECIDLE      => PIPERX0ELECIDLE_indly,
        PIPERX0PHYSTATUS     => PIPERX0PHYSTATUS_indly,
        PIPERX0STATUS        => PIPERX0STATUS_indly,
        PIPERX0VALID         => PIPERX0VALID_indly,
        PIPERX1CHANISALIGNED => PIPERX1CHANISALIGNED_indly,
        PIPERX1CHARISK       => PIPERX1CHARISK_indly,
        PIPERX1DATA          => PIPERX1DATA_indly,
        PIPERX1ELECIDLE      => PIPERX1ELECIDLE_indly,
        PIPERX1PHYSTATUS     => PIPERX1PHYSTATUS_indly,
        PIPERX1STATUS        => PIPERX1STATUS_indly,
        PIPERX1VALID         => PIPERX1VALID_indly,
        PIPERX2CHANISALIGNED => PIPERX2CHANISALIGNED_indly,
        PIPERX2CHARISK       => PIPERX2CHARISK_indly,
        PIPERX2DATA          => PIPERX2DATA_indly,
        PIPERX2ELECIDLE      => PIPERX2ELECIDLE_indly,
        PIPERX2PHYSTATUS     => PIPERX2PHYSTATUS_indly,
        PIPERX2STATUS        => PIPERX2STATUS_indly,
        PIPERX2VALID         => PIPERX2VALID_indly,
        PIPERX3CHANISALIGNED => PIPERX3CHANISALIGNED_indly,
        PIPERX3CHARISK       => PIPERX3CHARISK_indly,
        PIPERX3DATA          => PIPERX3DATA_indly,
        PIPERX3ELECIDLE      => PIPERX3ELECIDLE_indly,
        PIPERX3PHYSTATUS     => PIPERX3PHYSTATUS_indly,
        PIPERX3STATUS        => PIPERX3STATUS_indly,
        PIPERX3VALID         => PIPERX3VALID_indly,
        PIPERX4CHANISALIGNED => PIPERX4CHANISALIGNED_indly,
        PIPERX4CHARISK       => PIPERX4CHARISK_indly,
        PIPERX4DATA          => PIPERX4DATA_indly,
        PIPERX4ELECIDLE      => PIPERX4ELECIDLE_indly,
        PIPERX4PHYSTATUS     => PIPERX4PHYSTATUS_indly,
        PIPERX4STATUS        => PIPERX4STATUS_indly,
        PIPERX4VALID         => PIPERX4VALID_indly,
        PIPERX5CHANISALIGNED => PIPERX5CHANISALIGNED_indly,
        PIPERX5CHARISK       => PIPERX5CHARISK_indly,
        PIPERX5DATA          => PIPERX5DATA_indly,
        PIPERX5ELECIDLE      => PIPERX5ELECIDLE_indly,
        PIPERX5PHYSTATUS     => PIPERX5PHYSTATUS_indly,
        PIPERX5STATUS        => PIPERX5STATUS_indly,
        PIPERX5VALID         => PIPERX5VALID_indly,
        PIPERX6CHANISALIGNED => PIPERX6CHANISALIGNED_indly,
        PIPERX6CHARISK       => PIPERX6CHARISK_indly,
        PIPERX6DATA          => PIPERX6DATA_indly,
        PIPERX6ELECIDLE      => PIPERX6ELECIDLE_indly,
        PIPERX6PHYSTATUS     => PIPERX6PHYSTATUS_indly,
        PIPERX6STATUS        => PIPERX6STATUS_indly,
        PIPERX6VALID         => PIPERX6VALID_indly,
        PIPERX7CHANISALIGNED => PIPERX7CHANISALIGNED_indly,
        PIPERX7CHARISK       => PIPERX7CHARISK_indly,
        PIPERX7DATA          => PIPERX7DATA_indly,
        PIPERX7ELECIDLE      => PIPERX7ELECIDLE_indly,
        PIPERX7PHYSTATUS     => PIPERX7PHYSTATUS_indly,
        PIPERX7STATUS        => PIPERX7STATUS_indly,
        PIPERX7VALID         => PIPERX7VALID_indly,
        PL2DIRECTEDLSTATE    => PL2DIRECTEDLSTATE_indly,
        PLDBGMODE            => PLDBGMODE_indly,
        PLDIRECTEDLINKAUTON  => PLDIRECTEDLINKAUTON_indly,
        PLDIRECTEDLINKCHANGE => PLDIRECTEDLINKCHANGE_indly,
        PLDIRECTEDLINKSPEED  => PLDIRECTEDLINKSPEED_indly,
        PLDIRECTEDLINKWIDTH  => PLDIRECTEDLINKWIDTH_indly,
        PLDOWNSTREAMDEEMPHSOURCE => PLDOWNSTREAMDEEMPHSOURCE_indly,
        PLRSTN               => PLRSTN_indly,
        PLTRANSMITHOTRST     => PLTRANSMITHOTRST_indly,
        PLUPSTREAMPREFERDEEMPH => PLUPSTREAMPREFERDEEMPH_indly,
        SYSRSTN              => SYSRSTN_indly,
        TL2ASPMSUSPENDCREDITCHECKN => TL2ASPMSUSPENDCREDITCHECKN_indly,
        TL2PPMSUSPENDREQN    => TL2PPMSUSPENDREQN_indly,
        TLRSTN               => TLRSTN_indly,
        TRNFCSEL             => TRNFCSEL_indly,
        TRNRDSTRDYN          => TRNRDSTRDYN_indly,
        TRNRNPOKN            => TRNRNPOKN_indly,
        TRNTCFGGNTN          => TRNTCFGGNTN_indly,
        TRNTD                => TRNTD_indly,
        TRNTDLLPDATA         => TRNTDLLPDATA_indly,
        TRNTDLLPSRCRDYN      => TRNTDLLPSRCRDYN_indly,
        TRNTECRCGENN         => TRNTECRCGENN_indly,
        TRNTEOFN             => TRNTEOFN_indly,
        TRNTERRFWDN          => TRNTERRFWDN_indly,
        TRNTREMN             => TRNTREMN_indly,
        TRNTSOFN             => TRNTSOFN_indly,
        TRNTSRCDSCN          => TRNTSRCDSCN_indly,
        TRNTSRCRDYN          => TRNTSRCRDYN_indly,
        TRNTSTRN             => TRNTSTRN_indly,
        USERCLK              => USERCLK_indly        
      );
    
    INIPROC : process
    begin
    case AER_CAP_ECRC_CHECK_CAPABLE is
      when FALSE   =>  AER_CAP_ECRC_CHECK_CAPABLE_BINARY <= '0';
      when TRUE    =>  AER_CAP_ECRC_CHECK_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : AER_CAP_ECRC_CHECK_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case AER_CAP_ECRC_GEN_CAPABLE is
      when FALSE   =>  AER_CAP_ECRC_GEN_CAPABLE_BINARY <= '0';
      when TRUE    =>  AER_CAP_ECRC_GEN_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : AER_CAP_ECRC_GEN_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case AER_CAP_ON is
      when FALSE   =>  AER_CAP_ON_BINARY <= '0';
      when TRUE    =>  AER_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : AER_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case AER_CAP_PERMIT_ROOTERR_UPDATE is
      when FALSE   =>  AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY <= '0';
      when TRUE    =>  AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : AER_CAP_PERMIT_ROOTERR_UPDATE is neither TRUE nor FALSE." severity error;
    end case;
    case ALLOW_X8_GEN2 is
      when FALSE   =>  ALLOW_X8_GEN2_BINARY <= '0';
      when TRUE    =>  ALLOW_X8_GEN2_BINARY <= '1';
      when others  =>  assert FALSE report "Error : ALLOW_X8_GEN2 is neither TRUE nor FALSE." severity error;
    end case;
    case CMD_INTX_IMPLEMENTED is
      when FALSE   =>  CMD_INTX_IMPLEMENTED_BINARY <= '0';
      when TRUE    =>  CMD_INTX_IMPLEMENTED_BINARY <= '1';
      when others  =>  assert FALSE report "Error : CMD_INTX_IMPLEMENTED is neither TRUE nor FALSE." severity error;
    end case;
    case CPL_TIMEOUT_DISABLE_SUPPORTED is
      when FALSE   =>  CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY <= '0';
      when TRUE    =>  CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY <= '1';
      when others  =>  assert FALSE report "Error : CPL_TIMEOUT_DISABLE_SUPPORTED is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE is
      when FALSE   =>  DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY <= '0';
      when TRUE    =>  DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE is
      when FALSE   =>  DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY <= '0';
      when TRUE    =>  DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CAP_EXT_TAG_SUPPORTED is
      when FALSE   =>  DEV_CAP_EXT_TAG_SUPPORTED_BINARY <= '0';
      when TRUE    =>  DEV_CAP_EXT_TAG_SUPPORTED_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CAP_EXT_TAG_SUPPORTED is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE is
      when FALSE   =>  DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY <= '0';
      when TRUE    =>  DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CAP_ROLE_BASED_ERROR is
      when FALSE   =>  DEV_CAP_ROLE_BASED_ERROR_BINARY <= '0';
      when TRUE    =>  DEV_CAP_ROLE_BASED_ERROR_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CAP_ROLE_BASED_ERROR is neither TRUE nor FALSE." severity error;
    end case;
    case DEV_CONTROL_AUX_POWER_SUPPORTED is
      when FALSE   =>  DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY <= '0';
      when TRUE    =>  DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DEV_CONTROL_AUX_POWER_SUPPORTED is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_ASPM_L1_TIMER is
      when FALSE   =>  DISABLE_ASPM_L1_TIMER_BINARY <= '0';
      when TRUE    =>  DISABLE_ASPM_L1_TIMER_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_ASPM_L1_TIMER is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_BAR_FILTERING is
      when FALSE   =>  DISABLE_BAR_FILTERING_BINARY <= '0';
      when TRUE    =>  DISABLE_BAR_FILTERING_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_BAR_FILTERING is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_ID_CHECK is
      when FALSE   =>  DISABLE_ID_CHECK_BINARY <= '0';
      when TRUE    =>  DISABLE_ID_CHECK_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_ID_CHECK is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_LANE_REVERSAL is
      when FALSE   =>  DISABLE_LANE_REVERSAL_BINARY <= '0';
      when TRUE    =>  DISABLE_LANE_REVERSAL_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_LANE_REVERSAL is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_RX_TC_FILTER is
      when FALSE   =>  DISABLE_RX_TC_FILTER_BINARY <= '0';
      when TRUE    =>  DISABLE_RX_TC_FILTER_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_RX_TC_FILTER is neither TRUE nor FALSE." severity error;
    end case;
    case DISABLE_SCRAMBLING is
      when FALSE   =>  DISABLE_SCRAMBLING_BINARY <= '0';
      when TRUE    =>  DISABLE_SCRAMBLING_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DISABLE_SCRAMBLING is neither TRUE nor FALSE." severity error;
    end case;
    case DSN_CAP_ON is
      when FALSE   =>  DSN_CAP_ON_BINARY <= '0';
      when TRUE    =>  DSN_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : DSN_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case ENABLE_RX_TD_ECRC_TRIM is
      when FALSE   =>  ENABLE_RX_TD_ECRC_TRIM_BINARY <= '0';
      when TRUE    =>  ENABLE_RX_TD_ECRC_TRIM_BINARY <= '1';
      when others  =>  assert FALSE report "Error : ENABLE_RX_TD_ECRC_TRIM is neither TRUE nor FALSE." severity error;
    end case;
    case ENTER_RVRY_EI_L0 is
      when FALSE   =>  ENTER_RVRY_EI_L0_BINARY <= '0';
      when TRUE    =>  ENTER_RVRY_EI_L0_BINARY <= '1';
      when others  =>  assert FALSE report "Error : ENTER_RVRY_EI_L0 is neither TRUE nor FALSE." severity error;
    end case;
    case EXIT_LOOPBACK_ON_EI is
      when FALSE   =>  EXIT_LOOPBACK_ON_EI_BINARY <= '0';
      when TRUE    =>  EXIT_LOOPBACK_ON_EI_BINARY <= '1';
      when others  =>  assert FALSE report "Error : EXIT_LOOPBACK_ON_EI is neither TRUE nor FALSE." severity error;
    end case;
    case IS_SWITCH is
      when FALSE   =>  IS_SWITCH_BINARY <= '0';
      when TRUE    =>  IS_SWITCH_BINARY <= '1';
      when others  =>  assert FALSE report "Error : IS_SWITCH is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CAP_CLOCK_POWER_MANAGEMENT is
      when FALSE   =>  LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY <= '0';
      when TRUE    =>  LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CAP_CLOCK_POWER_MANAGEMENT is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP is
      when FALSE   =>  LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY <= '0';
      when TRUE    =>  LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP is
      when FALSE   =>  LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY <= '0';
      when TRUE    =>  LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE is
      when FALSE   =>  LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY <= '0';
      when TRUE    =>  LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CONTROL_RCB is
      when  0   =>  LINK_CONTROL_RCB_BINARY <= '0';
      when  1   =>  LINK_CONTROL_RCB_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CONTROL_RCB is not in range 0 .. 1." severity error;
    end case;
    case LINK_CTRL2_DEEMPHASIS is
      when FALSE   =>  LINK_CTRL2_DEEMPHASIS_BINARY <= '0';
      when TRUE    =>  LINK_CTRL2_DEEMPHASIS_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CTRL2_DEEMPHASIS is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE is
      when FALSE   =>  LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY <= '0';
      when TRUE    =>  LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE is neither TRUE nor FALSE." severity error;
    end case;
    case LINK_STATUS_SLOT_CLOCK_CONFIG is
      when FALSE   =>  LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY <= '0';
      when TRUE    =>  LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LINK_STATUS_SLOT_CLOCK_CONFIG is neither TRUE nor FALSE." severity error;
    end case;
    case LL_ACK_TIMEOUT_EN is
      when FALSE   =>  LL_ACK_TIMEOUT_EN_BINARY <= '0';
      when TRUE    =>  LL_ACK_TIMEOUT_EN_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LL_ACK_TIMEOUT_EN is neither TRUE nor FALSE." severity error;
    end case;
    case LL_REPLAY_TIMEOUT_EN is
      when FALSE   =>  LL_REPLAY_TIMEOUT_EN_BINARY <= '0';
      when TRUE    =>  LL_REPLAY_TIMEOUT_EN_BINARY <= '1';
      when others  =>  assert FALSE report "Error : LL_REPLAY_TIMEOUT_EN is neither TRUE nor FALSE." severity error;
    end case;
    case MSIX_CAP_ON is
      when FALSE   =>  MSIX_CAP_ON_BINARY <= '0';
      when TRUE    =>  MSIX_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : MSIX_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case MSI_CAP_64_BIT_ADDR_CAPABLE is
      when FALSE   =>  MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY <= '0';
      when TRUE    =>  MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : MSI_CAP_64_BIT_ADDR_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case MSI_CAP_MULTIMSG_EXTENSION is
      when  0   =>  MSI_CAP_MULTIMSG_EXTENSION_BINARY <= '0';
      when  1   =>  MSI_CAP_MULTIMSG_EXTENSION_BINARY <= '1';
      when others  =>  assert FALSE report "Error : MSI_CAP_MULTIMSG_EXTENSION is not in range 0 .. 1." severity error;
    end case;
    case MSI_CAP_ON is
      when FALSE   =>  MSI_CAP_ON_BINARY <= '0';
      when TRUE    =>  MSI_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : MSI_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case MSI_CAP_PER_VECTOR_MASKING_CAPABLE is
      when FALSE   =>  MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY <= '0';
      when TRUE    =>  MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : MSI_CAP_PER_VECTOR_MASKING_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case PCIE_CAP_ON is
      when FALSE   =>  PCIE_CAP_ON_BINARY <= '0';
      when TRUE    =>  PCIE_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PCIE_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case PCIE_CAP_SLOT_IMPLEMENTED is
      when FALSE   =>  PCIE_CAP_SLOT_IMPLEMENTED_BINARY <= '0';
      when TRUE    =>  PCIE_CAP_SLOT_IMPLEMENTED_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PCIE_CAP_SLOT_IMPLEMENTED is neither TRUE nor FALSE." severity error;
    end case;
    case PL_FAST_TRAIN is
      when FALSE   =>  PL_FAST_TRAIN_BINARY <= '0';
      when TRUE    =>  PL_FAST_TRAIN_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PL_FAST_TRAIN is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_D1SUPPORT is
      when FALSE   =>  PM_CAP_D1SUPPORT_BINARY <= '0';
      when TRUE    =>  PM_CAP_D1SUPPORT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_D1SUPPORT is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_D2SUPPORT is
      when FALSE   =>  PM_CAP_D2SUPPORT_BINARY <= '0';
      when TRUE    =>  PM_CAP_D2SUPPORT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_D2SUPPORT is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_DSI is
      when FALSE   =>  PM_CAP_DSI_BINARY <= '0';
      when TRUE    =>  PM_CAP_DSI_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_DSI is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_ON is
      when FALSE   =>  PM_CAP_ON_BINARY <= '0';
      when TRUE    =>  PM_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_PME_CLOCK is
      when FALSE   =>  PM_CAP_PME_CLOCK_BINARY <= '0';
      when TRUE    =>  PM_CAP_PME_CLOCK_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_PME_CLOCK is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CAP_RSVD_04 is
      when  0   =>  PM_CAP_RSVD_04_BINARY <= '0';
      when  1   =>  PM_CAP_RSVD_04_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CAP_RSVD_04 is not in range 0 .. 1." severity error;
    end case;
    case PM_CSR_B2B3 is
      when FALSE   =>  PM_CSR_B2B3_BINARY <= '0';
      when TRUE    =>  PM_CSR_B2B3_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CSR_B2B3 is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CSR_BPCCEN is
      when FALSE   =>  PM_CSR_BPCCEN_BINARY <= '0';
      when TRUE    =>  PM_CSR_BPCCEN_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CSR_BPCCEN is neither TRUE nor FALSE." severity error;
    end case;
    case PM_CSR_NOSOFTRST is
      when FALSE   =>  PM_CSR_NOSOFTRST_BINARY <= '0';
      when TRUE    =>  PM_CSR_NOSOFTRST_BINARY <= '1';
      when others  =>  assert FALSE report "Error : PM_CSR_NOSOFTRST is neither TRUE nor FALSE." severity error;
    end case;
    case RECRC_CHK_TRIM is
      when FALSE   =>  RECRC_CHK_TRIM_BINARY <= '0';
      when TRUE    =>  RECRC_CHK_TRIM_BINARY <= '1';
      when others  =>  assert FALSE report "Error : RECRC_CHK_TRIM is neither TRUE nor FALSE." severity error;
    end case;
    case ROOT_CAP_CRS_SW_VISIBILITY is
      when FALSE   =>  ROOT_CAP_CRS_SW_VISIBILITY_BINARY <= '0';
      when TRUE    =>  ROOT_CAP_CRS_SW_VISIBILITY_BINARY <= '1';
      when others  =>  assert FALSE report "Error : ROOT_CAP_CRS_SW_VISIBILITY is neither TRUE nor FALSE." severity error;
    end case;
    case SELECT_DLL_IF is
      when FALSE   =>  SELECT_DLL_IF_BINARY <= '0';
      when TRUE    =>  SELECT_DLL_IF_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SELECT_DLL_IF is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_ATT_BUTTON_PRESENT is
      when FALSE   =>  SLOT_CAP_ATT_BUTTON_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_ATT_BUTTON_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_ATT_BUTTON_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_ATT_INDICATOR_PRESENT is
      when FALSE   =>  SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_ATT_INDICATOR_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_ELEC_INTERLOCK_PRESENT is
      when FALSE   =>  SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_ELEC_INTERLOCK_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_HOTPLUG_CAPABLE is
      when FALSE   =>  SLOT_CAP_HOTPLUG_CAPABLE_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_HOTPLUG_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_HOTPLUG_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_HOTPLUG_SURPRISE is
      when FALSE   =>  SLOT_CAP_HOTPLUG_SURPRISE_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_HOTPLUG_SURPRISE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_HOTPLUG_SURPRISE is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_MRL_SENSOR_PRESENT is
      when FALSE   =>  SLOT_CAP_MRL_SENSOR_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_MRL_SENSOR_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_MRL_SENSOR_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_NO_CMD_COMPLETED_SUPPORT is
      when FALSE   =>  SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_NO_CMD_COMPLETED_SUPPORT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_POWER_CONTROLLER_PRESENT is
      when FALSE   =>  SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_POWER_CONTROLLER_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SLOT_CAP_POWER_INDICATOR_PRESENT is
      when FALSE   =>  SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY <= '0';
      when TRUE    =>  SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SLOT_CAP_POWER_INDICATOR_PRESENT is neither TRUE nor FALSE." severity error;
    end case;
    case SPARE_BIT0 is
      when  0   =>  SPARE_BIT0_BINARY <= '0';
      when  1   =>  SPARE_BIT0_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT0 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT1 is
      when  0   =>  SPARE_BIT1_BINARY <= '0';
      when  1   =>  SPARE_BIT1_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT1 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT2 is
      when  0   =>  SPARE_BIT2_BINARY <= '0';
      when  1   =>  SPARE_BIT2_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT2 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT3 is
      when  0   =>  SPARE_BIT3_BINARY <= '0';
      when  1   =>  SPARE_BIT3_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT3 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT4 is
      when  0   =>  SPARE_BIT4_BINARY <= '0';
      when  1   =>  SPARE_BIT4_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT4 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT5 is
      when  0   =>  SPARE_BIT5_BINARY <= '0';
      when  1   =>  SPARE_BIT5_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT5 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT6 is
      when  0   =>  SPARE_BIT6_BINARY <= '0';
      when  1   =>  SPARE_BIT6_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT6 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT7 is
      when  0   =>  SPARE_BIT7_BINARY <= '0';
      when  1   =>  SPARE_BIT7_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT7 is not in range 0 .. 1." severity error;
    end case;
    case SPARE_BIT8 is
      when  0   =>  SPARE_BIT8_BINARY <= '0';
      when  1   =>  SPARE_BIT8_BINARY <= '1';
      when others  =>  assert FALSE report "Error : SPARE_BIT8 is not in range 0 .. 1." severity error;
    end case;
    case TL_RBYPASS is
      when FALSE   =>  TL_RBYPASS_BINARY <= '0';
      when TRUE    =>  TL_RBYPASS_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_RBYPASS is neither TRUE nor FALSE." severity error;
    end case;
    case TL_RX_RAM_RADDR_LATENCY is
      when  0   =>  TL_RX_RAM_RADDR_LATENCY_BINARY <= '0';
      when  1   =>  TL_RX_RAM_RADDR_LATENCY_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_RX_RAM_RADDR_LATENCY is not in range 0 .. 1." severity error;
    end case;
    case TL_RX_RAM_WRITE_LATENCY is
      when  0   =>  TL_RX_RAM_WRITE_LATENCY_BINARY <= '0';
      when  1   =>  TL_RX_RAM_WRITE_LATENCY_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_RX_RAM_WRITE_LATENCY is not in range 0 .. 1." severity error;
    end case;
    case TL_TFC_DISABLE is
      when FALSE   =>  TL_TFC_DISABLE_BINARY <= '0';
      when TRUE    =>  TL_TFC_DISABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_TFC_DISABLE is neither TRUE nor FALSE." severity error;
    end case;
    case TL_TX_CHECKS_DISABLE is
      when FALSE   =>  TL_TX_CHECKS_DISABLE_BINARY <= '0';
      when TRUE    =>  TL_TX_CHECKS_DISABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_TX_CHECKS_DISABLE is neither TRUE nor FALSE." severity error;
    end case;
    case TL_TX_RAM_RADDR_LATENCY is
      when  0   =>  TL_TX_RAM_RADDR_LATENCY_BINARY <= '0';
      when  1   =>  TL_TX_RAM_RADDR_LATENCY_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_TX_RAM_RADDR_LATENCY is not in range 0 .. 1." severity error;
    end case;
    case TL_TX_RAM_WRITE_LATENCY is
      when  0   =>  TL_TX_RAM_WRITE_LATENCY_BINARY <= '0';
      when  1   =>  TL_TX_RAM_WRITE_LATENCY_BINARY <= '1';
      when others  =>  assert FALSE report "Error : TL_TX_RAM_WRITE_LATENCY is not in range 0 .. 1." severity error;
    end case;
    case UPCONFIG_CAPABLE is
      when FALSE   =>  UPCONFIG_CAPABLE_BINARY <= '0';
      when TRUE    =>  UPCONFIG_CAPABLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : UPCONFIG_CAPABLE is neither TRUE nor FALSE." severity error;
    end case;
    case UPSTREAM_FACING is
      when FALSE   =>  UPSTREAM_FACING_BINARY <= '0';
      when TRUE    =>  UPSTREAM_FACING_BINARY <= '1';
      when others  =>  assert FALSE report "Error : UPSTREAM_FACING is neither TRUE nor FALSE." severity error;
    end case;
    case UR_INV_REQ is
      when FALSE   =>  UR_INV_REQ_BINARY <= '0';
      when TRUE    =>  UR_INV_REQ_BINARY <= '1';
      when others  =>  assert FALSE report "Error : UR_INV_REQ is neither TRUE nor FALSE." severity error;
    end case;
    case VC0_CPL_INFINITE is
      when FALSE   =>  VC0_CPL_INFINITE_BINARY <= '0';
      when TRUE    =>  VC0_CPL_INFINITE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : VC0_CPL_INFINITE is neither TRUE nor FALSE." severity error;
    end case;
    case VC_CAP_ON is
      when FALSE   =>  VC_CAP_ON_BINARY <= '0';
      when TRUE    =>  VC_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : VC_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    case VC_CAP_REJECT_SNOOP_TRANSACTIONS is
      when FALSE   =>  VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY <= '0';
      when TRUE    =>  VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY <= '1';
      when others  =>  assert FALSE report "Error : VC_CAP_REJECT_SNOOP_TRANSACTIONS is neither TRUE nor FALSE." severity error;
    end case;
    case VSEC_CAP_IS_LINK_VISIBLE is
      when FALSE   =>  VSEC_CAP_IS_LINK_VISIBLE_BINARY <= '0';
      when TRUE    =>  VSEC_CAP_IS_LINK_VISIBLE_BINARY <= '1';
      when others  =>  assert FALSE report "Error : VSEC_CAP_IS_LINK_VISIBLE is neither TRUE nor FALSE." severity error;
    end case;
    case VSEC_CAP_ON is
      when FALSE   =>  VSEC_CAP_ON_BINARY <= '0';
      when TRUE    =>  VSEC_CAP_ON_BINARY <= '1';
      when others  =>  assert FALSE report "Error : VSEC_CAP_ON is neither TRUE nor FALSE." severity error;
    end case;
    if ((DEV_CAP_ENDPOINT_L0S_LATENCY >= 0) and (DEV_CAP_ENDPOINT_L0S_LATENCY <= 7)) then
      DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_ENDPOINT_L0S_LATENCY, 3);
    else
      assert FALSE report "Error : DEV_CAP_ENDPOINT_L0S_LATENCY is not in range 0 .. 7." severity error;
    end if;
    if ((DEV_CAP_ENDPOINT_L1_LATENCY >= 0) and (DEV_CAP_ENDPOINT_L1_LATENCY <= 7)) then
      DEV_CAP_ENDPOINT_L1_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_ENDPOINT_L1_LATENCY, 3);
    else
      assert FALSE report "Error : DEV_CAP_ENDPOINT_L1_LATENCY is not in range 0 .. 7." severity error;
    end if;
    if ((DEV_CAP_MAX_PAYLOAD_SUPPORTED >= 0) and (DEV_CAP_MAX_PAYLOAD_SUPPORTED <= 7)) then
      DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_MAX_PAYLOAD_SUPPORTED, 3);
    else
      assert FALSE report "Error : DEV_CAP_MAX_PAYLOAD_SUPPORTED is not in range 0 .. 7." severity error;
    end if;
    if ((DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT >= 0) and (DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT <= 3)) then
      DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT, 2);
    else
      assert FALSE report "Error : DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT is not in range 0 .. 3." severity error;
    end if;
    if ((DEV_CAP_RSVD_14_12 >= 0) and (DEV_CAP_RSVD_14_12 <= 7)) then
      DEV_CAP_RSVD_14_12_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_RSVD_14_12, 3);
    else
      assert FALSE report "Error : DEV_CAP_RSVD_14_12 is not in range 0 .. 7." severity error;
    end if;
    if ((DEV_CAP_RSVD_17_16 >= 0) and (DEV_CAP_RSVD_17_16 <= 3)) then
      DEV_CAP_RSVD_17_16_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_RSVD_17_16, 2);
    else
      assert FALSE report "Error : DEV_CAP_RSVD_17_16 is not in range 0 .. 3." severity error;
    end if;
    if ((DEV_CAP_RSVD_31_29 >= 0) and (DEV_CAP_RSVD_31_29 <= 7)) then
      DEV_CAP_RSVD_31_29_BINARY <= CONV_STD_LOGIC_VECTOR(DEV_CAP_RSVD_31_29, 3);
    else
      assert FALSE report "Error : DEV_CAP_RSVD_31_29 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_ASPM_SUPPORT >= 0) and (LINK_CAP_ASPM_SUPPORT <= 3)) then
      LINK_CAP_ASPM_SUPPORT_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_ASPM_SUPPORT, 2);
    else
      assert FALSE report "Error : LINK_CAP_ASPM_SUPPORT is not in range 0 .. 3." severity error;
    end if;
    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 >= 0) and (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 <= 7)) then
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1, 3);
    else
      assert FALSE report "Error : LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 >= 0) and (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 <= 7)) then
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2, 3);
    else
      assert FALSE report "Error : LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN1 >= 0) and (LINK_CAP_L0S_EXIT_LATENCY_GEN1 <= 7)) then
      LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L0S_EXIT_LATENCY_GEN1, 3);
    else
      assert FALSE report "Error : LINK_CAP_L0S_EXIT_LATENCY_GEN1 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN2 >= 0) and (LINK_CAP_L0S_EXIT_LATENCY_GEN2 <= 7)) then
      LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L0S_EXIT_LATENCY_GEN2, 3);
    else
      assert FALSE report "Error : LINK_CAP_L0S_EXIT_LATENCY_GEN2 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 >= 0) and (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 <= 7)) then
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1, 3);
    else
      assert FALSE report "Error : LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 >= 0) and (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 <= 7)) then
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2, 3);
    else
      assert FALSE report "Error : LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L1_EXIT_LATENCY_GEN1 >= 0) and (LINK_CAP_L1_EXIT_LATENCY_GEN1 <= 7)) then
      LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L1_EXIT_LATENCY_GEN1, 3);
    else
      assert FALSE report "Error : LINK_CAP_L1_EXIT_LATENCY_GEN1 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_L1_EXIT_LATENCY_GEN2 >= 0) and (LINK_CAP_L1_EXIT_LATENCY_GEN2 <= 7)) then
      LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_L1_EXIT_LATENCY_GEN2, 3);
    else
      assert FALSE report "Error : LINK_CAP_L1_EXIT_LATENCY_GEN2 is not in range 0 .. 7." severity error;
    end if;
    if ((LINK_CAP_RSVD_23_22 >= 0) and (LINK_CAP_RSVD_23_22 <= 3)) then
      LINK_CAP_RSVD_23_22_BINARY <= CONV_STD_LOGIC_VECTOR(LINK_CAP_RSVD_23_22, 2);
    else
      assert FALSE report "Error : LINK_CAP_RSVD_23_22 is not in range 0 .. 3." severity error;
    end if;
    if ((LL_ACK_TIMEOUT_FUNC >= 0) and (LL_ACK_TIMEOUT_FUNC <= 3)) then
      LL_ACK_TIMEOUT_FUNC_BINARY <= CONV_STD_LOGIC_VECTOR(LL_ACK_TIMEOUT_FUNC, 2);
    else
      assert FALSE report "Error : LL_ACK_TIMEOUT_FUNC is not in range 0 .. 3." severity error;
    end if;
    if ((LL_REPLAY_TIMEOUT_FUNC >= 0) and (LL_REPLAY_TIMEOUT_FUNC <= 3)) then
      LL_REPLAY_TIMEOUT_FUNC_BINARY <= CONV_STD_LOGIC_VECTOR(LL_REPLAY_TIMEOUT_FUNC, 2);
    else
      assert FALSE report "Error : LL_REPLAY_TIMEOUT_FUNC is not in range 0 .. 3." severity error;
    end if;
    if ((MSIX_CAP_PBA_BIR >= 0) and (MSIX_CAP_PBA_BIR <= 7)) then
      MSIX_CAP_PBA_BIR_BINARY <= CONV_STD_LOGIC_VECTOR(MSIX_CAP_PBA_BIR, 3);
    else
      assert FALSE report "Error : MSIX_CAP_PBA_BIR is not in range 0 .. 7." severity error;
    end if;
    if ((MSIX_CAP_TABLE_BIR >= 0) and (MSIX_CAP_TABLE_BIR <= 7)) then
      MSIX_CAP_TABLE_BIR_BINARY <= CONV_STD_LOGIC_VECTOR(MSIX_CAP_TABLE_BIR, 3);
    else
      assert FALSE report "Error : MSIX_CAP_TABLE_BIR is not in range 0 .. 7." severity error;
    end if;
    if ((MSI_CAP_MULTIMSGCAP >= 0) and (MSI_CAP_MULTIMSGCAP <= 7)) then
      MSI_CAP_MULTIMSGCAP_BINARY <= CONV_STD_LOGIC_VECTOR(MSI_CAP_MULTIMSGCAP, 3);
    else
      assert FALSE report "Error : MSI_CAP_MULTIMSGCAP is not in range 0 .. 7." severity error;
    end if;
    if ((N_FTS_COMCLK_GEN1 >= 0) and (N_FTS_COMCLK_GEN1 <= 255)) then
      N_FTS_COMCLK_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(N_FTS_COMCLK_GEN1, 8);
    else
      assert FALSE report "Error : N_FTS_COMCLK_GEN1 is not in range 0 .. 255." severity error;
    end if;
    if ((N_FTS_COMCLK_GEN2 >= 0) and (N_FTS_COMCLK_GEN2 <= 255)) then
      N_FTS_COMCLK_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(N_FTS_COMCLK_GEN2, 8);
    else
      assert FALSE report "Error : N_FTS_COMCLK_GEN2 is not in range 0 .. 255." severity error;
    end if;
    if ((N_FTS_GEN1 >= 0) and (N_FTS_GEN1 <= 255)) then
      N_FTS_GEN1_BINARY <= CONV_STD_LOGIC_VECTOR(N_FTS_GEN1, 8);
    else
      assert FALSE report "Error : N_FTS_GEN1 is not in range 0 .. 255." severity error;
    end if;
    if ((N_FTS_GEN2 >= 0) and (N_FTS_GEN2 <= 255)) then
      N_FTS_GEN2_BINARY <= CONV_STD_LOGIC_VECTOR(N_FTS_GEN2, 8);
    else
      assert FALSE report "Error : N_FTS_GEN2 is not in range 0 .. 255." severity error;
    end if;
    if ((PCIE_CAP_RSVD_15_14 >= 0) and (PCIE_CAP_RSVD_15_14 <= 3)) then
      PCIE_CAP_RSVD_15_14_BINARY <= CONV_STD_LOGIC_VECTOR(PCIE_CAP_RSVD_15_14, 2);
    else
      assert FALSE report "Error : PCIE_CAP_RSVD_15_14 is not in range 0 .. 3." severity error;
    end if;
    if ((PCIE_REVISION >= 0) and (PCIE_REVISION <= 15)) then
      PCIE_REVISION_BINARY <= CONV_STD_LOGIC_VECTOR(PCIE_REVISION, 4);
    else
      assert FALSE report "Error : PCIE_REVISION is not in range 0 .. 15." severity error;
    end if;
    if ((PGL0_LANE >= 0) and (PGL0_LANE <= 7)) then
      PGL0_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL0_LANE, 3);
    else
      assert FALSE report "Error : PGL0_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL1_LANE >= 0) and (PGL1_LANE <= 7)) then
      PGL1_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL1_LANE, 3);
    else
      assert FALSE report "Error : PGL1_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL2_LANE >= 0) and (PGL2_LANE <= 7)) then
      PGL2_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL2_LANE, 3);
    else
      assert FALSE report "Error : PGL2_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL3_LANE >= 0) and (PGL3_LANE <= 7)) then
      PGL3_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL3_LANE, 3);
    else
      assert FALSE report "Error : PGL3_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL4_LANE >= 0) and (PGL4_LANE <= 7)) then
      PGL4_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL4_LANE, 3);
    else
      assert FALSE report "Error : PGL4_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL5_LANE >= 0) and (PGL5_LANE <= 7)) then
      PGL5_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL5_LANE, 3);
    else
      assert FALSE report "Error : PGL5_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL6_LANE >= 0) and (PGL6_LANE <= 7)) then
      PGL6_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL6_LANE, 3);
    else
      assert FALSE report "Error : PGL6_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PGL7_LANE >= 0) and (PGL7_LANE <= 7)) then
      PGL7_LANE_BINARY <= CONV_STD_LOGIC_VECTOR(PGL7_LANE, 3);
    else
      assert FALSE report "Error : PGL7_LANE is not in range 0 .. 7." severity error;
    end if;
    if ((PL_AUTO_CONFIG >= 0) and (PL_AUTO_CONFIG <= 7)) then
      PL_AUTO_CONFIG_BINARY <= CONV_STD_LOGIC_VECTOR(PL_AUTO_CONFIG, 3);
    else
      assert FALSE report "Error : PL_AUTO_CONFIG is not in range 0 .. 7." severity error;
    end if;
    if ((PM_CAP_AUXCURRENT >= 0) and (PM_CAP_AUXCURRENT <= 7)) then
      PM_CAP_AUXCURRENT_BINARY <= CONV_STD_LOGIC_VECTOR(PM_CAP_AUXCURRENT, 3);
    else
      assert FALSE report "Error : PM_CAP_AUXCURRENT is not in range 0 .. 7." severity error;
    end if;
    if ((PM_CAP_VERSION >= 0) and (PM_CAP_VERSION <= 7)) then
      PM_CAP_VERSION_BINARY <= CONV_STD_LOGIC_VECTOR(PM_CAP_VERSION, 3);
    else
      assert FALSE report "Error : PM_CAP_VERSION is not in range 0 .. 7." severity error;
    end if;
    if ((RECRC_CHK >= 0) and (RECRC_CHK <= 3)) then
      RECRC_CHK_BINARY <= CONV_STD_LOGIC_VECTOR(RECRC_CHK, 2);
    else
      assert FALSE report "Error : RECRC_CHK is not in range 0 .. 3." severity error;
    end if;
    if ((SLOT_CAP_SLOT_POWER_LIMIT_SCALE >= 0) and (SLOT_CAP_SLOT_POWER_LIMIT_SCALE <= 3)) then
      SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY <= CONV_STD_LOGIC_VECTOR(SLOT_CAP_SLOT_POWER_LIMIT_SCALE, 2);
    else
      assert FALSE report "Error : SLOT_CAP_SLOT_POWER_LIMIT_SCALE is not in range 0 .. 3." severity error;
    end if;
    if ((TL_RX_RAM_RDATA_LATENCY >= 0) and (TL_RX_RAM_RDATA_LATENCY <= 3)) then
      TL_RX_RAM_RDATA_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(TL_RX_RAM_RDATA_LATENCY, 2);
    else
      assert FALSE report "Error : TL_RX_RAM_RDATA_LATENCY is not in range 0 .. 3." severity error;
    end if;
    if ((TL_TX_RAM_RDATA_LATENCY >= 0) and (TL_TX_RAM_RDATA_LATENCY <= 3)) then
      TL_TX_RAM_RDATA_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(TL_TX_RAM_RDATA_LATENCY, 2);
    else
      assert FALSE report "Error : TL_TX_RAM_RDATA_LATENCY is not in range 0 .. 3." severity error;
    end if;
    if ((USER_CLK_FREQ >= 0) and (USER_CLK_FREQ <= 7)) then
      USER_CLK_FREQ_BINARY <= CONV_STD_LOGIC_VECTOR(USER_CLK_FREQ, 3);
    else
      assert FALSE report "Error : USER_CLK_FREQ is not in range 0 .. 7." severity error;
    end if;
    if ((VC0_TOTAL_CREDITS_CD >= 0) and (VC0_TOTAL_CREDITS_CD <= 2047)) then
      VC0_TOTAL_CREDITS_CD_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TOTAL_CREDITS_CD, 11);
    else
      assert FALSE report "Error : VC0_TOTAL_CREDITS_CD is not in range 0 .. 2047." severity error;
    end if;
    if ((VC0_TOTAL_CREDITS_CH >= 0) and (VC0_TOTAL_CREDITS_CH <= 127)) then
      VC0_TOTAL_CREDITS_CH_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TOTAL_CREDITS_CH, 7);
    else
      assert FALSE report "Error : VC0_TOTAL_CREDITS_CH is not in range 0 .. 127." severity error;
    end if;
    if ((VC0_TOTAL_CREDITS_NPH >= 0) and (VC0_TOTAL_CREDITS_NPH <= 127)) then
      VC0_TOTAL_CREDITS_NPH_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TOTAL_CREDITS_NPH, 7);
    else
      assert FALSE report "Error : VC0_TOTAL_CREDITS_NPH is not in range 0 .. 127." severity error;
    end if;
    if ((VC0_TOTAL_CREDITS_PD >= 0) and (VC0_TOTAL_CREDITS_PD <= 2047)) then
      VC0_TOTAL_CREDITS_PD_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TOTAL_CREDITS_PD, 11);
    else
      assert FALSE report "Error : VC0_TOTAL_CREDITS_PD is not in range 0 .. 2047." severity error;
    end if;
    if ((VC0_TOTAL_CREDITS_PH >= 0) and (VC0_TOTAL_CREDITS_PH <= 127)) then
      VC0_TOTAL_CREDITS_PH_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TOTAL_CREDITS_PH, 7);
    else
      assert FALSE report "Error : VC0_TOTAL_CREDITS_PH is not in range 0 .. 127." severity error;
    end if;
    if ((VC0_TX_LASTPACKET >= 0) and (VC0_TX_LASTPACKET <= 31)) then
      VC0_TX_LASTPACKET_BINARY <= CONV_STD_LOGIC_VECTOR(VC0_TX_LASTPACKET, 5);
    else
      assert FALSE report "Error : VC0_TX_LASTPACKET is not in range 0 .. 31." severity error;
    end if;
    wait;
    end process INIPROC;
    

    
    TIMING : process
      variable Tmkr_CFGBYTEENN_USERCLK_posedge : VitalTimingDataArrayType(3 downto 0);
      variable Tmkr_CFGDI_USERCLK_posedge : VitalTimingDataArrayType(31 downto 0);
      variable Tmkr_CFGDSBUSNUMBER_USERCLK_posedge : VitalTimingDataArrayType(7 downto 0);
      variable Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge : VitalTimingDataArrayType(4 downto 0);
      variable Tmkr_CFGDSFUNCTIONNUMBER_USERCLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_CFGDSN_USERCLK_posedge : VitalTimingDataArrayType(63 downto 0);
      variable Tmkr_CFGDWADDR_USERCLK_posedge : VitalTimingDataArrayType(9 downto 0);
      variable Tmkr_CFGERRACSN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge : VitalTimingDataArrayType(127 downto 0);
      variable Tmkr_CFGERRCORN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRCPLABORTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRCPLTIMEOUTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRCPLUNEXPECTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRECRCN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRLOCKEDN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRPOSTEDN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge : VitalTimingDataArrayType(47 downto 0);
      variable Tmkr_CFGERRURN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGINTERRUPTASSERTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGINTERRUPTDI_USERCLK_posedge : VitalTimingDataArrayType(7 downto 0);
      variable Tmkr_CFGINTERRUPTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMDIRECTASPML1N_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMSENDPMACKN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMSENDPMETON_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMSENDPMNAKN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMTURNOFFOKN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPMWAKEN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGPORTNUMBER_USERCLK_posedge : VitalTimingDataArrayType(7 downto 0);
      variable Tmkr_CFGRDENN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGTRNPENDINGN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGWRENN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGWRREADONLYN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CFGWRRW1CASRWN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CMRSTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_CMSTICKYRSTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_DBGMODE_USERCLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_DBGSUBMODE_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_DLRSTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_DRPDADDR_DRPCLK_posedge : VitalTimingDataArrayType(8 downto 0);
      variable Tmkr_DRPDEN_DRPCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_DRPDI_DRPCLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_DRPDWE_DRPCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_FUNCLVLRSTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_LL2SENDASREQL1N_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_LL2SENDENTERL1N_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_LL2SENDENTERL23N_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_LL2SUSPENDNOWN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_LL2TLPRCVN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_MIMRXRDATA_USERCLK_posedge : VitalTimingDataArrayType(67 downto 0);
      variable Tmkr_MIMTXRDATA_USERCLK_posedge : VitalTimingDataArrayType(68 downto 0);
      variable Tmkr_PIPERX0CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX0CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX0DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX0ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX0PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX0STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX0VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX1CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX1CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX1DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX1ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX1PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX1STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX1VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX2CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX2CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX2DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX2ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX2PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX2STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX2VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX3CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX3CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX3DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX3ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX3PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX3STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX3VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX4CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX4CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX4DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX4ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX4PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX4STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX4VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX5CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX5CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX5DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX5ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX5PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX5STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX5VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX6CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX6CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX6DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX6ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX6PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX6STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX6VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX7CHANISALIGNED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX7CHARISK_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PIPERX7DATA_PIPECLK_posedge : VitalTimingDataArrayType(15 downto 0);
      variable Tmkr_PIPERX7ELECIDLE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX7PHYSTATUS_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PIPERX7STATUS_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PIPERX7VALID_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PL2DIRECTEDLSTATE_USERCLK_posedge : VitalTimingDataArrayType(4 downto 0);
      variable Tmkr_PLDBGMODE_PIPECLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_PLDIRECTEDLINKAUTON_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PLDIRECTEDLINKCHANGE_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PLDIRECTEDLINKSPEED_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PLDIRECTEDLINKWIDTH_PIPECLK_posedge : VitalTimingDataArrayType(1 downto 0);
      variable Tmkr_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PLRSTN_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PLTRANSMITHOTRST_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TL2PPMSUSPENDREQN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TLRSTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNFCSEL_USERCLK_posedge : VitalTimingDataArrayType(2 downto 0);
      variable Tmkr_TRNRDSTRDYN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNRNPOKN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTCFGGNTN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTDLLPDATA_USERCLK_posedge : VitalTimingDataArrayType(31 downto 0);
      variable Tmkr_TRNTDLLPSRCRDYN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTD_USERCLK_posedge : VitalTimingDataArrayType(63 downto 0);
      variable Tmkr_TRNTECRCGENN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTEOFN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTERRFWDN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTREMN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTSOFN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTSRCDSCN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTSRCRDYN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tmkr_TRNTSTRN_USERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
      variable Tviol_CFGBYTEENN_USERCLK_posedge : std_logic_vector(3 downto 0) := (others => '0');
      variable Tviol_CFGDI_USERCLK_posedge : std_logic_vector(31 downto 0) := (others => '0');
      variable Tviol_CFGDSBUSNUMBER_USERCLK_posedge : std_logic_vector(7 downto 0) := (others => '0');
      variable Tviol_CFGDSDEVICENUMBER_USERCLK_posedge : std_logic_vector(4 downto 0) := (others => '0');
      variable Tviol_CFGDSFUNCTIONNUMBER_USERCLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_CFGDSN_USERCLK_posedge : std_logic_vector(63 downto 0) := (others => '0');
      variable Tviol_CFGDWADDR_USERCLK_posedge : std_logic_vector(9 downto 0) := (others => '0');
      variable Tviol_CFGERRACSN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRAERHEADERLOG_USERCLK_posedge : std_logic_vector(127 downto 0) := (others => '0');
      variable Tviol_CFGERRCORN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRCPLABORTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRCPLTIMEOUTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRCPLUNEXPECTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRECRCN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRLOCKEDN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRPOSTEDN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge : std_logic_vector(47 downto 0) := (others => '0');
      variable Tviol_CFGERRURN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGINTERRUPTASSERTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGINTERRUPTDI_USERCLK_posedge : std_logic_vector(7 downto 0) := (others => '0');
      variable Tviol_CFGINTERRUPTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMDIRECTASPML1N_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMSENDPMACKN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMSENDPMETON_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMSENDPMNAKN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMTURNOFFOKN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPMWAKEN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGPORTNUMBER_USERCLK_posedge : std_logic_vector(7 downto 0) := (others => '0');
      variable Tviol_CFGRDENN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGTRNPENDINGN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGWRENN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGWRREADONLYN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CFGWRRW1CASRWN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CMRSTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_CMSTICKYRSTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_DBGMODE_USERCLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_DBGSUBMODE_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_DLRSTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_DRPDADDR_DRPCLK_posedge : std_logic_vector(8 downto 0) := (others => '0');
      variable Tviol_DRPDEN_DRPCLK_posedge :  std_ulogic := '0';
      variable Tviol_DRPDI_DRPCLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_DRPDWE_DRPCLK_posedge :  std_ulogic := '0';
      variable Tviol_FUNCLVLRSTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_LL2SENDASREQL1N_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_LL2SENDENTERL1N_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_LL2SENDENTERL23N_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_LL2SUSPENDNOWN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_LL2TLPRCVN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_MIMRXRDATA_USERCLK_posedge : std_logic_vector(67 downto 0) := (others => '0');
      variable Tviol_MIMTXRDATA_USERCLK_posedge : std_logic_vector(68 downto 0) := (others => '0');
      variable Tviol_PIPERX0CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX0CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX0DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX0ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX0PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX0STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX0VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX1CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX1CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX1DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX1ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX1PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX1STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX1VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX2CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX2CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX2DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX2ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX2PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX2STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX2VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX3CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX3CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX3DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX3ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX3PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX3STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX3VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX4CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX4CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX4DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX4ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX4PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX4STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX4VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX5CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX5CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX5DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX5ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX5PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX5STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX5VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX6CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX6CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX6DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX6ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX6PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX6STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX6VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX7CHANISALIGNED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX7CHARISK_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PIPERX7DATA_PIPECLK_posedge : std_logic_vector(15 downto 0) := (others => '0');
      variable Tviol_PIPERX7ELECIDLE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX7PHYSTATUS_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PIPERX7STATUS_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PIPERX7VALID_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PL2DIRECTEDLSTATE_USERCLK_posedge : std_logic_vector(4 downto 0) := (others => '0');
      variable Tviol_PLDBGMODE_PIPECLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_PLDIRECTEDLINKAUTON_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PLDIRECTEDLINKCHANGE_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PLDIRECTEDLINKSPEED_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PLDIRECTEDLINKWIDTH_PIPECLK_posedge : std_logic_vector(1 downto 0) := (others => '0');
      variable Tviol_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PLRSTN_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PLTRANSMITHOTRST_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge :  std_ulogic := '0';
      variable Tviol_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TL2PPMSUSPENDREQN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TLRSTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNFCSEL_USERCLK_posedge : std_logic_vector(2 downto 0) := (others => '0');
      variable Tviol_TRNRDSTRDYN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNRNPOKN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTCFGGNTN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTDLLPDATA_USERCLK_posedge : std_logic_vector(31 downto 0) := (others => '0');
      variable Tviol_TRNTDLLPSRCRDYN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTD_USERCLK_posedge : std_logic_vector(63 downto 0) := (others => '0');
      variable Tviol_TRNTECRCGENN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTEOFN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTERRFWDN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTREMN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTSOFN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTSRCDSCN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTSRCRDYN_USERCLK_posedge :  std_ulogic := '0';
      variable Tviol_TRNTSTRN_USERCLK_posedge :  std_ulogic := '0';
      variable CFGAERECRCCHECKEN_GlitchData : VitalGlitchDataType;
      variable CFGAERECRCGENEN_GlitchData : VitalGlitchDataType;
      variable CFGCOMMANDBUSMASTERENABLE_GlitchData : VitalGlitchDataType;
      variable CFGCOMMANDINTERRUPTDISABLE_GlitchData : VitalGlitchDataType;
      variable CFGCOMMANDIOENABLE_GlitchData : VitalGlitchDataType;
      variable CFGCOMMANDMEMENABLE_GlitchData : VitalGlitchDataType;
      variable CFGCOMMANDSERREN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROL2CPLTIMEOUTDIS_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROL2CPLTIMEOUTVAL0_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROL2CPLTIMEOUTVAL1_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROL2CPLTIMEOUTVAL2_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROL2CPLTIMEOUTVAL3_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLAUXPOWEREN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLCORRERRREPORTINGEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLENABLERO_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLEXTTAGEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLFATALERRREPORTINGEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXPAYLOAD0_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXPAYLOAD1_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXPAYLOAD2_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXREADREQ0_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXREADREQ1_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLMAXREADREQ2_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLNONFATALREPORTINGEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLNOSNOOPEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLPHANTOMEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVCONTROLURERRREPORTINGEN_GlitchData : VitalGlitchDataType;
      variable CFGDEVSTATUSCORRERRDETECTED_GlitchData : VitalGlitchDataType;
      variable CFGDEVSTATUSFATALERRDETECTED_GlitchData : VitalGlitchDataType;
      variable CFGDEVSTATUSNONFATALERRDETECTED_GlitchData : VitalGlitchDataType;
      variable CFGDEVSTATUSURDETECTED_GlitchData : VitalGlitchDataType;
      variable CFGDO0_GlitchData : VitalGlitchDataType;
      variable CFGDO10_GlitchData : VitalGlitchDataType;
      variable CFGDO11_GlitchData : VitalGlitchDataType;
      variable CFGDO12_GlitchData : VitalGlitchDataType;
      variable CFGDO13_GlitchData : VitalGlitchDataType;
      variable CFGDO14_GlitchData : VitalGlitchDataType;
      variable CFGDO15_GlitchData : VitalGlitchDataType;
      variable CFGDO16_GlitchData : VitalGlitchDataType;
      variable CFGDO17_GlitchData : VitalGlitchDataType;
      variable CFGDO18_GlitchData : VitalGlitchDataType;
      variable CFGDO19_GlitchData : VitalGlitchDataType;
      variable CFGDO1_GlitchData : VitalGlitchDataType;
      variable CFGDO20_GlitchData : VitalGlitchDataType;
      variable CFGDO21_GlitchData : VitalGlitchDataType;
      variable CFGDO22_GlitchData : VitalGlitchDataType;
      variable CFGDO23_GlitchData : VitalGlitchDataType;
      variable CFGDO24_GlitchData : VitalGlitchDataType;
      variable CFGDO25_GlitchData : VitalGlitchDataType;
      variable CFGDO26_GlitchData : VitalGlitchDataType;
      variable CFGDO27_GlitchData : VitalGlitchDataType;
      variable CFGDO28_GlitchData : VitalGlitchDataType;
      variable CFGDO29_GlitchData : VitalGlitchDataType;
      variable CFGDO2_GlitchData : VitalGlitchDataType;
      variable CFGDO30_GlitchData : VitalGlitchDataType;
      variable CFGDO31_GlitchData : VitalGlitchDataType;
      variable CFGDO3_GlitchData : VitalGlitchDataType;
      variable CFGDO4_GlitchData : VitalGlitchDataType;
      variable CFGDO5_GlitchData : VitalGlitchDataType;
      variable CFGDO6_GlitchData : VitalGlitchDataType;
      variable CFGDO7_GlitchData : VitalGlitchDataType;
      variable CFGDO8_GlitchData : VitalGlitchDataType;
      variable CFGDO9_GlitchData : VitalGlitchDataType;
      variable CFGERRAERHEADERLOGSETN_GlitchData : VitalGlitchDataType;
      variable CFGERRCPLRDYN_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO0_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO1_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO2_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO3_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO4_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO5_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO6_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTDO7_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMMENABLE0_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMMENABLE1_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMMENABLE2_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMSIENABLE_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMSIXENABLE_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTMSIXFM_GlitchData : VitalGlitchDataType;
      variable CFGINTERRUPTRDYN_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLASPMCONTROL0_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLASPMCONTROL1_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLAUTOBANDWIDTHINTEN_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLBANDWIDTHINTEN_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLCLOCKPMEN_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLCOMMONCLOCK_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLEXTENDEDSYNC_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLHWAUTOWIDTHDIS_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLLINKDISABLE_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLRCB_GlitchData : VitalGlitchDataType;
      variable CFGLINKCONTROLRETRAINLINK_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSAUTOBANDWIDTHSTATUS_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSBANDWITHSTATUS_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSCURRENTSPEED0_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSCURRENTSPEED1_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSDLLACTIVE_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSLINKTRAINING_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSNEGOTIATEDWIDTH0_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSNEGOTIATEDWIDTH1_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSNEGOTIATEDWIDTH2_GlitchData : VitalGlitchDataType;
      variable CFGLINKSTATUSNEGOTIATEDWIDTH3_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA0_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA10_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA11_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA12_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA13_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA14_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA15_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA1_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA2_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA3_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA4_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA5_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA6_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA7_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA8_GlitchData : VitalGlitchDataType;
      variable CFGMSGDATA9_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDASSERTINTA_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDASSERTINTB_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDASSERTINTC_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDASSERTINTD_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDDEASSERTINTA_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDDEASSERTINTB_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDDEASSERTINTC_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDDEASSERTINTD_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDERRCOR_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDERRFATAL_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDERRNONFATAL_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDPMASNAK_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDPMETOACK_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDPMETO_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDPMPME_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDSETSLOTPOWERLIMIT_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVEDUNLOCK_GlitchData : VitalGlitchDataType;
      variable CFGMSGRECEIVED_GlitchData : VitalGlitchDataType;
      variable CFGPCIELINKSTATE0_GlitchData : VitalGlitchDataType;
      variable CFGPCIELINKSTATE1_GlitchData : VitalGlitchDataType;
      variable CFGPCIELINKSTATE2_GlitchData : VitalGlitchDataType;
      variable CFGPMCSRPMEEN_GlitchData : VitalGlitchDataType;
      variable CFGPMCSRPMESTATUS_GlitchData : VitalGlitchDataType;
      variable CFGPMCSRPOWERSTATE0_GlitchData : VitalGlitchDataType;
      variable CFGPMCSRPOWERSTATE1_GlitchData : VitalGlitchDataType;
      variable CFGPMRCVASREQL1N_GlitchData : VitalGlitchDataType;
      variable CFGPMRCVENTERL1N_GlitchData : VitalGlitchDataType;
      variable CFGPMRCVENTERL23N_GlitchData : VitalGlitchDataType;
      variable CFGPMRCVREQACKN_GlitchData : VitalGlitchDataType;
      variable CFGRDWRDONEN_GlitchData : VitalGlitchDataType;
      variable CFGSLOTCONTROLELECTROMECHILCTLPULSE_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR0_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR1_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR2_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR3_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR4_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR5_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONADDR6_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTIONTYPE_GlitchData : VitalGlitchDataType;
      variable CFGTRANSACTION_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP0_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP1_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP2_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP3_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP4_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP5_GlitchData : VitalGlitchDataType;
      variable CFGVCTCVCMAP6_GlitchData : VitalGlitchDataType;
      variable DBGSCLRA_GlitchData : VitalGlitchDataType;
      variable DBGSCLRB_GlitchData : VitalGlitchDataType;
      variable DBGSCLRC_GlitchData : VitalGlitchDataType;
      variable DBGSCLRD_GlitchData : VitalGlitchDataType;
      variable DBGSCLRE_GlitchData : VitalGlitchDataType;
      variable DBGSCLRF_GlitchData : VitalGlitchDataType;
      variable DBGSCLRG_GlitchData : VitalGlitchDataType;
      variable DBGSCLRH_GlitchData : VitalGlitchDataType;
      variable DBGSCLRI_GlitchData : VitalGlitchDataType;
      variable DBGSCLRJ_GlitchData : VitalGlitchDataType;
      variable DBGSCLRK_GlitchData : VitalGlitchDataType;
      variable DBGVECA0_GlitchData : VitalGlitchDataType;
      variable DBGVECA10_GlitchData : VitalGlitchDataType;
      variable DBGVECA11_GlitchData : VitalGlitchDataType;
      variable DBGVECA12_GlitchData : VitalGlitchDataType;
      variable DBGVECA13_GlitchData : VitalGlitchDataType;
      variable DBGVECA14_GlitchData : VitalGlitchDataType;
      variable DBGVECA15_GlitchData : VitalGlitchDataType;
      variable DBGVECA16_GlitchData : VitalGlitchDataType;
      variable DBGVECA17_GlitchData : VitalGlitchDataType;
      variable DBGVECA18_GlitchData : VitalGlitchDataType;
      variable DBGVECA19_GlitchData : VitalGlitchDataType;
      variable DBGVECA1_GlitchData : VitalGlitchDataType;
      variable DBGVECA20_GlitchData : VitalGlitchDataType;
      variable DBGVECA21_GlitchData : VitalGlitchDataType;
      variable DBGVECA22_GlitchData : VitalGlitchDataType;
      variable DBGVECA23_GlitchData : VitalGlitchDataType;
      variable DBGVECA24_GlitchData : VitalGlitchDataType;
      variable DBGVECA25_GlitchData : VitalGlitchDataType;
      variable DBGVECA26_GlitchData : VitalGlitchDataType;
      variable DBGVECA27_GlitchData : VitalGlitchDataType;
      variable DBGVECA28_GlitchData : VitalGlitchDataType;
      variable DBGVECA29_GlitchData : VitalGlitchDataType;
      variable DBGVECA2_GlitchData : VitalGlitchDataType;
      variable DBGVECA30_GlitchData : VitalGlitchDataType;
      variable DBGVECA31_GlitchData : VitalGlitchDataType;
      variable DBGVECA32_GlitchData : VitalGlitchDataType;
      variable DBGVECA33_GlitchData : VitalGlitchDataType;
      variable DBGVECA34_GlitchData : VitalGlitchDataType;
      variable DBGVECA35_GlitchData : VitalGlitchDataType;
      variable DBGVECA36_GlitchData : VitalGlitchDataType;
      variable DBGVECA37_GlitchData : VitalGlitchDataType;
      variable DBGVECA38_GlitchData : VitalGlitchDataType;
      variable DBGVECA39_GlitchData : VitalGlitchDataType;
      variable DBGVECA3_GlitchData : VitalGlitchDataType;
      variable DBGVECA40_GlitchData : VitalGlitchDataType;
      variable DBGVECA41_GlitchData : VitalGlitchDataType;
      variable DBGVECA42_GlitchData : VitalGlitchDataType;
      variable DBGVECA43_GlitchData : VitalGlitchDataType;
      variable DBGVECA44_GlitchData : VitalGlitchDataType;
      variable DBGVECA45_GlitchData : VitalGlitchDataType;
      variable DBGVECA46_GlitchData : VitalGlitchDataType;
      variable DBGVECA47_GlitchData : VitalGlitchDataType;
      variable DBGVECA48_GlitchData : VitalGlitchDataType;
      variable DBGVECA49_GlitchData : VitalGlitchDataType;
      variable DBGVECA4_GlitchData : VitalGlitchDataType;
      variable DBGVECA50_GlitchData : VitalGlitchDataType;
      variable DBGVECA51_GlitchData : VitalGlitchDataType;
      variable DBGVECA52_GlitchData : VitalGlitchDataType;
      variable DBGVECA53_GlitchData : VitalGlitchDataType;
      variable DBGVECA54_GlitchData : VitalGlitchDataType;
      variable DBGVECA55_GlitchData : VitalGlitchDataType;
      variable DBGVECA56_GlitchData : VitalGlitchDataType;
      variable DBGVECA57_GlitchData : VitalGlitchDataType;
      variable DBGVECA58_GlitchData : VitalGlitchDataType;
      variable DBGVECA59_GlitchData : VitalGlitchDataType;
      variable DBGVECA5_GlitchData : VitalGlitchDataType;
      variable DBGVECA60_GlitchData : VitalGlitchDataType;
      variable DBGVECA61_GlitchData : VitalGlitchDataType;
      variable DBGVECA62_GlitchData : VitalGlitchDataType;
      variable DBGVECA63_GlitchData : VitalGlitchDataType;
      variable DBGVECA6_GlitchData : VitalGlitchDataType;
      variable DBGVECA7_GlitchData : VitalGlitchDataType;
      variable DBGVECA8_GlitchData : VitalGlitchDataType;
      variable DBGVECA9_GlitchData : VitalGlitchDataType;
      variable DBGVECB0_GlitchData : VitalGlitchDataType;
      variable DBGVECB10_GlitchData : VitalGlitchDataType;
      variable DBGVECB11_GlitchData : VitalGlitchDataType;
      variable DBGVECB12_GlitchData : VitalGlitchDataType;
      variable DBGVECB13_GlitchData : VitalGlitchDataType;
      variable DBGVECB14_GlitchData : VitalGlitchDataType;
      variable DBGVECB15_GlitchData : VitalGlitchDataType;
      variable DBGVECB16_GlitchData : VitalGlitchDataType;
      variable DBGVECB17_GlitchData : VitalGlitchDataType;
      variable DBGVECB18_GlitchData : VitalGlitchDataType;
      variable DBGVECB19_GlitchData : VitalGlitchDataType;
      variable DBGVECB1_GlitchData : VitalGlitchDataType;
      variable DBGVECB20_GlitchData : VitalGlitchDataType;
      variable DBGVECB21_GlitchData : VitalGlitchDataType;
      variable DBGVECB22_GlitchData : VitalGlitchDataType;
      variable DBGVECB23_GlitchData : VitalGlitchDataType;
      variable DBGVECB24_GlitchData : VitalGlitchDataType;
      variable DBGVECB25_GlitchData : VitalGlitchDataType;
      variable DBGVECB26_GlitchData : VitalGlitchDataType;
      variable DBGVECB27_GlitchData : VitalGlitchDataType;
      variable DBGVECB28_GlitchData : VitalGlitchDataType;
      variable DBGVECB29_GlitchData : VitalGlitchDataType;
      variable DBGVECB2_GlitchData : VitalGlitchDataType;
      variable DBGVECB30_GlitchData : VitalGlitchDataType;
      variable DBGVECB31_GlitchData : VitalGlitchDataType;
      variable DBGVECB32_GlitchData : VitalGlitchDataType;
      variable DBGVECB33_GlitchData : VitalGlitchDataType;
      variable DBGVECB34_GlitchData : VitalGlitchDataType;
      variable DBGVECB35_GlitchData : VitalGlitchDataType;
      variable DBGVECB36_GlitchData : VitalGlitchDataType;
      variable DBGVECB37_GlitchData : VitalGlitchDataType;
      variable DBGVECB38_GlitchData : VitalGlitchDataType;
      variable DBGVECB39_GlitchData : VitalGlitchDataType;
      variable DBGVECB3_GlitchData : VitalGlitchDataType;
      variable DBGVECB40_GlitchData : VitalGlitchDataType;
      variable DBGVECB41_GlitchData : VitalGlitchDataType;
      variable DBGVECB42_GlitchData : VitalGlitchDataType;
      variable DBGVECB43_GlitchData : VitalGlitchDataType;
      variable DBGVECB44_GlitchData : VitalGlitchDataType;
      variable DBGVECB45_GlitchData : VitalGlitchDataType;
      variable DBGVECB46_GlitchData : VitalGlitchDataType;
      variable DBGVECB47_GlitchData : VitalGlitchDataType;
      variable DBGVECB48_GlitchData : VitalGlitchDataType;
      variable DBGVECB49_GlitchData : VitalGlitchDataType;
      variable DBGVECB4_GlitchData : VitalGlitchDataType;
      variable DBGVECB50_GlitchData : VitalGlitchDataType;
      variable DBGVECB51_GlitchData : VitalGlitchDataType;
      variable DBGVECB52_GlitchData : VitalGlitchDataType;
      variable DBGVECB53_GlitchData : VitalGlitchDataType;
      variable DBGVECB54_GlitchData : VitalGlitchDataType;
      variable DBGVECB55_GlitchData : VitalGlitchDataType;
      variable DBGVECB56_GlitchData : VitalGlitchDataType;
      variable DBGVECB57_GlitchData : VitalGlitchDataType;
      variable DBGVECB58_GlitchData : VitalGlitchDataType;
      variable DBGVECB59_GlitchData : VitalGlitchDataType;
      variable DBGVECB5_GlitchData : VitalGlitchDataType;
      variable DBGVECB60_GlitchData : VitalGlitchDataType;
      variable DBGVECB61_GlitchData : VitalGlitchDataType;
      variable DBGVECB62_GlitchData : VitalGlitchDataType;
      variable DBGVECB63_GlitchData : VitalGlitchDataType;
      variable DBGVECB6_GlitchData : VitalGlitchDataType;
      variable DBGVECB7_GlitchData : VitalGlitchDataType;
      variable DBGVECB8_GlitchData : VitalGlitchDataType;
      variable DBGVECB9_GlitchData : VitalGlitchDataType;
      variable DBGVECC0_GlitchData : VitalGlitchDataType;
      variable DBGVECC10_GlitchData : VitalGlitchDataType;
      variable DBGVECC11_GlitchData : VitalGlitchDataType;
      variable DBGVECC1_GlitchData : VitalGlitchDataType;
      variable DBGVECC2_GlitchData : VitalGlitchDataType;
      variable DBGVECC3_GlitchData : VitalGlitchDataType;
      variable DBGVECC4_GlitchData : VitalGlitchDataType;
      variable DBGVECC5_GlitchData : VitalGlitchDataType;
      variable DBGVECC6_GlitchData : VitalGlitchDataType;
      variable DBGVECC7_GlitchData : VitalGlitchDataType;
      variable DBGVECC8_GlitchData : VitalGlitchDataType;
      variable DBGVECC9_GlitchData : VitalGlitchDataType;
      variable DRPDO0_GlitchData : VitalGlitchDataType;
      variable DRPDO10_GlitchData : VitalGlitchDataType;
      variable DRPDO11_GlitchData : VitalGlitchDataType;
      variable DRPDO12_GlitchData : VitalGlitchDataType;
      variable DRPDO13_GlitchData : VitalGlitchDataType;
      variable DRPDO14_GlitchData : VitalGlitchDataType;
      variable DRPDO15_GlitchData : VitalGlitchDataType;
      variable DRPDO1_GlitchData : VitalGlitchDataType;
      variable DRPDO2_GlitchData : VitalGlitchDataType;
      variable DRPDO3_GlitchData : VitalGlitchDataType;
      variable DRPDO4_GlitchData : VitalGlitchDataType;
      variable DRPDO5_GlitchData : VitalGlitchDataType;
      variable DRPDO6_GlitchData : VitalGlitchDataType;
      variable DRPDO7_GlitchData : VitalGlitchDataType;
      variable DRPDO8_GlitchData : VitalGlitchDataType;
      variable DRPDO9_GlitchData : VitalGlitchDataType;
      variable DRPDRDY_GlitchData : VitalGlitchDataType;
      variable LL2BADDLLPERRN_GlitchData : VitalGlitchDataType;
      variable LL2BADTLPERRN_GlitchData : VitalGlitchDataType;
      variable LL2PROTOCOLERRN_GlitchData : VitalGlitchDataType;
      variable LL2REPLAYROERRN_GlitchData : VitalGlitchDataType;
      variable LL2REPLAYTOERRN_GlitchData : VitalGlitchDataType;
      variable LL2SUSPENDOKN_GlitchData : VitalGlitchDataType;
      variable LL2TFCINIT1SEQN_GlitchData : VitalGlitchDataType;
      variable LL2TFCINIT2SEQN_GlitchData : VitalGlitchDataType;
      variable LNKCLKEN_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR0_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR10_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR11_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR12_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR1_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR2_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR3_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR4_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR5_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR6_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR7_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR8_GlitchData : VitalGlitchDataType;
      variable MIMRXRADDR9_GlitchData : VitalGlitchDataType;
      variable MIMRXRCE_GlitchData : VitalGlitchDataType;
      variable MIMRXREN_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR0_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR10_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR11_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR12_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR1_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR2_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR3_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR4_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR5_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR6_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR7_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR8_GlitchData : VitalGlitchDataType;
      variable MIMRXWADDR9_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA0_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA10_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA11_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA12_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA13_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA14_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA15_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA16_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA17_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA18_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA19_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA1_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA20_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA21_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA22_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA23_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA24_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA25_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA26_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA27_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA28_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA29_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA2_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA30_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA31_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA32_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA33_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA34_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA35_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA36_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA37_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA38_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA39_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA3_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA40_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA41_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA42_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA43_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA44_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA45_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA46_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA47_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA48_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA49_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA4_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA50_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA51_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA52_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA53_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA54_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA55_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA56_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA57_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA58_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA59_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA5_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA60_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA61_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA62_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA63_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA64_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA65_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA66_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA67_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA6_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA7_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA8_GlitchData : VitalGlitchDataType;
      variable MIMRXWDATA9_GlitchData : VitalGlitchDataType;
      variable MIMRXWEN_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR0_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR10_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR11_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR12_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR1_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR2_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR3_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR4_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR5_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR6_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR7_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR8_GlitchData : VitalGlitchDataType;
      variable MIMTXRADDR9_GlitchData : VitalGlitchDataType;
      variable MIMTXRCE_GlitchData : VitalGlitchDataType;
      variable MIMTXREN_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR0_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR10_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR11_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR12_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR1_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR2_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR3_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR4_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR5_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR6_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR7_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR8_GlitchData : VitalGlitchDataType;
      variable MIMTXWADDR9_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA0_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA10_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA11_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA12_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA13_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA14_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA15_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA16_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA17_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA18_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA19_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA1_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA20_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA21_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA22_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA23_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA24_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA25_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA26_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA27_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA28_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA29_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA2_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA30_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA31_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA32_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA33_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA34_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA35_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA36_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA37_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA38_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA39_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA3_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA40_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA41_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA42_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA43_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA44_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA45_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA46_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA47_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA48_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA49_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA4_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA50_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA51_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA52_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA53_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA54_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA55_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA56_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA57_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA58_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA59_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA5_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA60_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA61_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA62_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA63_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA64_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA65_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA66_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA67_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA68_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA6_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA7_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA8_GlitchData : VitalGlitchDataType;
      variable MIMTXWDATA9_GlitchData : VitalGlitchDataType;
      variable MIMTXWEN_GlitchData : VitalGlitchDataType;
      variable PIPERX0POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX1POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX2POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX3POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX4POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX5POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX6POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPERX7POLARITY_GlitchData : VitalGlitchDataType;
      variable PIPETX0CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX0CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX0COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX0DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX0ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX0POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX0POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX1CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX1CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX1COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX1DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX1ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX1POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX1POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX2CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX2CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX2COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX2DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX2ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX2POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX2POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX3CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX3CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX3COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX3DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX3ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX3POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX3POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX4CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX4CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX4COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX4DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX4ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX4POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX4POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX5CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX5CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX5COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX5DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX5ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX5POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX5POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX6CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX6CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX6COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX6DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX6ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX6POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX6POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETX7CHARISK0_GlitchData : VitalGlitchDataType;
      variable PIPETX7CHARISK1_GlitchData : VitalGlitchDataType;
      variable PIPETX7COMPLIANCE_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA0_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA10_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA11_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA12_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA13_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA14_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA15_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA1_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA2_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA3_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA4_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA5_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA6_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA7_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA8_GlitchData : VitalGlitchDataType;
      variable PIPETX7DATA9_GlitchData : VitalGlitchDataType;
      variable PIPETX7ELECIDLE_GlitchData : VitalGlitchDataType;
      variable PIPETX7POWERDOWN0_GlitchData : VitalGlitchDataType;
      variable PIPETX7POWERDOWN1_GlitchData : VitalGlitchDataType;
      variable PIPETXDEEMPH_GlitchData : VitalGlitchDataType;
      variable PIPETXMARGIN0_GlitchData : VitalGlitchDataType;
      variable PIPETXMARGIN1_GlitchData : VitalGlitchDataType;
      variable PIPETXMARGIN2_GlitchData : VitalGlitchDataType;
      variable PIPETXRATE_GlitchData : VitalGlitchDataType;
      variable PIPETXRCVRDET_GlitchData : VitalGlitchDataType;
      variable PIPETXRESET_GlitchData : VitalGlitchDataType;
      variable PL2LINKUPN_GlitchData : VitalGlitchDataType;
      variable PL2RECEIVERERRN_GlitchData : VitalGlitchDataType;
      variable PL2RECOVERYN_GlitchData : VitalGlitchDataType;
      variable PL2RXELECIDLE_GlitchData : VitalGlitchDataType;
      variable PL2SUSPENDOK_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC0_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC10_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC11_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC1_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC2_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC3_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC4_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC5_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC6_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC7_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC8_GlitchData : VitalGlitchDataType;
      variable PLDBGVEC9_GlitchData : VitalGlitchDataType;
      variable PLINITIALLINKWIDTH0_GlitchData : VitalGlitchDataType;
      variable PLINITIALLINKWIDTH1_GlitchData : VitalGlitchDataType;
      variable PLINITIALLINKWIDTH2_GlitchData : VitalGlitchDataType;
      variable PLLANEREVERSALMODE0_GlitchData : VitalGlitchDataType;
      variable PLLANEREVERSALMODE1_GlitchData : VitalGlitchDataType;
      variable PLLINKGEN2CAP_GlitchData : VitalGlitchDataType;
      variable PLLINKPARTNERGEN2SUPPORTED_GlitchData : VitalGlitchDataType;
      variable PLLINKUPCFGCAP_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE0_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE1_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE2_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE3_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE4_GlitchData : VitalGlitchDataType;
      variable PLLTSSMSTATE5_GlitchData : VitalGlitchDataType;
      variable PLPHYLNKUPN_GlitchData : VitalGlitchDataType;
      variable PLRECEIVEDHOTRST_GlitchData : VitalGlitchDataType;
      variable PLRXPMSTATE0_GlitchData : VitalGlitchDataType;
      variable PLRXPMSTATE1_GlitchData : VitalGlitchDataType;
      variable PLSELLNKRATE_GlitchData : VitalGlitchDataType;
      variable PLSELLNKWIDTH0_GlitchData : VitalGlitchDataType;
      variable PLSELLNKWIDTH1_GlitchData : VitalGlitchDataType;
      variable PLTXPMSTATE0_GlitchData : VitalGlitchDataType;
      variable PLTXPMSTATE1_GlitchData : VitalGlitchDataType;
      variable PLTXPMSTATE2_GlitchData : VitalGlitchDataType;
      variable RECEIVEDFUNCLVLRSTN_GlitchData : VitalGlitchDataType;
      variable TL2ASPMSUSPENDCREDITCHECKOKN_GlitchData : VitalGlitchDataType;
      variable TL2ASPMSUSPENDREQN_GlitchData : VitalGlitchDataType;
      variable TL2PPMSUSPENDOKN_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD0_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD10_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD11_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD1_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD2_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD3_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD4_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD5_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD6_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD7_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD8_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLD9_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH0_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH1_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH2_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH3_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH4_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH5_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH6_GlitchData : VitalGlitchDataType;
      variable TRNFCCPLH7_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD0_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD10_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD11_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD1_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD2_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD3_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD4_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD5_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD6_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD7_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD8_GlitchData : VitalGlitchDataType;
      variable TRNFCNPD9_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH0_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH1_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH2_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH3_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH4_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH5_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH6_GlitchData : VitalGlitchDataType;
      variable TRNFCNPH7_GlitchData : VitalGlitchDataType;
      variable TRNFCPD0_GlitchData : VitalGlitchDataType;
      variable TRNFCPD10_GlitchData : VitalGlitchDataType;
      variable TRNFCPD11_GlitchData : VitalGlitchDataType;
      variable TRNFCPD1_GlitchData : VitalGlitchDataType;
      variable TRNFCPD2_GlitchData : VitalGlitchDataType;
      variable TRNFCPD3_GlitchData : VitalGlitchDataType;
      variable TRNFCPD4_GlitchData : VitalGlitchDataType;
      variable TRNFCPD5_GlitchData : VitalGlitchDataType;
      variable TRNFCPD6_GlitchData : VitalGlitchDataType;
      variable TRNFCPD7_GlitchData : VitalGlitchDataType;
      variable TRNFCPD8_GlitchData : VitalGlitchDataType;
      variable TRNFCPD9_GlitchData : VitalGlitchDataType;
      variable TRNFCPH0_GlitchData : VitalGlitchDataType;
      variable TRNFCPH1_GlitchData : VitalGlitchDataType;
      variable TRNFCPH2_GlitchData : VitalGlitchDataType;
      variable TRNFCPH3_GlitchData : VitalGlitchDataType;
      variable TRNFCPH4_GlitchData : VitalGlitchDataType;
      variable TRNFCPH5_GlitchData : VitalGlitchDataType;
      variable TRNFCPH6_GlitchData : VitalGlitchDataType;
      variable TRNFCPH7_GlitchData : VitalGlitchDataType;
      variable TRNLNKUPN_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN0_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN1_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN2_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN3_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN4_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN5_GlitchData : VitalGlitchDataType;
      variable TRNRBARHITN6_GlitchData : VitalGlitchDataType;
      variable TRNRD0_GlitchData : VitalGlitchDataType;
      variable TRNRD10_GlitchData : VitalGlitchDataType;
      variable TRNRD11_GlitchData : VitalGlitchDataType;
      variable TRNRD12_GlitchData : VitalGlitchDataType;
      variable TRNRD13_GlitchData : VitalGlitchDataType;
      variable TRNRD14_GlitchData : VitalGlitchDataType;
      variable TRNRD15_GlitchData : VitalGlitchDataType;
      variable TRNRD16_GlitchData : VitalGlitchDataType;
      variable TRNRD17_GlitchData : VitalGlitchDataType;
      variable TRNRD18_GlitchData : VitalGlitchDataType;
      variable TRNRD19_GlitchData : VitalGlitchDataType;
      variable TRNRD1_GlitchData : VitalGlitchDataType;
      variable TRNRD20_GlitchData : VitalGlitchDataType;
      variable TRNRD21_GlitchData : VitalGlitchDataType;
      variable TRNRD22_GlitchData : VitalGlitchDataType;
      variable TRNRD23_GlitchData : VitalGlitchDataType;
      variable TRNRD24_GlitchData : VitalGlitchDataType;
      variable TRNRD25_GlitchData : VitalGlitchDataType;
      variable TRNRD26_GlitchData : VitalGlitchDataType;
      variable TRNRD27_GlitchData : VitalGlitchDataType;
      variable TRNRD28_GlitchData : VitalGlitchDataType;
      variable TRNRD29_GlitchData : VitalGlitchDataType;
      variable TRNRD2_GlitchData : VitalGlitchDataType;
      variable TRNRD30_GlitchData : VitalGlitchDataType;
      variable TRNRD31_GlitchData : VitalGlitchDataType;
      variable TRNRD32_GlitchData : VitalGlitchDataType;
      variable TRNRD33_GlitchData : VitalGlitchDataType;
      variable TRNRD34_GlitchData : VitalGlitchDataType;
      variable TRNRD35_GlitchData : VitalGlitchDataType;
      variable TRNRD36_GlitchData : VitalGlitchDataType;
      variable TRNRD37_GlitchData : VitalGlitchDataType;
      variable TRNRD38_GlitchData : VitalGlitchDataType;
      variable TRNRD39_GlitchData : VitalGlitchDataType;
      variable TRNRD3_GlitchData : VitalGlitchDataType;
      variable TRNRD40_GlitchData : VitalGlitchDataType;
      variable TRNRD41_GlitchData : VitalGlitchDataType;
      variable TRNRD42_GlitchData : VitalGlitchDataType;
      variable TRNRD43_GlitchData : VitalGlitchDataType;
      variable TRNRD44_GlitchData : VitalGlitchDataType;
      variable TRNRD45_GlitchData : VitalGlitchDataType;
      variable TRNRD46_GlitchData : VitalGlitchDataType;
      variable TRNRD47_GlitchData : VitalGlitchDataType;
      variable TRNRD48_GlitchData : VitalGlitchDataType;
      variable TRNRD49_GlitchData : VitalGlitchDataType;
      variable TRNRD4_GlitchData : VitalGlitchDataType;
      variable TRNRD50_GlitchData : VitalGlitchDataType;
      variable TRNRD51_GlitchData : VitalGlitchDataType;
      variable TRNRD52_GlitchData : VitalGlitchDataType;
      variable TRNRD53_GlitchData : VitalGlitchDataType;
      variable TRNRD54_GlitchData : VitalGlitchDataType;
      variable TRNRD55_GlitchData : VitalGlitchDataType;
      variable TRNRD56_GlitchData : VitalGlitchDataType;
      variable TRNRD57_GlitchData : VitalGlitchDataType;
      variable TRNRD58_GlitchData : VitalGlitchDataType;
      variable TRNRD59_GlitchData : VitalGlitchDataType;
      variable TRNRD5_GlitchData : VitalGlitchDataType;
      variable TRNRD60_GlitchData : VitalGlitchDataType;
      variable TRNRD61_GlitchData : VitalGlitchDataType;
      variable TRNRD62_GlitchData : VitalGlitchDataType;
      variable TRNRD63_GlitchData : VitalGlitchDataType;
      variable TRNRD6_GlitchData : VitalGlitchDataType;
      variable TRNRD7_GlitchData : VitalGlitchDataType;
      variable TRNRD8_GlitchData : VitalGlitchDataType;
      variable TRNRD9_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA0_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA10_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA11_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA12_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA13_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA14_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA15_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA16_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA17_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA18_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA19_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA1_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA20_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA21_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA22_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA23_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA24_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA25_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA26_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA27_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA28_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA29_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA2_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA30_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA31_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA3_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA4_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA5_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA6_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA7_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA8_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPDATA9_GlitchData : VitalGlitchDataType;
      variable TRNRDLLPSRCRDYN_GlitchData : VitalGlitchDataType;
      variable TRNRECRCERRN_GlitchData : VitalGlitchDataType;
      variable TRNREOFN_GlitchData : VitalGlitchDataType;
      variable TRNRERRFWDN_GlitchData : VitalGlitchDataType;
      variable TRNRREMN_GlitchData : VitalGlitchDataType;
      variable TRNRSOFN_GlitchData : VitalGlitchDataType;
      variable TRNRSRCDSCN_GlitchData : VitalGlitchDataType;
      variable TRNRSRCRDYN_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV0_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV1_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV2_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV3_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV4_GlitchData : VitalGlitchDataType;
      variable TRNTBUFAV5_GlitchData : VitalGlitchDataType;
      variable TRNTCFGREQN_GlitchData : VitalGlitchDataType;
      variable TRNTDLLPDSTRDYN_GlitchData : VitalGlitchDataType;
      variable TRNTDSTRDYN_GlitchData : VitalGlitchDataType;
      variable TRNTERRDROPN_GlitchData : VitalGlitchDataType;
      variable USERRSTN_GlitchData : VitalGlitchDataType;

      variable Pviol_DRPCLK : STD_ULOGIC := '0';
      variable Pviol_PIPECLK : STD_ULOGIC := '0';
      variable Pviol_USERCLK : STD_ULOGIC := '0';
      variable PInfo_DRPCLK : VitalPeriodDataType := VitalPeriodDataInit;
      variable PInfo_PIPECLK : VitalPeriodDataType := VitalPeriodDataInit;
      variable PInfo_USERCLK : VitalPeriodDataType := VitalPeriodDataInit;

      begin

      if (TimingChecksOn) then
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGBYTEENN_USERCLK_posedge(0),
          TimingData => Tmkr_CFGBYTEENN_USERCLK_posedge(0),
          TestSignal => CFGBYTEENN_USERCLK_dly(0),
          TestSignalName => "CFGBYTEENN(0)",
          TestDelay => tisd_CFGBYTEENN_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGBYTEENN_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGBYTEENN_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGBYTEENN_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGBYTEENN_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGBYTEENN_USERCLK_posedge(1),
          TimingData => Tmkr_CFGBYTEENN_USERCLK_posedge(1),
          TestSignal => CFGBYTEENN_USERCLK_dly(1),
          TestSignalName => "CFGBYTEENN(1)",
          TestDelay => tisd_CFGBYTEENN_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGBYTEENN_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGBYTEENN_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGBYTEENN_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGBYTEENN_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGBYTEENN_USERCLK_posedge(2),
          TimingData => Tmkr_CFGBYTEENN_USERCLK_posedge(2),
          TestSignal => CFGBYTEENN_USERCLK_dly(2),
          TestSignalName => "CFGBYTEENN(2)",
          TestDelay => tisd_CFGBYTEENN_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGBYTEENN_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGBYTEENN_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGBYTEENN_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGBYTEENN_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGBYTEENN_USERCLK_posedge(3),
          TimingData => Tmkr_CFGBYTEENN_USERCLK_posedge(3),
          TestSignal => CFGBYTEENN_USERCLK_dly(3),
          TestSignalName => "CFGBYTEENN(3)",
          TestDelay => tisd_CFGBYTEENN_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGBYTEENN_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGBYTEENN_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGBYTEENN_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGBYTEENN_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(0),
          TestSignal => CFGDI_USERCLK_dly(0),
          TestSignalName => "CFGDI(0)",
          TestDelay => tisd_CFGDI_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(1),
          TestSignal => CFGDI_USERCLK_dly(1),
          TestSignalName => "CFGDI(1)",
          TestDelay => tisd_CFGDI_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(10),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(10),
          TestSignal => CFGDI_USERCLK_dly(10),
          TestSignalName => "CFGDI(10)",
          TestDelay => tisd_CFGDI_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(10),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(10),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(11),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(11),
          TestSignal => CFGDI_USERCLK_dly(11),
          TestSignalName => "CFGDI(11)",
          TestDelay => tisd_CFGDI_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(11),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(11),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(12),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(12),
          TestSignal => CFGDI_USERCLK_dly(12),
          TestSignalName => "CFGDI(12)",
          TestDelay => tisd_CFGDI_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(12),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(12),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(13),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(13),
          TestSignal => CFGDI_USERCLK_dly(13),
          TestSignalName => "CFGDI(13)",
          TestDelay => tisd_CFGDI_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(13),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(13),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(14),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(14),
          TestSignal => CFGDI_USERCLK_dly(14),
          TestSignalName => "CFGDI(14)",
          TestDelay => tisd_CFGDI_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(14),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(14),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(15),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(15),
          TestSignal => CFGDI_USERCLK_dly(15),
          TestSignalName => "CFGDI(15)",
          TestDelay => tisd_CFGDI_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(15),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(15),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(16),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(16),
          TestSignal => CFGDI_USERCLK_dly(16),
          TestSignalName => "CFGDI(16)",
          TestDelay => tisd_CFGDI_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(16),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(16),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(17),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(17),
          TestSignal => CFGDI_USERCLK_dly(17),
          TestSignalName => "CFGDI(17)",
          TestDelay => tisd_CFGDI_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(17),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(17),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(18),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(18),
          TestSignal => CFGDI_USERCLK_dly(18),
          TestSignalName => "CFGDI(18)",
          TestDelay => tisd_CFGDI_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(18),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(18),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(19),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(19),
          TestSignal => CFGDI_USERCLK_dly(19),
          TestSignalName => "CFGDI(19)",
          TestDelay => tisd_CFGDI_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(19),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(19),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(2),
          TestSignal => CFGDI_USERCLK_dly(2),
          TestSignalName => "CFGDI(2)",
          TestDelay => tisd_CFGDI_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(20),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(20),
          TestSignal => CFGDI_USERCLK_dly(20),
          TestSignalName => "CFGDI(20)",
          TestDelay => tisd_CFGDI_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(20),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(20),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(21),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(21),
          TestSignal => CFGDI_USERCLK_dly(21),
          TestSignalName => "CFGDI(21)",
          TestDelay => tisd_CFGDI_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(21),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(21),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(22),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(22),
          TestSignal => CFGDI_USERCLK_dly(22),
          TestSignalName => "CFGDI(22)",
          TestDelay => tisd_CFGDI_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(22),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(22),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(23),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(23),
          TestSignal => CFGDI_USERCLK_dly(23),
          TestSignalName => "CFGDI(23)",
          TestDelay => tisd_CFGDI_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(23),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(23),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(24),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(24),
          TestSignal => CFGDI_USERCLK_dly(24),
          TestSignalName => "CFGDI(24)",
          TestDelay => tisd_CFGDI_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(24),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(24),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(25),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(25),
          TestSignal => CFGDI_USERCLK_dly(25),
          TestSignalName => "CFGDI(25)",
          TestDelay => tisd_CFGDI_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(25),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(25),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(26),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(26),
          TestSignal => CFGDI_USERCLK_dly(26),
          TestSignalName => "CFGDI(26)",
          TestDelay => tisd_CFGDI_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(26),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(26),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(27),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(27),
          TestSignal => CFGDI_USERCLK_dly(27),
          TestSignalName => "CFGDI(27)",
          TestDelay => tisd_CFGDI_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(27),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(27),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(28),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(28),
          TestSignal => CFGDI_USERCLK_dly(28),
          TestSignalName => "CFGDI(28)",
          TestDelay => tisd_CFGDI_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(28),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(28),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(29),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(29),
          TestSignal => CFGDI_USERCLK_dly(29),
          TestSignalName => "CFGDI(29)",
          TestDelay => tisd_CFGDI_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(29),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(29),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(3),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(3),
          TestSignal => CFGDI_USERCLK_dly(3),
          TestSignalName => "CFGDI(3)",
          TestDelay => tisd_CFGDI_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(30),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(30),
          TestSignal => CFGDI_USERCLK_dly(30),
          TestSignalName => "CFGDI(30)",
          TestDelay => tisd_CFGDI_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(30),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(30),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(31),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(31),
          TestSignal => CFGDI_USERCLK_dly(31),
          TestSignalName => "CFGDI(31)",
          TestDelay => tisd_CFGDI_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(31),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(31),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(4),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(4),
          TestSignal => CFGDI_USERCLK_dly(4),
          TestSignalName => "CFGDI(4)",
          TestDelay => tisd_CFGDI_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(5),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(5),
          TestSignal => CFGDI_USERCLK_dly(5),
          TestSignalName => "CFGDI(5)",
          TestDelay => tisd_CFGDI_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(6),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(6),
          TestSignal => CFGDI_USERCLK_dly(6),
          TestSignalName => "CFGDI(6)",
          TestDelay => tisd_CFGDI_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(7),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(7),
          TestSignal => CFGDI_USERCLK_dly(7),
          TestSignalName => "CFGDI(7)",
          TestDelay => tisd_CFGDI_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(8),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(8),
          TestSignal => CFGDI_USERCLK_dly(8),
          TestSignalName => "CFGDI(8)",
          TestDelay => tisd_CFGDI_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(8),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(8),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDI_USERCLK_posedge(9),
          TimingData => Tmkr_CFGDI_USERCLK_posedge(9),
          TestSignal => CFGDI_USERCLK_dly(9),
          TestSignalName => "CFGDI(9)",
          TestDelay => tisd_CFGDI_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDI_USERCLK_posedge_posedge(9),
          HoldHigh => thold_CFGDI_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_CFGDI_USERCLK_negedge_posedge(9),
          HoldLow => thold_CFGDI_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(0),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(0),
          TestSignalName => "CFGDSBUSNUMBER(0)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(1),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(1),
          TestSignalName => "CFGDSBUSNUMBER(1)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(2),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(2),
          TestSignalName => "CFGDSBUSNUMBER(2)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(3),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(3),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(3),
          TestSignalName => "CFGDSBUSNUMBER(3)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(4),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(4),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(4),
          TestSignalName => "CFGDSBUSNUMBER(4)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(5),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(5),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(5),
          TestSignalName => "CFGDSBUSNUMBER(5)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(6),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(6),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(6),
          TestSignalName => "CFGDSBUSNUMBER(6)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSBUSNUMBER_USERCLK_posedge(7),
          TimingData => Tmkr_CFGDSBUSNUMBER_USERCLK_posedge(7),
          TestSignal => CFGDSBUSNUMBER_USERCLK_dly(7),
          TestSignalName => "CFGDSBUSNUMBER(7)",
          TestDelay => tisd_CFGDSBUSNUMBER_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSDEVICENUMBER_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge(0),
          TestSignal => CFGDSDEVICENUMBER_USERCLK_dly(0),
          TestSignalName => "CFGDSDEVICENUMBER(0)",
          TestDelay => tisd_CFGDSDEVICENUMBER_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSDEVICENUMBER_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge(1),
          TestSignal => CFGDSDEVICENUMBER_USERCLK_dly(1),
          TestSignalName => "CFGDSDEVICENUMBER(1)",
          TestDelay => tisd_CFGDSDEVICENUMBER_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSDEVICENUMBER_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge(2),
          TestSignal => CFGDSDEVICENUMBER_USERCLK_dly(2),
          TestSignalName => "CFGDSDEVICENUMBER(2)",
          TestDelay => tisd_CFGDSDEVICENUMBER_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSDEVICENUMBER_USERCLK_posedge(3),
          TimingData => Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge(3),
          TestSignal => CFGDSDEVICENUMBER_USERCLK_dly(3),
          TestSignalName => "CFGDSDEVICENUMBER(3)",
          TestDelay => tisd_CFGDSDEVICENUMBER_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSDEVICENUMBER_USERCLK_posedge(4),
          TimingData => Tmkr_CFGDSDEVICENUMBER_USERCLK_posedge(4),
          TestSignal => CFGDSDEVICENUMBER_USERCLK_dly(4),
          TestSignalName => "CFGDSDEVICENUMBER(4)",
          TestDelay => tisd_CFGDSDEVICENUMBER_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSFUNCTIONNUMBER_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDSFUNCTIONNUMBER_USERCLK_posedge(0),
          TestSignal => CFGDSFUNCTIONNUMBER_USERCLK_dly(0),
          TestSignalName => "CFGDSFUNCTIONNUMBER(0)",
          TestDelay => tisd_CFGDSFUNCTIONNUMBER_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSFUNCTIONNUMBER_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDSFUNCTIONNUMBER_USERCLK_posedge(1),
          TestSignal => CFGDSFUNCTIONNUMBER_USERCLK_dly(1),
          TestSignalName => "CFGDSFUNCTIONNUMBER(1)",
          TestDelay => tisd_CFGDSFUNCTIONNUMBER_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSFUNCTIONNUMBER_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDSFUNCTIONNUMBER_USERCLK_posedge(2),
          TestSignal => CFGDSFUNCTIONNUMBER_USERCLK_dly(2),
          TestSignalName => "CFGDSFUNCTIONNUMBER(2)",
          TestDelay => tisd_CFGDSFUNCTIONNUMBER_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(0),
          TestSignal => CFGDSN_USERCLK_dly(0),
          TestSignalName => "CFGDSN(0)",
          TestDelay => tisd_CFGDSN_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(1),
          TestSignal => CFGDSN_USERCLK_dly(1),
          TestSignalName => "CFGDSN(1)",
          TestDelay => tisd_CFGDSN_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(10),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(10),
          TestSignal => CFGDSN_USERCLK_dly(10),
          TestSignalName => "CFGDSN(10)",
          TestDelay => tisd_CFGDSN_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(10),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(10),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(11),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(11),
          TestSignal => CFGDSN_USERCLK_dly(11),
          TestSignalName => "CFGDSN(11)",
          TestDelay => tisd_CFGDSN_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(11),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(11),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(12),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(12),
          TestSignal => CFGDSN_USERCLK_dly(12),
          TestSignalName => "CFGDSN(12)",
          TestDelay => tisd_CFGDSN_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(12),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(12),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(13),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(13),
          TestSignal => CFGDSN_USERCLK_dly(13),
          TestSignalName => "CFGDSN(13)",
          TestDelay => tisd_CFGDSN_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(13),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(13),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(14),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(14),
          TestSignal => CFGDSN_USERCLK_dly(14),
          TestSignalName => "CFGDSN(14)",
          TestDelay => tisd_CFGDSN_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(14),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(14),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(15),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(15),
          TestSignal => CFGDSN_USERCLK_dly(15),
          TestSignalName => "CFGDSN(15)",
          TestDelay => tisd_CFGDSN_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(15),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(15),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(16),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(16),
          TestSignal => CFGDSN_USERCLK_dly(16),
          TestSignalName => "CFGDSN(16)",
          TestDelay => tisd_CFGDSN_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(16),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(16),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(17),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(17),
          TestSignal => CFGDSN_USERCLK_dly(17),
          TestSignalName => "CFGDSN(17)",
          TestDelay => tisd_CFGDSN_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(17),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(17),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(18),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(18),
          TestSignal => CFGDSN_USERCLK_dly(18),
          TestSignalName => "CFGDSN(18)",
          TestDelay => tisd_CFGDSN_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(18),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(18),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(19),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(19),
          TestSignal => CFGDSN_USERCLK_dly(19),
          TestSignalName => "CFGDSN(19)",
          TestDelay => tisd_CFGDSN_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(19),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(19),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(2),
          TestSignal => CFGDSN_USERCLK_dly(2),
          TestSignalName => "CFGDSN(2)",
          TestDelay => tisd_CFGDSN_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(20),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(20),
          TestSignal => CFGDSN_USERCLK_dly(20),
          TestSignalName => "CFGDSN(20)",
          TestDelay => tisd_CFGDSN_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(20),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(20),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(21),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(21),
          TestSignal => CFGDSN_USERCLK_dly(21),
          TestSignalName => "CFGDSN(21)",
          TestDelay => tisd_CFGDSN_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(21),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(21),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(22),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(22),
          TestSignal => CFGDSN_USERCLK_dly(22),
          TestSignalName => "CFGDSN(22)",
          TestDelay => tisd_CFGDSN_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(22),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(22),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(23),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(23),
          TestSignal => CFGDSN_USERCLK_dly(23),
          TestSignalName => "CFGDSN(23)",
          TestDelay => tisd_CFGDSN_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(23),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(23),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(24),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(24),
          TestSignal => CFGDSN_USERCLK_dly(24),
          TestSignalName => "CFGDSN(24)",
          TestDelay => tisd_CFGDSN_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(24),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(24),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(25),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(25),
          TestSignal => CFGDSN_USERCLK_dly(25),
          TestSignalName => "CFGDSN(25)",
          TestDelay => tisd_CFGDSN_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(25),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(25),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(26),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(26),
          TestSignal => CFGDSN_USERCLK_dly(26),
          TestSignalName => "CFGDSN(26)",
          TestDelay => tisd_CFGDSN_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(26),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(26),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(27),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(27),
          TestSignal => CFGDSN_USERCLK_dly(27),
          TestSignalName => "CFGDSN(27)",
          TestDelay => tisd_CFGDSN_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(27),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(27),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(28),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(28),
          TestSignal => CFGDSN_USERCLK_dly(28),
          TestSignalName => "CFGDSN(28)",
          TestDelay => tisd_CFGDSN_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(28),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(28),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(29),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(29),
          TestSignal => CFGDSN_USERCLK_dly(29),
          TestSignalName => "CFGDSN(29)",
          TestDelay => tisd_CFGDSN_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(29),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(29),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(3),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(3),
          TestSignal => CFGDSN_USERCLK_dly(3),
          TestSignalName => "CFGDSN(3)",
          TestDelay => tisd_CFGDSN_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(30),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(30),
          TestSignal => CFGDSN_USERCLK_dly(30),
          TestSignalName => "CFGDSN(30)",
          TestDelay => tisd_CFGDSN_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(30),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(30),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(31),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(31),
          TestSignal => CFGDSN_USERCLK_dly(31),
          TestSignalName => "CFGDSN(31)",
          TestDelay => tisd_CFGDSN_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(31),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(31),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(32),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(32),
          TestSignal => CFGDSN_USERCLK_dly(32),
          TestSignalName => "CFGDSN(32)",
          TestDelay => tisd_CFGDSN_USERCLK(32),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(32),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(32),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(32),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(32),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(33),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(33),
          TestSignal => CFGDSN_USERCLK_dly(33),
          TestSignalName => "CFGDSN(33)",
          TestDelay => tisd_CFGDSN_USERCLK(33),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(33),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(33),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(33),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(33),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(34),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(34),
          TestSignal => CFGDSN_USERCLK_dly(34),
          TestSignalName => "CFGDSN(34)",
          TestDelay => tisd_CFGDSN_USERCLK(34),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(34),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(34),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(34),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(34),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(35),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(35),
          TestSignal => CFGDSN_USERCLK_dly(35),
          TestSignalName => "CFGDSN(35)",
          TestDelay => tisd_CFGDSN_USERCLK(35),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(35),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(35),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(35),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(35),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(36),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(36),
          TestSignal => CFGDSN_USERCLK_dly(36),
          TestSignalName => "CFGDSN(36)",
          TestDelay => tisd_CFGDSN_USERCLK(36),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(36),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(36),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(36),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(36),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(37),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(37),
          TestSignal => CFGDSN_USERCLK_dly(37),
          TestSignalName => "CFGDSN(37)",
          TestDelay => tisd_CFGDSN_USERCLK(37),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(37),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(37),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(37),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(37),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(38),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(38),
          TestSignal => CFGDSN_USERCLK_dly(38),
          TestSignalName => "CFGDSN(38)",
          TestDelay => tisd_CFGDSN_USERCLK(38),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(38),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(38),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(38),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(38),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(39),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(39),
          TestSignal => CFGDSN_USERCLK_dly(39),
          TestSignalName => "CFGDSN(39)",
          TestDelay => tisd_CFGDSN_USERCLK(39),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(39),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(39),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(39),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(39),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(4),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(4),
          TestSignal => CFGDSN_USERCLK_dly(4),
          TestSignalName => "CFGDSN(4)",
          TestDelay => tisd_CFGDSN_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(40),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(40),
          TestSignal => CFGDSN_USERCLK_dly(40),
          TestSignalName => "CFGDSN(40)",
          TestDelay => tisd_CFGDSN_USERCLK(40),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(40),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(40),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(40),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(40),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(41),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(41),
          TestSignal => CFGDSN_USERCLK_dly(41),
          TestSignalName => "CFGDSN(41)",
          TestDelay => tisd_CFGDSN_USERCLK(41),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(41),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(41),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(41),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(41),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(42),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(42),
          TestSignal => CFGDSN_USERCLK_dly(42),
          TestSignalName => "CFGDSN(42)",
          TestDelay => tisd_CFGDSN_USERCLK(42),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(42),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(42),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(42),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(42),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(43),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(43),
          TestSignal => CFGDSN_USERCLK_dly(43),
          TestSignalName => "CFGDSN(43)",
          TestDelay => tisd_CFGDSN_USERCLK(43),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(43),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(43),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(43),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(43),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(44),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(44),
          TestSignal => CFGDSN_USERCLK_dly(44),
          TestSignalName => "CFGDSN(44)",
          TestDelay => tisd_CFGDSN_USERCLK(44),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(44),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(44),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(44),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(44),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(45),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(45),
          TestSignal => CFGDSN_USERCLK_dly(45),
          TestSignalName => "CFGDSN(45)",
          TestDelay => tisd_CFGDSN_USERCLK(45),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(45),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(45),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(45),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(45),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(46),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(46),
          TestSignal => CFGDSN_USERCLK_dly(46),
          TestSignalName => "CFGDSN(46)",
          TestDelay => tisd_CFGDSN_USERCLK(46),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(46),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(46),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(46),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(46),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(47),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(47),
          TestSignal => CFGDSN_USERCLK_dly(47),
          TestSignalName => "CFGDSN(47)",
          TestDelay => tisd_CFGDSN_USERCLK(47),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(47),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(47),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(47),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(47),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(48),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(48),
          TestSignal => CFGDSN_USERCLK_dly(48),
          TestSignalName => "CFGDSN(48)",
          TestDelay => tisd_CFGDSN_USERCLK(48),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(48),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(48),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(48),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(48),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(49),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(49),
          TestSignal => CFGDSN_USERCLK_dly(49),
          TestSignalName => "CFGDSN(49)",
          TestDelay => tisd_CFGDSN_USERCLK(49),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(49),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(49),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(49),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(49),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(5),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(5),
          TestSignal => CFGDSN_USERCLK_dly(5),
          TestSignalName => "CFGDSN(5)",
          TestDelay => tisd_CFGDSN_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(50),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(50),
          TestSignal => CFGDSN_USERCLK_dly(50),
          TestSignalName => "CFGDSN(50)",
          TestDelay => tisd_CFGDSN_USERCLK(50),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(50),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(50),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(50),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(50),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(51),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(51),
          TestSignal => CFGDSN_USERCLK_dly(51),
          TestSignalName => "CFGDSN(51)",
          TestDelay => tisd_CFGDSN_USERCLK(51),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(51),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(51),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(51),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(51),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(52),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(52),
          TestSignal => CFGDSN_USERCLK_dly(52),
          TestSignalName => "CFGDSN(52)",
          TestDelay => tisd_CFGDSN_USERCLK(52),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(52),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(52),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(52),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(52),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(53),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(53),
          TestSignal => CFGDSN_USERCLK_dly(53),
          TestSignalName => "CFGDSN(53)",
          TestDelay => tisd_CFGDSN_USERCLK(53),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(53),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(53),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(53),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(53),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(54),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(54),
          TestSignal => CFGDSN_USERCLK_dly(54),
          TestSignalName => "CFGDSN(54)",
          TestDelay => tisd_CFGDSN_USERCLK(54),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(54),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(54),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(54),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(54),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(55),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(55),
          TestSignal => CFGDSN_USERCLK_dly(55),
          TestSignalName => "CFGDSN(55)",
          TestDelay => tisd_CFGDSN_USERCLK(55),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(55),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(55),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(55),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(55),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(56),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(56),
          TestSignal => CFGDSN_USERCLK_dly(56),
          TestSignalName => "CFGDSN(56)",
          TestDelay => tisd_CFGDSN_USERCLK(56),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(56),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(56),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(56),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(56),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(57),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(57),
          TestSignal => CFGDSN_USERCLK_dly(57),
          TestSignalName => "CFGDSN(57)",
          TestDelay => tisd_CFGDSN_USERCLK(57),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(57),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(57),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(57),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(57),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(58),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(58),
          TestSignal => CFGDSN_USERCLK_dly(58),
          TestSignalName => "CFGDSN(58)",
          TestDelay => tisd_CFGDSN_USERCLK(58),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(58),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(58),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(58),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(58),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(59),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(59),
          TestSignal => CFGDSN_USERCLK_dly(59),
          TestSignalName => "CFGDSN(59)",
          TestDelay => tisd_CFGDSN_USERCLK(59),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(59),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(59),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(59),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(59),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(6),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(6),
          TestSignal => CFGDSN_USERCLK_dly(6),
          TestSignalName => "CFGDSN(6)",
          TestDelay => tisd_CFGDSN_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(60),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(60),
          TestSignal => CFGDSN_USERCLK_dly(60),
          TestSignalName => "CFGDSN(60)",
          TestDelay => tisd_CFGDSN_USERCLK(60),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(60),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(60),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(60),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(60),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(61),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(61),
          TestSignal => CFGDSN_USERCLK_dly(61),
          TestSignalName => "CFGDSN(61)",
          TestDelay => tisd_CFGDSN_USERCLK(61),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(61),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(61),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(61),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(61),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(62),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(62),
          TestSignal => CFGDSN_USERCLK_dly(62),
          TestSignalName => "CFGDSN(62)",
          TestDelay => tisd_CFGDSN_USERCLK(62),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(62),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(62),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(62),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(62),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(63),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(63),
          TestSignal => CFGDSN_USERCLK_dly(63),
          TestSignalName => "CFGDSN(63)",
          TestDelay => tisd_CFGDSN_USERCLK(63),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(63),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(63),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(63),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(63),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(7),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(7),
          TestSignal => CFGDSN_USERCLK_dly(7),
          TestSignalName => "CFGDSN(7)",
          TestDelay => tisd_CFGDSN_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(8),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(8),
          TestSignal => CFGDSN_USERCLK_dly(8),
          TestSignalName => "CFGDSN(8)",
          TestDelay => tisd_CFGDSN_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(8),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(8),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDSN_USERCLK_posedge(9),
          TimingData => Tmkr_CFGDSN_USERCLK_posedge(9),
          TestSignal => CFGDSN_USERCLK_dly(9),
          TestSignalName => "CFGDSN(9)",
          TestDelay => tisd_CFGDSN_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDSN_USERCLK_posedge_posedge(9),
          HoldHigh => thold_CFGDSN_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_CFGDSN_USERCLK_negedge_posedge(9),
          HoldLow => thold_CFGDSN_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(0),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(0),
          TestSignal => CFGDWADDR_USERCLK_dly(0),
          TestSignalName => "CFGDWADDR(0)",
          TestDelay => tisd_CFGDWADDR_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(1),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(1),
          TestSignal => CFGDWADDR_USERCLK_dly(1),
          TestSignalName => "CFGDWADDR(1)",
          TestDelay => tisd_CFGDWADDR_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(2),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(2),
          TestSignal => CFGDWADDR_USERCLK_dly(2),
          TestSignalName => "CFGDWADDR(2)",
          TestDelay => tisd_CFGDWADDR_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(3),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(3),
          TestSignal => CFGDWADDR_USERCLK_dly(3),
          TestSignalName => "CFGDWADDR(3)",
          TestDelay => tisd_CFGDWADDR_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(4),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(4),
          TestSignal => CFGDWADDR_USERCLK_dly(4),
          TestSignalName => "CFGDWADDR(4)",
          TestDelay => tisd_CFGDWADDR_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(5),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(5),
          TestSignal => CFGDWADDR_USERCLK_dly(5),
          TestSignalName => "CFGDWADDR(5)",
          TestDelay => tisd_CFGDWADDR_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(6),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(6),
          TestSignal => CFGDWADDR_USERCLK_dly(6),
          TestSignalName => "CFGDWADDR(6)",
          TestDelay => tisd_CFGDWADDR_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(7),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(7),
          TestSignal => CFGDWADDR_USERCLK_dly(7),
          TestSignalName => "CFGDWADDR(7)",
          TestDelay => tisd_CFGDWADDR_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(8),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(8),
          TestSignal => CFGDWADDR_USERCLK_dly(8),
          TestSignalName => "CFGDWADDR(8)",
          TestDelay => tisd_CFGDWADDR_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(8),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(8),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGDWADDR_USERCLK_posedge(9),
          TimingData => Tmkr_CFGDWADDR_USERCLK_posedge(9),
          TestSignal => CFGDWADDR_USERCLK_dly(9),
          TestSignalName => "CFGDWADDR(9)",
          TestDelay => tisd_CFGDWADDR_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGDWADDR_USERCLK_posedge_posedge(9),
          HoldHigh => thold_CFGDWADDR_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_CFGDWADDR_USERCLK_negedge_posedge(9),
          HoldLow => thold_CFGDWADDR_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRACSN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRACSN_USERCLK_posedge,
          TestSignal => CFGERRACSN_USERCLK_dly,
          TestSignalName => "CFGERRACSN",
          TestDelay => tisd_CFGERRACSN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRACSN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRACSN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRACSN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRACSN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(0),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(0),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(0),
          TestSignalName => "CFGERRAERHEADERLOG(0)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(1),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(1),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(1),
          TestSignalName => "CFGERRAERHEADERLOG(1)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(10),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(10),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(10),
          TestSignalName => "CFGERRAERHEADERLOG(10)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(10),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(10),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(100),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(100),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(100),
          TestSignalName => "CFGERRAERHEADERLOG(100)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(100),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(100),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(100),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(100),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(100),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(101),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(101),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(101),
          TestSignalName => "CFGERRAERHEADERLOG(101)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(101),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(101),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(101),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(101),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(101),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(102),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(102),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(102),
          TestSignalName => "CFGERRAERHEADERLOG(102)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(102),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(102),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(102),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(102),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(102),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(103),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(103),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(103),
          TestSignalName => "CFGERRAERHEADERLOG(103)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(103),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(103),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(103),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(103),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(103),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(104),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(104),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(104),
          TestSignalName => "CFGERRAERHEADERLOG(104)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(104),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(104),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(104),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(104),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(104),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(105),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(105),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(105),
          TestSignalName => "CFGERRAERHEADERLOG(105)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(105),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(105),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(105),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(105),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(105),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(106),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(106),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(106),
          TestSignalName => "CFGERRAERHEADERLOG(106)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(106),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(106),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(106),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(106),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(106),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(107),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(107),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(107),
          TestSignalName => "CFGERRAERHEADERLOG(107)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(107),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(107),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(107),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(107),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(107),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(108),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(108),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(108),
          TestSignalName => "CFGERRAERHEADERLOG(108)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(108),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(108),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(108),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(108),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(108),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(109),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(109),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(109),
          TestSignalName => "CFGERRAERHEADERLOG(109)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(109),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(109),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(109),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(109),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(109),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(11),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(11),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(11),
          TestSignalName => "CFGERRAERHEADERLOG(11)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(11),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(11),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(110),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(110),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(110),
          TestSignalName => "CFGERRAERHEADERLOG(110)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(110),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(110),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(110),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(110),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(110),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(111),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(111),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(111),
          TestSignalName => "CFGERRAERHEADERLOG(111)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(111),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(111),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(111),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(111),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(111),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(112),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(112),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(112),
          TestSignalName => "CFGERRAERHEADERLOG(112)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(112),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(112),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(112),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(112),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(112),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(113),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(113),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(113),
          TestSignalName => "CFGERRAERHEADERLOG(113)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(113),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(113),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(113),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(113),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(113),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(114),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(114),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(114),
          TestSignalName => "CFGERRAERHEADERLOG(114)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(114),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(114),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(114),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(114),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(114),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(115),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(115),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(115),
          TestSignalName => "CFGERRAERHEADERLOG(115)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(115),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(115),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(115),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(115),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(115),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(116),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(116),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(116),
          TestSignalName => "CFGERRAERHEADERLOG(116)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(116),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(116),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(116),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(116),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(116),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(117),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(117),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(117),
          TestSignalName => "CFGERRAERHEADERLOG(117)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(117),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(117),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(117),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(117),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(117),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(118),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(118),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(118),
          TestSignalName => "CFGERRAERHEADERLOG(118)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(118),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(118),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(118),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(118),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(118),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(119),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(119),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(119),
          TestSignalName => "CFGERRAERHEADERLOG(119)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(119),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(119),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(119),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(119),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(119),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(12),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(12),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(12),
          TestSignalName => "CFGERRAERHEADERLOG(12)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(12),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(12),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(120),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(120),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(120),
          TestSignalName => "CFGERRAERHEADERLOG(120)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(120),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(120),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(120),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(120),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(120),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(121),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(121),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(121),
          TestSignalName => "CFGERRAERHEADERLOG(121)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(121),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(121),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(121),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(121),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(121),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(122),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(122),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(122),
          TestSignalName => "CFGERRAERHEADERLOG(122)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(122),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(122),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(122),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(122),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(122),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(123),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(123),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(123),
          TestSignalName => "CFGERRAERHEADERLOG(123)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(123),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(123),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(123),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(123),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(123),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(124),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(124),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(124),
          TestSignalName => "CFGERRAERHEADERLOG(124)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(124),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(124),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(124),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(124),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(124),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(125),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(125),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(125),
          TestSignalName => "CFGERRAERHEADERLOG(125)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(125),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(125),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(125),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(125),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(125),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(126),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(126),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(126),
          TestSignalName => "CFGERRAERHEADERLOG(126)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(126),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(126),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(126),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(126),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(126),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(127),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(127),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(127),
          TestSignalName => "CFGERRAERHEADERLOG(127)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(127),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(127),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(127),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(127),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(127),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(13),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(13),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(13),
          TestSignalName => "CFGERRAERHEADERLOG(13)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(13),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(13),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(14),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(14),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(14),
          TestSignalName => "CFGERRAERHEADERLOG(14)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(14),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(14),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(15),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(15),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(15),
          TestSignalName => "CFGERRAERHEADERLOG(15)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(15),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(15),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(16),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(16),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(16),
          TestSignalName => "CFGERRAERHEADERLOG(16)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(16),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(16),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(17),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(17),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(17),
          TestSignalName => "CFGERRAERHEADERLOG(17)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(17),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(17),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(18),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(18),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(18),
          TestSignalName => "CFGERRAERHEADERLOG(18)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(18),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(18),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(19),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(19),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(19),
          TestSignalName => "CFGERRAERHEADERLOG(19)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(19),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(19),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(2),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(2),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(2),
          TestSignalName => "CFGERRAERHEADERLOG(2)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(20),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(20),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(20),
          TestSignalName => "CFGERRAERHEADERLOG(20)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(20),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(20),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(21),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(21),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(21),
          TestSignalName => "CFGERRAERHEADERLOG(21)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(21),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(21),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(22),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(22),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(22),
          TestSignalName => "CFGERRAERHEADERLOG(22)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(22),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(22),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(23),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(23),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(23),
          TestSignalName => "CFGERRAERHEADERLOG(23)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(23),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(23),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(24),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(24),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(24),
          TestSignalName => "CFGERRAERHEADERLOG(24)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(24),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(24),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(25),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(25),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(25),
          TestSignalName => "CFGERRAERHEADERLOG(25)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(25),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(25),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(26),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(26),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(26),
          TestSignalName => "CFGERRAERHEADERLOG(26)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(26),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(26),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(27),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(27),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(27),
          TestSignalName => "CFGERRAERHEADERLOG(27)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(27),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(27),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(28),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(28),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(28),
          TestSignalName => "CFGERRAERHEADERLOG(28)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(28),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(28),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(29),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(29),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(29),
          TestSignalName => "CFGERRAERHEADERLOG(29)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(29),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(29),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(3),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(3),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(3),
          TestSignalName => "CFGERRAERHEADERLOG(3)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(30),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(30),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(30),
          TestSignalName => "CFGERRAERHEADERLOG(30)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(30),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(30),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(31),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(31),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(31),
          TestSignalName => "CFGERRAERHEADERLOG(31)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(31),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(31),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(32),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(32),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(32),
          TestSignalName => "CFGERRAERHEADERLOG(32)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(32),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(32),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(32),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(32),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(32),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(33),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(33),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(33),
          TestSignalName => "CFGERRAERHEADERLOG(33)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(33),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(33),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(33),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(33),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(33),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(34),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(34),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(34),
          TestSignalName => "CFGERRAERHEADERLOG(34)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(34),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(34),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(34),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(34),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(34),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(35),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(35),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(35),
          TestSignalName => "CFGERRAERHEADERLOG(35)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(35),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(35),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(35),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(35),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(35),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(36),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(36),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(36),
          TestSignalName => "CFGERRAERHEADERLOG(36)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(36),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(36),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(36),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(36),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(36),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(37),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(37),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(37),
          TestSignalName => "CFGERRAERHEADERLOG(37)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(37),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(37),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(37),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(37),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(37),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(38),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(38),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(38),
          TestSignalName => "CFGERRAERHEADERLOG(38)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(38),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(38),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(38),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(38),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(38),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(39),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(39),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(39),
          TestSignalName => "CFGERRAERHEADERLOG(39)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(39),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(39),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(39),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(39),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(39),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(4),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(4),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(4),
          TestSignalName => "CFGERRAERHEADERLOG(4)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(40),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(40),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(40),
          TestSignalName => "CFGERRAERHEADERLOG(40)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(40),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(40),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(40),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(40),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(40),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(41),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(41),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(41),
          TestSignalName => "CFGERRAERHEADERLOG(41)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(41),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(41),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(41),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(41),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(41),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(42),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(42),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(42),
          TestSignalName => "CFGERRAERHEADERLOG(42)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(42),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(42),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(42),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(42),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(42),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(43),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(43),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(43),
          TestSignalName => "CFGERRAERHEADERLOG(43)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(43),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(43),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(43),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(43),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(43),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(44),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(44),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(44),
          TestSignalName => "CFGERRAERHEADERLOG(44)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(44),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(44),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(44),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(44),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(44),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(45),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(45),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(45),
          TestSignalName => "CFGERRAERHEADERLOG(45)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(45),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(45),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(45),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(45),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(45),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(46),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(46),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(46),
          TestSignalName => "CFGERRAERHEADERLOG(46)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(46),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(46),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(46),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(46),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(46),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(47),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(47),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(47),
          TestSignalName => "CFGERRAERHEADERLOG(47)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(47),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(47),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(47),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(47),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(47),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(48),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(48),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(48),
          TestSignalName => "CFGERRAERHEADERLOG(48)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(48),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(48),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(48),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(48),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(48),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(49),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(49),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(49),
          TestSignalName => "CFGERRAERHEADERLOG(49)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(49),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(49),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(49),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(49),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(49),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(5),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(5),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(5),
          TestSignalName => "CFGERRAERHEADERLOG(5)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(50),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(50),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(50),
          TestSignalName => "CFGERRAERHEADERLOG(50)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(50),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(50),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(50),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(50),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(50),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(51),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(51),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(51),
          TestSignalName => "CFGERRAERHEADERLOG(51)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(51),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(51),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(51),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(51),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(51),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(52),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(52),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(52),
          TestSignalName => "CFGERRAERHEADERLOG(52)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(52),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(52),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(52),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(52),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(52),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(53),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(53),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(53),
          TestSignalName => "CFGERRAERHEADERLOG(53)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(53),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(53),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(53),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(53),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(53),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(54),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(54),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(54),
          TestSignalName => "CFGERRAERHEADERLOG(54)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(54),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(54),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(54),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(54),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(54),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(55),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(55),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(55),
          TestSignalName => "CFGERRAERHEADERLOG(55)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(55),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(55),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(55),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(55),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(55),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(56),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(56),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(56),
          TestSignalName => "CFGERRAERHEADERLOG(56)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(56),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(56),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(56),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(56),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(56),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(57),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(57),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(57),
          TestSignalName => "CFGERRAERHEADERLOG(57)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(57),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(57),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(57),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(57),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(57),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(58),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(58),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(58),
          TestSignalName => "CFGERRAERHEADERLOG(58)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(58),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(58),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(58),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(58),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(58),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(59),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(59),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(59),
          TestSignalName => "CFGERRAERHEADERLOG(59)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(59),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(59),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(59),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(59),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(59),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(6),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(6),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(6),
          TestSignalName => "CFGERRAERHEADERLOG(6)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(60),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(60),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(60),
          TestSignalName => "CFGERRAERHEADERLOG(60)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(60),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(60),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(60),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(60),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(60),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(61),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(61),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(61),
          TestSignalName => "CFGERRAERHEADERLOG(61)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(61),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(61),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(61),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(61),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(61),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(62),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(62),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(62),
          TestSignalName => "CFGERRAERHEADERLOG(62)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(62),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(62),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(62),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(62),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(62),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(63),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(63),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(63),
          TestSignalName => "CFGERRAERHEADERLOG(63)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(63),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(63),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(63),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(63),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(63),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(64),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(64),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(64),
          TestSignalName => "CFGERRAERHEADERLOG(64)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(64),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(64),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(64),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(64),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(64),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(65),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(65),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(65),
          TestSignalName => "CFGERRAERHEADERLOG(65)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(65),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(65),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(65),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(65),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(65),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(66),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(66),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(66),
          TestSignalName => "CFGERRAERHEADERLOG(66)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(66),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(66),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(66),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(66),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(66),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(67),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(67),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(67),
          TestSignalName => "CFGERRAERHEADERLOG(67)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(67),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(67),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(67),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(67),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(67),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(68),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(68),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(68),
          TestSignalName => "CFGERRAERHEADERLOG(68)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(68),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(68),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(68),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(68),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(68),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(69),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(69),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(69),
          TestSignalName => "CFGERRAERHEADERLOG(69)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(69),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(69),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(69),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(69),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(69),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(7),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(7),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(7),
          TestSignalName => "CFGERRAERHEADERLOG(7)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(70),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(70),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(70),
          TestSignalName => "CFGERRAERHEADERLOG(70)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(70),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(70),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(70),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(70),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(70),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(71),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(71),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(71),
          TestSignalName => "CFGERRAERHEADERLOG(71)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(71),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(71),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(71),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(71),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(71),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(72),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(72),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(72),
          TestSignalName => "CFGERRAERHEADERLOG(72)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(72),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(72),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(72),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(72),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(72),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(73),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(73),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(73),
          TestSignalName => "CFGERRAERHEADERLOG(73)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(73),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(73),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(73),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(73),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(73),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(74),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(74),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(74),
          TestSignalName => "CFGERRAERHEADERLOG(74)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(74),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(74),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(74),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(74),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(74),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(75),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(75),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(75),
          TestSignalName => "CFGERRAERHEADERLOG(75)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(75),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(75),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(75),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(75),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(75),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(76),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(76),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(76),
          TestSignalName => "CFGERRAERHEADERLOG(76)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(76),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(76),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(76),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(76),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(76),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(77),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(77),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(77),
          TestSignalName => "CFGERRAERHEADERLOG(77)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(77),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(77),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(77),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(77),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(77),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(78),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(78),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(78),
          TestSignalName => "CFGERRAERHEADERLOG(78)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(78),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(78),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(78),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(78),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(78),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(79),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(79),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(79),
          TestSignalName => "CFGERRAERHEADERLOG(79)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(79),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(79),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(79),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(79),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(79),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(8),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(8),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(8),
          TestSignalName => "CFGERRAERHEADERLOG(8)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(8),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(8),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(80),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(80),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(80),
          TestSignalName => "CFGERRAERHEADERLOG(80)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(80),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(80),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(80),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(80),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(80),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(81),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(81),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(81),
          TestSignalName => "CFGERRAERHEADERLOG(81)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(81),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(81),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(81),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(81),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(81),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(82),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(82),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(82),
          TestSignalName => "CFGERRAERHEADERLOG(82)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(82),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(82),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(82),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(82),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(82),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(83),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(83),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(83),
          TestSignalName => "CFGERRAERHEADERLOG(83)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(83),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(83),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(83),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(83),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(83),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(84),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(84),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(84),
          TestSignalName => "CFGERRAERHEADERLOG(84)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(84),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(84),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(84),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(84),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(84),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(85),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(85),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(85),
          TestSignalName => "CFGERRAERHEADERLOG(85)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(85),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(85),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(85),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(85),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(85),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(86),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(86),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(86),
          TestSignalName => "CFGERRAERHEADERLOG(86)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(86),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(86),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(86),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(86),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(86),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(87),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(87),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(87),
          TestSignalName => "CFGERRAERHEADERLOG(87)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(87),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(87),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(87),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(87),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(87),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(88),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(88),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(88),
          TestSignalName => "CFGERRAERHEADERLOG(88)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(88),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(88),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(88),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(88),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(88),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(89),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(89),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(89),
          TestSignalName => "CFGERRAERHEADERLOG(89)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(89),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(89),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(89),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(89),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(89),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(9),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(9),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(9),
          TestSignalName => "CFGERRAERHEADERLOG(9)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(9),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(9),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(90),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(90),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(90),
          TestSignalName => "CFGERRAERHEADERLOG(90)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(90),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(90),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(90),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(90),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(90),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(91),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(91),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(91),
          TestSignalName => "CFGERRAERHEADERLOG(91)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(91),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(91),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(91),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(91),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(91),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(92),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(92),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(92),
          TestSignalName => "CFGERRAERHEADERLOG(92)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(92),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(92),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(92),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(92),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(92),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(93),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(93),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(93),
          TestSignalName => "CFGERRAERHEADERLOG(93)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(93),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(93),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(93),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(93),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(93),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(94),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(94),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(94),
          TestSignalName => "CFGERRAERHEADERLOG(94)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(94),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(94),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(94),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(94),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(94),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(95),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(95),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(95),
          TestSignalName => "CFGERRAERHEADERLOG(95)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(95),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(95),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(95),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(95),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(95),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(96),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(96),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(96),
          TestSignalName => "CFGERRAERHEADERLOG(96)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(96),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(96),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(96),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(96),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(96),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(97),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(97),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(97),
          TestSignalName => "CFGERRAERHEADERLOG(97)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(97),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(97),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(97),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(97),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(97),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(98),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(98),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(98),
          TestSignalName => "CFGERRAERHEADERLOG(98)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(98),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(98),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(98),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(98),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(98),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRAERHEADERLOG_USERCLK_posedge(99),
          TimingData => Tmkr_CFGERRAERHEADERLOG_USERCLK_posedge(99),
          TestSignal => CFGERRAERHEADERLOG_USERCLK_dly(99),
          TestSignalName => "CFGERRAERHEADERLOG(99)",
          TestDelay => tisd_CFGERRAERHEADERLOG_USERCLK(99),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(99),
          HoldHigh => thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge(99),
          SetupLow => tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(99),
          HoldLow => thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge(99),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRCORN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRCORN_USERCLK_posedge,
          TestSignal => CFGERRCORN_USERCLK_dly,
          TestSignalName => "CFGERRCORN",
          TestDelay => tisd_CFGERRCORN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRCORN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRCORN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRCORN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRCORN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRCPLABORTN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRCPLABORTN_USERCLK_posedge,
          TestSignal => CFGERRCPLABORTN_USERCLK_dly,
          TestSignalName => "CFGERRCPLABORTN",
          TestDelay => tisd_CFGERRCPLABORTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRCPLABORTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRCPLABORTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRCPLABORTN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRCPLABORTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRCPLTIMEOUTN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRCPLTIMEOUTN_USERCLK_posedge,
          TestSignal => CFGERRCPLTIMEOUTN_USERCLK_dly,
          TestSignalName => "CFGERRCPLTIMEOUTN",
          TestDelay => tisd_CFGERRCPLTIMEOUTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRCPLUNEXPECTN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRCPLUNEXPECTN_USERCLK_posedge,
          TestSignal => CFGERRCPLUNEXPECTN_USERCLK_dly,
          TestSignalName => "CFGERRCPLUNEXPECTN",
          TestDelay => tisd_CFGERRCPLUNEXPECTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRECRCN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRECRCN_USERCLK_posedge,
          TestSignal => CFGERRECRCN_USERCLK_dly,
          TestSignalName => "CFGERRECRCN",
          TestDelay => tisd_CFGERRECRCN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRECRCN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRECRCN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRECRCN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRECRCN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRLOCKEDN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRLOCKEDN_USERCLK_posedge,
          TestSignal => CFGERRLOCKEDN_USERCLK_dly,
          TestSignalName => "CFGERRLOCKEDN",
          TestDelay => tisd_CFGERRLOCKEDN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRLOCKEDN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRLOCKEDN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRLOCKEDN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRLOCKEDN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRPOSTEDN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRPOSTEDN_USERCLK_posedge,
          TestSignal => CFGERRPOSTEDN_USERCLK_dly,
          TestSignalName => "CFGERRPOSTEDN",
          TestDelay => tisd_CFGERRPOSTEDN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRPOSTEDN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRPOSTEDN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRPOSTEDN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRPOSTEDN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(0),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(0),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(0),
          TestSignalName => "CFGERRTLPCPLHEADER(0)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(1),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(1),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(1),
          TestSignalName => "CFGERRTLPCPLHEADER(1)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(10),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(10),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(10),
          TestSignalName => "CFGERRTLPCPLHEADER(10)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(10),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(10),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(11),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(11),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(11),
          TestSignalName => "CFGERRTLPCPLHEADER(11)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(11),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(11),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(12),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(12),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(12),
          TestSignalName => "CFGERRTLPCPLHEADER(12)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(12),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(12),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(13),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(13),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(13),
          TestSignalName => "CFGERRTLPCPLHEADER(13)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(13),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(13),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(14),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(14),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(14),
          TestSignalName => "CFGERRTLPCPLHEADER(14)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(14),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(14),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(15),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(15),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(15),
          TestSignalName => "CFGERRTLPCPLHEADER(15)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(15),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(15),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(16),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(16),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(16),
          TestSignalName => "CFGERRTLPCPLHEADER(16)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(16),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(16),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(17),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(17),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(17),
          TestSignalName => "CFGERRTLPCPLHEADER(17)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(17),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(17),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(18),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(18),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(18),
          TestSignalName => "CFGERRTLPCPLHEADER(18)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(18),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(18),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(19),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(19),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(19),
          TestSignalName => "CFGERRTLPCPLHEADER(19)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(19),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(19),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(2),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(2),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(2),
          TestSignalName => "CFGERRTLPCPLHEADER(2)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(20),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(20),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(20),
          TestSignalName => "CFGERRTLPCPLHEADER(20)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(20),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(20),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(21),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(21),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(21),
          TestSignalName => "CFGERRTLPCPLHEADER(21)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(21),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(21),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(22),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(22),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(22),
          TestSignalName => "CFGERRTLPCPLHEADER(22)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(22),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(22),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(23),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(23),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(23),
          TestSignalName => "CFGERRTLPCPLHEADER(23)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(23),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(23),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(24),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(24),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(24),
          TestSignalName => "CFGERRTLPCPLHEADER(24)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(24),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(24),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(25),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(25),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(25),
          TestSignalName => "CFGERRTLPCPLHEADER(25)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(25),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(25),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(26),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(26),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(26),
          TestSignalName => "CFGERRTLPCPLHEADER(26)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(26),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(26),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(27),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(27),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(27),
          TestSignalName => "CFGERRTLPCPLHEADER(27)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(27),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(27),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(28),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(28),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(28),
          TestSignalName => "CFGERRTLPCPLHEADER(28)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(28),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(28),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(29),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(29),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(29),
          TestSignalName => "CFGERRTLPCPLHEADER(29)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(29),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(29),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(3),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(3),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(3),
          TestSignalName => "CFGERRTLPCPLHEADER(3)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(30),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(30),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(30),
          TestSignalName => "CFGERRTLPCPLHEADER(30)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(30),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(30),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(31),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(31),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(31),
          TestSignalName => "CFGERRTLPCPLHEADER(31)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(31),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(31),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(32),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(32),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(32),
          TestSignalName => "CFGERRTLPCPLHEADER(32)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(32),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(32),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(32),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(32),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(32),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(33),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(33),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(33),
          TestSignalName => "CFGERRTLPCPLHEADER(33)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(33),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(33),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(33),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(33),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(33),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(34),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(34),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(34),
          TestSignalName => "CFGERRTLPCPLHEADER(34)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(34),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(34),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(34),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(34),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(34),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(35),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(35),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(35),
          TestSignalName => "CFGERRTLPCPLHEADER(35)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(35),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(35),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(35),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(35),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(35),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(36),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(36),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(36),
          TestSignalName => "CFGERRTLPCPLHEADER(36)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(36),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(36),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(36),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(36),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(36),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(37),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(37),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(37),
          TestSignalName => "CFGERRTLPCPLHEADER(37)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(37),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(37),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(37),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(37),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(37),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(38),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(38),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(38),
          TestSignalName => "CFGERRTLPCPLHEADER(38)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(38),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(38),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(38),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(38),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(38),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(39),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(39),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(39),
          TestSignalName => "CFGERRTLPCPLHEADER(39)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(39),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(39),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(39),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(39),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(39),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(4),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(4),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(4),
          TestSignalName => "CFGERRTLPCPLHEADER(4)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(40),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(40),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(40),
          TestSignalName => "CFGERRTLPCPLHEADER(40)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(40),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(40),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(40),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(40),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(40),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(41),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(41),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(41),
          TestSignalName => "CFGERRTLPCPLHEADER(41)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(41),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(41),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(41),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(41),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(41),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(42),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(42),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(42),
          TestSignalName => "CFGERRTLPCPLHEADER(42)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(42),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(42),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(42),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(42),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(42),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(43),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(43),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(43),
          TestSignalName => "CFGERRTLPCPLHEADER(43)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(43),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(43),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(43),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(43),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(43),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(44),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(44),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(44),
          TestSignalName => "CFGERRTLPCPLHEADER(44)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(44),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(44),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(44),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(44),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(44),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(45),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(45),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(45),
          TestSignalName => "CFGERRTLPCPLHEADER(45)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(45),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(45),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(45),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(45),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(45),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(46),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(46),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(46),
          TestSignalName => "CFGERRTLPCPLHEADER(46)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(46),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(46),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(46),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(46),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(46),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(47),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(47),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(47),
          TestSignalName => "CFGERRTLPCPLHEADER(47)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(47),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(47),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(47),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(47),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(47),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(5),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(5),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(5),
          TestSignalName => "CFGERRTLPCPLHEADER(5)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(6),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(6),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(6),
          TestSignalName => "CFGERRTLPCPLHEADER(6)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(7),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(7),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(7),
          TestSignalName => "CFGERRTLPCPLHEADER(7)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(8),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(8),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(8),
          TestSignalName => "CFGERRTLPCPLHEADER(8)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(8),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(8),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRTLPCPLHEADER_USERCLK_posedge(9),
          TimingData => Tmkr_CFGERRTLPCPLHEADER_USERCLK_posedge(9),
          TestSignal => CFGERRTLPCPLHEADER_USERCLK_dly(9),
          TestSignalName => "CFGERRTLPCPLHEADER(9)",
          TestDelay => tisd_CFGERRTLPCPLHEADER_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(9),
          HoldHigh => thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(9),
          HoldLow => thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGERRURN_USERCLK_posedge,
          TimingData => Tmkr_CFGERRURN_USERCLK_posedge,
          TestSignal => CFGERRURN_USERCLK_dly,
          TestSignalName => "CFGERRURN",
          TestDelay => tisd_CFGERRURN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGERRURN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGERRURN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGERRURN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGERRURN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTASSERTN_USERCLK_posedge,
          TimingData => Tmkr_CFGINTERRUPTASSERTN_USERCLK_posedge,
          TestSignal => CFGINTERRUPTASSERTN_USERCLK_dly,
          TestSignalName => "CFGINTERRUPTASSERTN",
          TestDelay => tisd_CFGINTERRUPTASSERTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(0),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(0),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(0),
          TestSignalName => "CFGINTERRUPTDI(0)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(1),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(1),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(1),
          TestSignalName => "CFGINTERRUPTDI(1)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(2),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(2),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(2),
          TestSignalName => "CFGINTERRUPTDI(2)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(3),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(3),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(3),
          TestSignalName => "CFGINTERRUPTDI(3)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(4),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(4),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(4),
          TestSignalName => "CFGINTERRUPTDI(4)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(5),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(5),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(5),
          TestSignalName => "CFGINTERRUPTDI(5)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(6),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(6),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(6),
          TestSignalName => "CFGINTERRUPTDI(6)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTDI_USERCLK_posedge(7),
          TimingData => Tmkr_CFGINTERRUPTDI_USERCLK_posedge(7),
          TestSignal => CFGINTERRUPTDI_USERCLK_dly(7),
          TestSignalName => "CFGINTERRUPTDI(7)",
          TestDelay => tisd_CFGINTERRUPTDI_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGINTERRUPTDI_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGINTERRUPTDI_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGINTERRUPTN_USERCLK_posedge,
          TimingData => Tmkr_CFGINTERRUPTN_USERCLK_posedge,
          TestSignal => CFGINTERRUPTN_USERCLK_dly,
          TestSignalName => "CFGINTERRUPTN",
          TestDelay => tisd_CFGINTERRUPTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGINTERRUPTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGINTERRUPTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGINTERRUPTN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGINTERRUPTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMDIRECTASPML1N_USERCLK_posedge,
          TimingData => Tmkr_CFGPMDIRECTASPML1N_USERCLK_posedge,
          TestSignal => CFGPMDIRECTASPML1N_USERCLK_dly,
          TestSignalName => "CFGPMDIRECTASPML1N",
          TestDelay => tisd_CFGPMDIRECTASPML1N_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMSENDPMACKN_USERCLK_posedge,
          TimingData => Tmkr_CFGPMSENDPMACKN_USERCLK_posedge,
          TestSignal => CFGPMSENDPMACKN_USERCLK_dly,
          TestSignalName => "CFGPMSENDPMACKN",
          TestDelay => tisd_CFGPMSENDPMACKN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMSENDPMACKN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMSENDPMACKN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMSENDPMACKN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMSENDPMACKN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMSENDPMETON_USERCLK_posedge,
          TimingData => Tmkr_CFGPMSENDPMETON_USERCLK_posedge,
          TestSignal => CFGPMSENDPMETON_USERCLK_dly,
          TestSignalName => "CFGPMSENDPMETON",
          TestDelay => tisd_CFGPMSENDPMETON_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMSENDPMETON_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMSENDPMETON_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMSENDPMETON_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMSENDPMETON_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMSENDPMNAKN_USERCLK_posedge,
          TimingData => Tmkr_CFGPMSENDPMNAKN_USERCLK_posedge,
          TestSignal => CFGPMSENDPMNAKN_USERCLK_dly,
          TestSignalName => "CFGPMSENDPMNAKN",
          TestDelay => tisd_CFGPMSENDPMNAKN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMSENDPMNAKN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMSENDPMNAKN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMSENDPMNAKN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMSENDPMNAKN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMTURNOFFOKN_USERCLK_posedge,
          TimingData => Tmkr_CFGPMTURNOFFOKN_USERCLK_posedge,
          TestSignal => CFGPMTURNOFFOKN_USERCLK_dly,
          TestSignalName => "CFGPMTURNOFFOKN",
          TestDelay => tisd_CFGPMTURNOFFOKN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMTURNOFFOKN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMTURNOFFOKN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMTURNOFFOKN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMTURNOFFOKN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPMWAKEN_USERCLK_posedge,
          TimingData => Tmkr_CFGPMWAKEN_USERCLK_posedge,
          TestSignal => CFGPMWAKEN_USERCLK_dly,
          TestSignalName => "CFGPMWAKEN",
          TestDelay => tisd_CFGPMWAKEN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPMWAKEN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGPMWAKEN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGPMWAKEN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGPMWAKEN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(0),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(0),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(0),
          TestSignalName => "CFGPORTNUMBER(0)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(0),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(0),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(1),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(1),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(1),
          TestSignalName => "CFGPORTNUMBER(1)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(1),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(1),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(2),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(2),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(2),
          TestSignalName => "CFGPORTNUMBER(2)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(2),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(2),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(3),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(3),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(3),
          TestSignalName => "CFGPORTNUMBER(3)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(3),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(3),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(4),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(4),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(4),
          TestSignalName => "CFGPORTNUMBER(4)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(4),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(4),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(5),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(5),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(5),
          TestSignalName => "CFGPORTNUMBER(5)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(5),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(5),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(6),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(6),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(6),
          TestSignalName => "CFGPORTNUMBER(6)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(6),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(6),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGPORTNUMBER_USERCLK_posedge(7),
          TimingData => Tmkr_CFGPORTNUMBER_USERCLK_posedge(7),
          TestSignal => CFGPORTNUMBER_USERCLK_dly(7),
          TestSignalName => "CFGPORTNUMBER(7)",
          TestDelay => tisd_CFGPORTNUMBER_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge(7),
          HoldHigh => thold_CFGPORTNUMBER_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge(7),
          HoldLow => thold_CFGPORTNUMBER_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGRDENN_USERCLK_posedge,
          TimingData => Tmkr_CFGRDENN_USERCLK_posedge,
          TestSignal => CFGRDENN_USERCLK_dly,
          TestSignalName => "CFGRDENN",
          TestDelay => tisd_CFGRDENN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGRDENN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGRDENN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGRDENN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGRDENN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGTRNPENDINGN_USERCLK_posedge,
          TimingData => Tmkr_CFGTRNPENDINGN_USERCLK_posedge,
          TestSignal => CFGTRNPENDINGN_USERCLK_dly,
          TestSignalName => "CFGTRNPENDINGN",
          TestDelay => tisd_CFGTRNPENDINGN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGTRNPENDINGN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGTRNPENDINGN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGTRNPENDINGN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGTRNPENDINGN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGWRENN_USERCLK_posedge,
          TimingData => Tmkr_CFGWRENN_USERCLK_posedge,
          TestSignal => CFGWRENN_USERCLK_dly,
          TestSignalName => "CFGWRENN",
          TestDelay => tisd_CFGWRENN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGWRENN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGWRENN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGWRENN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGWRENN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGWRREADONLYN_USERCLK_posedge,
          TimingData => Tmkr_CFGWRREADONLYN_USERCLK_posedge,
          TestSignal => CFGWRREADONLYN_USERCLK_dly,
          TestSignalName => "CFGWRREADONLYN",
          TestDelay => tisd_CFGWRREADONLYN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGWRREADONLYN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGWRREADONLYN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGWRREADONLYN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGWRREADONLYN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CFGWRRW1CASRWN_USERCLK_posedge,
          TimingData => Tmkr_CFGWRRW1CASRWN_USERCLK_posedge,
          TestSignal => CFGWRRW1CASRWN_USERCLK_dly,
          TestSignalName => "CFGWRRW1CASRWN",
          TestDelay => tisd_CFGWRRW1CASRWN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CFGWRRW1CASRWN_USERCLK_posedge_posedge,
          HoldHigh => thold_CFGWRRW1CASRWN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CFGWRRW1CASRWN_USERCLK_negedge_posedge,
          HoldLow => thold_CFGWRRW1CASRWN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CMRSTN_USERCLK_posedge,
          TimingData => Tmkr_CMRSTN_USERCLK_posedge,
          TestSignal => CMRSTN_USERCLK_dly,
          TestSignalName => "CMRSTN",
          TestDelay => tisd_CMRSTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CMRSTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CMRSTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CMRSTN_USERCLK_negedge_posedge,
          HoldLow => thold_CMRSTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_CMSTICKYRSTN_USERCLK_posedge,
          TimingData => Tmkr_CMSTICKYRSTN_USERCLK_posedge,
          TestSignal => CMSTICKYRSTN_USERCLK_dly,
          TestSignalName => "CMSTICKYRSTN",
          TestDelay => tisd_CMSTICKYRSTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_CMSTICKYRSTN_USERCLK_posedge_posedge,
          HoldHigh => thold_CMSTICKYRSTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_CMSTICKYRSTN_USERCLK_negedge_posedge,
          HoldLow => thold_CMSTICKYRSTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DBGMODE_USERCLK_posedge(0),
          TimingData => Tmkr_DBGMODE_USERCLK_posedge(0),
          TestSignal => DBGMODE_USERCLK_dly(0),
          TestSignalName => "DBGMODE(0)",
          TestDelay => tisd_DBGMODE_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_DBGMODE_USERCLK_posedge_posedge(0),
          HoldHigh => thold_DBGMODE_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_DBGMODE_USERCLK_negedge_posedge(0),
          HoldLow => thold_DBGMODE_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DBGMODE_USERCLK_posedge(1),
          TimingData => Tmkr_DBGMODE_USERCLK_posedge(1),
          TestSignal => DBGMODE_USERCLK_dly(1),
          TestSignalName => "DBGMODE(1)",
          TestDelay => tisd_DBGMODE_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_DBGMODE_USERCLK_posedge_posedge(1),
          HoldHigh => thold_DBGMODE_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_DBGMODE_USERCLK_negedge_posedge(1),
          HoldLow => thold_DBGMODE_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DBGSUBMODE_USERCLK_posedge,
          TimingData => Tmkr_DBGSUBMODE_USERCLK_posedge,
          TestSignal => DBGSUBMODE_USERCLK_dly,
          TestSignalName => "DBGSUBMODE",
          TestDelay => tisd_DBGSUBMODE_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_DBGSUBMODE_USERCLK_posedge_posedge,
          HoldHigh => thold_DBGSUBMODE_USERCLK_posedge_posedge,
          SetupLow => tsetup_DBGSUBMODE_USERCLK_negedge_posedge,
          HoldLow => thold_DBGSUBMODE_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DLRSTN_USERCLK_posedge,
          TimingData => Tmkr_DLRSTN_USERCLK_posedge,
          TestSignal => DLRSTN_USERCLK_dly,
          TestSignalName => "DLRSTN",
          TestDelay => tisd_DLRSTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_DLRSTN_USERCLK_posedge_posedge,
          HoldHigh => thold_DLRSTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_DLRSTN_USERCLK_negedge_posedge,
          HoldLow => thold_DLRSTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(0),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(0),
          TestSignal => DRPDADDR_DRPCLK_dly(0),
          TestSignalName => "DRPDADDR(0)",
          TestDelay => tisd_DRPDADDR_DRPCLK(0),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(0),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(0),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(0),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(1),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(1),
          TestSignal => DRPDADDR_DRPCLK_dly(1),
          TestSignalName => "DRPDADDR(1)",
          TestDelay => tisd_DRPDADDR_DRPCLK(1),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(1),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(1),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(1),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(2),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(2),
          TestSignal => DRPDADDR_DRPCLK_dly(2),
          TestSignalName => "DRPDADDR(2)",
          TestDelay => tisd_DRPDADDR_DRPCLK(2),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(2),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(2),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(2),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(3),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(3),
          TestSignal => DRPDADDR_DRPCLK_dly(3),
          TestSignalName => "DRPDADDR(3)",
          TestDelay => tisd_DRPDADDR_DRPCLK(3),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(3),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(3),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(3),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(4),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(4),
          TestSignal => DRPDADDR_DRPCLK_dly(4),
          TestSignalName => "DRPDADDR(4)",
          TestDelay => tisd_DRPDADDR_DRPCLK(4),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(4),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(4),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(4),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(5),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(5),
          TestSignal => DRPDADDR_DRPCLK_dly(5),
          TestSignalName => "DRPDADDR(5)",
          TestDelay => tisd_DRPDADDR_DRPCLK(5),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(5),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(5),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(5),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(6),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(6),
          TestSignal => DRPDADDR_DRPCLK_dly(6),
          TestSignalName => "DRPDADDR(6)",
          TestDelay => tisd_DRPDADDR_DRPCLK(6),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(6),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(6),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(6),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(7),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(7),
          TestSignal => DRPDADDR_DRPCLK_dly(7),
          TestSignalName => "DRPDADDR(7)",
          TestDelay => tisd_DRPDADDR_DRPCLK(7),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(7),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(7),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(7),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDADDR_DRPCLK_posedge(8),
          TimingData => Tmkr_DRPDADDR_DRPCLK_posedge(8),
          TestSignal => DRPDADDR_DRPCLK_dly(8),
          TestSignalName => "DRPDADDR(8)",
          TestDelay => tisd_DRPDADDR_DRPCLK(8),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDADDR_DRPCLK_posedge_posedge(8),
          HoldHigh => thold_DRPDADDR_DRPCLK_posedge_posedge(8),
          SetupLow => tsetup_DRPDADDR_DRPCLK_negedge_posedge(8),
          HoldLow => thold_DRPDADDR_DRPCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDEN_DRPCLK_posedge,
          TimingData => Tmkr_DRPDEN_DRPCLK_posedge,
          TestSignal => DRPDEN_DRPCLK_dly,
          TestSignalName => "DRPDEN",
          TestDelay => tisd_DRPDEN_DRPCLK,
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDEN_DRPCLK_posedge_posedge,
          HoldHigh => thold_DRPDEN_DRPCLK_posedge_posedge,
          SetupLow => tsetup_DRPDEN_DRPCLK_negedge_posedge,
          HoldLow => thold_DRPDEN_DRPCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(0),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(0),
          TestSignal => DRPDI_DRPCLK_dly(0),
          TestSignalName => "DRPDI(0)",
          TestDelay => tisd_DRPDI_DRPCLK(0),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(0),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(0),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(0),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(1),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(1),
          TestSignal => DRPDI_DRPCLK_dly(1),
          TestSignalName => "DRPDI(1)",
          TestDelay => tisd_DRPDI_DRPCLK(1),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(1),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(1),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(1),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(10),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(10),
          TestSignal => DRPDI_DRPCLK_dly(10),
          TestSignalName => "DRPDI(10)",
          TestDelay => tisd_DRPDI_DRPCLK(10),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(10),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(10),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(10),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(11),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(11),
          TestSignal => DRPDI_DRPCLK_dly(11),
          TestSignalName => "DRPDI(11)",
          TestDelay => tisd_DRPDI_DRPCLK(11),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(11),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(11),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(11),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(12),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(12),
          TestSignal => DRPDI_DRPCLK_dly(12),
          TestSignalName => "DRPDI(12)",
          TestDelay => tisd_DRPDI_DRPCLK(12),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(12),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(12),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(12),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(13),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(13),
          TestSignal => DRPDI_DRPCLK_dly(13),
          TestSignalName => "DRPDI(13)",
          TestDelay => tisd_DRPDI_DRPCLK(13),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(13),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(13),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(13),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(14),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(14),
          TestSignal => DRPDI_DRPCLK_dly(14),
          TestSignalName => "DRPDI(14)",
          TestDelay => tisd_DRPDI_DRPCLK(14),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(14),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(14),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(14),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(15),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(15),
          TestSignal => DRPDI_DRPCLK_dly(15),
          TestSignalName => "DRPDI(15)",
          TestDelay => tisd_DRPDI_DRPCLK(15),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(15),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(15),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(15),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(2),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(2),
          TestSignal => DRPDI_DRPCLK_dly(2),
          TestSignalName => "DRPDI(2)",
          TestDelay => tisd_DRPDI_DRPCLK(2),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(2),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(2),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(2),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(3),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(3),
          TestSignal => DRPDI_DRPCLK_dly(3),
          TestSignalName => "DRPDI(3)",
          TestDelay => tisd_DRPDI_DRPCLK(3),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(3),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(3),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(3),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(4),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(4),
          TestSignal => DRPDI_DRPCLK_dly(4),
          TestSignalName => "DRPDI(4)",
          TestDelay => tisd_DRPDI_DRPCLK(4),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(4),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(4),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(4),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(5),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(5),
          TestSignal => DRPDI_DRPCLK_dly(5),
          TestSignalName => "DRPDI(5)",
          TestDelay => tisd_DRPDI_DRPCLK(5),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(5),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(5),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(5),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(6),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(6),
          TestSignal => DRPDI_DRPCLK_dly(6),
          TestSignalName => "DRPDI(6)",
          TestDelay => tisd_DRPDI_DRPCLK(6),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(6),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(6),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(6),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(7),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(7),
          TestSignal => DRPDI_DRPCLK_dly(7),
          TestSignalName => "DRPDI(7)",
          TestDelay => tisd_DRPDI_DRPCLK(7),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(7),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(7),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(7),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(8),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(8),
          TestSignal => DRPDI_DRPCLK_dly(8),
          TestSignalName => "DRPDI(8)",
          TestDelay => tisd_DRPDI_DRPCLK(8),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(8),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(8),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(8),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDI_DRPCLK_posedge(9),
          TimingData => Tmkr_DRPDI_DRPCLK_posedge(9),
          TestSignal => DRPDI_DRPCLK_dly(9),
          TestSignalName => "DRPDI(9)",
          TestDelay => tisd_DRPDI_DRPCLK(9),
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDI_DRPCLK_posedge_posedge(9),
          HoldHigh => thold_DRPDI_DRPCLK_posedge_posedge(9),
          SetupLow => tsetup_DRPDI_DRPCLK_negedge_posedge(9),
          HoldLow => thold_DRPDI_DRPCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_DRPDWE_DRPCLK_posedge,
          TimingData => Tmkr_DRPDWE_DRPCLK_posedge,
          TestSignal => DRPDWE_DRPCLK_dly,
          TestSignalName => "DRPDWE",
          TestDelay => tisd_DRPDWE_DRPCLK,
          RefSignal => DRPCLK_dly,
          RefSignalName => "DRPCLK",
          RefDelay => ticd_DRPCLK,
          SetupHigh => tsetup_DRPDWE_DRPCLK_posedge_posedge,
          HoldHigh => thold_DRPDWE_DRPCLK_posedge_posedge,
          SetupLow => tsetup_DRPDWE_DRPCLK_negedge_posedge,
          HoldLow => thold_DRPDWE_DRPCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_FUNCLVLRSTN_USERCLK_posedge,
          TimingData => Tmkr_FUNCLVLRSTN_USERCLK_posedge,
          TestSignal => FUNCLVLRSTN_USERCLK_dly,
          TestSignalName => "FUNCLVLRSTN",
          TestDelay => tisd_FUNCLVLRSTN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_FUNCLVLRSTN_USERCLK_posedge_posedge,
          HoldHigh => thold_FUNCLVLRSTN_USERCLK_posedge_posedge,
          SetupLow => tsetup_FUNCLVLRSTN_USERCLK_negedge_posedge,
          HoldLow => thold_FUNCLVLRSTN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_LL2SENDASREQL1N_USERCLK_posedge,
          TimingData => Tmkr_LL2SENDASREQL1N_USERCLK_posedge,
          TestSignal => LL2SENDASREQL1N_USERCLK_dly,
          TestSignalName => "LL2SENDASREQL1N",
          TestDelay => tisd_LL2SENDASREQL1N_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_LL2SENDASREQL1N_USERCLK_posedge_posedge,
          HoldHigh => thold_LL2SENDASREQL1N_USERCLK_posedge_posedge,
          SetupLow => tsetup_LL2SENDASREQL1N_USERCLK_negedge_posedge,
          HoldLow => thold_LL2SENDASREQL1N_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_LL2SENDENTERL1N_USERCLK_posedge,
          TimingData => Tmkr_LL2SENDENTERL1N_USERCLK_posedge,
          TestSignal => LL2SENDENTERL1N_USERCLK_dly,
          TestSignalName => "LL2SENDENTERL1N",
          TestDelay => tisd_LL2SENDENTERL1N_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_LL2SENDENTERL1N_USERCLK_posedge_posedge,
          HoldHigh => thold_LL2SENDENTERL1N_USERCLK_posedge_posedge,
          SetupLow => tsetup_LL2SENDENTERL1N_USERCLK_negedge_posedge,
          HoldLow => thold_LL2SENDENTERL1N_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_LL2SENDENTERL23N_USERCLK_posedge,
          TimingData => Tmkr_LL2SENDENTERL23N_USERCLK_posedge,
          TestSignal => LL2SENDENTERL23N_USERCLK_dly,
          TestSignalName => "LL2SENDENTERL23N",
          TestDelay => tisd_LL2SENDENTERL23N_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_LL2SENDENTERL23N_USERCLK_posedge_posedge,
          HoldHigh => thold_LL2SENDENTERL23N_USERCLK_posedge_posedge,
          SetupLow => tsetup_LL2SENDENTERL23N_USERCLK_negedge_posedge,
          HoldLow => thold_LL2SENDENTERL23N_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_LL2SUSPENDNOWN_USERCLK_posedge,
          TimingData => Tmkr_LL2SUSPENDNOWN_USERCLK_posedge,
          TestSignal => LL2SUSPENDNOWN_USERCLK_dly,
          TestSignalName => "LL2SUSPENDNOWN",
          TestDelay => tisd_LL2SUSPENDNOWN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_LL2SUSPENDNOWN_USERCLK_posedge_posedge,
          HoldHigh => thold_LL2SUSPENDNOWN_USERCLK_posedge_posedge,
          SetupLow => tsetup_LL2SUSPENDNOWN_USERCLK_negedge_posedge,
          HoldLow => thold_LL2SUSPENDNOWN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_LL2TLPRCVN_USERCLK_posedge,
          TimingData => Tmkr_LL2TLPRCVN_USERCLK_posedge,
          TestSignal => LL2TLPRCVN_USERCLK_dly,
          TestSignalName => "LL2TLPRCVN",
          TestDelay => tisd_LL2TLPRCVN_USERCLK,
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_LL2TLPRCVN_USERCLK_posedge_posedge,
          HoldHigh => thold_LL2TLPRCVN_USERCLK_posedge_posedge,
          SetupLow => tsetup_LL2TLPRCVN_USERCLK_negedge_posedge,
          HoldLow => thold_LL2TLPRCVN_USERCLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(0),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(0),
          TestSignal => MIMRXRDATA_USERCLK_dly(0),
          TestSignalName => "MIMRXRDATA(0)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(0),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(0),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(1),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(1),
          TestSignal => MIMRXRDATA_USERCLK_dly(1),
          TestSignalName => "MIMRXRDATA(1)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(1),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(1),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(10),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(10),
          TestSignal => MIMRXRDATA_USERCLK_dly(10),
          TestSignalName => "MIMRXRDATA(10)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(10),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(10),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(11),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(11),
          TestSignal => MIMRXRDATA_USERCLK_dly(11),
          TestSignalName => "MIMRXRDATA(11)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(11),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(11),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(12),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(12),
          TestSignal => MIMRXRDATA_USERCLK_dly(12),
          TestSignalName => "MIMRXRDATA(12)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(12),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(12),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(13),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(13),
          TestSignal => MIMRXRDATA_USERCLK_dly(13),
          TestSignalName => "MIMRXRDATA(13)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(13),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(13),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(14),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(14),
          TestSignal => MIMRXRDATA_USERCLK_dly(14),
          TestSignalName => "MIMRXRDATA(14)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(14),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(14),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(15),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(15),
          TestSignal => MIMRXRDATA_USERCLK_dly(15),
          TestSignalName => "MIMRXRDATA(15)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(15),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(15),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(16),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(16),
          TestSignal => MIMRXRDATA_USERCLK_dly(16),
          TestSignalName => "MIMRXRDATA(16)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(16),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(16),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(17),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(17),
          TestSignal => MIMRXRDATA_USERCLK_dly(17),
          TestSignalName => "MIMRXRDATA(17)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(17),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(17),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(18),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(18),
          TestSignal => MIMRXRDATA_USERCLK_dly(18),
          TestSignalName => "MIMRXRDATA(18)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(18),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(18),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(19),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(19),
          TestSignal => MIMRXRDATA_USERCLK_dly(19),
          TestSignalName => "MIMRXRDATA(19)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(19),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(19),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(2),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(2),
          TestSignal => MIMRXRDATA_USERCLK_dly(2),
          TestSignalName => "MIMRXRDATA(2)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(2),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(2),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(20),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(20),
          TestSignal => MIMRXRDATA_USERCLK_dly(20),
          TestSignalName => "MIMRXRDATA(20)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(20),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(20),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(21),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(21),
          TestSignal => MIMRXRDATA_USERCLK_dly(21),
          TestSignalName => "MIMRXRDATA(21)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(21),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(21),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(22),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(22),
          TestSignal => MIMRXRDATA_USERCLK_dly(22),
          TestSignalName => "MIMRXRDATA(22)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(22),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(22),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(23),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(23),
          TestSignal => MIMRXRDATA_USERCLK_dly(23),
          TestSignalName => "MIMRXRDATA(23)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(23),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(23),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(24),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(24),
          TestSignal => MIMRXRDATA_USERCLK_dly(24),
          TestSignalName => "MIMRXRDATA(24)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(24),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(24),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(25),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(25),
          TestSignal => MIMRXRDATA_USERCLK_dly(25),
          TestSignalName => "MIMRXRDATA(25)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(25),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(25),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(26),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(26),
          TestSignal => MIMRXRDATA_USERCLK_dly(26),
          TestSignalName => "MIMRXRDATA(26)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(26),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(26),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(27),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(27),
          TestSignal => MIMRXRDATA_USERCLK_dly(27),
          TestSignalName => "MIMRXRDATA(27)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(27),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(27),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(28),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(28),
          TestSignal => MIMRXRDATA_USERCLK_dly(28),
          TestSignalName => "MIMRXRDATA(28)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(28),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(28),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(29),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(29),
          TestSignal => MIMRXRDATA_USERCLK_dly(29),
          TestSignalName => "MIMRXRDATA(29)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(29),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(29),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(3),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(3),
          TestSignal => MIMRXRDATA_USERCLK_dly(3),
          TestSignalName => "MIMRXRDATA(3)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(3),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(3),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(30),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(30),
          TestSignal => MIMRXRDATA_USERCLK_dly(30),
          TestSignalName => "MIMRXRDATA(30)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(30),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(30),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(31),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(31),
          TestSignal => MIMRXRDATA_USERCLK_dly(31),
          TestSignalName => "MIMRXRDATA(31)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(31),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(31),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(32),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(32),
          TestSignal => MIMRXRDATA_USERCLK_dly(32),
          TestSignalName => "MIMRXRDATA(32)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(32),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(32),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(32),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(32),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(32),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(33),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(33),
          TestSignal => MIMRXRDATA_USERCLK_dly(33),
          TestSignalName => "MIMRXRDATA(33)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(33),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(33),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(33),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(33),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(33),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(34),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(34),
          TestSignal => MIMRXRDATA_USERCLK_dly(34),
          TestSignalName => "MIMRXRDATA(34)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(34),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(34),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(34),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(34),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(34),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(35),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(35),
          TestSignal => MIMRXRDATA_USERCLK_dly(35),
          TestSignalName => "MIMRXRDATA(35)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(35),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(35),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(35),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(35),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(35),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(36),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(36),
          TestSignal => MIMRXRDATA_USERCLK_dly(36),
          TestSignalName => "MIMRXRDATA(36)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(36),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(36),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(36),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(36),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(36),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(37),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(37),
          TestSignal => MIMRXRDATA_USERCLK_dly(37),
          TestSignalName => "MIMRXRDATA(37)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(37),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(37),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(37),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(37),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(37),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(38),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(38),
          TestSignal => MIMRXRDATA_USERCLK_dly(38),
          TestSignalName => "MIMRXRDATA(38)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(38),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(38),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(38),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(38),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(38),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(39),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(39),
          TestSignal => MIMRXRDATA_USERCLK_dly(39),
          TestSignalName => "MIMRXRDATA(39)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(39),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(39),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(39),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(39),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(39),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(4),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(4),
          TestSignal => MIMRXRDATA_USERCLK_dly(4),
          TestSignalName => "MIMRXRDATA(4)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(4),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(4),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(40),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(40),
          TestSignal => MIMRXRDATA_USERCLK_dly(40),
          TestSignalName => "MIMRXRDATA(40)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(40),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(40),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(40),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(40),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(40),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(41),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(41),
          TestSignal => MIMRXRDATA_USERCLK_dly(41),
          TestSignalName => "MIMRXRDATA(41)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(41),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(41),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(41),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(41),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(41),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(42),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(42),
          TestSignal => MIMRXRDATA_USERCLK_dly(42),
          TestSignalName => "MIMRXRDATA(42)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(42),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(42),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(42),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(42),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(42),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(43),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(43),
          TestSignal => MIMRXRDATA_USERCLK_dly(43),
          TestSignalName => "MIMRXRDATA(43)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(43),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(43),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(43),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(43),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(43),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(44),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(44),
          TestSignal => MIMRXRDATA_USERCLK_dly(44),
          TestSignalName => "MIMRXRDATA(44)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(44),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(44),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(44),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(44),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(44),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(45),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(45),
          TestSignal => MIMRXRDATA_USERCLK_dly(45),
          TestSignalName => "MIMRXRDATA(45)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(45),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(45),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(45),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(45),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(45),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(46),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(46),
          TestSignal => MIMRXRDATA_USERCLK_dly(46),
          TestSignalName => "MIMRXRDATA(46)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(46),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(46),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(46),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(46),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(46),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(47),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(47),
          TestSignal => MIMRXRDATA_USERCLK_dly(47),
          TestSignalName => "MIMRXRDATA(47)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(47),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(47),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(47),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(47),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(47),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(48),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(48),
          TestSignal => MIMRXRDATA_USERCLK_dly(48),
          TestSignalName => "MIMRXRDATA(48)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(48),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(48),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(48),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(48),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(48),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(49),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(49),
          TestSignal => MIMRXRDATA_USERCLK_dly(49),
          TestSignalName => "MIMRXRDATA(49)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(49),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(49),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(49),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(49),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(49),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(5),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(5),
          TestSignal => MIMRXRDATA_USERCLK_dly(5),
          TestSignalName => "MIMRXRDATA(5)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(5),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(5),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(50),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(50),
          TestSignal => MIMRXRDATA_USERCLK_dly(50),
          TestSignalName => "MIMRXRDATA(50)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(50),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(50),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(50),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(50),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(50),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(51),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(51),
          TestSignal => MIMRXRDATA_USERCLK_dly(51),
          TestSignalName => "MIMRXRDATA(51)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(51),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(51),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(51),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(51),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(51),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(52),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(52),
          TestSignal => MIMRXRDATA_USERCLK_dly(52),
          TestSignalName => "MIMRXRDATA(52)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(52),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(52),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(52),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(52),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(52),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(53),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(53),
          TestSignal => MIMRXRDATA_USERCLK_dly(53),
          TestSignalName => "MIMRXRDATA(53)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(53),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(53),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(53),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(53),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(53),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(54),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(54),
          TestSignal => MIMRXRDATA_USERCLK_dly(54),
          TestSignalName => "MIMRXRDATA(54)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(54),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(54),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(54),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(54),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(54),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(55),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(55),
          TestSignal => MIMRXRDATA_USERCLK_dly(55),
          TestSignalName => "MIMRXRDATA(55)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(55),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(55),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(55),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(55),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(55),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(56),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(56),
          TestSignal => MIMRXRDATA_USERCLK_dly(56),
          TestSignalName => "MIMRXRDATA(56)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(56),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(56),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(56),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(56),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(56),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(57),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(57),
          TestSignal => MIMRXRDATA_USERCLK_dly(57),
          TestSignalName => "MIMRXRDATA(57)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(57),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(57),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(57),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(57),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(57),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(58),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(58),
          TestSignal => MIMRXRDATA_USERCLK_dly(58),
          TestSignalName => "MIMRXRDATA(58)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(58),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(58),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(58),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(58),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(58),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(59),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(59),
          TestSignal => MIMRXRDATA_USERCLK_dly(59),
          TestSignalName => "MIMRXRDATA(59)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(59),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(59),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(59),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(59),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(59),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(6),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(6),
          TestSignal => MIMRXRDATA_USERCLK_dly(6),
          TestSignalName => "MIMRXRDATA(6)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(6),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(6),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(60),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(60),
          TestSignal => MIMRXRDATA_USERCLK_dly(60),
          TestSignalName => "MIMRXRDATA(60)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(60),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(60),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(60),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(60),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(60),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(61),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(61),
          TestSignal => MIMRXRDATA_USERCLK_dly(61),
          TestSignalName => "MIMRXRDATA(61)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(61),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(61),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(61),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(61),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(61),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(62),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(62),
          TestSignal => MIMRXRDATA_USERCLK_dly(62),
          TestSignalName => "MIMRXRDATA(62)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(62),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(62),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(62),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(62),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(62),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(63),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(63),
          TestSignal => MIMRXRDATA_USERCLK_dly(63),
          TestSignalName => "MIMRXRDATA(63)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(63),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(63),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(63),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(63),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(63),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(64),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(64),
          TestSignal => MIMRXRDATA_USERCLK_dly(64),
          TestSignalName => "MIMRXRDATA(64)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(64),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(64),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(64),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(64),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(64),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(65),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(65),
          TestSignal => MIMRXRDATA_USERCLK_dly(65),
          TestSignalName => "MIMRXRDATA(65)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(65),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(65),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(65),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(65),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(65),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(66),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(66),
          TestSignal => MIMRXRDATA_USERCLK_dly(66),
          TestSignalName => "MIMRXRDATA(66)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(66),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(66),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(66),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(66),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(66),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(67),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(67),
          TestSignal => MIMRXRDATA_USERCLK_dly(67),
          TestSignalName => "MIMRXRDATA(67)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(67),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(67),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(67),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(67),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(67),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(7),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(7),
          TestSignal => MIMRXRDATA_USERCLK_dly(7),
          TestSignalName => "MIMRXRDATA(7)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(7),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(7),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(8),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(8),
          TestSignal => MIMRXRDATA_USERCLK_dly(8),
          TestSignalName => "MIMRXRDATA(8)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(8),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(8),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMRXRDATA_USERCLK_posedge(9),
          TimingData => Tmkr_MIMRXRDATA_USERCLK_posedge(9),
          TestSignal => MIMRXRDATA_USERCLK_dly(9),
          TestSignalName => "MIMRXRDATA(9)",
          TestDelay => tisd_MIMRXRDATA_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMRXRDATA_USERCLK_posedge_posedge(9),
          HoldHigh => thold_MIMRXRDATA_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_MIMRXRDATA_USERCLK_negedge_posedge(9),
          HoldLow => thold_MIMRXRDATA_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(0),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(0),
          TestSignal => MIMTXRDATA_USERCLK_dly(0),
          TestSignalName => "MIMTXRDATA(0)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(0),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(0),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(0),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(0),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(1),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(1),
          TestSignal => MIMTXRDATA_USERCLK_dly(1),
          TestSignalName => "MIMTXRDATA(1)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(1),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(1),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(1),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(1),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(10),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(10),
          TestSignal => MIMTXRDATA_USERCLK_dly(10),
          TestSignalName => "MIMTXRDATA(10)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(10),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(10),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(10),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(10),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(11),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(11),
          TestSignal => MIMTXRDATA_USERCLK_dly(11),
          TestSignalName => "MIMTXRDATA(11)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(11),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(11),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(11),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(11),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(12),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(12),
          TestSignal => MIMTXRDATA_USERCLK_dly(12),
          TestSignalName => "MIMTXRDATA(12)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(12),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(12),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(12),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(12),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(13),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(13),
          TestSignal => MIMTXRDATA_USERCLK_dly(13),
          TestSignalName => "MIMTXRDATA(13)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(13),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(13),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(13),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(13),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(14),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(14),
          TestSignal => MIMTXRDATA_USERCLK_dly(14),
          TestSignalName => "MIMTXRDATA(14)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(14),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(14),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(14),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(14),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(15),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(15),
          TestSignal => MIMTXRDATA_USERCLK_dly(15),
          TestSignalName => "MIMTXRDATA(15)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(15),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(15),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(15),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(15),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(16),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(16),
          TestSignal => MIMTXRDATA_USERCLK_dly(16),
          TestSignalName => "MIMTXRDATA(16)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(16),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(16),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(16),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(16),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(16),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(17),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(17),
          TestSignal => MIMTXRDATA_USERCLK_dly(17),
          TestSignalName => "MIMTXRDATA(17)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(17),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(17),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(17),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(17),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(17),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(18),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(18),
          TestSignal => MIMTXRDATA_USERCLK_dly(18),
          TestSignalName => "MIMTXRDATA(18)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(18),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(18),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(18),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(18),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(18),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(19),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(19),
          TestSignal => MIMTXRDATA_USERCLK_dly(19),
          TestSignalName => "MIMTXRDATA(19)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(19),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(19),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(19),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(19),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(19),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(2),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(2),
          TestSignal => MIMTXRDATA_USERCLK_dly(2),
          TestSignalName => "MIMTXRDATA(2)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(2),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(2),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(2),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(2),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(20),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(20),
          TestSignal => MIMTXRDATA_USERCLK_dly(20),
          TestSignalName => "MIMTXRDATA(20)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(20),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(20),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(20),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(20),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(20),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(21),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(21),
          TestSignal => MIMTXRDATA_USERCLK_dly(21),
          TestSignalName => "MIMTXRDATA(21)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(21),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(21),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(21),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(21),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(21),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(22),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(22),
          TestSignal => MIMTXRDATA_USERCLK_dly(22),
          TestSignalName => "MIMTXRDATA(22)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(22),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(22),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(22),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(22),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(22),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(23),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(23),
          TestSignal => MIMTXRDATA_USERCLK_dly(23),
          TestSignalName => "MIMTXRDATA(23)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(23),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(23),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(23),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(23),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(23),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(24),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(24),
          TestSignal => MIMTXRDATA_USERCLK_dly(24),
          TestSignalName => "MIMTXRDATA(24)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(24),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(24),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(24),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(24),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(24),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(25),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(25),
          TestSignal => MIMTXRDATA_USERCLK_dly(25),
          TestSignalName => "MIMTXRDATA(25)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(25),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(25),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(25),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(25),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(25),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(26),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(26),
          TestSignal => MIMTXRDATA_USERCLK_dly(26),
          TestSignalName => "MIMTXRDATA(26)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(26),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(26),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(26),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(26),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(26),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(27),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(27),
          TestSignal => MIMTXRDATA_USERCLK_dly(27),
          TestSignalName => "MIMTXRDATA(27)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(27),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(27),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(27),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(27),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(27),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(28),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(28),
          TestSignal => MIMTXRDATA_USERCLK_dly(28),
          TestSignalName => "MIMTXRDATA(28)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(28),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(28),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(28),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(28),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(28),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(29),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(29),
          TestSignal => MIMTXRDATA_USERCLK_dly(29),
          TestSignalName => "MIMTXRDATA(29)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(29),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(29),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(29),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(29),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(29),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(3),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(3),
          TestSignal => MIMTXRDATA_USERCLK_dly(3),
          TestSignalName => "MIMTXRDATA(3)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(3),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(3),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(3),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(3),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(30),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(30),
          TestSignal => MIMTXRDATA_USERCLK_dly(30),
          TestSignalName => "MIMTXRDATA(30)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(30),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(30),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(30),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(30),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(30),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(31),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(31),
          TestSignal => MIMTXRDATA_USERCLK_dly(31),
          TestSignalName => "MIMTXRDATA(31)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(31),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(31),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(31),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(31),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(31),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(32),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(32),
          TestSignal => MIMTXRDATA_USERCLK_dly(32),
          TestSignalName => "MIMTXRDATA(32)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(32),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(32),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(32),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(32),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(32),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(33),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(33),
          TestSignal => MIMTXRDATA_USERCLK_dly(33),
          TestSignalName => "MIMTXRDATA(33)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(33),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(33),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(33),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(33),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(33),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(34),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(34),
          TestSignal => MIMTXRDATA_USERCLK_dly(34),
          TestSignalName => "MIMTXRDATA(34)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(34),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(34),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(34),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(34),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(34),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(35),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(35),
          TestSignal => MIMTXRDATA_USERCLK_dly(35),
          TestSignalName => "MIMTXRDATA(35)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(35),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(35),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(35),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(35),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(35),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(36),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(36),
          TestSignal => MIMTXRDATA_USERCLK_dly(36),
          TestSignalName => "MIMTXRDATA(36)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(36),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(36),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(36),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(36),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(36),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(37),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(37),
          TestSignal => MIMTXRDATA_USERCLK_dly(37),
          TestSignalName => "MIMTXRDATA(37)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(37),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(37),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(37),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(37),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(37),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(38),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(38),
          TestSignal => MIMTXRDATA_USERCLK_dly(38),
          TestSignalName => "MIMTXRDATA(38)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(38),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(38),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(38),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(38),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(38),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(39),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(39),
          TestSignal => MIMTXRDATA_USERCLK_dly(39),
          TestSignalName => "MIMTXRDATA(39)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(39),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(39),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(39),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(39),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(39),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(4),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(4),
          TestSignal => MIMTXRDATA_USERCLK_dly(4),
          TestSignalName => "MIMTXRDATA(4)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(4),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(4),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(4),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(4),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(40),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(40),
          TestSignal => MIMTXRDATA_USERCLK_dly(40),
          TestSignalName => "MIMTXRDATA(40)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(40),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(40),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(40),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(40),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(40),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(41),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(41),
          TestSignal => MIMTXRDATA_USERCLK_dly(41),
          TestSignalName => "MIMTXRDATA(41)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(41),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(41),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(41),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(41),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(41),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(42),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(42),
          TestSignal => MIMTXRDATA_USERCLK_dly(42),
          TestSignalName => "MIMTXRDATA(42)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(42),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(42),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(42),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(42),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(42),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(43),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(43),
          TestSignal => MIMTXRDATA_USERCLK_dly(43),
          TestSignalName => "MIMTXRDATA(43)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(43),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(43),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(43),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(43),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(43),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(44),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(44),
          TestSignal => MIMTXRDATA_USERCLK_dly(44),
          TestSignalName => "MIMTXRDATA(44)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(44),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(44),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(44),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(44),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(44),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(45),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(45),
          TestSignal => MIMTXRDATA_USERCLK_dly(45),
          TestSignalName => "MIMTXRDATA(45)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(45),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(45),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(45),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(45),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(45),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(46),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(46),
          TestSignal => MIMTXRDATA_USERCLK_dly(46),
          TestSignalName => "MIMTXRDATA(46)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(46),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(46),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(46),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(46),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(46),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(47),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(47),
          TestSignal => MIMTXRDATA_USERCLK_dly(47),
          TestSignalName => "MIMTXRDATA(47)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(47),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(47),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(47),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(47),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(47),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(48),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(48),
          TestSignal => MIMTXRDATA_USERCLK_dly(48),
          TestSignalName => "MIMTXRDATA(48)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(48),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(48),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(48),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(48),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(48),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(49),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(49),
          TestSignal => MIMTXRDATA_USERCLK_dly(49),
          TestSignalName => "MIMTXRDATA(49)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(49),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(49),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(49),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(49),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(49),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(5),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(5),
          TestSignal => MIMTXRDATA_USERCLK_dly(5),
          TestSignalName => "MIMTXRDATA(5)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(5),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(5),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(5),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(5),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(50),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(50),
          TestSignal => MIMTXRDATA_USERCLK_dly(50),
          TestSignalName => "MIMTXRDATA(50)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(50),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(50),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(50),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(50),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(50),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(51),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(51),
          TestSignal => MIMTXRDATA_USERCLK_dly(51),
          TestSignalName => "MIMTXRDATA(51)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(51),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(51),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(51),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(51),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(51),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(52),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(52),
          TestSignal => MIMTXRDATA_USERCLK_dly(52),
          TestSignalName => "MIMTXRDATA(52)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(52),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(52),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(52),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(52),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(52),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(53),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(53),
          TestSignal => MIMTXRDATA_USERCLK_dly(53),
          TestSignalName => "MIMTXRDATA(53)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(53),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(53),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(53),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(53),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(53),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(54),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(54),
          TestSignal => MIMTXRDATA_USERCLK_dly(54),
          TestSignalName => "MIMTXRDATA(54)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(54),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(54),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(54),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(54),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(54),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(55),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(55),
          TestSignal => MIMTXRDATA_USERCLK_dly(55),
          TestSignalName => "MIMTXRDATA(55)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(55),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(55),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(55),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(55),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(55),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(56),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(56),
          TestSignal => MIMTXRDATA_USERCLK_dly(56),
          TestSignalName => "MIMTXRDATA(56)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(56),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(56),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(56),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(56),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(56),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(57),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(57),
          TestSignal => MIMTXRDATA_USERCLK_dly(57),
          TestSignalName => "MIMTXRDATA(57)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(57),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(57),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(57),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(57),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(57),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(58),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(58),
          TestSignal => MIMTXRDATA_USERCLK_dly(58),
          TestSignalName => "MIMTXRDATA(58)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(58),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(58),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(58),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(58),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(58),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(59),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(59),
          TestSignal => MIMTXRDATA_USERCLK_dly(59),
          TestSignalName => "MIMTXRDATA(59)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(59),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(59),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(59),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(59),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(59),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(6),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(6),
          TestSignal => MIMTXRDATA_USERCLK_dly(6),
          TestSignalName => "MIMTXRDATA(6)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(6),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(6),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(6),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(6),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(60),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(60),
          TestSignal => MIMTXRDATA_USERCLK_dly(60),
          TestSignalName => "MIMTXRDATA(60)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(60),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(60),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(60),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(60),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(60),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(61),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(61),
          TestSignal => MIMTXRDATA_USERCLK_dly(61),
          TestSignalName => "MIMTXRDATA(61)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(61),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(61),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(61),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(61),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(61),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(62),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(62),
          TestSignal => MIMTXRDATA_USERCLK_dly(62),
          TestSignalName => "MIMTXRDATA(62)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(62),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(62),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(62),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(62),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(62),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(63),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(63),
          TestSignal => MIMTXRDATA_USERCLK_dly(63),
          TestSignalName => "MIMTXRDATA(63)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(63),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(63),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(63),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(63),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(63),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(64),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(64),
          TestSignal => MIMTXRDATA_USERCLK_dly(64),
          TestSignalName => "MIMTXRDATA(64)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(64),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(64),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(64),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(64),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(64),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(65),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(65),
          TestSignal => MIMTXRDATA_USERCLK_dly(65),
          TestSignalName => "MIMTXRDATA(65)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(65),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(65),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(65),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(65),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(65),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(66),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(66),
          TestSignal => MIMTXRDATA_USERCLK_dly(66),
          TestSignalName => "MIMTXRDATA(66)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(66),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(66),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(66),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(66),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(66),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(67),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(67),
          TestSignal => MIMTXRDATA_USERCLK_dly(67),
          TestSignalName => "MIMTXRDATA(67)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(67),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(67),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(67),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(67),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(67),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(68),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(68),
          TestSignal => MIMTXRDATA_USERCLK_dly(68),
          TestSignalName => "MIMTXRDATA(68)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(68),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(68),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(68),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(68),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(68),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(7),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(7),
          TestSignal => MIMTXRDATA_USERCLK_dly(7),
          TestSignalName => "MIMTXRDATA(7)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(7),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(7),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(7),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(7),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(8),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(8),
          TestSignal => MIMTXRDATA_USERCLK_dly(8),
          TestSignalName => "MIMTXRDATA(8)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(8),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(8),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(8),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(8),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_MIMTXRDATA_USERCLK_posedge(9),
          TimingData => Tmkr_MIMTXRDATA_USERCLK_posedge(9),
          TestSignal => MIMTXRDATA_USERCLK_dly(9),
          TestSignalName => "MIMTXRDATA(9)",
          TestDelay => tisd_MIMTXRDATA_USERCLK(9),
          RefSignal => USERCLK_dly,
          RefSignalName => "USERCLK",
          RefDelay => ticd_USERCLK,
          SetupHigh => tsetup_MIMTXRDATA_USERCLK_posedge_posedge(9),
          HoldHigh => thold_MIMTXRDATA_USERCLK_posedge_posedge(9),
          SetupLow => tsetup_MIMTXRDATA_USERCLK_negedge_posedge(9),
          HoldLow => thold_MIMTXRDATA_USERCLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0CHANISALIGNED_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX0CHANISALIGNED_PIPECLK_posedge,
          TestSignal => PIPERX0CHANISALIGNED_PIPECLK_dly,
          TestSignalName => "PIPERX0CHANISALIGNED",
          TestDelay => tisd_PIPERX0CHANISALIGNED_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0CHARISK_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX0CHARISK_PIPECLK_posedge(0),
          TestSignal => PIPERX0CHARISK_PIPECLK_dly(0),
          TestSignalName => "PIPERX0CHARISK(0)",
          TestDelay => tisd_PIPERX0CHARISK_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0CHARISK_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX0CHARISK_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX0CHARISK_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX0CHARISK_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0CHARISK_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX0CHARISK_PIPECLK_posedge(1),
          TestSignal => PIPERX0CHARISK_PIPECLK_dly(1),
          TestSignalName => "PIPERX0CHARISK(1)",
          TestDelay => tisd_PIPERX0CHARISK_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0CHARISK_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX0CHARISK_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX0CHARISK_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX0CHARISK_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(0),
          TestSignal => PIPERX0DATA_PIPECLK_dly(0),
          TestSignalName => "PIPERX0DATA(0)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(1),
          TestSignal => PIPERX0DATA_PIPECLK_dly(1),
          TestSignalName => "PIPERX0DATA(1)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(10),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(10),
          TestSignal => PIPERX0DATA_PIPECLK_dly(10),
          TestSignalName => "PIPERX0DATA(10)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(10),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(10),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(10),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(10),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(11),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(11),
          TestSignal => PIPERX0DATA_PIPECLK_dly(11),
          TestSignalName => "PIPERX0DATA(11)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(11),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(11),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(11),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(11),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(12),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(12),
          TestSignal => PIPERX0DATA_PIPECLK_dly(12),
          TestSignalName => "PIPERX0DATA(12)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(12),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(12),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(12),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(12),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(13),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(13),
          TestSignal => PIPERX0DATA_PIPECLK_dly(13),
          TestSignalName => "PIPERX0DATA(13)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(13),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(13),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(13),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(13),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(14),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(14),
          TestSignal => PIPERX0DATA_PIPECLK_dly(14),
          TestSignalName => "PIPERX0DATA(14)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(14),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(14),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(14),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(14),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(15),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(15),
          TestSignal => PIPERX0DATA_PIPECLK_dly(15),
          TestSignalName => "PIPERX0DATA(15)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(15),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(15),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(15),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(15),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(2),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(2),
          TestSignal => PIPERX0DATA_PIPECLK_dly(2),
          TestSignalName => "PIPERX0DATA(2)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(2),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(2),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(2),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(2),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(3),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(3),
          TestSignal => PIPERX0DATA_PIPECLK_dly(3),
          TestSignalName => "PIPERX0DATA(3)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(3),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(3),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(3),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(3),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(4),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(4),
          TestSignal => PIPERX0DATA_PIPECLK_dly(4),
          TestSignalName => "PIPERX0DATA(4)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(4),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(4),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(4),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(4),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(5),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(5),
          TestSignal => PIPERX0DATA_PIPECLK_dly(5),
          TestSignalName => "PIPERX0DATA(5)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(5),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(5),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(5),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(5),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(6),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(6),
          TestSignal => PIPERX0DATA_PIPECLK_dly(6),
          TestSignalName => "PIPERX0DATA(6)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(6),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(6),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(6),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(6),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(7),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(7),
          TestSignal => PIPERX0DATA_PIPECLK_dly(7),
          TestSignalName => "PIPERX0DATA(7)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(7),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(7),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(7),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(7),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(8),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(8),
          TestSignal => PIPERX0DATA_PIPECLK_dly(8),
          TestSignalName => "PIPERX0DATA(8)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(8),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(8),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(8),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(8),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0DATA_PIPECLK_posedge(9),
          TimingData => Tmkr_PIPERX0DATA_PIPECLK_posedge(9),
          TestSignal => PIPERX0DATA_PIPECLK_dly(9),
          TestSignalName => "PIPERX0DATA(9)",
          TestDelay => tisd_PIPERX0DATA_PIPECLK(9),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0DATA_PIPECLK_posedge_posedge(9),
          HoldHigh => thold_PIPERX0DATA_PIPECLK_posedge_posedge(9),
          SetupLow => tsetup_PIPERX0DATA_PIPECLK_negedge_posedge(9),
          HoldLow => thold_PIPERX0DATA_PIPECLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0ELECIDLE_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX0ELECIDLE_PIPECLK_posedge,
          TestSignal => PIPERX0ELECIDLE_PIPECLK_dly,
          TestSignalName => "PIPERX0ELECIDLE",
          TestDelay => tisd_PIPERX0ELECIDLE_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0ELECIDLE_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX0ELECIDLE_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX0ELECIDLE_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX0ELECIDLE_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0PHYSTATUS_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX0PHYSTATUS_PIPECLK_posedge,
          TestSignal => PIPERX0PHYSTATUS_PIPECLK_dly,
          TestSignalName => "PIPERX0PHYSTATUS",
          TestDelay => tisd_PIPERX0PHYSTATUS_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0STATUS_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX0STATUS_PIPECLK_posedge(0),
          TestSignal => PIPERX0STATUS_PIPECLK_dly(0),
          TestSignalName => "PIPERX0STATUS(0)",
          TestDelay => tisd_PIPERX0STATUS_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0STATUS_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX0STATUS_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX0STATUS_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX0STATUS_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0STATUS_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX0STATUS_PIPECLK_posedge(1),
          TestSignal => PIPERX0STATUS_PIPECLK_dly(1),
          TestSignalName => "PIPERX0STATUS(1)",
          TestDelay => tisd_PIPERX0STATUS_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0STATUS_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX0STATUS_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX0STATUS_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX0STATUS_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0STATUS_PIPECLK_posedge(2),
          TimingData => Tmkr_PIPERX0STATUS_PIPECLK_posedge(2),
          TestSignal => PIPERX0STATUS_PIPECLK_dly(2),
          TestSignalName => "PIPERX0STATUS(2)",
          TestDelay => tisd_PIPERX0STATUS_PIPECLK(2),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0STATUS_PIPECLK_posedge_posedge(2),
          HoldHigh => thold_PIPERX0STATUS_PIPECLK_posedge_posedge(2),
          SetupLow => tsetup_PIPERX0STATUS_PIPECLK_negedge_posedge(2),
          HoldLow => thold_PIPERX0STATUS_PIPECLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX0VALID_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX0VALID_PIPECLK_posedge,
          TestSignal => PIPERX0VALID_PIPECLK_dly,
          TestSignalName => "PIPERX0VALID",
          TestDelay => tisd_PIPERX0VALID_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX0VALID_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX0VALID_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX0VALID_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX0VALID_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1CHANISALIGNED_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX1CHANISALIGNED_PIPECLK_posedge,
          TestSignal => PIPERX1CHANISALIGNED_PIPECLK_dly,
          TestSignalName => "PIPERX1CHANISALIGNED",
          TestDelay => tisd_PIPERX1CHANISALIGNED_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1CHARISK_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX1CHARISK_PIPECLK_posedge(0),
          TestSignal => PIPERX1CHARISK_PIPECLK_dly(0),
          TestSignalName => "PIPERX1CHARISK(0)",
          TestDelay => tisd_PIPERX1CHARISK_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1CHARISK_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX1CHARISK_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX1CHARISK_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX1CHARISK_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1CHARISK_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX1CHARISK_PIPECLK_posedge(1),
          TestSignal => PIPERX1CHARISK_PIPECLK_dly(1),
          TestSignalName => "PIPERX1CHARISK(1)",
          TestDelay => tisd_PIPERX1CHARISK_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1CHARISK_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX1CHARISK_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX1CHARISK_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX1CHARISK_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(0),
          TestSignal => PIPERX1DATA_PIPECLK_dly(0),
          TestSignalName => "PIPERX1DATA(0)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(1),
          TestSignal => PIPERX1DATA_PIPECLK_dly(1),
          TestSignalName => "PIPERX1DATA(1)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(10),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(10),
          TestSignal => PIPERX1DATA_PIPECLK_dly(10),
          TestSignalName => "PIPERX1DATA(10)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(10),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(10),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(10),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(10),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(10),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(11),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(11),
          TestSignal => PIPERX1DATA_PIPECLK_dly(11),
          TestSignalName => "PIPERX1DATA(11)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(11),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(11),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(11),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(11),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(11),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(12),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(12),
          TestSignal => PIPERX1DATA_PIPECLK_dly(12),
          TestSignalName => "PIPERX1DATA(12)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(12),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(12),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(12),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(12),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(12),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(13),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(13),
          TestSignal => PIPERX1DATA_PIPECLK_dly(13),
          TestSignalName => "PIPERX1DATA(13)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(13),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(13),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(13),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(13),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(13),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(14),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(14),
          TestSignal => PIPERX1DATA_PIPECLK_dly(14),
          TestSignalName => "PIPERX1DATA(14)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(14),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(14),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(14),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(14),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(14),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(15),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(15),
          TestSignal => PIPERX1DATA_PIPECLK_dly(15),
          TestSignalName => "PIPERX1DATA(15)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(15),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(15),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(15),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(15),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(15),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(2),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(2),
          TestSignal => PIPERX1DATA_PIPECLK_dly(2),
          TestSignalName => "PIPERX1DATA(2)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(2),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(2),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(2),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(2),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(2),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(3),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(3),
          TestSignal => PIPERX1DATA_PIPECLK_dly(3),
          TestSignalName => "PIPERX1DATA(3)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(3),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(3),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(3),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(3),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(3),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(4),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(4),
          TestSignal => PIPERX1DATA_PIPECLK_dly(4),
          TestSignalName => "PIPERX1DATA(4)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(4),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(4),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(4),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(4),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(4),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(5),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(5),
          TestSignal => PIPERX1DATA_PIPECLK_dly(5),
          TestSignalName => "PIPERX1DATA(5)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(5),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(5),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(5),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(5),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(5),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(6),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(6),
          TestSignal => PIPERX1DATA_PIPECLK_dly(6),
          TestSignalName => "PIPERX1DATA(6)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(6),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(6),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(6),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(6),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(6),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(7),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(7),
          TestSignal => PIPERX1DATA_PIPECLK_dly(7),
          TestSignalName => "PIPERX1DATA(7)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(7),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(7),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(7),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(7),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(7),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(8),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(8),
          TestSignal => PIPERX1DATA_PIPECLK_dly(8),
          TestSignalName => "PIPERX1DATA(8)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(8),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(8),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(8),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(8),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(8),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1DATA_PIPECLK_posedge(9),
          TimingData => Tmkr_PIPERX1DATA_PIPECLK_posedge(9),
          TestSignal => PIPERX1DATA_PIPECLK_dly(9),
          TestSignalName => "PIPERX1DATA(9)",
          TestDelay => tisd_PIPERX1DATA_PIPECLK(9),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1DATA_PIPECLK_posedge_posedge(9),
          HoldHigh => thold_PIPERX1DATA_PIPECLK_posedge_posedge(9),
          SetupLow => tsetup_PIPERX1DATA_PIPECLK_negedge_posedge(9),
          HoldLow => thold_PIPERX1DATA_PIPECLK_negedge_posedge(9),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1ELECIDLE_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX1ELECIDLE_PIPECLK_posedge,
          TestSignal => PIPERX1ELECIDLE_PIPECLK_dly,
          TestSignalName => "PIPERX1ELECIDLE",
          TestDelay => tisd_PIPERX1ELECIDLE_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1ELECIDLE_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX1ELECIDLE_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX1ELECIDLE_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX1ELECIDLE_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1PHYSTATUS_PIPECLK_posedge,
          TimingData => Tmkr_PIPERX1PHYSTATUS_PIPECLK_posedge,
          TestSignal => PIPERX1PHYSTATUS_PIPECLK_dly,
          TestSignalName => "PIPERX1PHYSTATUS",
          TestDelay => tisd_PIPERX1PHYSTATUS_PIPECLK,
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge,
          HoldHigh => thold_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge,
          SetupLow => tsetup_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge,
          HoldLow => thold_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge,
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1STATUS_PIPECLK_posedge(0),
          TimingData => Tmkr_PIPERX1STATUS_PIPECLK_posedge(0),
          TestSignal => PIPERX1STATUS_PIPECLK_dly(0),
          TestSignalName => "PIPERX1STATUS(0)",
          TestDelay => tisd_PIPERX1STATUS_PIPECLK(0),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1STATUS_PIPECLK_posedge_posedge(0),
          HoldHigh => thold_PIPERX1STATUS_PIPECLK_posedge_posedge(0),
          SetupLow => tsetup_PIPERX1STATUS_PIPECLK_negedge_posedge(0),
          HoldLow => thold_PIPERX1STATUS_PIPECLK_negedge_posedge(0),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1STATUS_PIPECLK_posedge(1),
          TimingData => Tmkr_PIPERX1STATUS_PIPECLK_posedge(1),
          TestSignal => PIPERX1STATUS_PIPECLK_dly(1),
          TestSignalName => "PIPERX1STATUS(1)",
          TestDelay => tisd_PIPERX1STATUS_PIPECLK(1),
          RefSignal => PIPECLK_dly,
          RefSignalName => "PIPECLK",
          RefDelay => ticd_PIPECLK,
          SetupHigh => tsetup_PIPERX1STATUS_PIPECLK_posedge_posedge(1),
          HoldHigh => thold_PIPERX1STATUS_PIPECLK_posedge_posedge(1),
          SetupLow => tsetup_PIPERX1STATUS_PIPECLK_negedge_posedge(1),
          HoldLow => thold_PIPERX1STATUS_PIPECLK_negedge_posedge(1),
          CheckEnabled   => TRUE,
          RefTransition  => 'R',
          HeaderMsg      => InstancePath & "/X_PCIE_2_0",
          Xon            => Xon,
          MsgOn          => MsgOn,
          MsgSeverity    => WARNING
        );
        VitalSetupHoldCheck
        (
          Violation => Tviol_PIPERX1STATUS_PIPECLK_posedge(2),
          TimingData => Tmkr_PIPERX1STATUS_PIPECLK_posedge(2),
          TestSignal => PIPERX1STATUS_PIPECLK_dly(2),
          TestSignalName => "PIPERX1STATUS(2)",
          TestDelay => tisd_PIPERX1STATUS_PIPECLK(2),
          RefSignal => PIPECLK_dly,
          Ref